/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.actions;

import java.io.IOException;
import java.util.Collections;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egit.core.AdapterUtils;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.CompareUtils;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.actions.RepositoryActionHandler;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jgit.lib.IndexDiff;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.WorkingTreeIterator;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class CompareIndexWithHeadActionHandler
extends RepositoryActionHandler {
    public Object execute(final ExecutionEvent event) throws ExecutionException {
        final Repository repository = this.getRepository(true, event);
        if (repository == null) {
            return null;
        }
        final Object fileOrPath = this.getSingleSelectedObject(event);
        if (fileOrPath == null) {
            return null;
        }
        Job job = new Job(UIText.CompareUtils_jobName){

            public IStatus run(IProgressMonitor monitor) {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                IPath location = (IPath)(fileOrPath instanceof IPath ? fileOrPath : ((IResource)fileOrPath).getLocation());
                if (!CompareIndexWithHeadActionHandler.this.isStaged(repository, location, true)) {
                    CompareIndexWithHeadActionHandler.showNoStagedFileInfo(location);
                    return Status.CANCEL_STATUS;
                }
                try {
                    CompareIndexWithHeadActionHandler.this.runCompare(event, repository);
                }
                catch (Exception e) {
                    return Activator.createErrorStatus(UIText.CompareWithRefAction_errorOnSynchronize, e);
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
        return null;
    }

    private static void showNoStagedFileInfo(IPath location) {
        final String title = UIText.CompareIndexWithHeadActionHandler_nothingToDoTitle;
        final String message = NLS.bind((String)UIText.CompareIndexWithHeadActionHandler_fileNotStaged, (Object)location.toOSString());
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openInformation(null, (String)title, (String)message);
            }
        });
    }

    private void runCompare(ExecutionEvent event, Repository repository) throws Exception {
        IWorkbenchPage workBenchPage = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event).getActivePage();
        IResource[] resources = this.getSelectedResources(event);
        if (resources.length > 0) {
            CompareUtils.compare(resources, repository, "Index", "HEAD", false, workBenchPage);
        } else {
            IPath[] locations = this.getSelectedLocations(event);
            if (locations.length > 0) {
                CompareUtils.compare(locations[0], repository, "Index", "HEAD", false, workBenchPage);
            }
        }
    }

    private Object getSingleSelectedObject(ExecutionEvent event) throws ExecutionException {
        IResource[] resources = this.getSelectedResources(event);
        if (resources.length == 1) {
            return resources[0];
        }
        IPath[] locations = this.getSelectedLocations(event);
        if (locations.length == 1) {
            return locations[0];
        }
        return null;
    }

    @Override
    public boolean isEnabled() {
        IStructuredSelection selection = this.getSelection();
        if (selection.size() != 1) {
            return false;
        }
        Repository repository = this.getRepository();
        if (repository == null) {
            return false;
        }
        Object selected = selection.getFirstElement();
        IResource resource = (IResource)AdapterUtils.adapt((Object)selected, IResource.class);
        if (resource instanceof IFile) {
            return this.isStaged(repository, resource.getLocation(), false);
        }
        if (resource == null) {
            IPath location = (IPath)AdapterUtils.adapt((Object)selected, IPath.class);
            return this.isStaged(repository, location, false);
        }
        return false;
    }

    private boolean isStaged(Repository repository, IPath location, boolean checkIndex) {
        if (location == null || location.toFile().isDirectory() || repository.isBare()) {
            return false;
        }
        Path workDir = new Path(repository.getWorkTree().getAbsolutePath());
        String resRelPath = location.makeRelativeTo((IPath)workDir).toString();
        if (resRelPath.length() == 0 || resRelPath.equals(location.toString())) {
            return false;
        }
        if (!checkIndex) {
            return true;
        }
        try {
            FileTreeIterator fileTreeIterator = new FileTreeIterator(repository);
            IndexDiff indexDiff = new IndexDiff(repository, "HEAD", (WorkingTreeIterator)fileTreeIterator);
            indexDiff.setFilter(PathFilterGroup.createFromStrings(Collections.singletonList(resRelPath)));
            indexDiff.diff();
            return indexDiff.getAdded().contains(resRelPath) || indexDiff.getChanged().contains(resRelPath) || indexDiff.getRemoved().contains(resRelPath);
        }
        catch (IOException e) {
            Activator.error(NLS.bind((String)UIText.GitHistoryPage_errorLookingUpPath, (Object)location.toString()), e);
            return false;
        }
    }
}

