/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.components;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egit.core.op.ListRemoteOperation;
import org.eclipse.egit.core.securestorage.UserPasswordCredentials;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.components.RefSpecPanel;
import org.eclipse.egit.ui.internal.components.RepositorySelection;
import org.eclipse.egit.ui.internal.components.SelectionChangeListener;
import org.eclipse.egit.ui.internal.credentials.EGitCredentialsProvider;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.TagOpt;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class RefSpecPage
extends WizardPage {
    private final Repository local;
    private final boolean pushPage;
    private RepositorySelection validatedRepoSelection;
    private RepositorySelection currentRepoSelection;
    private RefSpecPanel specsPanel;
    private Button saveButton;
    private Button tagsAutoFollowButton;
    private Button tagsFetchTagsButton;
    private Button tagsNoTagsButton;
    private String transportError;
    private UserPasswordCredentials credentials;
    private String helpContext = null;

    public RefSpecPage(Repository local, boolean pushPage) {
        super(RefSpecPage.class.getName());
        this.local = local;
        this.pushPage = pushPage;
        if (pushPage) {
            this.setTitle(UIText.RefSpecPage_titlePush);
            this.setDescription(UIText.RefSpecPage_descriptionPush);
        } else {
            this.setTitle(UIText.RefSpecPage_titleFetch);
            this.setDescription(UIText.RefSpecPage_descriptionFetch);
        }
    }

    public void setSelection(RepositorySelection selection) {
        if (!selection.equals(this.validatedRepoSelection)) {
            this.currentRepoSelection = selection;
            this.setPageComplete(false);
        } else {
            this.checkPage();
        }
        this.revalidate();
    }

    public void setCredentials(UserPasswordCredentials credentials) {
        this.credentials = credentials;
    }

    public void createControl(Composite parent) {
        Composite panel = new Composite(parent, 0);
        panel.setLayout((Layout)new GridLayout());
        this.specsPanel = new RefSpecPanel(panel, this.pushPage);
        this.specsPanel.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.specsPanel.addRefSpecTableListener(new SelectionChangeListener(){

            @Override
            public void selectionChanged() {
                RefSpecPage.this.checkPage();
            }
        });
        if (!this.pushPage) {
            Group tagsGroup = new Group(panel, 0);
            tagsGroup.setLayoutData((Object)new GridData(4, 4, true, false));
            tagsGroup.setText(UIText.RefSpecPage_annotatedTagsGroup);
            tagsGroup.setLayout((Layout)new GridLayout());
            this.tagsAutoFollowButton = new Button((Composite)tagsGroup, 16);
            this.tagsAutoFollowButton.setText(UIText.RefSpecPage_annotatedTagsAutoFollow);
            this.tagsFetchTagsButton = new Button((Composite)tagsGroup, 16);
            this.tagsFetchTagsButton.setText(UIText.RefSpecPage_annotatedTagsFetchTags);
            this.tagsNoTagsButton = new Button((Composite)tagsGroup, 16);
            this.tagsNoTagsButton.setText(UIText.RefSpecPage_annotatedTagsNoTags);
        }
        this.saveButton = new Button(panel, 32);
        this.saveButton.setLayoutData((Object)new GridData(16384, 4, true, false));
        Dialog.applyDialogFont((Control)panel);
        this.setControl((Control)panel);
        this.checkPage();
    }

    public List<RefSpec> getRefSpecs() {
        if (this.specsPanel == null) {
            return Collections.emptyList();
        }
        return new ArrayList<RefSpec>(this.specsPanel.getRefSpecs());
    }

    public boolean isSaveRequested() {
        return this.saveButton.getSelection();
    }

    public TagOpt getTagOpt() {
        if (this.tagsAutoFollowButton.getSelection()) {
            return TagOpt.AUTO_FOLLOW;
        }
        if (this.tagsFetchTagsButton.getSelection()) {
            return TagOpt.FETCH_TAGS;
        }
        return TagOpt.NO_TAGS;
    }

    public boolean specsSelectionEquals(List<RefSpec> specs) {
        return this.getRefSpecs().equals(specs);
    }

    public void setHelpContext(String id) {
        this.helpContext = id;
    }

    public void performHelp() {
        PlatformUI.getWorkbench().getHelpSystem().displayHelp(this.helpContext);
    }

    private void revalidate() {
        if (this.currentRepoSelection != null && this.currentRepoSelection.equals(this.validatedRepoSelection)) {
            this.checkPage();
            return;
        }
        if (this.currentRepoSelection == null) {
            return;
        }
        this.specsPanel.clearRefSpecs();
        this.specsPanel.setEnable(false);
        this.saveButton.setVisible(false);
        this.saveButton.setSelection(false);
        this.validatedRepoSelection = null;
        this.transportError = null;
        this.getControl().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                RefSpecPage.this.revalidateImpl(RefSpecPage.this.currentRepoSelection);
            }
        });
    }

    private void revalidateImpl(RepositorySelection newRepoSelection) {
        ListRemoteOperation listRemotesOp;
        try {
            URIish uri = newRepoSelection.getURI(this.pushPage);
            int timeout = Activator.getDefault().getPreferenceStore().getInt("remote_connection_timeout");
            listRemotesOp = new ListRemoteOperation(this.local, uri, timeout);
            if (this.credentials != null) {
                listRemotesOp.setCredentialsProvider((CredentialsProvider)new EGitCredentialsProvider(this.credentials.getUser(), this.credentials.getPassword()));
            }
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    listRemotesOp.run(monitor);
                }
            });
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            this.transportError(cause.getMessage());
            Activator.handleError(UIText.RefSpecPage_errorTransportDialogMessage, cause, true);
            return;
        }
        catch (InterruptedException e) {
            this.transportError(UIText.RefSpecPage_operationCancelled);
            return;
        }
        this.validatedRepoSelection = newRepoSelection;
        this.specsPanel.setAssistanceData(this.local, listRemotesOp.getRemoteRefs(), this.currentRepoSelection.getConfig());
        if (newRepoSelection.isConfigSelected()) {
            this.saveButton.setVisible(true);
            this.saveButton.setText(NLS.bind((String)UIText.RefSpecPage_saveSpecifications, (Object)this.currentRepoSelection.getConfigName()));
            this.saveButton.getParent().layout();
            if (!this.pushPage) {
                this.tagsAutoFollowButton.setSelection(false);
                this.tagsFetchTagsButton.setSelection(false);
                this.tagsNoTagsButton.setSelection(false);
                TagOpt tagOpt = newRepoSelection.getConfig().getTagOpt();
                switch (tagOpt) {
                    case AUTO_FOLLOW: {
                        this.tagsAutoFollowButton.setSelection(true);
                        break;
                    }
                    case FETCH_TAGS: {
                        this.tagsFetchTagsButton.setSelection(true);
                        break;
                    }
                    case NO_TAGS: {
                        this.tagsNoTagsButton.setSelection(true);
                    }
                    default: {
                        break;
                    }
                }
            }
        } else if (!this.pushPage) {
            this.tagsAutoFollowButton.setSelection(true);
        }
        this.checkPage();
    }

    private void transportError(String message) {
        this.transportError = message;
        this.checkPage();
    }

    private void checkPage() {
        if (this.transportError != null) {
            this.setErrorMessage(this.transportError);
            this.setPageComplete(false);
            return;
        }
        if (!this.specsPanel.isEmpty() && this.specsPanel.isValid() && !this.specsPanel.isMatchingAnyRefs()) {
            this.setErrorMessage(UIText.RefSpecPage_errorDontMatchSrc);
            this.setPageComplete(false);
            return;
        }
        this.setErrorMessage(this.specsPanel.getErrorMessage());
        this.setPageComplete(!this.specsPanel.isEmpty() && this.specsPanel.isValid());
    }
}

