/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.search;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.help.internal.base.HelpBasePlugin;
import org.eclipse.help.internal.base.remote.RemoteHelp;
import org.eclipse.help.internal.base.remote.RemoteSearchManager;
import org.eclipse.help.internal.search.ISearchHitCollector;
import org.eclipse.help.internal.search.ISearchQuery;
import org.eclipse.help.internal.search.LocalSearchManager;
import org.eclipse.help.internal.search.QueryTooComplexException;
import org.eclipse.help.internal.search.SearchHit;
import org.eclipse.help.internal.search.SearchResult;
import org.eclipse.help.internal.search.federated.FederatedSearchEntry;
import org.eclipse.help.internal.search.federated.FederatedSearchJob;
import org.eclipse.help.search.AbstractSearchProcessor;
import org.eclipse.help.search.ISearchResult;

public class SearchManager {
    private LocalSearchManager localManager = new LocalSearchManager();
    private RemoteSearchManager remoteManager = new RemoteSearchManager();

    public void search(ISearchQuery searchQuery, ISearchHitCollector collector, IProgressMonitor pm) throws QueryTooComplexException {
        if (RemoteHelp.isEnabled()) {
            this.searchLocalAndRemote(searchQuery, collector, pm);
        } else {
            this.searchLocal(searchQuery, collector, pm);
        }
    }

    public void searchLocal(ISearchQuery searchQuery, ISearchHitCollector collector, IProgressMonitor pm) throws QueryTooComplexException {
        this.localManager.search(searchQuery, collector, pm);
    }

    public void searchLocalAndRemote(ISearchQuery searchQuery, ISearchHitCollector collector, IProgressMonitor pm) throws QueryTooComplexException {
        SearchState state = new SearchState();
        state.searchQuery = searchQuery;
        pm.beginTask("", 100);
        state.localMonitor = new SubProgressMonitor(pm, 50, 2);
        state.remoteMonitor = new SubProgressMonitor(pm, 50, 2);
        state.localSearchJob.schedule();
        state.remoteSearchJob.schedule();
        try {
            state.localSearchJob.join();
            state.remoteSearchJob.join();
        }
        catch (InterruptedException e) {
            String msg = "Unexpected InterruptedException while waiting for help search jobs to finish";
            HelpBasePlugin.logError(msg, e);
        }
        state.bufferedCollector.flush(collector);
        pm.done();
    }

    public void search(String expression, FederatedSearchEntry[] entries) {
        int i = 0;
        while (i < entries.length) {
            FederatedSearchJob job = new FederatedSearchJob(expression, entries[i]);
            job.schedule();
            ++i;
        }
    }

    public LocalSearchManager getLocalSearchManager() {
        return this.localManager;
    }

    public RemoteSearchManager getRemoteSearchManager() {
        return this.remoteManager;
    }

    public void close() {
        this.localManager.close();
    }

    public static AbstractSearchProcessor[] getSearchProcessors() {
        IConfigurationElement[] configs = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.help.base.searchProcessor");
        ArrayList<Object> processors = new ArrayList<Object>();
        int c = 0;
        while (c < configs.length) {
            try {
                processors.add(configs[c].createExecutableExtension("class"));
            }
            catch (CoreException coreException) {}
            ++c;
        }
        return processors.toArray(new AbstractSearchProcessor[processors.size()]);
    }

    public static ISearchResult[] convertHitsToResults(SearchHit[] hits) {
        ISearchResult[] results = new ISearchResult[hits.length];
        int r = 0;
        while (r < results.length) {
            SearchResult result = new SearchResult();
            if (hits[r].getHref() != null) {
                result.setHref(hits[r].getHref());
            }
            if (hits[r].getId() != null) {
                result.setId(hits[r].getId());
            }
            if (hits[r].getParticipantId() != null) {
                result.setParticipantId(hits[r].getParticipantId());
            }
            if (hits[r].getDescription() != null) {
                result.setDescription(hits[r].getDescription());
            }
            if (hits[r].getLabel() != null) {
                result.setLabel(hits[r].getLabel());
            }
            if (hits[r].getSummary() != null) {
                result.setSummary(hits[r].getSummary());
            }
            if (hits[r].getToc() != null) {
                result.setToc(hits[r].getToc());
            }
            if (hits[r].getIconURL() != null) {
                result.setIcon(hits[r].getIconURL());
            }
            result.setScore(hits[r].getScore());
            result.setPotentialHit(hits[r].isPotentialHit());
            results[r] = result;
            ++r;
        }
        return results;
    }

    public static SearchHit[] convertResultsToHits(ISearchResult[] results) {
        SearchHit[] hits = new SearchHit[results.length];
        int r = 0;
        while (r < results.length) {
            hits[r] = new SearchHit(results[r].getHref(), results[r].getLabel(), results[r].getSummary(), results[r].getScore(), results[r].getToc(), results[r].getId(), results[r].getParticipantId(), results[r].isPotentialHit());
            ++r;
        }
        return hits;
    }

    private class BufferedSearchHitCollector
    implements ISearchHitCollector {
        private Set<SearchHit> allHits = new HashSet<SearchHit>();
        private String wordsSearched = null;

        private BufferedSearchHitCollector() {
        }

        @Override
        public void addHits(List<SearchHit> hits, String wordsSearched) {
            if (wordsSearched != null) {
                this.wordsSearched = wordsSearched;
            }
            this.allHits.addAll(hits);
        }

        public void flush(ISearchHitCollector collector) {
            ArrayList<SearchHit> hitsList = new ArrayList<SearchHit>(this.allHits);
            Collections.sort(hitsList);
            collector.addHits(hitsList, this.wordsSearched);
            this.allHits.clear();
            this.wordsSearched = null;
        }

        @Override
        public void addQTCException(QueryTooComplexException exception) throws QueryTooComplexException {
            throw exception;
        }
    }

    private class SearchState {
        public IProgressMonitor localMonitor;
        public IProgressMonitor remoteMonitor;
        public ISearchQuery searchQuery;
        public BufferedSearchHitCollector bufferedCollector;
        public Job localSearchJob;
        public Job remoteSearchJob;

        public SearchState() {
            this.bufferedCollector = new BufferedSearchHitCollector();
            this.localSearchJob = new Job("localSearchJob"){

                protected IStatus run(IProgressMonitor monitor) {
                    SearchManager.this.localManager.search(SearchState.this.searchQuery, SearchState.this.bufferedCollector, SearchState.this.localMonitor);
                    return Status.OK_STATUS;
                }
            };
            this.remoteSearchJob = new Job("remoteSearchJob"){

                protected IStatus run(IProgressMonitor monitor) {
                    SearchManager.this.remoteManager.search(SearchState.this.searchQuery, SearchState.this.bufferedCollector, SearchState.this.remoteMonitor);
                    return Status.OK_STATUS;
                }
            };
            this.localSearchJob.setSystem(true);
            this.remoteSearchJob.setSystem(true);
        }
    }
}

