/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.ui.editor.assist;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension4;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.mylyn.wikitext.core.parser.outline.OutlineItem;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class AnchorCompletionProcessor
implements IContentAssistProcessor {
    private static final CompletionProposalComparator PROPOSAL_COMPARATOR = new CompletionProposalComparator();
    private OutlineItem outline;

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        String prefix;
        if (this.outline == null) {
            return null;
        }
        ITextSelection selection = (ITextSelection)viewer.getSelectionProvider().getSelection();
        if (selection.getOffset() == offset) {
            offset = selection.getOffset() + selection.getLength();
        }
        if ((prefix = this.extractPrefix(viewer, offset)) == null) {
            return null;
        }
        final ArrayList suggestions = new ArrayList(20);
        final int prefixOffset = offset - prefix.length();
        this.outline.accept(new OutlineItem.Visitor(){

            public boolean visit(OutlineItem item) {
                String id;
                if (item != AnchorCompletionProcessor.this.outline && (id = item.getId()) != null && id.length() > 0) {
                    suggestions.add(AnchorCompletionProcessor.this.createProposal(prefix, prefixOffset, id));
                }
                return true;
            }
        });
        if (suggestions.isEmpty()) {
            return null;
        }
        Collections.sort(suggestions, PROPOSAL_COMPARATOR);
        return suggestions.toArray(new ICompletionProposal[suggestions.size()]);
    }

    private CompletionProposal createProposal(String prefix, int offset, String id) {
        CompletionProposal proposal = new CompletionProposal(offset, id, prefix.length());
        if (id.startsWith(prefix)) {
            proposal.setRelevance(90);
        } else {
            proposal.setRelevance(0);
        }
        return proposal;
    }

    /*
     * Unable to fully structure code
     */
    protected String extractPrefix(ITextViewer viewer, int offset) {
        block4: {
            i = offset;
            document = viewer.getDocument();
            if (i <= document.getLength()) ** GOTO lbl7
            return null;
            {
                while (Character.isJavaIdentifierPart(ch = document.getChar(i - 1))) {
                    --i;
lbl7:
                    // 2 sources

                    if (i > 0) continue;
                }
                if (i != 0 && document.getChar(i - 1) == '#') break block4;
            }
            return null;
        }
        try {
            return document.get(i, offset - i);
        }
        catch (BadLocationException v0) {
            return null;
        }
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return null;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    public OutlineItem getOutline() {
        return this.outline;
    }

    public void setOutline(OutlineItem outline) {
        this.outline = outline;
    }

    private static class CompletionProposal
    implements ICompletionProposal,
    ICompletionProposalExtension4 {
        private final String proposalText;
        private final int offset;
        private final int replacementLength;
        private int relevance;

        public CompletionProposal(int offset, String proposalText, int replacementLength) {
            this.offset = offset;
            this.proposalText = proposalText;
            this.replacementLength = replacementLength;
        }

        public void apply(IDocument document) {
            try {
                document.replace(this.offset, this.replacementLength, this.proposalText);
            }
            catch (BadLocationException badLocationException) {}
        }

        public String getAdditionalProposalInfo() {
            return null;
        }

        public IContextInformation getContextInformation() {
            return null;
        }

        public String getDisplayString() {
            return this.proposalText;
        }

        public Image getImage() {
            return null;
        }

        public Point getSelection(IDocument document) {
            return new Point(this.offset + this.proposalText.length(), 0);
        }

        public boolean isAutoInsertable() {
            return true;
        }

        public int getRelevance() {
            return this.relevance;
        }

        public void setRelevance(int relevance) {
            this.relevance = relevance;
        }
    }

    private static class CompletionProposalComparator
    implements Comparator<CompletionProposal> {
        private CompletionProposalComparator() {
        }

        @Override
        public int compare(CompletionProposal o1, CompletionProposal o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1.getRelevance() > o2.getRelevance()) {
                return -1;
            }
            if (o2.getRelevance() > o1.getRelevance()) {
                return 1;
            }
            return o1.proposalText.compareTo(o2.proposalText);
        }
    }
}

