/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.provisional.analysis.lami.ui.handler;

import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.ui.handler.Messages;

@NonNullByDefault(value={})
class AddAnalysisDialog
extends Dialog {
    private final String title;
    private String fName = "";
    private String fCommand = "";
    private final IInputValidator fNameValidator;
    private final IInputValidator fCommandValidator;
    private Button fOkButton;
    private Text fNameText;
    private Text fCommandText;
    private Label fNameErrorLabel;
    private Label fCommandErrorLabel;

    public AddAnalysisDialog(Shell parentShell, String dialogTitle, IInputValidator nameValidator, IInputValidator commandValidator) {
        super(parentShell);
        this.title = dialogTitle;
        this.fNameValidator = nameValidator;
        this.fCommandValidator = commandValidator;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.fName = this.fNameText.getText();
            this.fCommand = this.fCommandText.getText();
        } else {
            this.fName = null;
            this.fCommand = null;
        }
        super.buttonPressed(buttonId);
    }

    protected boolean isResizable() {
        return true;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.fOkButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.validateInputs();
        this.fNameText.setFocus();
    }

    private static void createSubtitleLabel(Composite parent, String text) {
        Label label = new Label(parent, 64);
        label.setText(String.valueOf(text) + ':');
        FontDescriptor boldDescriptor = FontDescriptor.createFrom((Font)parent.getFont()).setStyle(1);
        Font boldFont = boldDescriptor.createFont((Device)parent.getDisplay());
        label.setFont(boldFont);
        label.addDisposeListener(event -> boldDescriptor.destroyFont(boldFont));
    }

    private static Label createErrorLabel(Composite parent) {
        Label label = new Label(parent, 64);
        Color color = new Color((Device)parent.getDisplay(), 231, 76, 60);
        label.setForeground(color);
        FontDescriptor fd = FontDescriptor.createFrom((Font)parent.getFont());
        fd.setHeight(9);
        Font font = fd.createFont((Device)parent.getDisplay());
        label.setFont(font);
        label.addDisposeListener(e -> {
            color.dispose();
            fd.destroyFont(font);
        });
        return label;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        AddAnalysisDialog.createSubtitleLabel(composite, Messages.AddAnalysisDialog_Name);
        this.fNameText = new Text(composite, this.getInputTextStyle());
        this.fNameText.setLayoutData((Object)new GridData(768));
        this.fNameText.addModifyListener(e -> this.validateInputs());
        this.fNameErrorLabel = AddAnalysisDialog.createErrorLabel(composite);
        new Label(composite, 64);
        AddAnalysisDialog.createSubtitleLabel(composite, Messages.AddAnalysisDialog_Command);
        this.fCommandText = new Text(composite, this.getInputTextStyle());
        this.fCommandText.setLayoutData((Object)new GridData(768));
        Font mono = new Font((Device)parent.getDisplay(), "Monospace", 9, 0);
        this.fCommandText.setFont(mono);
        this.fCommandText.addModifyListener(e -> this.validateInputs());
        this.fCommandText.addDisposeListener(e -> mono.dispose());
        this.fCommandErrorLabel = AddAnalysisDialog.createErrorLabel(composite);
        AddAnalysisDialog.applyDialogFont((Control)composite);
        return composite;
    }

    public void create() {
        super.create();
        Shell shell = this.getShell();
        shell.setMinimumSize(shell.getSize());
    }

    public String getName() {
        return this.fName;
    }

    public String getCommand() {
        return this.fCommand;
    }

    protected boolean validateInput(IInputValidator validator, Text text, Label errorLabel) {
        String errMsg = validator.isValid(text.getText());
        this.setErrorLabel(errorLabel, errMsg);
        return errMsg == null;
    }

    protected void validateInputs() {
        boolean valid = true;
        valid &= this.validateInput(this.fNameValidator, this.fNameText, this.fNameErrorLabel);
        this.fOkButton.setEnabled(valid &= this.validateInput(this.fCommandValidator, this.fCommandText, this.fCommandErrorLabel));
    }

    protected void setErrorLabel(Label label, String errorMessage) {
        if (label != null && !label.isDisposed()) {
            label.setText(errorMessage == null ? " \n " : errorMessage);
            boolean hasError = errorMessage != null && StringConverter.removeWhiteSpaces((String)errorMessage).length() > 0;
            label.setEnabled(hasError);
            label.setVisible(hasError);
            label.getParent().update();
            Button button = this.getButton(0);
            if (button != null) {
                button.setEnabled(errorMessage == null);
            }
        }
    }

    protected int getInputTextStyle() {
        return 2052;
    }
}

