/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.provisional.analysis.lami.ui.viewers;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Iterators;
import java.text.Format;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.aspect.LamiTableEntryAspect;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.module.LamiChartModel;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.module.LamiLabelFormat;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.module.LamiResultTable;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.module.LamiTableEntry;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.ui.signals.LamiSelectionUpdateSignal;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.ui.viewers.LamiXYChartViewer;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.ui.viewers.Messages;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;
import org.swtchart.IAxisTick;
import org.swtchart.ILineSeries;
import org.swtchart.ISeries;
import org.swtchart.LineStyle;

public class LamiScatterViewer
extends LamiXYChartViewer {
    private static final int SELECTION_SNAP_RANGE_MULTIPLIER = 20;
    private static final int SELECTION_CROSS_SIZE_MULTIPLIER = 3;
    private final Map<ISeries, List<Integer>> fIndexMapping;
    private Point fHoveringCrossDataPoint;

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public LamiScatterViewer(Composite parent, LamiResultTable resultTable, LamiChartModel graphModel) {
        super(parent, resultTable, graphModel);
        if (this.getChartModel().getChartType() != LamiChartModel.ChartType.XY_SCATTER) {
            throw new IllegalStateException("Chart type not a Scatter Chart " + this.getChartModel().getChartType().toString());
        }
        this.fIndexMapping = new HashMap<ISeries, List<Integer>>();
        this.fHoveringCrossDataPoint = new Point(-1, -1);
        List<LamiTableEntryAspect> xAxisAspects = this.getXAxisAspects();
        if (xAxisAspects.stream().distinct().count() == 1L) {
            LamiTableEntryAspect singleXAspect = xAxisAspects.get(0);
            xAxisAspects.clear();
            xAxisAspects.add(singleXAspect);
        }
        final @Nullable BiMap xMap = (BiMap)NonNullUtils.checkNotNull((Object)HashBiMap.create());
        boolean xIsLog = graphModel.xAxisIsLog();
        boolean areXAspectsContinuous = LamiScatterViewer.areAspectsContinuous(xAxisAspects);
        boolean areXAspectsTimeStamp = LamiScatterViewer.areAspectsTimeStamp(xAxisAspects);
        for (LamiTableEntryAspect aspect : xAxisAspects) {
            if (aspect.isContinuous() != areXAspectsContinuous) {
                throw new IllegalStateException("Some X aspects are continuous and some are not");
            }
            if (aspect.isTimeStamp() == areXAspectsTimeStamp) continue;
            throw new IllegalStateException("Some X aspects are time based and some are not");
        }
        if (!areXAspectsContinuous) {
            this.generateLabelMap(xAxisAspects, (BiMap<String, Integer>)((BiMap)NonNullUtils.checkNotNull((Object)xMap)));
        }
        List<LamiTableEntryAspect> yAxisAspects = this.getYAxisAspects();
        final @Nullable BiMap yMap = (BiMap)NonNullUtils.checkNotNull((Object)HashBiMap.create());
        boolean yIsLog = graphModel.yAxisIsLog();
        boolean areYAspectsContinuous = LamiScatterViewer.areAspectsContinuous(yAxisAspects);
        boolean areYAspectsTimeStamp = LamiScatterViewer.areAspectsTimeStamp(yAxisAspects);
        for (LamiTableEntryAspect aspect : yAxisAspects) {
            if (aspect.isContinuous() != areYAspectsContinuous) {
                throw new IllegalStateException("Some Y aspects are continuous and some are not");
            }
            if (aspect.isTimeStamp() == areYAspectsTimeStamp) continue;
            throw new IllegalStateException("Some Y aspects are time based and some are not");
        }
        if (!areYAspectsContinuous) {
            this.generateLabelMap(yAxisAspects, (BiMap<String, Integer>)yMap);
        }
        int index = 0;
        for (LamiTableEntryAspect yAspect : this.getYAxisAspects()) {
            LamiTableEntryAspect xAspect;
            String name = "";
            if (xAxisAspects.size() == 1) {
                xAspect = xAxisAspects.get(0);
                name = yAspect.getLabel();
            } else {
                xAspect = xAxisAspects.get(index);
                name = String.valueOf(yAspect.getName()) + ' ' + Messages.LamiScatterViewer_by + ' ' + xAspect.getName();
            }
            List<@Nullable Object> xDoubleSeries = new ArrayList();
            List<@Nullable Object> yDoubleSeries = new ArrayList();
            xDoubleSeries = xAspect.isContinuous() ? this.getResultTable().getEntries().stream().map(entry -> xAspect.resolveDouble(entry)).collect(Collectors.toList()) : this.getResultTable().getEntries().stream().map(entry -> {
                String string = xAspect.resolveString(entry);
                Integer value = (Integer)xMap.get((Object)string);
                if (value != null) {
                    return value.doubleValue();
                }
                return null;
            }).collect(Collectors.toList());
            yDoubleSeries = yAspect.isContinuous() ? this.getResultTable().getEntries().stream().map(entry -> yAspect.resolveDouble(entry)).collect(Collectors.toList()) : this.getResultTable().getEntries().stream().map(entry -> {
                String string = yAspect.resolveString(entry);
                Integer value = (Integer)yMap.get((Object)string);
                if (value != null) {
                    return value.doubleValue();
                }
                return null;
            }).collect(Collectors.toList());
            ArrayList<@Nullable Double> validXDoubleSeries = new ArrayList<Double>();
            ArrayList<@Nullable Double> validYDoubleSeries = new ArrayList<Double>();
            ArrayList<Integer> indexSeriesCorrespondance = new ArrayList<Integer>();
            if (xDoubleSeries.size() != yDoubleSeries.size()) {
                throw new IllegalStateException("Series sizes don't match!");
            }
            int i = 0;
            while (i < xDoubleSeries.size()) {
                Double xValue = (Double)xDoubleSeries.get(i);
                Double yValue = (Double)yDoubleSeries.get(i);
                if (!(xValue == null || yValue == null || xIsLog && xValue <= 0.0 || yIsLog && yValue <= 0.0)) {
                    validXDoubleSeries.add(xValue);
                    validYDoubleSeries.add(yValue);
                    indexSeriesCorrespondance.add(i);
                }
                ++i;
            }
            if (validXDoubleSeries.isEmpty() || validXDoubleSeries.isEmpty()) {
                ++index;
                continue;
            }
            ILineSeries scatterSeries = (ILineSeries)this.getChart().getSeriesSet().createSeries(ISeries.SeriesType.LINE, name);
            scatterSeries.setLineStyle(LineStyle.NONE);
            double[] xserie = validXDoubleSeries.stream().mapToDouble(elem -> (Double)NonNullUtils.checkNotNull((Object)elem)).toArray();
            double[] yserie = validYDoubleSeries.stream().mapToDouble(elem -> (Double)NonNullUtils.checkNotNull((Object)elem)).toArray();
            scatterSeries.setXSeries(xserie);
            scatterSeries.setYSeries(yserie);
            this.fIndexMapping.put((ISeries)scatterSeries, indexSeriesCorrespondance);
            ++index;
        }
        final IAxisTick xTick = this.getChart().getAxisSet().getXAxis(0).getTick();
        if (areXAspectsContinuous) {
            xTick.setFormat(LamiScatterViewer.getContinuousAxisFormatter(xAxisAspects, this.getResultTable().getEntries()));
        } else {
            xTick.setFormat((Format)new LamiLabelFormat((BiMap)NonNullUtils.checkNotNull((Object)xMap)));
            LamiScatterViewer.updateTickMark((BiMap<String, Integer>)((BiMap)NonNullUtils.checkNotNull((Object)xMap)), xTick, this.getChart().getPlotArea().getSize().x);
            this.getChart().getAxisSet().getXAxis(0).getGrid().setStyle(LineStyle.NONE);
        }
        final IAxisTick yTick = this.getChart().getAxisSet().getYAxis(0).getTick();
        if (areYAspectsContinuous) {
            yTick.setFormat(LamiScatterViewer.getContinuousAxisFormatter(yAxisAspects, this.getResultTable().getEntries()));
        } else {
            yTick.setFormat((Format)new LamiLabelFormat((BiMap)NonNullUtils.checkNotNull((Object)yMap)));
            LamiScatterViewer.updateTickMark((BiMap<String, Integer>)((BiMap)NonNullUtils.checkNotNull((Object)yMap)), yTick, this.getChart().getPlotArea().getSize().y);
            this.getChart().getAxisSet().getYAxis(0).getGrid().setStyle(LineStyle.NONE);
        }
        yTick.setTickLabelAngle(1);
        this.setLineSeriesColor();
        if (xIsLog && areXAspectsContinuous && !areXAspectsTimeStamp) {
            Stream.of(this.getChart().getAxisSet().getXAxes()).forEach(axis -> axis.enableLogScale(xIsLog));
        }
        if (yIsLog && areYAspectsContinuous && !areYAspectsTimeStamp) {
            Stream.of(this.getChart().getAxisSet().getYAxes()).forEach(axis -> axis.enableLogScale(yIsLog));
        }
        this.getChart().getAxisSet().adjustRange();
        this.getChart().getPlotArea().addMouseListener((MouseListener)new LamiScatterMouseDownListener());
        this.getChart().getPlotArea().addMouseMoveListener((MouseMoveListener)new HoveringCrossListener());
        this.getChart().getPlotArea().addListener(7, new Listener(){

            public void handleEvent(@Nullable Event event) {
                if (event != null) {
                    ((LamiScatterViewer)LamiScatterViewer.this).fHoveringCrossDataPoint.x = -1;
                    ((LamiScatterViewer)LamiScatterViewer.this).fHoveringCrossDataPoint.y = -1;
                    LamiScatterViewer.this.redraw();
                }
            }
        });
        this.getChart().getPlotArea().addPaintListener((PaintListener)new LamiScatterPainterListener());
        this.getChart().addListener(11, new Listener(){

            public void handleEvent(@Nullable Event event) {
                if (yTick.getFormat() instanceof LamiLabelFormat) {
                    LamiScatterViewer.updateTickMark((BiMap<String, Integer>)((BiMap)NonNullUtils.checkNotNull((Object)yMap)), yTick, LamiScatterViewer.this.getChart().getPlotArea().getSize().y);
                }
                if (xTick.getFormat() instanceof LamiLabelFormat) {
                    LamiScatterViewer.updateTickMark((BiMap<String, Integer>)((BiMap)NonNullUtils.checkNotNull((Object)xMap)), xTick, LamiScatterViewer.this.getChart().getPlotArea().getSize().x);
                }
            }
        });
    }

    private void generateLabelMap(List<LamiTableEntryAspect> aspects, BiMap<@Nullable String, Integer> map) {
        TreeSet<@Nullable String> set = new TreeSet<String>();
        for (LamiTableEntryAspect aspect : aspects) {
            for (LamiTableEntry entry : this.getResultTable().getEntries()) {
                String string = aspect.resolveString(entry);
                if (string == null) continue;
                set.add(string);
            }
        }
        for (String string : set) {
            map.put((Object)string, (Object)map.size());
        }
    }

    private void setLineSeriesColor() {
        Iterator colorsIt = Iterators.cycle((Iterable)COLORS);
        ISeries[] iSeriesArray = this.getChart().getSeriesSet().getSeries();
        int n = iSeriesArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISeries series = iSeriesArray[n2];
            ((ILineSeries)series).setSymbolColor((Color)colorsIt.next());
            ArrayList<Color> colors = new ArrayList<Color>();
            int i = 0;
            while (i < series.getXSeries().length) {
                Color color = ((ILineSeries)series).getSymbolColor();
                colors.add((Color)NonNullUtils.checkNotNull((Object)color));
                ++i;
            }
            ((ILineSeries)series).setSymbolColors(colors.toArray(new Color[colors.size()]));
            ++n2;
        }
    }

    private int getTableEntryIndexFromGraphIndex(ISeries series, int index) {
        List<Integer> indexes = this.fIndexMapping.get(series);
        if (indexes == null || index > indexes.size() || index < 0) {
            return -1;
        }
        return indexes.get(index);
    }

    private int getGraphIndexFromTableEntryIndex(ISeries series, int index) {
        List<Integer> indexes = this.fIndexMapping.get(series);
        if (indexes == null || !indexes.contains(index)) {
            return -1;
        }
        return indexes.indexOf(index);
    }

    @Override
    protected void refreshDisplayLabels() {
    }

    protected Set<Integer> getInternalSelections() {
        Set<Integer> indexes = super.getSelection();
        Set<Integer> internalIndexes = indexes.stream().mapToInt(index -> this.getResultTable().getEntries().indexOf(this.getResultTable().getEntries().get((int)index))).boxed().collect(Collectors.toSet());
        return internalIndexes;
    }

    private static void updateTickMark(BiMap<@Nullable String, Integer> map, IAxisTick tick, int availableLenghtPixel) {
        int nbLabels = Math.max(1, map.size());
        int stepSizePixel = availableLenghtPixel / nbLabels;
        if (16.0 > (double)stepSizePixel) {
            stepSizePixel = 16;
        }
        tick.setTickMarkStepHint(stepSizePixel);
    }

    @Override
    protected void setSelection(@NonNull Set<@NonNull Integer> selection) {
        super.setSelection(selection);
        Iterator colorsIt = Iterators.cycle((Iterable)COLORS);
        Iterator lightColorsIt = Iterators.cycle((Iterable)LIGHT_COLORS);
        Set<Integer> currentSelections = this.getInternalSelections();
        ISeries[] iSeriesArray = this.getChart().getSeriesSet().getSeries();
        int n = iSeriesArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISeries series = iSeriesArray[n2];
            Color lightColor = (Color)lightColorsIt.next();
            Color color = (Color)colorsIt.next();
            Object[] colors = ((ILineSeries)series).getSymbolColors();
            if (currentSelections.isEmpty()) {
                Arrays.fill(colors, color);
            } else {
                Arrays.fill(colors, lightColor);
            }
            ((ILineSeries)series).setSymbolColors((Color[])colors);
            ++n2;
        }
    }

    private final class HoveringCrossListener
    implements MouseMoveListener {
        private HoveringCrossListener() {
        }

        public void mouseMove(@Nullable MouseEvent e) {
            if (e == null) {
                return;
            }
            ISeries[] series = LamiScatterViewer.this.getChart().getSeriesSet().getSeries();
            @Nullable Point closest = null;
            double closestDistance = -1.0;
            ISeries[] iSeriesArray = series;
            int n = series.length;
            int n2 = 0;
            while (n2 < n) {
                ISeries oneSeries = iSeriesArray[n2];
                ILineSeries lineSerie = (ILineSeries)oneSeries;
                int i = 0;
                while (i < lineSerie.getXSeries().length) {
                    Point dataPoint = lineSerie.getPixelCoordinates(i);
                    int snapRangeRadius = lineSerie.getSymbolSize() * 20;
                    double distance = Math.hypot(dataPoint.x - e.x, dataPoint.y - e.y);
                    if (distance < (double)snapRangeRadius && (closestDistance == -1.0 || distance < closestDistance)) {
                        closest = dataPoint;
                        closestDistance = distance;
                    }
                    ++i;
                }
                ++n2;
            }
            if (closest != null) {
                ((LamiScatterViewer)LamiScatterViewer.this).fHoveringCrossDataPoint.x = closest.x;
                ((LamiScatterViewer)LamiScatterViewer.this).fHoveringCrossDataPoint.y = closest.y;
            } else {
                ((LamiScatterViewer)LamiScatterViewer.this).fHoveringCrossDataPoint.x = -1;
                ((LamiScatterViewer)LamiScatterViewer.this).fHoveringCrossDataPoint.y = -1;
            }
            LamiScatterViewer.this.refresh();
        }
    }

    private final class LamiScatterMouseDownListener
    extends MouseAdapter {
        private LamiScatterMouseDownListener() {
        }

        public void mouseDown(@Nullable MouseEvent event) {
            if (event == null || event.button != 1) {
                return;
            }
            int xMouseLocation = event.x;
            int yMouseLocation = event.y;
            boolean ctrlMode = false;
            ISeries[] series = LamiScatterViewer.this.getChart().getSeriesSet().getSeries();
            Set<Integer> selections = LamiScatterViewer.this.getSelection();
            if ((event.stateMask & 0x40000) != 0) {
                selections = LamiScatterViewer.this.getSelection();
                ctrlMode = true;
            } else {
                LamiScatterViewer.this.unsetSelection();
                selections = new HashSet<Integer>();
            }
            ISeries[] iSeriesArray = series;
            int n = series.length;
            int n2 = 0;
            while (n2 < n) {
                int tableEntryIndex;
                ISeries oneSeries = iSeriesArray[n2];
                ILineSeries lineSerie = (ILineSeries)oneSeries;
                int closest = -1;
                double closestDistance = -1.0;
                int i = 0;
                while (i < lineSerie.getXSeries().length) {
                    int snapRangeRadius;
                    Point dataPoint = lineSerie.getPixelCoordinates(i);
                    double distance = Math.hypot(dataPoint.x - xMouseLocation, dataPoint.y - yMouseLocation);
                    if (distance < (double)(snapRangeRadius = lineSerie.getSymbolSize() * 20) && (closestDistance == -1.0 || distance < closestDistance)) {
                        closest = i;
                        closestDistance = distance;
                    }
                    ++i;
                }
                if (closest != -1 && (tableEntryIndex = LamiScatterViewer.this.getTableEntryIndexFromGraphIndex((ISeries)NonNullUtils.checkNotNull((Object)oneSeries), closest)) >= 0) {
                    LamiTableEntry entry = (LamiTableEntry)LamiScatterViewer.this.getResultTable().getEntries().get(tableEntryIndex);
                    int index = LamiScatterViewer.this.getResultTable().getEntries().indexOf(entry);
                    if (ctrlMode && selections.remove(index)) break;
                    selections.add(index);
                    break;
                }
                ++n2;
            }
            LamiScatterViewer.this.setSelection(selections);
            LamiSelectionUpdateSignal signal = new LamiSelectionUpdateSignal((Object)this, selections, (Integer)NonNullUtils.checkNotNull((Object)LamiScatterViewer.this.getResultTable().hashCode()));
            TmfSignalManager.dispatchSignal((TmfSignal)signal);
            LamiScatterViewer.this.refresh();
        }
    }

    private final class LamiScatterPainterListener
    implements PaintListener {
        private LamiScatterPainterListener() {
        }

        public void paintControl(@Nullable PaintEvent e) {
            if (e == null) {
                return;
            }
            GC gc = e.gc;
            this.drawSelectedDot((GC)NonNullUtils.checkNotNull((Object)gc));
            this.drawHoveringCross((GC)NonNullUtils.checkNotNull((Object)gc));
        }

        private void drawSelectedDot(GC gc) {
            if (LamiScatterViewer.this.isSelected()) {
                Iterator colorsIt = Iterators.cycle((Iterable)COLORS);
                ISeries[] iSeriesArray = LamiScatterViewer.this.getChart().getSeriesSet().getSeries();
                int n = iSeriesArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ISeries series = iSeriesArray[n2];
                    Color color = (Color)colorsIt.next();
                    int symbolSize = ((ILineSeries)series).getSymbolSize();
                    for (int index : LamiScatterViewer.this.getInternalSelections()) {
                        int graphIndex = LamiScatterViewer.this.getGraphIndexFromTableEntryIndex(series, index);
                        if (graphIndex < 0) continue;
                        Point point = series.getPixelCoordinates(graphIndex);
                        gc.setBackground(color);
                        gc.fillOval(point.x - symbolSize, point.y - symbolSize, symbolSize * 2, symbolSize * 2);
                        gc.setLineWidth(2);
                        gc.setLineStyle(1);
                        int drawingDelta = 3 * symbolSize;
                        gc.drawLine(point.x, point.y - drawingDelta, point.x, point.y + drawingDelta);
                        gc.drawLine(point.x - drawingDelta, point.y, point.x + drawingDelta, point.y);
                    }
                    ++n2;
                }
            }
        }

        private void drawHoveringCross(GC gc) {
            gc.setLineWidth(1);
            gc.setLineStyle(1);
            gc.setForeground(Display.getCurrent().getSystemColor(2));
            gc.setBackground(Display.getCurrent().getSystemColor(1));
            gc.drawLine(((LamiScatterViewer)LamiScatterViewer.this).fHoveringCrossDataPoint.x, 0, ((LamiScatterViewer)LamiScatterViewer.this).fHoveringCrossDataPoint.x, LamiScatterViewer.this.getChart().getPlotArea().getSize().y);
            gc.drawLine(0, ((LamiScatterViewer)LamiScatterViewer.this).fHoveringCrossDataPoint.y, LamiScatterViewer.this.getChart().getPlotArea().getSize().x, ((LamiScatterViewer)LamiScatterViewer.this).fHoveringCrossDataPoint.y);
        }
    }
}

