/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.controlflow;

import com.google.common.collect.ImmutableList;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.controlflow.IControlFlowEntryComparator;
import org.eclipse.tracecompass.tmf.ui.views.timegraph.ITimeGraphEntryComparator;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;

public final class ControlFlowColumnComparators {
    public static final ITimeGraphEntryComparator PROCESS_NAME_COLUMN_COMPARATOR = new ITimeGraphEntryComparator(){
        private final List<Comparator<ITimeGraphEntry>> SECONDARY_COMPARATORS = this.init();
        private int fDirection = 1024;

        public int compare(@Nullable ITimeGraphEntry o1, @Nullable ITimeGraphEntry o2) {
            int result = IControlFlowEntryComparator.PROCESS_NAME_COMPARATOR.compare(o1, o2);
            return ControlFlowColumnComparators.compareList(result, this.fDirection, this.SECONDARY_COMPARATORS, o1, o2);
        }

        public void setDirection(int direction) {
            this.fDirection = direction;
        }

        private List<Comparator<ITimeGraphEntry>> init() {
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.add(IControlFlowEntryComparator.BIRTH_TIME_COMPARATOR).add(IControlFlowEntryComparator.TID_COMPARATOR).add(IControlFlowEntryComparator.PTID_COMPARATOR);
            return builder.build();
        }
    };
    public static final ITimeGraphEntryComparator TID_COLUMN_COMPARATOR = new ITimeGraphEntryComparator(){
        private final List<Comparator<ITimeGraphEntry>> SECONDARY_COMPARATORS = this.init();
        private int fDirection = 1024;

        public int compare(@Nullable ITimeGraphEntry o1, @Nullable ITimeGraphEntry o2) {
            int result = IControlFlowEntryComparator.TID_COMPARATOR.compare(o1, o2);
            return ControlFlowColumnComparators.compareList(result, this.fDirection, this.SECONDARY_COMPARATORS, o1, o2);
        }

        public void setDirection(int direction) {
            this.fDirection = direction;
        }

        private List<Comparator<ITimeGraphEntry>> init() {
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.add(IControlFlowEntryComparator.BIRTH_TIME_COMPARATOR).add(IControlFlowEntryComparator.PROCESS_NAME_COMPARATOR).add(IControlFlowEntryComparator.PTID_COMPARATOR);
            return builder.build();
        }
    };
    public static final ITimeGraphEntryComparator PTID_COLUMN_COMPARATOR = new ITimeGraphEntryComparator(){
        private final List<Comparator<ITimeGraphEntry>> SECONDARY_COMPARATORS = this.init();
        private int fDirection = 1024;

        public int compare(@Nullable ITimeGraphEntry o1, @Nullable ITimeGraphEntry o2) {
            int result = IControlFlowEntryComparator.PTID_COMPARATOR.compare(o1, o2);
            return ControlFlowColumnComparators.compareList(result, this.fDirection, this.SECONDARY_COMPARATORS, o1, o2);
        }

        public void setDirection(int direction) {
            this.fDirection = direction;
        }

        private List<Comparator<ITimeGraphEntry>> init() {
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.add(IControlFlowEntryComparator.BIRTH_TIME_COMPARATOR).add(IControlFlowEntryComparator.PROCESS_NAME_COMPARATOR).add(IControlFlowEntryComparator.TID_COMPARATOR);
            return builder.build();
        }
    };
    public static final ITimeGraphEntryComparator BIRTH_TIME_COLUMN_COMPARATOR = new ITimeGraphEntryComparator(){
        private final List<Comparator<ITimeGraphEntry>> SECONDARY_COMPARATORS = this.init();
        private int fDirection = 1024;

        public int compare(@Nullable ITimeGraphEntry o1, @Nullable ITimeGraphEntry o2) {
            int result = IControlFlowEntryComparator.BIRTH_TIME_COMPARATOR.compare(o1, o2);
            return ControlFlowColumnComparators.compareList(result, this.fDirection, this.SECONDARY_COMPARATORS, o1, o2);
        }

        public void setDirection(int direction) {
            this.fDirection = direction;
        }

        private List<Comparator<ITimeGraphEntry>> init() {
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.add(IControlFlowEntryComparator.PROCESS_NAME_COMPARATOR).add(IControlFlowEntryComparator.TID_COMPARATOR).add(IControlFlowEntryComparator.PTID_COMPARATOR);
            return builder.build();
        }
    };

    private ControlFlowColumnComparators() {
    }

    private static int compareList(int prevResult, int direction, List<Comparator<ITimeGraphEntry>> comps, ITimeGraphEntry o1, ITimeGraphEntry o2) {
        int result = prevResult;
        for (Comparator<ITimeGraphEntry> comparator : comps) {
            if (result != 0) continue;
            result = comparator.compare(o1, o2);
            if (direction != 128) continue;
            result = -result;
        }
        return result;
    }
}

