/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.timing.ui.views.segmentstore.scatter;

import java.text.Format;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tracecompass.analysis.timing.core.segmentstore.IAnalysisProgressListener;
import org.eclipse.tracecompass.analysis.timing.core.segmentstore.ISegmentStoreProvider;
import org.eclipse.tracecompass.analysis.timing.ui.views.segmentstore.SubSecondTimeWithUnitFormat;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.analysis.timing.ui.Activator;
import org.eclipse.tracecompass.internal.analysis.timing.ui.views.segmentstore.scatter.Messages;
import org.eclipse.tracecompass.internal.analysis.timing.ui.views.segmentstore.scatter.SegmentStoreScatterGraphTooltipProvider;
import org.eclipse.tracecompass.segmentstore.core.ISegment;
import org.eclipse.tracecompass.segmentstore.core.ISegmentStore;
import org.eclipse.tracecompass.segmentstore.core.SegmentComparators;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceClosedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceSelectedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfWindowRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.ui.signal.TmfTimeViewAlignmentInfo;
import org.eclipse.tracecompass.tmf.ui.signal.TmfTimeViewAlignmentSignal;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.ITmfChartTimeProvider;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.TmfBaseProvider;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.TmfChartTimeStampFormat;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.linecharts.TmfCommonXLineChartViewer;
import org.swtchart.Chart;
import org.swtchart.IAxis;
import org.swtchart.IAxisTick;
import org.swtchart.ILineSeries;
import org.swtchart.ISeries;
import org.swtchart.ISeriesSet;
import org.swtchart.LineStyle;
import org.swtchart.Range;

public abstract class AbstractSegmentStoreScatterGraphViewer
extends TmfCommonXLineChartViewer {
    private static final Format FORMAT = new SubSecondTimeWithUnitFormat();
    private long fPixelSize = -1L;
    private long fPixelStart = 0L;
    private Collection<ISegment> fDisplayData = Collections.EMPTY_LIST;
    private SegmentStoreProviderProgressListener fListener;
    private @Nullable ISegmentStoreProvider fSegmentProvider;
    private @Nullable Job fCompactingJob;

    public AbstractSegmentStoreScatterGraphViewer(Composite parent, String title, String xLabel, String yLabel) {
        super(parent, title, xLabel, yLabel);
        this.setTooltipProvider((TmfBaseProvider)new SegmentStoreScatterGraphTooltipProvider((ITmfChartTimeProvider)this));
        this.fListener = new SegmentStoreProviderProgressListener();
        ITmfTrace trace = TmfTraceManager.getInstance().getActiveTrace();
        this.initializeProvider(trace);
        this.getSwtChart().getLegend().setVisible(false);
        this.getSwtChart().getAxisSet().getYAxis(0).getTick().setFormat(FORMAT);
    }

    private final void initializeProvider(@Nullable ITmfTrace trace) {
        ISegmentStoreProvider segmentStoreProvider;
        if (trace != null && (segmentStoreProvider = this.getSegmentStoreProvider(trace)) != null) {
            segmentStoreProvider.addListener((IAnalysisProgressListener)this.fListener);
            this.setData(segmentStoreProvider);
            this.updateRange(TmfTraceManager.getInstance().getCurrentTraceContext().getWindowRange());
        }
    }

    public void updateModel(@Nullable ISegmentStore<ISegment> dataInput) {
        TmfTimeRange currentRange = TmfTraceManager.getInstance().getCurrentTraceContext().getWindowRange();
        long currentStart = currentRange.getStartTime().toNanos();
        long currentEnd = currentRange.getEndTime().toNanos();
        if (dataInput == null) {
            if (!AbstractSegmentStoreScatterGraphViewer.getDisplay().isDisposed()) {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        AbstractSegmentStoreScatterGraphViewer.this.clearContent();
                    }
                });
            }
            this.fDisplayData = Collections.EMPTY_LIST;
        } else {
            Collection elements = (Collection)dataInput.getIntersectingElements(currentStart, currentEnd);
            ArrayList<ISegment> list = new ArrayList<ISegment>(elements);
            Collections.sort(list, SegmentComparators.INTERVAL_START_COMPARATOR);
            this.fDisplayData = list;
        }
        this.setWindowRange(currentStart, currentEnd);
        this.updateRange(currentRange);
    }

    protected void initializeDataSource() {
        ITmfTrace trace = this.getTrace();
        this.initializeProvider(trace);
        if (trace != null) {
            this.setData(this.getSegmentStoreProvider(trace));
        }
    }

    protected void updateData(long start, long end, int nb, @Nullable IProgressMonitor monitor) {
        int dataSize;
        Collection<ISegment> data = this.fDisplayData;
        int n = dataSize = nb == 0 ? data.size() : nb;
        if (dataSize == 0 || end == start) {
            return;
        }
        double[] xSeries = new double[dataSize];
        double[] ySeries = new double[dataSize];
        Iterator<ISegment> modelIter = data.iterator();
        long maxTempY = 1L;
        int i = 0;
        while (i < dataSize) {
            if (modelIter.hasNext()) {
                ISegment segment = modelIter.next();
                xSeries[i] = segment.getStart() - start;
                ySeries[i] = segment.getLength();
                maxTempY = Math.max(maxTempY, segment.getLength());
            }
            ++i;
        }
        long maxY = maxTempY;
        this.setXAxis(xSeries);
        Chart swtChart = this.getSwtChart();
        if (swtChart.isDisposed() || xSeries.length < 1) {
            return;
        }
        swtChart.updateLayout();
        this.setSeries(Messages.SegmentStoreScatterGraphViewer_legend, ySeries);
        TmfChartTimeStampFormat tmfChartTimeStampFormat = new TmfChartTimeStampFormat(this.getTimeOffset());
        ILineSeries series = (ILineSeries)swtChart.getSeriesSet().getSeries(Messages.SegmentStoreScatterGraphViewer_legend);
        if (series == null) {
            series = this.addSeries(Messages.SegmentStoreScatterGraphViewer_legend);
        }
        series.setXSeries(xSeries);
        series.setYSeries(ySeries);
        IAxis xAxis = swtChart.getAxisSet().getXAxis(0);
        IAxisTick xTick = xAxis.getTick();
        xTick.setFormat((Format)tmfChartTimeStampFormat);
        xAxis.setRange(new Range(0.0, (double)(end - start)));
        if ((double)maxY > 0.0) {
            swtChart.getAxisSet().getYAxis(0).setRange(new Range(0.0, (double)maxY));
        }
        swtChart.redraw();
        if (this.isSendTimeAlignSignals()) {
            Point viewPos = this.getParent().getParent().toDisplay(0, 0);
            int axisPos = swtChart.toDisplay((int)0, (int)0).x + this.getPointAreaOffset();
            int timeAxisOffset = axisPos - viewPos.x;
            TmfTimeViewAlignmentInfo timeAlignmentInfo = new TmfTimeViewAlignmentInfo(this.getControl().getShell(), viewPos, timeAxisOffset);
            TmfSignalManager.dispatchSignal((TmfSignal)new TmfTimeViewAlignmentSignal((Object)this, timeAlignmentInfo, true));
        }
    }

    protected void setWindowRange(long windowStartTime, long windowEndTime) {
        super.setWindowRange(windowStartTime, windowEndTime);
    }

    protected ILineSeries addSeries(@Nullable String seriesName) {
        ISeriesSet seriesSet = this.getSwtChart().getSeriesSet();
        ILineSeries series = (ILineSeries)seriesSet.createSeries(ISeries.SeriesType.LINE, seriesName);
        series.setVisible(true);
        series.enableArea(false);
        series.setLineStyle(LineStyle.NONE);
        series.setSymbolType(ILineSeries.PlotSymbolType.DIAMOND);
        return series;
    }

    public void setData(@Nullable ISegmentStoreProvider provider) {
        if (provider == null) {
            this.updateModel(null);
            return;
        }
        ISegmentStore segStore = provider.getSegmentStore();
        if (segStore != null) {
            this.updateModel((ISegmentStore<ISegment>)segStore);
            this.setSegmentProvider(provider);
            return;
        }
        this.updateModel(null);
        provider.addListener((IAnalysisProgressListener)this.fListener);
        if (provider instanceof IAnalysisModule) {
            ((IAnalysisModule)provider).schedule();
        }
        this.setSegmentProvider(provider);
    }

    protected abstract @Nullable ISegmentStoreProvider getSegmentStoreProvider(ITmfTrace var1);

    @TmfSignalHandler
    public void traceSelected(@Nullable TmfTraceSelectedSignal signal) {
        super.traceSelected(signal);
        if (signal == null) {
            return;
        }
        ITmfTrace trace = signal.getTrace();
        this.setTrace(trace);
        if (trace != null) {
            TmfTimeRange timeRange = TmfTraceManager.getInstance().getCurrentTraceContext().getWindowRange();
            this.setWindowRange(timeRange.getStartTime().toNanos(), timeRange.getEndTime().toNanos());
            this.setData(this.getSegmentStoreProvider(trace));
            this.updateRange(timeRange);
        }
    }

    @TmfSignalHandler
    public void traceOpened(@Nullable TmfTraceOpenedSignal signal) {
        super.traceOpened(signal);
        if (signal == null) {
            return;
        }
        ITmfTrace trace = signal.getTrace();
        this.setTrace(trace);
        if (trace != null) {
            ISegmentStoreProvider segmentStoreProvider = this.getSegmentStoreProvider(trace);
            TmfTimeRange timeRange = TmfTraceManager.getInstance().getCurrentTraceContext().getWindowRange();
            this.setWindowRange(timeRange.getStartTime().toNanos(), timeRange.getEndTime().toNanos());
            this.setData(segmentStoreProvider);
        }
    }

    private void updateRange(@Nullable TmfTimeRange timeRange) {
        Job compactingJob = this.fCompactingJob;
        if (compactingJob != null && compactingJob.getState() == 4) {
            compactingJob.cancel();
        }
        this.fCompactingJob = compactingJob = new CompactingSegmentStoreQuery((TmfTimeRange)NonNullUtils.checkNotNull((Object)timeRange));
        compactingJob.schedule();
    }

    @TmfSignalHandler
    public void traceClosed(@Nullable TmfTraceClosedSignal signal) {
        super.traceClosed(signal);
        if (signal != null && TmfTraceManager.getInstance().getActiveTrace() == null) {
            ISegmentStoreProvider provider = this.getSegmentProvider();
            if (provider != null) {
                provider.removeListener((IAnalysisProgressListener)this.fListener);
            }
            this.clearContent();
        }
        this.refresh();
    }

    @TmfSignalHandler
    public void windowRangeUpdated(@Nullable TmfWindowRangeUpdatedSignal signal) {
        super.windowRangeUpdated(signal);
        if (signal == null) {
            return;
        }
        if (this.getTrace() != null) {
            TmfTimeRange currentRange = signal.getCurrentRange();
            this.updateRange(currentRange);
        } else {
            Activator.getDefault().logInfo("No Trace to update");
        }
    }

    private @Nullable ISegmentStoreProvider getSegmentProvider() {
        return this.fSegmentProvider;
    }

    private void setSegmentProvider(ISegmentStoreProvider provider) {
        this.fSegmentProvider = provider;
    }

    private final class CompactingSegmentStoreQuery
    extends Job {
        private static final long MAX_POINTS = 1000L;
        private final TmfTimeRange fCurrentRange;

        private CompactingSegmentStoreQuery(TmfTimeRange currentRange) {
            super(Messages.SegmentStoreScatterGraphViewer_compactTitle);
            this.fCurrentRange = currentRange;
        }

        protected IStatus run(@Nullable IProgressMonitor monitor) {
            IProgressMonitor statusMonitor = monitor;
            if (statusMonitor == null) {
                return new Status(4, "org.eclipse.tracecompass.analysis.timing.ui", "Monitor is null");
            }
            ISegmentStoreProvider segmentProvider = AbstractSegmentStoreScatterGraphViewer.this.getSegmentProvider();
            long startTimeInNanos = this.fCurrentRange.getStartTime().toNanos();
            long endTimeInNanos = this.fCurrentRange.getEndTime().toNanos();
            if (segmentProvider == null) {
                AbstractSegmentStoreScatterGraphViewer.this.setWindowRange(startTimeInNanos, endTimeInNanos);
                this.redraw(statusMonitor, startTimeInNanos, startTimeInNanos, Collections.EMPTY_LIST);
                return new Status(2, "org.eclipse.tracecompass.analysis.timing.ui", "segment provider not available");
            }
            ISegmentStore segStore = segmentProvider.getSegmentStore();
            if (segStore == null) {
                AbstractSegmentStoreScatterGraphViewer.this.setWindowRange(startTimeInNanos, endTimeInNanos);
                this.redraw(statusMonitor, startTimeInNanos, startTimeInNanos, Collections.EMPTY_LIST);
                return new Status(1, "org.eclipse.tracecompass.analysis.timing.ui", "Segment provider does not have segments");
            }
            long startTime = this.fCurrentRange.getStartTime().getValue();
            long endTime = this.fCurrentRange.getEndTime().getValue();
            AbstractSegmentStoreScatterGraphViewer.this.fPixelStart = startTime;
            AbstractSegmentStoreScatterGraphViewer.this.fPixelSize = (endTime - startTime) / 1000L;
            Iterable intersectingElements = segStore.getIntersectingElements(startTime, endTime);
            List<ISegment> list = this.convertIterableToList(intersectingElements, statusMonitor);
            List<ISegment> displayData = !list.isEmpty() ? this.compactList(startTime, list, statusMonitor) : list;
            AbstractSegmentStoreScatterGraphViewer.this.setWindowRange(startTimeInNanos, endTimeInNanos);
            this.redraw(statusMonitor, startTime, endTime, displayData);
            if (statusMonitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            return Status.OK_STATUS;
        }

        private void redraw(final IProgressMonitor statusMonitor, final long startTime, final long endTime, final List<ISegment> displayData) {
            AbstractSegmentStoreScatterGraphViewer.this.fDisplayData = displayData;
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    AbstractSegmentStoreScatterGraphViewer.this.updateData(startTime, endTime, displayData.size(), statusMonitor);
                }
            });
        }

        private List<ISegment> compactList(long startTime, List<ISegment> listToCompact, IProgressMonitor statusMonitor) {
            ArrayList<ISegment> displayData = new ArrayList<ISegment>();
            ISegment last = listToCompact.get(0);
            if (last.getStart() >= startTime) {
                displayData.add(last);
            }
            for (ISegment next : listToCompact) {
                if (next.getStart() < startTime) continue;
                if (statusMonitor.isCanceled()) {
                    return Collections.EMPTY_LIST;
                }
                if (this.overlaps(last, next)) continue;
                displayData.add(next);
                last = next;
            }
            return displayData;
        }

        private List<ISegment> convertIterableToList(Iterable<ISegment> iterable, IProgressMonitor statusMonitor) {
            ArrayList<ISegment> list = new ArrayList<ISegment>();
            for (ISegment seg : iterable) {
                if (statusMonitor.isCanceled()) {
                    return Collections.EMPTY_LIST;
                }
                list.add(seg);
            }
            Collections.sort(list, SegmentComparators.INTERVAL_START_COMPARATOR);
            return list;
        }

        private boolean overlaps(ISegment last, ISegment next) {
            long timePerPix = AbstractSegmentStoreScatterGraphViewer.this.fPixelSize;
            long start = last.getStart();
            long pixelStart = AbstractSegmentStoreScatterGraphViewer.this.fPixelStart;
            long pixelDuration = start - pixelStart;
            long startPixBoundL = pixelDuration / timePerPix * timePerPix + pixelStart;
            long startPixBoundR = startPixBoundL + timePerPix;
            long currentStart = next.getStart();
            if (currentStart >= startPixBoundL && currentStart <= startPixBoundR) {
                long length = last.getLength();
                long lengthNext = next.getLength();
                long lengthLow = length / timePerPix * timePerPix;
                long lengthHigh = lengthLow + timePerPix;
                return lengthNext >= lengthLow && lengthNext <= lengthHigh;
            }
            return false;
        }
    }

    private final class SegmentStoreProviderProgressListener
    implements IAnalysisProgressListener {
        private SegmentStoreProviderProgressListener() {
        }

        public void onComplete(ISegmentStoreProvider segmentProvider, ISegmentStore<ISegment> segmentStore) {
            if (segmentProvider.equals(AbstractSegmentStoreScatterGraphViewer.this.getSegmentProvider())) {
                AbstractSegmentStoreScatterGraphViewer.this.updateModel(segmentStore);
                AbstractSegmentStoreScatterGraphViewer.this.updateRange(TmfTraceManager.getInstance().getCurrentTraceContext().getWindowRange());
            }
        }
    }
}

