/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteConnectionChangeListener;
import org.eclipse.remote.core.RemoteConnectionChangeEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TargetNodeState;
import org.eclipse.tracecompass.internal.lttng2.control.ui.Activator;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.messages.Messages;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.ITraceControlComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.NullControlService;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceControlComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceProviderGroup;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceSessionComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceSessionGroup;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.property.TargetNodePropertySource;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.service.ILttngControlService;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.service.LTTngControlServiceFactory;
import org.eclipse.tracecompass.tmf.remote.core.proxy.RemoteSystemProxy;
import org.eclipse.tracecompass.tmf.remote.core.shell.ICommandShell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.IPropertySource;

public class TargetNodeComponent
extends TraceControlComponent
implements IRemoteConnectionChangeListener {
    public static final String TARGET_NODE_CONNECTED_ICON_FILE = "icons/obj16/target_connected.gif";
    public static final String TARGET_NODE_DISCONNECTED_ICON_FILE = "icons/obj16/target_disconnected.gif";
    private static final ILttngControlService NULL_CONTROL_SERVICE = new NullControlService();
    private TargetNodeState fState = TargetNodeState.DISCONNECTED;
    private Image fDisconnectedImage = null;
    private @NonNull RemoteSystemProxy fRemoteProxy;
    private ILttngControlService fService = null;
    private ICommandShell fShell = null;

    public TargetNodeComponent(String name, ITraceControlComponent parent, @NonNull RemoteSystemProxy proxy) {
        super(name, parent);
        this.setImage(TARGET_NODE_CONNECTED_ICON_FILE);
        this.fDisconnectedImage = Activator.getDefault().loadIcon(TARGET_NODE_DISCONNECTED_ICON_FILE);
        this.fRemoteProxy = proxy;
        this.fRemoteProxy.getRemoteConnection().addConnectionChangeListener((IRemoteConnectionChangeListener)this);
        this.setToolTip(this.fRemoteProxy.getRemoteConnection().getName());
    }

    public TargetNodeComponent(String name, ITraceControlComponent parent, @NonNull IRemoteConnection host) {
        this(name, parent, new RemoteSystemProxy(host));
    }

    @Override
    public void dispose() {
        this.fRemoteProxy.getRemoteConnection().removeConnectionChangeListener((IRemoteConnectionChangeListener)this);
        this.fRemoteProxy.dispose();
        this.disposeControlService();
    }

    private void disposeControlService() {
        this.fService = null;
        ICommandShell shell = this.fShell;
        if (shell != null) {
            shell.dispose();
            this.fShell = null;
        }
    }

    @Override
    public Image getImage() {
        if (this.fState == TargetNodeState.CONNECTED) {
            return super.getImage();
        }
        return this.fDisconnectedImage;
    }

    @Override
    public TargetNodeState getTargetNodeState() {
        return this.fState;
    }

    @Override
    public void setTargetNodeState(TargetNodeState state) {
        this.fState = state;
        this.fireComponentChanged(this);
    }

    @Override
    public ILttngControlService getControlService() {
        return this.fService == null ? NULL_CONTROL_SERVICE : this.fService;
    }

    @Override
    public void setControlService(ILttngControlService service) {
        this.fService = service;
    }

    @Override
    public <T> @Nullable T getAdapter(Class<T> adapter) {
        if (adapter == IPropertySource.class) {
            return adapter.cast(new TargetNodePropertySource(this));
        }
        return null;
    }

    public @NonNull RemoteSystemProxy getRemoteSystemProxy() {
        return this.fRemoteProxy;
    }

    public @NonNull TraceSessionComponent[] getSessions() {
        List<ITraceControlComponent> compenents = this.getChildren(TraceSessionGroup.class);
        if (compenents.size() > 0) {
            TraceSessionGroup group = (TraceSessionGroup)compenents.get(0);
            List<ITraceControlComponent> sessions = group.getChildren(TraceSessionComponent.class);
            return sessions.toArray(new TraceSessionComponent[sessions.size()]);
        }
        return new TraceSessionComponent[0];
    }

    public String getNodeVersion() {
        if (this.getControlService() != NULL_CONTROL_SERVICE) {
            return this.getControlService().getVersionString();
        }
        return "";
    }

    public boolean isEventFilteringSupported(boolean isKernel) {
        if (isKernel) {
            return this.getControlService().isVersionSupported("2.7.0");
        }
        return this.getControlService().isVersionSupported("2.1.0");
    }

    public boolean isNetworkStreamingSupported() {
        return this.getControlService().isVersionSupported("2.1.0");
    }

    public boolean isBufferTypeConfigSupported() {
        return this.getControlService().isVersionSupported("2.2.0");
    }

    public boolean isTraceFileRotationSupported() {
        return this.getControlService().isVersionSupported("2.2.0");
    }

    public boolean isPeriodicalMetadataFlushSupported() {
        return this.getControlService().isVersionSupported("2.2.0");
    }

    public boolean isSnapshotSupported() {
        return this.getControlService().isVersionSupported("2.3.0");
    }

    public boolean isLiveSupported() {
        return false;
    }

    public boolean isContextOnEventSupported() {
        return !this.getControlService().isVersionSupported("2.2.0");
    }

    public boolean isVersionSupported(String version) {
        return this.getControlService().isVersionSupported(version);
    }

    public void connectionChanged(RemoteConnectionChangeEvent e) {
        if (this.fState == TargetNodeState.CONNECTING) {
            return;
        }
        switch (e.getType()) {
            case 1: 
            case 4: {
                this.handleDisconnected();
                break;
            }
            case 2: {
                this.handleConnected();
                break;
            }
        }
    }

    public void connect() {
        if (this.fState == TargetNodeState.DISCONNECTED) {
            try {
                this.setTargetNodeState(TargetNodeState.CONNECTING);
                Job job = new Job(MessageFormat.format(Messages.TraceControl_OpenConnectionTo, this.getName())){

                    protected IStatus run(IProgressMonitor monitor) {
                        try {
                            TargetNodeComponent.this.fRemoteProxy.connect((IProgressMonitor)NonNullUtils.checkNotNull((Object)monitor));
                            return Status.OK_STATUS;
                        }
                        catch (Exception e) {
                            return new Status(4, "org.eclipse.tracecompass.lttng2.control.ui", Messages.TraceControl_ConnectionFailure, (Throwable)e);
                        }
                    }
                };
                job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                    public void done(IJobChangeEvent event) {
                        IStatus status = event.getResult();
                        if (status.isOK()) {
                            TargetNodeComponent.this.handleConnected();
                        } else {
                            TargetNodeComponent.this.handleDisconnected();
                            if (status.getSeverity() != 8) {
                                Activator.getDefault().getLog().log(status);
                            }
                        }
                    }
                });
                job.schedule();
            }
            catch (Exception e) {
                this.setTargetNodeState(TargetNodeState.DISCONNECTED);
                Activator.getDefault().logError(String.valueOf(Messages.TraceControl_ConnectionFailure) + " (" + this.getName() + "). \n", e);
            }
        }
    }

    public void disconnect() {
        if (this.fState == TargetNodeState.CONNECTED) {
            try {
                try {
                    this.setTargetNodeState(TargetNodeState.DISCONNECTING);
                    this.fRemoteProxy.disconnect();
                }
                catch (Exception e) {
                    Activator.getDefault().logError(String.valueOf(Messages.TraceControl_DisconnectionFailure) + " (" + this.getName() + "). \n", e);
                    this.handleDisconnected();
                }
            }
            finally {
                this.handleDisconnected();
            }
        }
    }

    public void getConfigurationFromNode() {
        Job job = new Job(Messages.TraceControl_RetrieveNodeConfigurationJob){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    TraceProviderGroup providerGroup = new TraceProviderGroup(Messages.TraceControl_ProviderDisplayName, TargetNodeComponent.this);
                    TargetNodeComponent.this.addChild(providerGroup);
                    TraceSessionGroup sessionGroup = new TraceSessionGroup(Messages.TraceControl_AllSessionsDisplayName, TargetNodeComponent.this);
                    TargetNodeComponent.this.addChild(sessionGroup);
                    providerGroup.getProviderFromNode(monitor);
                    sessionGroup.getSessionsFromNode(monitor);
                }
                catch (ExecutionException e) {
                    TargetNodeComponent.this.removeAllChildren();
                    return new Status(4, "org.eclipse.tracecompass.lttng2.control.ui", Messages.TraceControl_RetrieveNodeConfigurationFailure, (Throwable)e);
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
    }

    public void refresh() {
        this.removeAllChildren();
        this.getConfigurationFromNode();
    }

    private ILttngControlService createControlService() throws ExecutionException {
        if (this.fService == null) {
            try {
                ICommandShell shell;
                this.fShell = shell = this.fRemoteProxy.createCommandShell();
                this.fService = LTTngControlServiceFactory.getLttngControlService(shell);
            }
            catch (ExecutionException e) {
                this.disposeControlService();
                throw e;
            }
        }
        return this.fService;
    }

    private void handleConnected() {
        try {
            this.createControlService();
            this.getConfigurationFromNode();
            this.setTargetNodeState(TargetNodeState.CONNECTED);
        }
        catch (ExecutionException e) {
            if (this.getControlService() == NULL_CONTROL_SERVICE) {
                this.fState = TargetNodeState.CONNECTED;
                this.disconnect();
            }
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ErrorDialog er = new ErrorDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), Messages.TraceControl_ErrorTitle, Messages.TraceControl_RetrieveNodeConfigurationFailure, (IStatus)new Status(4, "org.eclipse.tracecompass.lttng2.control.ui", e.getMessage(), (Throwable)e), 4);
                    er.open();
                }
            });
            Activator.getDefault().logError(String.valueOf(Messages.TraceControl_RetrieveNodeConfigurationFailure) + " (" + this.getName() + "). \n", e);
        }
    }

    private void handleDisconnected() {
        this.disposeControlService();
        this.setTargetNodeState(TargetNodeState.DISCONNECTED);
        this.removeAllChildren();
    }

    @Override
    public void addChild(ITraceControlComponent component) {
        if (this.getTargetNodeState() == TargetNodeState.DISCONNECTED) {
            return;
        }
        super.addChild(component);
    }
}

