/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.IChannelInfo;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.IEventInfo;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.LogLevelType;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceChannelOutputType;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceEnablement;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceLogLevel;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.impl.ChannelInfo;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.impl.ProbeEventInfo;
import org.eclipse.tracecompass.internal.lttng2.control.ui.Activator;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.messages.Messages;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.ITraceControlComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TargetNodeComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceControlComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceDomainComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceEventComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceProbeEventComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceSessionComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.property.TraceChannelPropertySource;
import org.eclipse.ui.views.properties.IPropertySource;

public class TraceChannelComponent
extends TraceControlComponent {
    public static final String TRACE_CHANNEL_ICON_FILE_ENABLED = "icons/obj16/channel.gif";
    public static final String TRACE_CHANNEL_ICON_FILE_DISABLED = "icons/obj16/channel_disabled.gif";
    private IChannelInfo fChannelInfo = null;
    private Image fDisabledImage = null;

    public TraceChannelComponent(String name, ITraceControlComponent parent) {
        super(name, parent);
        this.setImage(TRACE_CHANNEL_ICON_FILE_ENABLED);
        this.setToolTip(Messages.TraceControl_ChannelDisplayName);
        this.fChannelInfo = new ChannelInfo(name);
        this.fDisabledImage = Activator.getDefault().loadIcon(TRACE_CHANNEL_ICON_FILE_DISABLED);
    }

    @Override
    public Image getImage() {
        if (this.fChannelInfo.getState() == TraceEnablement.DISABLED) {
            return this.fDisabledImage;
        }
        return super.getImage();
    }

    public void setChannelInfo(IChannelInfo channelInfo) {
        this.fChannelInfo = channelInfo;
        IEventInfo[] events = this.fChannelInfo.getEvents();
        ArrayList<ITraceControlComponent> eventComponents = new ArrayList<ITraceControlComponent>();
        int i = 0;
        while (i < events.length) {
            TraceEventComponent event = null;
            event = events[i].getClass() == ProbeEventInfo.class ? new TraceProbeEventComponent(events[i].getName(), this) : new TraceEventComponent(events[i].getName(), this);
            eventComponents.add(event);
            event.setEventInfo(events[i]);
            ++i;
        }
        if (!eventComponents.isEmpty()) {
            this.setChildren(eventComponents);
        }
    }

    public boolean isOverwriteMode() {
        return this.fChannelInfo.isOverwriteMode();
    }

    public void setOverwriteMode(boolean mode) {
        this.fChannelInfo.setOverwriteMode(mode);
    }

    public long getSubBufferSize() {
        return this.fChannelInfo.getSubBufferSize();
    }

    public void setSubBufferSize(long bufferSize) {
        this.fChannelInfo.setSubBufferSize(bufferSize);
    }

    public int getNumberOfSubBuffers() {
        return this.fChannelInfo.getNumberOfSubBuffers();
    }

    public void setNumberOfSubBuffers(int numberOfSubBuffers) {
        this.fChannelInfo.setNumberOfSubBuffers(numberOfSubBuffers);
    }

    public long getSwitchTimer() {
        return this.fChannelInfo.getSwitchTimer();
    }

    public void setSwitchTimer(long timer) {
        this.fChannelInfo.setSwitchTimer(timer);
    }

    public long getReadTimer() {
        return this.fChannelInfo.getReadTimer();
    }

    public void setReadTimer(long timer) {
        this.fChannelInfo.setReadTimer(timer);
    }

    public TraceChannelOutputType getOutputType() {
        return this.fChannelInfo.getOutputType();
    }

    public void setOutputType(TraceChannelOutputType type) {
        this.fChannelInfo.setOutputType(type);
    }

    public void setOutputType(String type) {
        this.fChannelInfo.setOutputType(type);
    }

    public TraceEnablement getState() {
        return this.fChannelInfo.getState();
    }

    public void setState(TraceEnablement state) {
        this.fChannelInfo.setState(state);
    }

    public void setState(String stateName) {
        this.fChannelInfo.setState(stateName);
    }

    public long getMaxSizeTraceFiles() {
        return this.fChannelInfo.getMaxSizeTraceFiles();
    }

    public int getMaxNumberTraceFiles() {
        return this.fChannelInfo.getMaxNumberTraceFiles();
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == IPropertySource.class) {
            return adapter.cast(new TraceChannelPropertySource(this));
        }
        return null;
    }

    public String getSessionName() {
        return ((TraceDomainComponent)this.getParent()).getSessionName();
    }

    public TraceSessionComponent getSession() {
        return ((TraceDomainComponent)this.getParent()).getSession();
    }

    public boolean isKernel() {
        return ((TraceDomainComponent)this.getParent()).isKernel();
    }

    public TargetNodeComponent getTargetNode() {
        return ((TraceDomainComponent)this.getParent()).getTargetNode();
    }

    public void enableEvents(List<String> eventNames, IProgressMonitor monitor) throws ExecutionException {
        this.enableEvents(eventNames, null, monitor);
    }

    public void enableEvents(List<String> eventNames, String filterExpression, IProgressMonitor monitor) throws ExecutionException {
        this.getControlService().enableEvents(this.getSessionName(), this.getName(), eventNames, this.isKernel(), filterExpression, monitor);
    }

    public void enableSyscalls(IProgressMonitor monitor) throws ExecutionException {
        this.getControlService().enableSyscalls(this.getSessionName(), this.getName(), monitor);
    }

    public void enableProbe(String eventName, boolean isFunction, String probe, IProgressMonitor monitor) throws ExecutionException {
        this.getControlService().enableProbe(this.getSessionName(), this.getName(), eventName, isFunction, probe, monitor);
    }

    public void enableLogLevel(String eventName, LogLevelType logLevelType, TraceLogLevel level, String filterExpression, IProgressMonitor monitor) throws ExecutionException {
        this.getControlService().enableLogLevel(this.getSessionName(), this.getName(), eventName, logLevelType, level, filterExpression, monitor);
    }

    public void disableEvent(List<String> eventNames, IProgressMonitor monitor) throws ExecutionException {
        this.getControlService().disableEvent(this.getParent().getParent().getName(), this.getName(), eventNames, this.isKernel(), monitor);
    }

    public void addContexts(List<String> contexts, IProgressMonitor monitor) throws ExecutionException {
        this.getControlService().addContexts(this.getSessionName(), this.getName(), null, this.isKernel(), contexts, monitor);
    }
}

