/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.ust.ui.analysis.callstack;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.lttng2.ust.ui.analysis.callstack.Messages;
import org.eclipse.tracecompass.lttng2.ust.core.trace.layout.ILttngUstEventLayout;
import org.eclipse.tracecompass.tmf.core.analysis.requirements.TmfAbstractAnalysisRequirement;
import org.eclipse.tracecompass.tmf.core.analysis.requirements.TmfAnalysisEventFieldRequirement;
import org.eclipse.tracecompass.tmf.core.analysis.requirements.TmfCompositeAnalysisRequirement;

@NonNullByDefault
public class LttngUstCallStackAnalysisRequirement
extends TmfCompositeAnalysisRequirement {
    public LttngUstCallStackAnalysisRequirement(ILttngUstEventLayout layout) {
        super(LttngUstCallStackAnalysisRequirement.getSubRequirements(layout), TmfAbstractAnalysisRequirement.PriorityLevel.AT_LEAST_ONE);
        this.addInformation(NonNullUtils.nullToEmptyString((Object)Messages.LttnUstCallStackAnalysisModule_EventsLoadingInformation));
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static Collection<TmfAbstractAnalysisRequirement> getSubRequirements(ILttngUstEventLayout layout) {
        @NonNull ImmutableSet requiredEventsFields = ImmutableSet.of((Object)layout.contextProcname(), (Object)layout.contextVtid());
        TmfAnalysisEventFieldRequirement entryReq = new TmfAnalysisEventFieldRequirement(layout.eventCygProfileFuncEntry(), (Collection)requiredEventsFields, TmfAbstractAnalysisRequirement.PriorityLevel.MANDATORY);
        TmfAnalysisEventFieldRequirement exitReq = new TmfAnalysisEventFieldRequirement(layout.eventCygProfileFuncExit(), (Collection)requiredEventsFields, TmfAbstractAnalysisRequirement.PriorityLevel.MANDATORY);
        TmfCompositeAnalysisRequirement cygProfile = new TmfCompositeAnalysisRequirement((Collection)ImmutableSet.of((Object)entryReq, (Object)exitReq), TmfAbstractAnalysisRequirement.PriorityLevel.MANDATORY);
        entryReq = new TmfAnalysisEventFieldRequirement(layout.eventCygProfileFastFuncEntry(), (Collection)requiredEventsFields, TmfAbstractAnalysisRequirement.PriorityLevel.MANDATORY);
        exitReq = new TmfAnalysisEventFieldRequirement(layout.eventCygProfileFastFuncExit(), (Collection)requiredEventsFields, TmfAbstractAnalysisRequirement.PriorityLevel.MANDATORY);
        TmfCompositeAnalysisRequirement cygProfileFast = new TmfCompositeAnalysisRequirement((Collection)ImmutableSet.of((Object)entryReq, (Object)exitReq), TmfAbstractAnalysisRequirement.PriorityLevel.MANDATORY);
        return ImmutableSet.of((Object)cygProfile, (Object)cygProfileFast);
    }
}

