/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.symbols;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.ui.symbols.DefaultSymbolProvider;
import org.eclipse.tracecompass.tmf.ui.symbols.ISymbolProvider;
import org.eclipse.tracecompass.tmf.ui.symbols.ISymbolProviderFactory;

public final class SymbolProviderManager {
    private static SymbolProviderManager INSTANCE;
    private static final String EXTENSION_POINT_ID = "org.eclipse.tracecompass.tmf.ui.symbolProvider";
    private static final String ELEM_NAME_PROVIDER = "providerFactory";
    private static final String ATTR_CLASS = "class";
    private static final String ATTR_PRIORITY = "priority";
    private final List<SymbolProviderFactoryWrapper> fProviders;
    private final Map<ITmfTrace, WeakReference<ISymbolProvider>> fInstances = new WeakHashMap<ITmfTrace, WeakReference<ISymbolProvider>>();

    public static synchronized @NonNull SymbolProviderManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new SymbolProviderManager();
        }
        return INSTANCE;
    }

    private SymbolProviderManager() {
        IConfigurationElement[] configElements;
        this.fProviders = new ArrayList<SymbolProviderFactoryWrapper>();
        IConfigurationElement[] iConfigurationElementArray = configElements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_ID);
        int n = configElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (ELEM_NAME_PROVIDER.equals(element.getName())) {
                try {
                    Object extension = element.createExecutableExtension(ATTR_CLASS);
                    int priority = 0;
                    try {
                        priority = Integer.parseInt(element.getAttribute(ATTR_PRIORITY));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    this.fProviders.add(new SymbolProviderFactoryWrapper((ISymbolProviderFactory)extension, priority));
                }
                catch (ClassCastException | CoreException e) {
                    Activator.getDefault().logError("Exception while loading extensions", e);
                }
            }
            ++n2;
        }
        this.fProviders.sort(Comparator.comparingLong(o -> -o.priority));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @NonNull ISymbolProvider getSymbolProvider(@NonNull ITmfTrace trace) {
        Map<ITmfTrace, WeakReference<ISymbolProvider>> map = this.fInstances;
        synchronized (map) {
            ISymbolProvider provider;
            WeakReference<ISymbolProvider> reference = this.fInstances.get(trace);
            if (reference != null && (provider = (ISymbolProvider)reference.get()) != null) {
                return provider;
            }
            for (SymbolProviderFactoryWrapper wrapper : this.fProviders) {
                ISymbolProviderFactory factory = wrapper.factory;
                ISymbolProvider provider2 = factory.createProvider(trace);
                if (provider2 == null) continue;
                this.fInstances.put(trace, new WeakReference<ISymbolProvider>(provider2));
                return provider2;
            }
        }
        return new DefaultSymbolProvider(trace);
    }

    private static class SymbolProviderFactoryWrapper {
        public final ISymbolProviderFactory factory;
        public final int priority;

        private SymbolProviderFactoryWrapper(ISymbolProviderFactory factory, int priority) {
            this.factory = factory;
            this.priority = priority;
        }
    }
}

