/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.viewers.events;

import java.util.ArrayList;
import org.eclipse.tracecompass.tmf.core.event.ITmfCustomAttributes;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;
import org.eclipse.tracecompass.tmf.core.event.lookup.ITmfCallsite;
import org.eclipse.tracecompass.tmf.core.event.lookup.ITmfModelLookup;
import org.eclipse.tracecompass.tmf.core.event.lookup.ITmfSourceLookup;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.ui.properties.ReadOnlyTextPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;

public class TmfEventPropertySource
implements IPropertySource {
    private static final String ID_TIMESTAMP = "event_timestamp";
    private static final String ID_TYPE = "event_type";
    private static final String ID_TRACE = "trace_attribute";
    private static final String ID_CONTENT = "event_content";
    private static final String ID_SOURCE_LOOKUP = "event_lookup";
    private static final String ID_MODEL_URI = "model_uri";
    private static final String ID_CUSTOM_ATTRIBUTE = "custom_attribute";
    private static final String NAME_TIMESTAMP = "Timestamp";
    private static final String NAME_TYPE = "Type";
    private static final String NAME_TRACE = "Trace";
    private static final String NAME_CONTENT = "Content";
    private static final String NAME_SOURCE_LOOKUP = "Source Lookup";
    private static final String NAME_MODEL_URI = "Model URI";
    private static final String NAME_CUSTOM_ATTRIBUTES = "Custom Attributes";
    private static final String EMPTY_STRING = "";
    private ITmfEvent fEvent;

    public TmfEventPropertySource(ITmfEvent event) {
        this.fEvent = event;
    }

    public Object getEditableValue() {
        return null;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        ITmfCustomAttributes event;
        ArrayList<ReadOnlyTextPropertyDescriptor> descriptors = new ArrayList<ReadOnlyTextPropertyDescriptor>();
        descriptors.add(new ReadOnlyTextPropertyDescriptor(ID_TIMESTAMP, NAME_TIMESTAMP));
        descriptors.add(new ReadOnlyTextPropertyDescriptor(ID_TYPE, NAME_TYPE));
        descriptors.add(new ReadOnlyTextPropertyDescriptor(ID_TRACE, NAME_TRACE));
        descriptors.add(new ReadOnlyTextPropertyDescriptor(ID_CONTENT, NAME_CONTENT));
        if (this.fEvent instanceof ITmfSourceLookup && ((ITmfSourceLookup)this.fEvent).getCallsite() != null) {
            descriptors.add(new ReadOnlyTextPropertyDescriptor(ID_SOURCE_LOOKUP, NAME_SOURCE_LOOKUP));
        }
        if (this.fEvent instanceof ITmfModelLookup && ((ITmfModelLookup)this.fEvent).getModelUri() != null) {
            descriptors.add(new ReadOnlyTextPropertyDescriptor(ID_MODEL_URI, NAME_MODEL_URI));
        }
        if (this.fEvent instanceof ITmfCustomAttributes && !(event = (ITmfCustomAttributes)this.fEvent).listCustomAttributes().isEmpty()) {
            descriptors.add(new ReadOnlyTextPropertyDescriptor(ID_CUSTOM_ATTRIBUTE, NAME_CUSTOM_ATTRIBUTES));
        }
        return descriptors.toArray(new IPropertyDescriptor[0]);
    }

    public Object getPropertyValue(Object id) {
        if (id.equals(ID_TIMESTAMP)) {
            return new TimestampPropertySource(this.fEvent.getTimestamp());
        }
        if (id.equals(ID_TYPE) && this.fEvent.getType() != null) {
            return this.fEvent.getType().toString();
        }
        if (id.equals(ID_TRACE)) {
            return this.fEvent.getTrace().getName();
        }
        if (id.equals(ID_MODEL_URI)) {
            return ((ITmfModelLookup)this.fEvent).getModelUri();
        }
        if (id.equals(ID_SOURCE_LOOKUP)) {
            return new SourceLookupPropertySource((ITmfSourceLookup)this.fEvent);
        }
        if (id.equals(ID_CONTENT) && this.fEvent.getContent() != null) {
            return new ContentPropertySource(this.fEvent.getContent());
        }
        if (id.equals(ID_CUSTOM_ATTRIBUTE)) {
            return new CustomAttributePropertySource((ITmfCustomAttributes)this.fEvent);
        }
        return null;
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }

    private static class ContentPropertySource
    implements IPropertySource {
        private ITmfEventField fContent;

        public ContentPropertySource(ITmfEventField content) {
            this.fContent = content;
        }

        public Object getEditableValue() {
            return this.fContent.toString();
        }

        public IPropertyDescriptor[] getPropertyDescriptors() {
            ArrayList<ReadOnlyTextPropertyDescriptor> descriptors = new ArrayList<ReadOnlyTextPropertyDescriptor>(this.fContent.getFields().size());
            for (ITmfEventField field : this.fContent.getFields()) {
                if (field == null) continue;
                descriptors.add(new ReadOnlyTextPropertyDescriptor(field, field.getName()));
            }
            return descriptors.toArray(new IPropertyDescriptor[0]);
        }

        public Object getPropertyValue(Object id) {
            ITmfEventField field = (ITmfEventField)id;
            if (!field.getFields().isEmpty()) {
                return new ContentPropertySource(field);
            }
            return field.getFormattedValue();
        }

        public boolean isPropertySet(Object id) {
            return false;
        }

        public void resetPropertyValue(Object id) {
        }

        public void setPropertyValue(Object id, Object value) {
        }
    }

    private class CustomAttributePropertySource
    implements IPropertySource {
        private final ITmfCustomAttributes event;

        public CustomAttributePropertySource(ITmfCustomAttributes event) {
            this.event = event;
        }

        public Object getEditableValue() {
            return TmfEventPropertySource.EMPTY_STRING;
        }

        public IPropertyDescriptor[] getPropertyDescriptors() {
            ArrayList<ReadOnlyTextPropertyDescriptor> descriptors = new ArrayList<ReadOnlyTextPropertyDescriptor>();
            for (String customAttribute : this.event.listCustomAttributes()) {
                descriptors.add(new ReadOnlyTextPropertyDescriptor(customAttribute, customAttribute));
            }
            return descriptors.toArray(new IPropertyDescriptor[0]);
        }

        public Object getPropertyValue(Object id) {
            if (!(id instanceof String)) {
                return null;
            }
            return this.event.getCustomAttribute((String)id);
        }

        public boolean isPropertySet(Object id) {
            return false;
        }

        public void resetPropertyValue(Object id) {
        }

        public void setPropertyValue(Object id, Object value) {
        }
    }

    private static class SourceLookupPropertySource
    implements IPropertySource {
        private static final String ID_FILE_NAME = "callsite_file";
        private static final String ID_FUNCTION_NAME = "callsite_function";
        private static final String ID_LINE_NUMBER = "callsite_line";
        private static final String NAME_FILE_NAME = "File";
        private static final String NAME_FUNCTION_NAME = "Function";
        private static final String NAME_LINE_NUMBER = "Line";
        private final ITmfSourceLookup fSourceLookup;

        public SourceLookupPropertySource(ITmfSourceLookup lookup) {
            this.fSourceLookup = lookup;
        }

        public Object getEditableValue() {
            ITmfCallsite cs = this.fSourceLookup.getCallsite();
            if (cs != null) {
                return cs.toString();
            }
            return null;
        }

        public IPropertyDescriptor[] getPropertyDescriptors() {
            ArrayList<ReadOnlyTextPropertyDescriptor> descriptors = new ArrayList<ReadOnlyTextPropertyDescriptor>();
            ITmfCallsite cs = this.fSourceLookup.getCallsite();
            if (cs != null) {
                descriptors.add(new ReadOnlyTextPropertyDescriptor(ID_FILE_NAME, NAME_FILE_NAME));
                descriptors.add(new ReadOnlyTextPropertyDescriptor(ID_LINE_NUMBER, NAME_LINE_NUMBER));
                if (cs.getFunctionName() != null) {
                    descriptors.add(new ReadOnlyTextPropertyDescriptor(ID_FUNCTION_NAME, NAME_FUNCTION_NAME));
                }
            }
            return descriptors.toArray(new IPropertyDescriptor[0]);
        }

        public String getPropertyValue(Object id) {
            ITmfCallsite cs = this.fSourceLookup.getCallsite();
            if (cs == null) {
                throw new IllegalStateException();
            }
            if (!(id instanceof String)) {
                return null;
            }
            switch ((String)id) {
                case "callsite_file": {
                    return cs.getFileName();
                }
                case "callsite_function": {
                    return cs.getFunctionName();
                }
                case "callsite_line": {
                    return String.valueOf(cs.getLineNumber());
                }
            }
            return null;
        }

        public boolean isPropertySet(Object id) {
            return false;
        }

        public void resetPropertyValue(Object id) {
        }

        public void setPropertyValue(Object id, Object value) {
        }
    }

    private static class TimestampPropertySource
    implements IPropertySource {
        private static final String ID_TIMESTAMP_VALUE = "timestamp_value";
        private static final String ID_TIMESTAMP_SCALE = "timestamp_scale";
        private static final String NAME_TIMESTAMP_VALUE = "value";
        private static final String NAME_TIMESTAMP_SCALE = "scale";
        private ITmfTimestamp fTimestamp;

        public TimestampPropertySource(ITmfTimestamp timestamp) {
            this.fTimestamp = timestamp;
        }

        public Object getEditableValue() {
            return this.fTimestamp.toString();
        }

        public IPropertyDescriptor[] getPropertyDescriptors() {
            IPropertyDescriptor[] descriptors = new IPropertyDescriptor[]{new ReadOnlyTextPropertyDescriptor(ID_TIMESTAMP_VALUE, NAME_TIMESTAMP_VALUE), new ReadOnlyTextPropertyDescriptor(ID_TIMESTAMP_SCALE, NAME_TIMESTAMP_SCALE)};
            return descriptors;
        }

        public Object getPropertyValue(Object id) {
            if (id.equals(ID_TIMESTAMP_VALUE)) {
                return Long.toString(this.fTimestamp.getValue());
            }
            if (id.equals(ID_TIMESTAMP_SCALE)) {
                return Integer.toString(this.fTimestamp.getScale());
            }
            return null;
        }

        public boolean isPropertySet(Object id) {
            return false;
        }

        public void resetPropertyValue(Object id) {
        }

        public void setPropertyValue(Object id, Object value) {
        }
    }
}

