/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.views.timegraph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGBA;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;
import org.eclipse.tracecompass.tmf.core.signal.TmfSelectionRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfTimestampFormatUpdateSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceClosedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceSelectedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfWindowRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceAdapterManager;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceContext;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.ui.TmfUiRefreshHandler;
import org.eclipse.tracecompass.tmf.ui.signal.TmfTimeViewAlignmentInfo;
import org.eclipse.tracecompass.tmf.ui.views.ITmfTimeAligned;
import org.eclipse.tracecompass.tmf.ui.views.TmfView;
import org.eclipse.tracecompass.tmf.ui.views.timegraph.ITimeGraphEntryComparator;
import org.eclipse.tracecompass.tmf.ui.views.timegraph.Messages;
import org.eclipse.tracecompass.tmf.ui.views.timegraph.ShowFindDialogAction;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.ITimeGraphBookmarkListener;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.ITimeGraphContentProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.ITimeGraphPresentationProvider2;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.ITimeGraphRangeListener;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.ITimeGraphSelectionListener;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.ITimeGraphTimeListener;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphBookmarkEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphCombo;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphContentProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphPresentationProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphRangeUpdateEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphTimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphViewer;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ILinkEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.IMarkerEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.IMarkerEventSource;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.MarkerEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.TimeGraphControl;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.Utils;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;

public abstract class AbstractTimeGraphView
extends TmfView
implements ITmfTimeAligned,
IResourceChangeListener {
    protected static final int ALL_LEVELS = -1;
    private static final Pattern RGBA_PATTERN = Pattern.compile("RGBA \\{(\\d+), (\\d+), (\\d+), (\\d+)\\}");
    private ITimeGraphWrapper fTimeGraphWrapper;
    private AtomicInteger fDirty = new AtomicInteger();
    private final Object fZoomThreadResultLock = new Object();
    private ITmfTrace fTrace;
    private IFile fEditorFile;
    private List<TimeGraphEntry> fEntryList;
    private final Map<ITmfTrace, List<TimeGraphEntry>> fEntryListMap = new HashMap<ITmfTrace, List<TimeGraphEntry>>();
    private final Map<ITmfTrace, @NonNull ViewerFilter[]> fFiltersMap = new HashMap<ITmfTrace, ViewerFilter[]>();
    private final Map<ITmfTrace, ViewContext> fViewContext = new HashMap<ITmfTrace, ViewContext>();
    private final Map<ITmfTrace, List<IMarkerEventSource>> fMarkerEventSourcesMap = new HashMap<ITmfTrace, List<IMarkerEventSource>>();
    private final Map<ITmfTrace, BuildThread> fBuildThreadMap = new HashMap<ITmfTrace, BuildThread>();
    private long fStartTime = -1L;
    private long fEndTime = -1L;
    private final int fDisplayWidth;
    private ZoomThread fZoomThread;
    private Action fNextResourceAction;
    private Action fPreviousResourceAction;
    private Comparator<ITimeGraphEntry> fEntryComparator = null;
    private State fRedrawState = State.IDLE;
    private final Object fSyncObj = new Object();
    private final TimeGraphPresentationProvider fPresentation;
    private String[] fColumns;
    private Comparator<ITimeGraphEntry>[] fColumnComparators;
    private TreeLabelProvider fLabelProvider = null;
    private @NonNull ITimeGraphContentProvider fTimeGraphContentProvider = new TimeGraphContentProvider();
    private int[] fWeight = new int[]{1, 3};
    private String[] fFilterColumns;
    private boolean fPackDone = false;
    private ITreeContentProvider fFilterContentProvider;
    private TreeLabelProvider fFilterLabelProvider;
    private int fAutoExpandLevel = -1;
    private int fInitialSortColumn = 0;
    private int fCurrentSortColumn = 0;
    private int fSortDirection = 1024;
    private volatile boolean fIsRevealSelection = false;
    private final @NonNull MenuManager fEntryMenuManager = new MenuManager();
    private TimeGraphPartListener fPartListener;
    private static final ShowFindDialogAction FIND_ACTION = new ShowFindDialogAction();
    private ActionHandler fFindActionHandler;
    private IHandlerActivation fFindHandlerActivation;
    private final FindTarget fFindTarget;

    public AbstractTimeGraphView(String id, TimeGraphPresentationProvider pres) {
        super(id);
        this.fPresentation = pres;
        this.fDisplayWidth = Display.getDefault().getBounds().width;
        this.fFindTarget = new FindTarget();
    }

    protected TimeGraphCombo getTimeGraphCombo() {
        if (this.fTimeGraphWrapper instanceof TimeGraphComboWrapper) {
            return ((TimeGraphComboWrapper)this.fTimeGraphWrapper).getTimeGraphCombo();
        }
        return null;
    }

    protected TimeGraphViewer getTimeGraphViewer() {
        return this.fTimeGraphWrapper.getTimeGraphViewer();
    }

    protected ITimeGraphPresentationProvider2 getPresentationProvider() {
        return this.fPresentation;
    }

    protected void setTreeColumns(String[] columns) {
        this.setTreeColumns(columns, null, 0);
    }

    protected void setTreeColumns(String[] columns, Comparator<ITimeGraphEntry>[] comparators, int initialSortColumn) {
        this.checkPartNotCreated();
        this.fColumns = columns;
        this.fColumnComparators = comparators;
        this.fInitialSortColumn = initialSortColumn;
    }

    protected void setTreeLabelProvider(TreeLabelProvider tlp) {
        this.checkPartNotCreated();
        this.fLabelProvider = tlp;
    }

    protected void setTimeGraphContentProvider(@NonNull ITimeGraphContentProvider tgcp) {
        this.checkPartNotCreated();
        this.fTimeGraphContentProvider = tgcp;
    }

    protected void setWeight(int[] weights) {
        this.checkPartNotCreated();
        this.fWeight = weights;
    }

    protected void setFilterColumns(String[] filterColumns) {
        this.checkPartNotCreated();
        this.fFilterColumns = filterColumns;
    }

    protected void setFilterContentProvider(ITreeContentProvider contentProvider) {
        this.checkPartNotCreated();
        this.fFilterContentProvider = contentProvider;
    }

    protected void setFilterLabelProvider(TreeLabelProvider labelProvider) {
        this.checkPartNotCreated();
        this.fFilterLabelProvider = labelProvider;
    }

    private void checkPartNotCreated() {
        if (this.getParentComposite() != null) {
            throw new IllegalStateException("This method must be called before createPartControl.");
        }
    }

    protected int getDisplayWidth() {
        return this.fDisplayWidth;
    }

    protected Comparator<ITimeGraphEntry> getEntryComparator() {
        return this.fEntryComparator;
    }

    protected void setEntryComparator(Comparator<ITimeGraphEntry> comparator) {
        this.fEntryComparator = comparator;
    }

    protected ITmfTrace getTrace() {
        return this.fTrace;
    }

    protected long getStartTime() {
        return this.fStartTime;
    }

    protected void setStartTime(long time) {
        this.fStartTime = time;
    }

    protected long getEndTime() {
        return this.fEndTime;
    }

    protected void setEndTime(long time) {
        this.fEndTime = time;
    }

    protected void setAutoExpandLevel(int level) {
        this.fAutoExpandLevel = level;
        ITimeGraphWrapper tgWrapper = this.fTimeGraphWrapper;
        if (tgWrapper != null) {
            tgWrapper.setAutoExpandLevel(level);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<TimeGraphEntry> getEntryList(ITmfTrace trace) {
        Map<ITmfTrace, List<TimeGraphEntry>> map = this.fEntryListMap;
        synchronized (map) {
            return this.fEntryListMap.get(trace);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void putEntryList(ITmfTrace trace, List<TimeGraphEntry> list) {
        Map<ITmfTrace, List<TimeGraphEntry>> map = this.fEntryListMap;
        synchronized (map) {
            this.fEntryListMap.put(trace, new CopyOnWriteArrayList<TimeGraphEntry>(list));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addToEntryList(ITmfTrace trace, List<TimeGraphEntry> list) {
        Map<ITmfTrace, List<TimeGraphEntry>> map = this.fEntryListMap;
        synchronized (map) {
            List<TimeGraphEntry> entryList = this.fEntryListMap.get(trace);
            if (entryList == null) {
                this.fEntryListMap.put(trace, new CopyOnWriteArrayList<TimeGraphEntry>(list));
            } else {
                entryList.addAll(list);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeFromEntryList(ITmfTrace trace, List<TimeGraphEntry> list) {
        Map<ITmfTrace, List<TimeGraphEntry>> map = this.fEntryListMap;
        synchronized (map) {
            List<TimeGraphEntry> entryList = this.fEntryListMap.get(trace);
            if (entryList != null) {
                entryList.removeAll(list);
            }
        }
    }

    protected String getNextText() {
        return Messages.AbstractTimeGraphtView_NextText;
    }

    protected String getNextTooltip() {
        return Messages.AbstractTimeGraphView_NextTooltip;
    }

    protected String getPrevText() {
        return Messages.AbstractTimeGraphView_PreviousText;
    }

    protected String getPrevTooltip() {
        return Messages.AbstractTimeGraphView_PreviousTooltip;
    }

    FindTarget getFindTarget() {
        return this.fFindTarget;
    }

    @Override
    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        if (this.fColumns == null || this.fLabelProvider == null) {
            this.fTimeGraphWrapper = new TimeGraphViewerWrapper(parent, 0);
        } else {
            TimeGraphComboWrapper wrapper = new TimeGraphComboWrapper(parent, 0);
            this.fTimeGraphWrapper = wrapper;
            TimeGraphCombo combo = wrapper.getTimeGraphCombo();
            combo.setTreeContentProvider(this.fTimeGraphContentProvider);
            combo.setTreeLabelProvider(this.fLabelProvider);
            combo.setTreeColumns(this.fColumns);
            if (this.fColumnComparators != null) {
                this.createColumnSelectionListener(combo.getTreeViewer());
            }
            this.createDoubleClickListener(combo.getTreeViewer());
        }
        this.fTimeGraphWrapper.setTimeGraphContentProvider(this.fTimeGraphContentProvider);
        this.fTimeGraphWrapper.setFilterContentProvider((ITreeContentProvider)(this.fFilterContentProvider != null ? this.fFilterContentProvider : this.fTimeGraphContentProvider));
        this.fTimeGraphWrapper.setFilterLabelProvider(this.fFilterLabelProvider);
        this.fTimeGraphWrapper.setFilterColumns(this.fFilterColumns);
        this.fTimeGraphWrapper.setTimeGraphPresentationProvider(this.fPresentation);
        this.fTimeGraphWrapper.setAutoExpandLevel(this.fAutoExpandLevel);
        this.fTimeGraphWrapper.getTimeGraphViewer().addRangeListener(new ITimeGraphRangeListener(){

            @Override
            public void timeRangeUpdated(TimeGraphRangeUpdateEvent event) {
                long startTime = event.getStartTime();
                long endTime = event.getEndTime();
                TmfTimeRange range = new TmfTimeRange(TmfTimestamp.fromNanos((long)startTime), TmfTimestamp.fromNanos((long)endTime));
                AbstractTimeGraphView.this.broadcast((TmfSignal)new TmfWindowRangeUpdatedSignal((Object)AbstractTimeGraphView.this, range));
                AbstractTimeGraphView.this.startZoomThread(startTime, endTime);
            }
        });
        this.fTimeGraphWrapper.getTimeGraphViewer().addTimeListener(new ITimeGraphTimeListener(){

            @Override
            public void timeSelected(TimeGraphTimeEvent event) {
                ITmfTimestamp startTime = TmfTimestamp.fromNanos((long)event.getBeginTime());
                ITmfTimestamp endTime = TmfTimestamp.fromNanos((long)event.getEndTime());
                AbstractTimeGraphView.this.broadcast((TmfSignal)new TmfSelectionRangeUpdatedSignal((Object)AbstractTimeGraphView.this, startTime, endTime));
            }
        });
        this.fTimeGraphWrapper.getTimeGraphViewer().addBookmarkListener(new ITimeGraphBookmarkListener(){

            @Override
            public void bookmarkAdded(final TimeGraphBookmarkEvent event) {
                try {
                    ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                        public void run(IProgressMonitor monitor) throws CoreException {
                            IMarkerEvent bookmark = event.getBookmark();
                            IMarker marker = AbstractTimeGraphView.this.fEditorFile.createMarker("org.eclipse.core.resources.bookmark");
                            marker.setAttribute("message", (Object)bookmark.getLabel());
                            marker.setAttribute("time", (Object)Long.toString(bookmark.getTime()));
                            if (bookmark.getDuration() > 0L) {
                                marker.setAttribute("duration", (Object)Long.toString(bookmark.getDuration()));
                                marker.setAttribute("location", (Object)NLS.bind((String)org.eclipse.tracecompass.internal.tmf.ui.Messages.TmfMarker_LocationTimeRange, (Object)TmfTimestamp.fromNanos((long)bookmark.getTime()), (Object)TmfTimestamp.fromNanos((long)(bookmark.getTime() + bookmark.getDuration()))));
                            } else {
                                marker.setAttribute("location", (Object)NLS.bind((String)org.eclipse.tracecompass.internal.tmf.ui.Messages.TmfMarker_LocationTime, (Object)TmfTimestamp.fromNanos((long)bookmark.getTime())));
                            }
                            marker.setAttribute("color", (Object)bookmark.getColor().toString());
                        }
                    }, null);
                }
                catch (CoreException e) {
                    Activator.getDefault().logError(e.getMessage());
                }
            }

            @Override
            public void bookmarkRemoved(TimeGraphBookmarkEvent event) {
                try {
                    IMarker[] markers;
                    IMarkerEvent bookmark = event.getBookmark();
                    IMarker[] iMarkerArray = markers = AbstractTimeGraphView.this.fEditorFile.findMarkers("org.eclipse.core.resources.bookmark", false, 0);
                    int n = markers.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IMarker marker = iMarkerArray[n2];
                        if (bookmark.getLabel().equals(marker.getAttribute("message")) && Long.toString(bookmark.getTime()).equals(marker.getAttribute("time", null)) && Long.toString(bookmark.getDuration()).equals(marker.getAttribute("duration", Long.toString(0L))) && bookmark.getColor().toString().equals(marker.getAttribute("color"))) {
                            marker.delete();
                            break;
                        }
                        ++n2;
                    }
                }
                catch (CoreException e) {
                    Activator.getDefault().logError(e.getMessage());
                }
            }
        });
        this.fTimeGraphWrapper.getTimeGraphViewer().setTimeFormat(Utils.TimeFormat.CALENDAR);
        IStatusLineManager statusLineManager = this.getViewSite().getActionBars().getStatusLineManager();
        this.fTimeGraphWrapper.getTimeGraphViewer().getTimeGraphControl().setStatusLineManager(statusLineManager);
        this.makeActions();
        this.contributeToActionBars();
        ITmfTrace trace = TmfTraceManager.getInstance().getActiveTrace();
        if (trace != null) {
            this.traceSelected(new TmfTraceSelectedSignal((Object)this, trace));
        }
        this.getSite().setSelectionProvider(this.fTimeGraphWrapper.getSelectionProvider());
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
        this.createContextMenu();
        this.fPartListener = new TimeGraphPartListener();
        this.getSite().getPage().addPartListener((IPartListener)this.fPartListener);
    }

    public void setFocus() {
        this.fTimeGraphWrapper.setFocus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        super.dispose();
        Map<ITmfTrace, BuildThread> map = this.fBuildThreadMap;
        synchronized (map) {
            this.fBuildThreadMap.values().forEach(buildThread -> buildThread.cancel());
        }
        if (this.fZoomThread != null) {
            this.fZoomThread.cancel();
        }
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        this.getSite().getPage().removePartListener((IPartListener)this.fPartListener);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IMarkerDelta[] iMarkerDeltaArray = event.findMarkerDeltas("org.eclipse.core.resources.bookmark", false);
        int n = iMarkerDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMarkerDelta delta = iMarkerDeltaArray[n2];
            if (delta.getResource().equals((Object)this.fEditorFile)) {
                this.fTimeGraphWrapper.getTimeGraphViewer().setBookmarks(AbstractTimeGraphView.refreshBookmarks(this.fEditorFile));
                this.redraw();
                return;
            }
            ++n2;
        }
    }

    private static List<IMarkerEvent> refreshBookmarks(IFile editorFile) {
        ArrayList<IMarkerEvent> bookmarks = new ArrayList<IMarkerEvent>();
        if (editorFile == null || !editorFile.exists()) {
            return bookmarks;
        }
        try {
            IMarker[] markers;
            IMarker[] iMarkerArray = markers = editorFile.findMarkers("org.eclipse.core.resources.bookmark", false, 0);
            int n = markers.length;
            int n2 = 0;
            while (n2 < n) {
                Matcher matcher;
                IMarker marker = iMarkerArray[n2];
                String label = marker.getAttribute("message", null);
                String time = marker.getAttribute("time", null);
                String duration = marker.getAttribute("duration", Long.toString(0L));
                String rgba = marker.getAttribute("color", null);
                if (label != null && time != null && rgba != null && (matcher = RGBA_PATTERN.matcher(rgba)).matches()) {
                    try {
                        int red = Integer.valueOf(matcher.group(1));
                        int green = Integer.valueOf(matcher.group(2));
                        int blue = Integer.valueOf(matcher.group(3));
                        int alpha = Integer.valueOf(matcher.group(4));
                        RGBA color = new RGBA(red, green, blue, alpha);
                        bookmarks.add(new MarkerEvent(null, Long.valueOf(time), Long.valueOf(duration), IMarkerEvent.BOOKMARKS, color, label, true));
                    }
                    catch (NumberFormatException e) {
                        Activator.getDefault().logError(e.getMessage());
                    }
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            Activator.getDefault().logError(e.getMessage());
        }
        return bookmarks;
    }

    @TmfSignalHandler
    public void traceOpened(TmfTraceOpenedSignal signal) {
        this.loadTrace(signal.getTrace());
    }

    @TmfSignalHandler
    public void traceSelected(TmfTraceSelectedSignal signal) {
        if (signal.getTrace() == this.fTrace) {
            return;
        }
        this.loadTrace(signal.getTrace());
    }

    @TmfSignalHandler
    public void traceClosed(TmfTraceClosedSignal signal) {
        this.resetView(signal.getTrace());
        if (signal.getTrace() == this.fTrace) {
            this.fTrace = null;
            this.fEditorFile = null;
            this.setStartTime(-1L);
            this.setEndTime(-1L);
            this.refresh();
        }
    }

    @TmfSignalHandler
    public void selectionRangeUpdated(TmfSelectionRangeUpdatedSignal signal) {
        if (signal.getSource() == this || this.fTrace == null) {
            return;
        }
        final long beginTime = signal.getBeginTime().toNanos();
        final long endTime = signal.getEndTime().toNanos();
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (AbstractTimeGraphView.this.fTimeGraphWrapper.isDisposed()) {
                    return;
                }
                if (beginTime == endTime) {
                    AbstractTimeGraphView.this.fTimeGraphWrapper.getTimeGraphViewer().setSelectedTime(beginTime, true);
                } else {
                    AbstractTimeGraphView.this.fTimeGraphWrapper.getTimeGraphViewer().setSelectionRange(beginTime, endTime, true);
                }
                AbstractTimeGraphView.this.synchingToTime(AbstractTimeGraphView.this.fTimeGraphWrapper.getTimeGraphViewer().getSelectionBegin());
            }
        });
    }

    @TmfSignalHandler
    public void windowRangeUpdated(TmfWindowRangeUpdatedSignal signal) {
        if (signal.getSource() == this || this.fTrace == null) {
            return;
        }
        if (signal.getCurrentRange().getIntersection(this.fTrace.getTimeRange()) == null) {
            return;
        }
        final long startTime = signal.getCurrentRange().getStartTime().toNanos();
        final long endTime = signal.getCurrentRange().getEndTime().toNanos();
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (AbstractTimeGraphView.this.fTimeGraphWrapper.isDisposed()) {
                    return;
                }
                AbstractTimeGraphView.this.fTimeGraphWrapper.getTimeGraphViewer().setStartFinishTime(startTime, endTime);
                AbstractTimeGraphView.this.startZoomThread(startTime, endTime);
            }
        });
    }

    @TmfSignalHandler
    public void updateTimeFormat(TmfTimestampFormatUpdateSignal signal) {
        this.fTimeGraphWrapper.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadTrace(ITmfTrace trace) {
        if (this.fZoomThread != null) {
            this.fZoomThread.cancel();
            this.fZoomThread = null;
        }
        if (this.fTrace != null) {
            this.fFiltersMap.put(this.fTrace, this.fTimeGraphWrapper.getFilters());
            this.fViewContext.put(this.fTrace, new ViewContext(this.fCurrentSortColumn, this.fSortDirection, this.fTimeGraphWrapper.getSelection()));
        }
        this.fTrace = trace;
        this.restoreViewContext();
        this.fEditorFile = TmfTraceManager.getInstance().getTraceEditorFile(trace);
        Map<ITmfTrace, List<TimeGraphEntry>> map = this.fEntryListMap;
        synchronized (map) {
            this.fEntryList = this.fEntryListMap.get(this.fTrace);
            if (this.fEntryList == null) {
                this.rebuild();
            } else {
                this.setStartTime(this.fTrace.getStartTime().toNanos());
                this.setEndTime(this.fTrace.getEndTime().toNanos());
                this.refresh();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rebuild() {
        this.setStartTime(Long.MAX_VALUE);
        this.setEndTime(Long.MIN_VALUE);
        this.refresh();
        ITmfTrace viewTrace = this.fTrace;
        if (viewTrace == null) {
            return;
        }
        this.resetView(viewTrace);
        ArrayList markerEventSources = new ArrayList();
        Map<ITmfTrace, BuildThread> map = this.fBuildThreadMap;
        synchronized (map) {
            for (ITmfTrace trace : this.getTracesToBuild(viewTrace)) {
                if (trace == null) break;
                markerEventSources.addAll(TmfTraceAdapterManager.getAdapters((ITmfTrace)trace, IMarkerEventSource.class));
                BuildThread buildThread = new BuildThread(trace, viewTrace, this.getName());
                this.fBuildThreadMap.put(trace, buildThread);
                buildThread.start();
            }
        }
        this.fMarkerEventSourcesMap.put(viewTrace, markerEventSources);
    }

    protected void synchingToTime(long time) {
    }

    protected @NonNull Iterable<ITmfTrace> getTracesToBuild(@NonNull ITmfTrace trace) {
        return TmfTraceManager.getTraceSet((ITmfTrace)trace);
    }

    protected abstract void buildEntryList(@NonNull ITmfTrace var1, @NonNull ITmfTrace var2, @NonNull IProgressMonitor var3);

    protected abstract @Nullable List<@NonNull ITimeEvent> getEventList(@NonNull TimeGraphEntry var1, long var2, long var4, long var6, @NonNull IProgressMonitor var8);

    protected @Nullable List<@NonNull ILinkEvent> getLinkList(long startTime, long endTime, long resolution, @NonNull IProgressMonitor monitor) {
        return new ArrayList<ILinkEvent>();
    }

    protected @NonNull List<String> getViewMarkerCategories() {
        return new ArrayList<String>();
    }

    protected @NonNull List<IMarkerEvent> getViewMarkerList(long startTime, long endTime, long resolution, @NonNull IProgressMonitor monitor) {
        return new ArrayList<IMarkerEvent>();
    }

    protected @NonNull List<IMarkerEvent> getTraceMarkerList(long startTime, long endTime, long resolution, @NonNull IProgressMonitor monitor) {
        ArrayList<IMarkerEvent> markers = new ArrayList<IMarkerEvent>();
        block0: for (IMarkerEventSource markerEventSource : this.getMarkerEventSources(this.fTrace)) {
            for (String category : markerEventSource.getMarkerCategories()) {
                if (monitor.isCanceled()) continue block0;
                markers.addAll(markerEventSource.getMarkerList(category, startTime, endTime, resolution, monitor));
            }
        }
        return markers;
    }

    private @NonNull List<String> getMarkerCategories() {
        LinkedHashSet<String> categories = new LinkedHashSet<String>(this.getViewMarkerCategories());
        for (IMarkerEventSource markerEventSource : this.getMarkerEventSources(this.fTrace)) {
            categories.addAll(markerEventSource.getMarkerCategories());
        }
        return new ArrayList<String>(categories);
    }

    private @NonNull List<IMarkerEventSource> getMarkerEventSources(ITmfTrace trace) {
        List<IMarkerEventSource> markerEventSources = this.fMarkerEventSourcesMap.get(trace);
        if (markerEventSources == null) {
            markerEventSources = Collections.emptyList();
        }
        return markerEventSources;
    }

    protected void refresh() {
        final boolean zoomThread = Thread.currentThread() instanceof ZoomThread;
        TmfUiRefreshHandler.getInstance().queueUpdate(this, new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (AbstractTimeGraphView.this.fTimeGraphWrapper.isDisposed()) {
                    return;
                }
                AbstractTimeGraphView.this.fDirty.incrementAndGet();
                boolean hasEntries = false;
                Map map = AbstractTimeGraphView.this.fEntryListMap;
                synchronized (map) {
                    AbstractTimeGraphView.this.fEntryList = (List)AbstractTimeGraphView.this.fEntryListMap.get(AbstractTimeGraphView.this.fTrace);
                    if (AbstractTimeGraphView.this.fEntryList == null) {
                        AbstractTimeGraphView.this.fEntryList = new CopyOnWriteArrayList();
                    } else if (AbstractTimeGraphView.this.fEntryComparator != null) {
                        ArrayList list = new ArrayList(AbstractTimeGraphView.this.fEntryList);
                        Collections.sort(list, AbstractTimeGraphView.this.fEntryComparator);
                        for (ITimeGraphEntry entry : list) {
                            AbstractTimeGraphView.this.sortChildren(entry, AbstractTimeGraphView.this.fEntryComparator);
                        }
                        AbstractTimeGraphView.this.fEntryList.clear();
                        AbstractTimeGraphView.this.fEntryList.addAll(list);
                    }
                    hasEntries = !AbstractTimeGraphView.this.fEntryList.isEmpty();
                }
                boolean inputChanged = AbstractTimeGraphView.this.fEntryList != AbstractTimeGraphView.this.fTimeGraphWrapper.getInput();
                TimeGraphCombo combo = AbstractTimeGraphView.this.getTimeGraphCombo();
                try {
                    if (combo != null) {
                        combo.getTreeViewer().getTree().setRedraw(false);
                    }
                    AbstractTimeGraphView.this.getTimeGraphViewer().getTimeGraphControl().setRedraw(false);
                    if (inputChanged) {
                        AbstractTimeGraphView.this.fTimeGraphWrapper.setInput(AbstractTimeGraphView.this.fEntryList);
                        AbstractTimeGraphView.this.fTimeGraphWrapper.setFilters((ViewerFilter[])AbstractTimeGraphView.this.fFiltersMap.get(AbstractTimeGraphView.this.fTrace));
                        AbstractTimeGraphView.this.fTimeGraphWrapper.getTimeGraphViewer().setLinks(null);
                        AbstractTimeGraphView.this.fTimeGraphWrapper.getTimeGraphViewer().setBookmarks(AbstractTimeGraphView.refreshBookmarks(AbstractTimeGraphView.this.fEditorFile));
                        AbstractTimeGraphView.this.fTimeGraphWrapper.getTimeGraphViewer().setMarkerCategories(AbstractTimeGraphView.this.getMarkerCategories());
                        AbstractTimeGraphView.this.fTimeGraphWrapper.getTimeGraphViewer().setMarkers(null);
                        AbstractTimeGraphView.this.applyViewContext();
                    } else {
                        AbstractTimeGraphView.this.fTimeGraphWrapper.refresh();
                    }
                    if (AbstractTimeGraphView.this.fIsRevealSelection) {
                        AbstractTimeGraphView.this.fIsRevealSelection = false;
                        ITimeGraphEntry entry1 = AbstractTimeGraphView.this.fTimeGraphWrapper.getSelection();
                        AbstractTimeGraphView.this.fTimeGraphWrapper.setSelection(entry1);
                    }
                }
                finally {
                    if (combo != null) {
                        combo.getTreeViewer().getTree().setRedraw(true);
                    }
                    AbstractTimeGraphView.this.getTimeGraphViewer().getTimeGraphControl().setRedraw(true);
                }
                long startBound = AbstractTimeGraphView.this.fStartTime == Long.MAX_VALUE ? -1L : AbstractTimeGraphView.this.fStartTime;
                long endBound = AbstractTimeGraphView.this.fEndTime == Long.MIN_VALUE ? -1L : AbstractTimeGraphView.this.fEndTime;
                AbstractTimeGraphView.this.fTimeGraphWrapper.getTimeGraphViewer().setTimeBounds(startBound, endBound);
                TmfTraceContext ctx = TmfTraceManager.getInstance().getCurrentTraceContext();
                long selectionBeginTime = AbstractTimeGraphView.this.fTrace == null ? -1L : ctx.getSelectionRange().getStartTime().toNanos();
                long selectionEndTime = AbstractTimeGraphView.this.fTrace == null ? -1L : ctx.getSelectionRange().getEndTime().toNanos();
                long startTime = AbstractTimeGraphView.this.fTrace == null ? -1L : ctx.getWindowRange().getStartTime().toNanos();
                long endTime = AbstractTimeGraphView.this.fTrace == null ? -1L : ctx.getWindowRange().getEndTime().toNanos();
                startTime = AbstractTimeGraphView.this.fStartTime == Long.MAX_VALUE ? -1L : Math.max(startTime, AbstractTimeGraphView.this.fStartTime);
                endTime = AbstractTimeGraphView.this.fEndTime == Long.MIN_VALUE ? -1L : Math.min(endTime, AbstractTimeGraphView.this.fEndTime);
                AbstractTimeGraphView.this.fTimeGraphWrapper.getTimeGraphViewer().setSelectionRange(selectionBeginTime, selectionEndTime, false);
                AbstractTimeGraphView.this.fTimeGraphWrapper.getTimeGraphViewer().setStartFinishTime(startTime, endTime);
                if (inputChanged && selectionBeginTime != -1L) {
                    AbstractTimeGraphView.this.synchingToTime(selectionBeginTime);
                }
                if (AbstractTimeGraphView.this.fTimeGraphWrapper instanceof TimeGraphComboWrapper && !AbstractTimeGraphView.this.fPackDone) {
                    TreeColumn[] treeColumnArray = ((TimeGraphComboWrapper)AbstractTimeGraphView.this.fTimeGraphWrapper).getTreeViewer().getTree().getColumns();
                    int n = treeColumnArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TreeColumn column = treeColumnArray[n2];
                        column.pack();
                        ++n2;
                    }
                    if (hasEntries) {
                        AbstractTimeGraphView.this.fPackDone = true;
                    }
                }
                if (!zoomThread) {
                    AbstractTimeGraphView.this.startZoomThread(startTime, endTime);
                }
                AbstractTimeGraphView.this.fDirty.decrementAndGet();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void redraw() {
        Object object = this.fSyncObj;
        synchronized (object) {
            if (this.fRedrawState != State.IDLE) {
                this.fRedrawState = State.PENDING;
                return;
            }
            this.fRedrawState = State.BUSY;
        }
        Display.getDefault().asyncExec(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (AbstractTimeGraphView.this.fTimeGraphWrapper.isDisposed()) {
                    return;
                }
                AbstractTimeGraphView.this.fTimeGraphWrapper.redraw();
                AbstractTimeGraphView.this.fTimeGraphWrapper.update();
                Object object = AbstractTimeGraphView.this.fSyncObj;
                synchronized (object) {
                    if (AbstractTimeGraphView.this.fRedrawState == State.PENDING) {
                        AbstractTimeGraphView.this.fRedrawState = State.IDLE;
                        AbstractTimeGraphView.this.redraw();
                    } else {
                        AbstractTimeGraphView.this.fRedrawState = State.IDLE;
                    }
                }
            }
        });
    }

    private void sortChildren(ITimeGraphEntry entry, Comparator<ITimeGraphEntry> comparator) {
        if (entry instanceof TimeGraphEntry) {
            ((TimeGraphEntry)entry).sortChildren(comparator);
        }
        for (ITimeGraphEntry iTimeGraphEntry : entry.getChildren()) {
            this.sortChildren(iTimeGraphEntry, comparator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void startZoomThread(long startTime, long endTime) {
        long clampedStartTime = Math.min(Math.max(startTime, this.fStartTime), this.fEndTime);
        long clampedEndTime = Math.max(Math.min(endTime, this.fEndTime), this.fStartTime);
        this.fDirty.incrementAndGet();
        boolean restart = false;
        if (this.fZoomThread != null) {
            this.fZoomThread.cancel();
            if (this.fZoomThread.fZoomStartTime == clampedStartTime && this.fZoomThread.fZoomEndTime == clampedEndTime) {
                restart = true;
            }
        }
        long resolution = Math.max(1L, (clampedEndTime - clampedStartTime) / (long)this.fDisplayWidth);
        this.fZoomThread = this.createZoomThread(clampedStartTime, clampedEndTime, resolution, restart);
        if (this.fZoomThread != null) {
            Object object = this.fZoomThreadResultLock;
            synchronized (object) {
                this.fZoomThread.start();
            }
        } else {
            this.fDirty.decrementAndGet();
        }
    }

    protected @Nullable ZoomThread createZoomThread(long startTime, long endTime, long resolution, boolean restart) {
        List<TimeGraphEntry> entryList = this.fEntryList;
        if (entryList == null) {
            return null;
        }
        return new ZoomThreadByEntry(entryList, startTime, endTime, resolution);
    }

    private void makeActions() {
        this.fPreviousResourceAction = this.fTimeGraphWrapper.getTimeGraphViewer().getPreviousItemAction();
        this.fPreviousResourceAction.setText(this.getPrevText());
        this.fPreviousResourceAction.setToolTipText(this.getPrevTooltip());
        this.fNextResourceAction = this.fTimeGraphWrapper.getTimeGraphViewer().getNextItemAction();
        this.fNextResourceAction.setText(this.getNextText());
        this.fNextResourceAction.setToolTipText(this.getNextTooltip());
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalToolBar(bars.getToolBarManager());
        this.fillLocalMenu(bars.getMenuManager());
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        if (this.fFilterColumns != null && this.fFilterLabelProvider != null && this.fFilterColumns.length > 0) {
            manager.add(this.fTimeGraphWrapper.getShowFilterDialogAction());
        }
        manager.add((IAction)this.fTimeGraphWrapper.getTimeGraphViewer().getShowLegendAction());
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.fTimeGraphWrapper.getTimeGraphViewer().getResetScaleAction());
        manager.add((IAction)this.fTimeGraphWrapper.getTimeGraphViewer().getPreviousEventAction());
        manager.add((IAction)this.fTimeGraphWrapper.getTimeGraphViewer().getNextEventAction());
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.fTimeGraphWrapper.getTimeGraphViewer().getToggleBookmarkAction());
        manager.add((IAction)this.fTimeGraphWrapper.getTimeGraphViewer().getPreviousMarkerAction());
        manager.add((IAction)this.fTimeGraphWrapper.getTimeGraphViewer().getNextMarkerAction());
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.fPreviousResourceAction);
        manager.add((IAction)this.fNextResourceAction);
        manager.add((IAction)this.fTimeGraphWrapper.getTimeGraphViewer().getZoomInAction());
        manager.add((IAction)this.fTimeGraphWrapper.getTimeGraphViewer().getZoomOutAction());
        manager.add((IContributionItem)new Separator());
    }

    protected void fillLocalMenu(IMenuManager manager) {
        manager.add((IContributionItem)this.fTimeGraphWrapper.getTimeGraphViewer().getMarkersMenu());
    }

    @Override
    public TmfTimeViewAlignmentInfo getTimeViewAlignmentInfo() {
        if (this.fTimeGraphWrapper == null) {
            return null;
        }
        return this.fTimeGraphWrapper.getTimeViewAlignmentInfo();
    }

    @Override
    public int getAvailableWidth(int requestedOffset) {
        if (this.fTimeGraphWrapper == null) {
            return 0;
        }
        return this.fTimeGraphWrapper.getAvailableWidth(requestedOffset);
    }

    @Override
    public void performAlign(int offset, int width) {
        if (this.fTimeGraphWrapper != null) {
            this.fTimeGraphWrapper.performAlign(offset, width);
        }
    }

    public boolean isDirty() {
        if (this.fTrace == null) {
            return false;
        }
        TmfTraceContext ctx = TmfTraceManager.getInstance().getCurrentTraceContext();
        long startTime = ctx.getWindowRange().getStartTime().toNanos();
        long endTime = ctx.getWindowRange().getEndTime().toNanos();
        if (this.fTimeGraphWrapper.getTimeGraphViewer().getTime0() != startTime || this.fTimeGraphWrapper.getTimeGraphViewer().getTime1() != endTime) {
            return true;
        }
        if (this.fZoomThread == null) {
            return this.fDirty.get() != 0;
        }
        return this.fDirty.get() != 0 || this.fZoomThread.getZoomStartTime() != startTime || this.fZoomThread.getZoomEndTime() != endTime;
    }

    private void createColumnSelectionListener(TreeViewer treeViewer) {
        int i = 0;
        while (i < this.fColumnComparators.length) {
            final int index = i;
            final Comparator<ITimeGraphEntry> comp = this.fColumnComparators[index];
            final Tree tree = treeViewer.getTree();
            final TreeColumn column = tree.getColumn(i);
            if (comp != null) {
                column.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        TreeColumn prevSortcolumn = tree.getSortColumn();
                        int direction = tree.getSortDirection();
                        direction = prevSortcolumn == column ? (direction == 1024 ? 128 : 1024) : 1024;
                        tree.setSortColumn(column);
                        tree.setSortDirection(direction);
                        AbstractTimeGraphView.this.fSortDirection = direction;
                        AbstractTimeGraphView.this.fCurrentSortColumn = index;
                        Comparator comparator = comp;
                        if (comparator instanceof ITimeGraphEntryComparator) {
                            ((ITimeGraphEntryComparator)comparator).setDirection(direction);
                        }
                        if (direction != 1024) {
                            comparator = (Comparator)NonNullUtils.checkNotNull(Collections.reverseOrder(comparator));
                        }
                        AbstractTimeGraphView.this.setEntryComparator(comparator);
                        AbstractTimeGraphView.this.fIsRevealSelection = true;
                        if (AbstractTimeGraphView.this.fTimeGraphWrapper instanceof TimeGraphComboWrapper) {
                            ((TimeGraphComboWrapper)AbstractTimeGraphView.this.fTimeGraphWrapper).getTreeViewer().getControl().setFocus();
                        }
                        AbstractTimeGraphView.this.refresh();
                    }
                });
            }
            ++i;
        }
    }

    private void createDoubleClickListener(TreeViewer treeViewer) {
        treeViewer.addDoubleClickListener(event -> {
            ITimeGraphEntry entry;
            TreeSelection selection;
            if (event.getSelection() instanceof TreeSelection && (selection = (TreeSelection)event.getSelection()).getFirstElement() instanceof ITimeGraphEntry && (entry = (ITimeGraphEntry)selection.getFirstElement()).hasChildren()) {
                this.fTimeGraphWrapper.setExpandedState(entry, !this.fTimeGraphWrapper.getExpandedState(entry));
            }
        });
    }

    private void restoreViewContext() {
        TimeGraphCombo combo = this.getTimeGraphCombo();
        ViewContext viewContext = this.fViewContext.get(this.fTrace);
        if (combo != null && this.fColumnComparators != null) {
            this.fSortDirection = 1024;
            this.fCurrentSortColumn = this.fInitialSortColumn;
            if (viewContext != null) {
                this.fSortDirection = viewContext.getSortDirection();
                this.fCurrentSortColumn = viewContext.getSortColumn();
            }
            if (this.fCurrentSortColumn < this.fColumnComparators.length && this.fColumnComparators[this.fCurrentSortColumn] != null) {
                Comparator comparator = this.fColumnComparators[this.fCurrentSortColumn];
                if (comparator instanceof ITimeGraphEntryComparator) {
                    ((ITimeGraphEntryComparator)comparator).setDirection(this.fSortDirection);
                }
                if (this.fSortDirection != 1024) {
                    comparator = (Comparator)NonNullUtils.checkNotNull(Collections.reverseOrder(comparator));
                }
                this.setEntryComparator(comparator);
            }
        }
    }

    private void applyViewContext() {
        TimeGraphCombo combo = this.getTimeGraphCombo();
        ViewContext viewContext = this.fViewContext.get(this.fTrace);
        if (combo != null) {
            TreeViewer treeViewer = combo.getTreeViewer();
            Tree tree = treeViewer.getTree();
            TreeColumn column = tree.getColumn(this.fCurrentSortColumn);
            tree.setSortDirection(this.fSortDirection);
            tree.setSortColumn(column);
            combo.getTreeViewer().getControl().setFocus();
        }
        if (viewContext != null && viewContext.getSelection() != null) {
            this.fTimeGraphWrapper.setSelection(viewContext.getSelection());
        }
        this.fViewContext.remove(this.fTrace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resetView(ITmfTrace viewTrace) {
        if (viewTrace == null) {
            return;
        }
        Map<ITmfTrace, Object> map = this.fBuildThreadMap;
        synchronized (map) {
            for (ITmfTrace trace : this.getTracesToBuild(viewTrace)) {
                BuildThread buildThread = this.fBuildThreadMap.remove(trace);
                if (buildThread == null) continue;
                buildThread.cancel();
            }
        }
        map = this.fEntryListMap;
        synchronized (map) {
            this.fEntryListMap.remove(viewTrace);
        }
        this.fViewContext.remove(viewTrace);
        this.fFiltersMap.remove(viewTrace);
        this.fMarkerEventSourcesMap.remove(viewTrace);
        if (viewTrace == this.fTrace && this.fZoomThread != null) {
            this.fZoomThread.cancel();
            this.fZoomThread = null;
        }
    }

    private void createContextMenu() {
        TimeGraphCombo combo = this.getTimeGraphCombo();
        this.fEntryMenuManager.setRemoveAllWhenShown(true);
        if (combo != null) {
            TreeViewer treeViewer = combo.getTreeViewer();
            Tree tree = treeViewer.getTree();
            Menu menu = this.fEntryMenuManager.createContextMenu((Control)tree);
            tree.setMenu(menu);
        } else {
            final TimeGraphControl timeGraphControl = this.getTimeGraphViewer().getTimeGraphControl();
            final Menu entryMenu = this.fEntryMenuManager.createContextMenu((Control)timeGraphControl);
            timeGraphControl.addTimeGraphEntryMenuListener(new MenuDetectListener(){

                public void menuDetected(MenuDetectEvent event) {
                    Point p = timeGraphControl.toControl(event.x, event.y);
                    if (p.x < AbstractTimeGraphView.this.getTimeGraphViewer().getNameSpace()) {
                        timeGraphControl.setMenu(entryMenu);
                    } else {
                        timeGraphControl.setMenu(null);
                        event.doit = false;
                    }
                }
            });
        }
        this.fEntryMenuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                AbstractTimeGraphView.this.fillTimeGraphEntryContextMenu((IMenuManager)AbstractTimeGraphView.this.fEntryMenuManager);
                AbstractTimeGraphView.this.fEntryMenuManager.add((IContributionItem)new GroupMarker("additions"));
            }
        });
        this.getSite().registerContextMenu(this.fEntryMenuManager, this.fTimeGraphWrapper.getSelectionProvider());
    }

    protected void fillTimeGraphEntryContextMenu(@NonNull IMenuManager menuManager) {
    }

    private class BuildThread
    extends Thread {
        private final @NonNull ITmfTrace fBuildTrace;
        private final @NonNull ITmfTrace fParentTrace;
        private final @NonNull IProgressMonitor fMonitor;

        public BuildThread(@NonNull ITmfTrace trace, ITmfTrace parentTrace, String name) {
            super(String.valueOf(name) + " build");
            this.fBuildTrace = trace;
            this.fParentTrace = parentTrace;
            this.fMonitor = new NullProgressMonitor();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            AbstractTimeGraphView.this.buildEntryList(this.fBuildTrace, this.fParentTrace, this.fMonitor);
            Map map = AbstractTimeGraphView.this.fBuildThreadMap;
            synchronized (map) {
                AbstractTimeGraphView.this.fBuildThreadMap.remove(this.fBuildTrace);
            }
        }

        public void cancel() {
            this.fMonitor.setCanceled(true);
        }
    }

    class FindTarget {
        FindTarget() {
        }

        public ITimeGraphEntry getSelection() {
            return AbstractTimeGraphView.this.fTimeGraphWrapper.getSelection();
        }

        public void selectAndReveal(@NonNull ITimeGraphEntry entry) {
            AbstractTimeGraphView.this.fTimeGraphWrapper.selectAndReveal(entry);
        }

        public ITimeGraphEntry[] getEntries() {
            TimeGraphViewer viewer = AbstractTimeGraphView.this.getTimeGraphViewer();
            return viewer.getTimeGraphContentProvider().getElements(viewer.getInput());
        }

        public Shell getShell() {
            return AbstractTimeGraphView.this.getSite().getShell();
        }
    }

    private static interface ITimeGraphWrapper {
        public void setTimeGraphContentProvider(ITimeGraphContentProvider var1);

        public void setTimeGraphPresentationProvider(TimeGraphPresentationProvider var1);

        public TimeGraphViewer getTimeGraphViewer();

        public void addSelectionListener(ITimeGraphSelectionListener var1);

        public ISelectionProvider getSelectionProvider();

        public void setFocus();

        public boolean isDisposed();

        public void refresh();

        public void setInput(Object var1);

        public Object getInput();

        public void setFilters(@NonNull ViewerFilter[] var1);

        public @NonNull ViewerFilter[] getFilters();

        public void redraw();

        public void update();

        public void setAutoExpandLevel(int var1);

        public boolean getExpandedState(ITimeGraphEntry var1);

        public void setExpandedState(ITimeGraphEntry var1, boolean var2);

        public void setFilterColumns(String[] var1);

        public void setFilterContentProvider(ITreeContentProvider var1);

        public void setFilterLabelProvider(ITableLabelProvider var1);

        public IAction getShowFilterDialogAction();

        public void performAlign(int var1, int var2);

        public TmfTimeViewAlignmentInfo getTimeViewAlignmentInfo();

        public int getAvailableWidth(int var1);

        public ITimeGraphEntry getSelection();

        public void setSelection(ITimeGraphEntry var1);

        public void selectAndReveal(@NonNull ITimeGraphEntry var1);
    }

    private static enum State {
        IDLE,
        BUSY,
        PENDING;

    }

    private class TimeGraphComboWrapper
    implements ITimeGraphWrapper {
        private TimeGraphCombo combo;

        private TimeGraphComboWrapper(Composite parent, int style) {
            this.combo = new TimeGraphCombo(parent, style, AbstractTimeGraphView.this.fWeight);
        }

        @Override
        public void setTimeGraphContentProvider(ITimeGraphContentProvider timeGraphContentProvider) {
            this.combo.setTimeGraphContentProvider(timeGraphContentProvider);
        }

        @Override
        public void setTimeGraphPresentationProvider(TimeGraphPresentationProvider timeGraphPresentationProvider) {
            this.combo.setTimeGraphProvider(timeGraphPresentationProvider);
        }

        @Override
        public TimeGraphViewer getTimeGraphViewer() {
            return this.combo.getTimeGraphViewer();
        }

        @Override
        public void addSelectionListener(ITimeGraphSelectionListener listener) {
            this.combo.addSelectionListener(listener);
        }

        @Override
        public ISelectionProvider getSelectionProvider() {
            return this.combo.getTreeViewer();
        }

        @Override
        public void setFocus() {
            this.combo.setFocus();
        }

        @Override
        public boolean isDisposed() {
            return this.combo.isDisposed();
        }

        @Override
        public void setInput(Object input) {
            this.combo.setInput(input);
        }

        @Override
        public Object getInput() {
            return this.combo.getInput();
        }

        @Override
        public void setFilterColumns(String[] columnNames) {
            this.combo.setFilterColumns(columnNames);
        }

        @Override
        public void setFilterContentProvider(ITreeContentProvider contentProvider) {
            this.combo.setFilterContentProvider(contentProvider);
        }

        @Override
        public void setFilterLabelProvider(ITableLabelProvider labelProvider) {
            this.combo.setFilterLabelProvider(labelProvider);
        }

        @Override
        public void setFilters(@NonNull ViewerFilter[] filters) {
            this.combo.setFilters(filters);
        }

        @Override
        public @NonNull ViewerFilter[] getFilters() {
            return this.combo.getFilters();
        }

        @Override
        public IAction getShowFilterDialogAction() {
            return this.combo.getShowFilterDialogAction();
        }

        @Override
        public void refresh() {
            this.combo.refresh();
        }

        @Override
        public void redraw() {
            this.combo.redraw();
        }

        @Override
        public void update() {
            this.combo.update();
        }

        @Override
        public void setAutoExpandLevel(int level) {
            this.combo.setAutoExpandLevel(level);
        }

        @Override
        public boolean getExpandedState(ITimeGraphEntry entry) {
            return this.combo.getExpandedState(entry);
        }

        @Override
        public void setExpandedState(ITimeGraphEntry entry, boolean expanded) {
            this.combo.setExpandedState(entry, expanded);
        }

        TimeGraphCombo getTimeGraphCombo() {
            return this.combo;
        }

        TreeViewer getTreeViewer() {
            return this.combo.getTreeViewer();
        }

        @Override
        public void performAlign(int offset, int width) {
            this.combo.performAlign(offset, width);
        }

        @Override
        public TmfTimeViewAlignmentInfo getTimeViewAlignmentInfo() {
            return this.combo.getTimeViewAlignmentInfo();
        }

        @Override
        public int getAvailableWidth(int requestedOffset) {
            return this.combo.getAvailableWidth(requestedOffset);
        }

        @Override
        public ITimeGraphEntry getSelection() {
            return this.combo.getTimeGraphViewer().getSelection();
        }

        @Override
        public void setSelection(ITimeGraphEntry selection) {
            this.combo.setSelection(selection);
        }

        @Override
        public void selectAndReveal(@NonNull ITimeGraphEntry selection) {
            this.combo.selectAndReveal(selection);
        }
    }

    class TimeGraphPartListener
    implements IPartListener {
        TimeGraphPartListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void partActivated(IWorkbenchPart part) {
            if (part == AbstractTimeGraphView.this) {
                ShowFindDialogAction showFindDialogAction = FIND_ACTION;
                synchronized (showFindDialogAction) {
                    if (AbstractTimeGraphView.this.fFindActionHandler == null) {
                        AbstractTimeGraphView.this.fFindActionHandler = new ActionHandler((IAction)FIND_ACTION);
                    }
                    if (AbstractTimeGraphView.this.fFindHandlerActivation == null) {
                        Object service = PlatformUI.getWorkbench().getService(IHandlerService.class);
                        AbstractTimeGraphView.this.fFindHandlerActivation = ((IHandlerService)service).activateHandler(ActionFactory.FIND.getCommandId(), (IHandler)AbstractTimeGraphView.this.fFindActionHandler);
                    }
                }
            }
            FIND_ACTION.partActivated(part);
        }

        public void partDeactivated(IWorkbenchPart part) {
            if (part == AbstractTimeGraphView.this && AbstractTimeGraphView.this.fFindHandlerActivation != null) {
                Object service = PlatformUI.getWorkbench().getService(IHandlerService.class);
                ((IHandlerService)service).deactivateHandler(AbstractTimeGraphView.this.fFindHandlerActivation);
                AbstractTimeGraphView.this.fFindHandlerActivation = null;
            }
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
        }

        public void partOpened(IWorkbenchPart part) {
        }
    }

    private class TimeGraphViewerWrapper
    implements ITimeGraphWrapper {
        private TimeGraphViewer viewer;

        private TimeGraphViewerWrapper(Composite parent, int style) {
            this.viewer = new TimeGraphViewer(parent, style);
        }

        @Override
        public void setTimeGraphContentProvider(ITimeGraphContentProvider timeGraphContentProvider) {
            this.viewer.setTimeGraphContentProvider(timeGraphContentProvider);
        }

        @Override
        public void setTimeGraphPresentationProvider(TimeGraphPresentationProvider timeGraphPresentationProvider) {
            this.viewer.setTimeGraphProvider(timeGraphPresentationProvider);
        }

        @Override
        public TimeGraphViewer getTimeGraphViewer() {
            return this.viewer;
        }

        @Override
        public void addSelectionListener(ITimeGraphSelectionListener listener) {
            this.viewer.addSelectionListener(listener);
        }

        @Override
        public ISelectionProvider getSelectionProvider() {
            return this.viewer.getSelectionProvider();
        }

        @Override
        public void setFocus() {
            this.viewer.setFocus();
        }

        @Override
        public boolean isDisposed() {
            return this.viewer.getControl().isDisposed();
        }

        @Override
        public void setInput(Object input) {
            this.viewer.setInput(input);
        }

        @Override
        public Object getInput() {
            return this.viewer.getInput();
        }

        @Override
        public void setFilterColumns(String[] columnNames) {
            this.viewer.setFilterColumns(columnNames);
        }

        @Override
        public void setFilterContentProvider(ITreeContentProvider contentProvider) {
            this.viewer.setFilterContentProvider(contentProvider);
        }

        @Override
        public void setFilterLabelProvider(ITableLabelProvider labelProvider) {
            this.viewer.setFilterLabelProvider(labelProvider);
        }

        @Override
        public void setFilters(@NonNull ViewerFilter[] filters) {
            this.viewer.setFilters(filters);
        }

        @Override
        public @NonNull ViewerFilter[] getFilters() {
            return this.viewer.getFilters();
        }

        @Override
        public IAction getShowFilterDialogAction() {
            return this.viewer.getShowFilterDialogAction();
        }

        @Override
        public void refresh() {
            this.viewer.refresh();
        }

        @Override
        public void redraw() {
            this.viewer.getControl().redraw();
        }

        @Override
        public void update() {
            this.viewer.getControl().update();
        }

        @Override
        public void setAutoExpandLevel(int level) {
            this.viewer.setAutoExpandLevel(level);
        }

        @Override
        public boolean getExpandedState(ITimeGraphEntry entry) {
            return this.viewer.getExpandedState(entry);
        }

        @Override
        public void setExpandedState(ITimeGraphEntry entry, boolean expanded) {
            this.viewer.setExpandedState(entry, expanded);
        }

        @Override
        public void performAlign(int offset, int width) {
            this.viewer.performAlign(offset, width);
        }

        @Override
        public TmfTimeViewAlignmentInfo getTimeViewAlignmentInfo() {
            return this.viewer.getTimeViewAlignmentInfo();
        }

        @Override
        public int getAvailableWidth(int requestedOffset) {
            return this.viewer.getAvailableWidth(requestedOffset);
        }

        @Override
        public ITimeGraphEntry getSelection() {
            return this.viewer.getSelection();
        }

        @Override
        public void setSelection(ITimeGraphEntry selection) {
            this.viewer.setSelection(selection);
        }

        @Override
        public void selectAndReveal(@NonNull ITimeGraphEntry selection) {
            this.viewer.selectAndReveal(selection);
        }
    }

    protected static class TreeLabelProvider
    implements ITableLabelProvider,
    ILabelProvider {
        protected TreeLabelProvider() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            TimeGraphEntry entry = (TimeGraphEntry)element;
            if (columnIndex == 0) {
                return entry.getName();
            }
            return new String();
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            TimeGraphEntry entry = (TimeGraphEntry)element;
            return entry.getName();
        }
    }

    private static class ViewContext {
        private int fSortColumnIndex;
        private int fSortDirection;
        private @Nullable ITimeGraphEntry fSelection;

        ViewContext(int sortColunm, int sortDirection, ITimeGraphEntry selection) {
            this.fSortColumnIndex = sortColunm;
            this.fSortDirection = sortDirection;
            this.fSelection = selection;
        }

        public int getSortColumn() {
            return this.fSortColumnIndex;
        }

        public int getSortDirection() {
            return this.fSortDirection;
        }

        public ITimeGraphEntry getSelection() {
            return this.fSelection;
        }
    }

    protected abstract class ZoomThread
    extends Thread {
        private final long fZoomStartTime;
        private final long fZoomEndTime;
        private final long fResolution;
        private final @NonNull IProgressMonitor fMonitor;

        public ZoomThread(long startTime, long endTime, long resolution) {
            super(String.valueOf(AbstractTimeGraphView.this.getName()) + " zoom");
            this.fZoomStartTime = startTime;
            this.fZoomEndTime = endTime;
            this.fResolution = resolution;
            this.fMonitor = new NullProgressMonitor();
        }

        public long getZoomStartTime() {
            return this.fZoomStartTime;
        }

        public long getZoomEndTime() {
            return this.fZoomEndTime;
        }

        public long getResolution() {
            return this.fResolution;
        }

        public @NonNull IProgressMonitor getMonitor() {
            return this.fMonitor;
        }

        public void cancel() {
            this.fMonitor.setCanceled(true);
        }

        @Override
        public final void run() {
            this.doRun();
            AbstractTimeGraphView.this.fDirty.decrementAndGet();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void applyResults(Runnable runnable) {
            Object object = AbstractTimeGraphView.this.fZoomThreadResultLock;
            synchronized (object) {
                if (this == AbstractTimeGraphView.this.fZoomThread) {
                    runnable.run();
                }
            }
        }

        public abstract void doRun();
    }

    private class ZoomThreadByEntry
    extends ZoomThread {
        private final @NonNull List<TimeGraphEntry> fZoomEntryList;

        public ZoomThreadByEntry(List<TimeGraphEntry> entryList, long startTime, long endTime, long resolution) {
            super(startTime, endTime, resolution);
            this.fZoomEntryList = entryList;
        }

        @Override
        public void doRun() {
            for (TimeGraphEntry entry : this.fZoomEntryList) {
                if (this.getMonitor().isCanceled()) {
                    return;
                }
                if (entry == null) break;
                this.zoom(entry, this.getMonitor());
            }
            List<ILinkEvent> events = AbstractTimeGraphView.this.getLinkList(this.getZoomStartTime(), this.getZoomEndTime(), this.getResolution(), this.getMonitor());
            ArrayList<IMarkerEvent> markers = new ArrayList<IMarkerEvent>(AbstractTimeGraphView.this.getViewMarkerList(this.getZoomStartTime(), this.getZoomEndTime(), this.getResolution(), this.getMonitor()));
            markers.addAll(AbstractTimeGraphView.this.getTraceMarkerList(this.getZoomStartTime(), this.getZoomEndTime(), this.getResolution(), this.getMonitor()));
            this.applyResults(() -> {
                if (events != null) {
                    AbstractTimeGraphView.this.fTimeGraphWrapper.getTimeGraphViewer().setLinks(events);
                }
                AbstractTimeGraphView.this.fTimeGraphWrapper.getTimeGraphViewer().setMarkers(markers);
                AbstractTimeGraphView.this.redraw();
            });
        }

        private void zoom(@NonNull TimeGraphEntry entry, @NonNull IProgressMonitor monitor) {
            if (this.getZoomStartTime() <= AbstractTimeGraphView.this.fStartTime && this.getZoomEndTime() >= AbstractTimeGraphView.this.fEndTime) {
                this.applyResults(() -> entry.setZoomedEventList(null));
            } else {
                List<ITimeEvent> zoomedEventList = AbstractTimeGraphView.this.getEventList(entry, this.getZoomStartTime(), this.getZoomEndTime(), this.getResolution(), monitor);
                if (zoomedEventList != null) {
                    this.applyResults(() -> entry.setZoomedEventList(zoomedEventList));
                }
            }
            AbstractTimeGraphView.this.redraw();
            for (TimeGraphEntry child : entry.getChildren()) {
                if (monitor.isCanceled()) {
                    return;
                }
                this.zoom(child, monitor);
            }
        }
    }
}

