/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.views.uml2sd.core;

import org.eclipse.tracecompass.tmf.ui.views.uml2sd.core.GraphNode;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.core.Lifeline;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.core.Metrics;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.drawings.IColor;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.drawings.IGC;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.preferences.SDViewPref;

public class BasicExecutionOccurrence
extends GraphNode {
    public static final String EXEC_OCC_TAG = "Execution_Occ";
    private Lifeline fLifeline = null;

    public BasicExecutionOccurrence() {
        this.setColorPrefId("PREF_EXEC");
    }

    @Override
    public int getX() {
        if (this.fLifeline == null) {
            return 0;
        }
        return this.fLifeline.getX() + Metrics.getLifelineWidth() / 2 - 4;
    }

    @Override
    public int getY() {
        if (this.fLifeline == null) {
            return 0;
        }
        return this.fLifeline.getY() + this.fLifeline.getHeight() + (Metrics.getMessageFontHeigth() + Metrics.getMessagesSpacing()) * this.getStartOccurrence();
    }

    @Override
    public int getWidth() {
        if (this.fLifeline == null) {
            return 0;
        }
        return 8;
    }

    @Override
    public int getHeight() {
        if (this.fLifeline == null) {
            return 0;
        }
        return (Metrics.getMessageFontHeigth() + Metrics.getMessagesSpacing()) * (this.getEndOccurrence() - this.getStartOccurrence());
    }

    @Override
    public boolean contains(int xValue, int yValue) {
        int height;
        int width;
        int y;
        int x = this.getX();
        if (GraphNode.contains(x, y = this.getY(), width = this.getWidth(), height = this.getHeight(), xValue, yValue)) {
            return true;
        }
        return this.getNodeAt(xValue, yValue) != null;
    }

    @Override
    public String getName() {
        if (super.getName() == null || super.getName().equals("")) {
            return this.fLifeline.getToolTipText();
        }
        return super.getName();
    }

    public void setLifeline(Lifeline theLifeline) {
        this.fLifeline = theLifeline;
    }

    public Lifeline getLifeline() {
        return this.fLifeline;
    }

    @Override
    public int getStartOccurrence() {
        return super.getStartOccurrence();
    }

    @Override
    public int getEndOccurrence() {
        return super.getEndOccurrence();
    }

    @Override
    public void setStartOccurrence(int occurrence) {
        super.setStartOccurrence(occurrence);
    }

    @Override
    public void setEndOccurrence(int occurrence) {
        super.setEndOccurrence(occurrence);
    }

    @Override
    public void draw(IGC context) {
        int x = this.getX();
        int y = this.getY();
        int width = this.getWidth();
        int height = this.getHeight();
        IColor tempFillColor = null;
        IColor tempStrokeColor = null;
        SDViewPref pref = SDViewPref.getInstance();
        if (this.fLifeline.isSelected() || this.isSelected()) {
            context.setBackground(pref.getBackGroundColorSelection());
            context.setForeground(pref.getForeGroundColorSelection());
        } else {
            tempFillColor = this.setUnselectedFillColor(context);
        }
        if (pref.useGradienColor()) {
            context.fillGradientRectangle(x, y, width, height, false);
        } else {
            context.fillRectangle(x, y, width, height);
        }
        tempStrokeColor = this.setUnselectedStrokeColor(context);
        context.drawRectangle(x, y, width, height);
        if (tempFillColor != null) {
            tempFillColor.dispose();
        }
        if (tempStrokeColor != null) {
            tempStrokeColor.dispose();
        }
        if (this.hasFocus()) {
            this.drawFocus(context);
        }
        super.drawChildenNodes(context);
    }

    protected IColor setUnselectedFillColor(IGC context) {
        SDViewPref pref = SDViewPref.getInstance();
        if (pref.useGradienColor()) {
            context.setGradientColor(pref.getBackGroundColor("PREF_EXEC"));
            context.setBackground(pref.getBackGroundColor("PREF_FRAME"));
        } else {
            context.setBackground(pref.getBackGroundColor("PREF_EXEC"));
        }
        return null;
    }

    protected IColor setUnselectedStrokeColor(IGC context) {
        context.setForeground(SDViewPref.getInstance().getForeGroundColor("PREF_EXEC"));
        return null;
    }

    @Override
    public String getArrayId() {
        return EXEC_OCC_TAG;
    }

    @Override
    public boolean positiveDistanceToPoint(int x, int y) {
        return this.getY() + this.getHeight() > y;
    }

    @Override
    public boolean isVisible(int x, int y, int width, int height) {
        if (this.getLifeline() != null && this.getLifeline().isVisible(x, y, width, height)) {
            int ly = this.getY();
            int lh = this.getHeight();
            if (ly >= y && ly < y + height) {
                return true;
            }
            if (ly + lh > y && ly + lh <= y + height) {
                return true;
            }
            if (ly < y && ly + lh > y + height) {
                return true;
            }
        }
        return false;
    }
}

