/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.widgets.timegraph;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;
import org.eclipse.tracecompass.tmf.ui.signal.TmfTimeViewAlignmentInfo;
import org.eclipse.tracecompass.tmf.ui.signal.TmfTimeViewAlignmentSignal;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.ITimeGraphContentProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.ITimeGraphPresentationProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.ITimeGraphSelectionListener;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.ITimeGraphTreeListener;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphSelectionEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphTreeExpansionEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphViewer;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.dialogs.ITimeGraphEntryActiveProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.dialogs.ShowFilterDialogAction;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ILinkEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.ITimeDataProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.TimeGraphColorScheme;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.TimeGraphControl;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.TimeGraphMarkerAxis;

public class TimeGraphCombo
extends Composite {
    public static final int ALL_LEVELS = -1;
    private static final Object FILLER = new Object();
    private TreeViewer fTreeViewer;
    private @NonNull TimeGraphViewer fTimeGraphViewer;
    private final Map<ITimeGraphSelectionListener, SelectionListenerWrapper> fSelectionListenerMap = new HashMap<ITimeGraphSelectionListener, SelectionListenerWrapper>();
    private final Map<@NonNull ViewerFilter, @NonNull ViewerFilter> fViewerFilterMap = new HashMap<ViewerFilter, ViewerFilter>();
    private boolean fInhibitTreeSelection = false;
    private int fNumFillerRows;
    private int fLinuxItemHeight = 0;
    private ShowFilterDialogAction fShowFilterDialogAction;
    private static final int[] DEFAULT_WEIGHTS = new int[]{1, 1};
    private List<TreeItem> fVisibleExpandedItems = null;
    private Listener fSashDragListener;
    private SashForm fSashForm;
    private final boolean fScrollBarsInTreeWorkaround;
    private Font fTreeFont;

    public TimeGraphCombo(Composite parent, int style) {
        this(parent, style, DEFAULT_WEIGHTS);
    }

    public TimeGraphCombo(Composite parent, int style, int[] weights) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        this.fSashForm = new SashForm((Composite)this, 0);
        this.fScrollBarsInTreeWorkaround = "win32".equals(SWT.getPlatform());
        int scrollBarStyle = this.fScrollBarsInTreeWorkaround ? 256 : 272;
        this.fTreeViewer = new TreeViewer((Composite)this.fSashForm, 0x10000 | scrollBarStyle);
        this.fTreeViewer.setAutoExpandLevel(-1);
        final Tree tree = this.fTreeViewer.getTree();
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        this.fTimeGraphViewer = new TimeGraphViewerExtension((Composite)this.fSashForm, 0, tree);
        if (this.fScrollBarsInTreeWorkaround) {
            tree.addControlListener((ControlListener)new ControlAdapter(){
                private int depth = 0;

                public void controlResized(ControlEvent e) {
                    if (this.depth == 0) {
                        ++this.depth;
                        tree.getVerticalBar().setEnabled(false);
                        tree.getVerticalBar().setVisible(false);
                        --this.depth;
                    }
                }
            });
        }
        tree.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                int headerHeight = tree.getHeaderHeight();
                if (headerHeight > 0) {
                    TimeGraphCombo.this.fTimeGraphViewer.setHeaderHeight(headerHeight);
                    tree.removePaintListener((PaintListener)this);
                }
            }
        });
        tree.addDisposeListener(e -> {
            if (this.fTreeFont != null) {
                this.fTreeFont.dispose();
            }
        });
        this.fTreeViewer.addTreeListener(new ITreeViewerListener(){

            public void treeCollapsed(TreeExpansionEvent event) {
                TimeGraphCombo.this.fTimeGraphViewer.setExpandedState((ITimeGraphEntry)event.getElement(), false);
                TimeGraphCombo.this.fVisibleExpandedItems = null;
                TimeGraphCombo.this.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        TimeGraphCombo.this.alignTreeItems(true);
                    }
                });
            }

            public void treeExpanded(TreeExpansionEvent event) {
                ITimeGraphEntry entry = (ITimeGraphEntry)event.getElement();
                TimeGraphCombo.this.fTimeGraphViewer.setExpandedState(entry, true);
                HashSet<Object> expandedElements = new HashSet<Object>(Arrays.asList(TimeGraphCombo.this.fTreeViewer.getExpandedElements()));
                for (ITimeGraphEntry iTimeGraphEntry : entry.getChildren()) {
                    if (!iTimeGraphEntry.hasChildren()) continue;
                    boolean expanded = expandedElements.contains(iTimeGraphEntry);
                    TimeGraphCombo.this.fTimeGraphViewer.setExpandedState(iTimeGraphEntry, expanded);
                }
                TimeGraphCombo.this.fVisibleExpandedItems = null;
                TimeGraphCombo.this.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        TimeGraphCombo.this.alignTreeItems(true);
                    }
                });
            }
        });
        this.fTimeGraphViewer.addTreeListener(new ITimeGraphTreeListener(){

            @Override
            public void treeCollapsed(TimeGraphTreeExpansionEvent event) {
                TimeGraphCombo.this.fTreeViewer.setExpandedState((Object)event.getEntry(), false);
                TimeGraphCombo.this.alignTreeItems(true);
            }

            @Override
            public void treeExpanded(TimeGraphTreeExpansionEvent event) {
                ITimeGraphEntry entry = event.getEntry();
                TimeGraphCombo.this.fTreeViewer.setExpandedState((Object)entry, true);
                HashSet<Object> expandedElements = new HashSet<Object>(Arrays.asList(TimeGraphCombo.this.fTreeViewer.getExpandedElements()));
                for (ITimeGraphEntry iTimeGraphEntry : entry.getChildren()) {
                    if (!iTimeGraphEntry.hasChildren()) continue;
                    boolean expanded = expandedElements.contains(iTimeGraphEntry);
                    TimeGraphCombo.this.fTimeGraphViewer.setExpandedState(iTimeGraphEntry, expanded);
                }
                TimeGraphCombo.this.alignTreeItems(true);
            }
        });
        tree.addListener(3, event -> {
            List<TreeItem> treeItems = this.getVisibleExpandedItems(tree, false);
            if (treeItems.isEmpty()) {
                event.doit = false;
                this.fTreeViewer.setSelection((ISelection)new StructuredSelection());
                this.fTimeGraphViewer.setSelection(null);
                return;
            }
            TreeItem lastTreeItem = treeItems.get(treeItems.size() - 1);
            if (event.y >= lastTreeItem.getBounds().y + lastTreeItem.getBounds().height) {
                event.doit = false;
                tree.select(treeItems.get(treeItems.size() - 1));
                this.fTreeViewer.setSelection((ISelection)new StructuredSelection());
                this.fTimeGraphViewer.setSelection(null);
            }
        });
        tree.addListener(37, event -> {
            event.doit = false;
            if (event.count == 0) {
                return;
            }
            Slider scrollBar = this.fTimeGraphViewer.getVerticalBar();
            this.fTimeGraphViewer.setTopIndex(scrollBar.getSelection() - event.count);
            this.alignTreeItems(false);
        });
        tree.addListener(1, event -> {
            List<TreeItem> treeItems = this.getVisibleExpandedItems(tree, false);
            if (treeItems.size() == 0) {
                this.fTreeViewer.setSelection((ISelection)new StructuredSelection());
                event.doit = false;
                return;
            }
            if (event.keyCode == 0x1000002) {
                int index = Math.min(this.fTimeGraphViewer.getSelectionIndex() + 1, treeItems.size() - 1);
                this.fTimeGraphViewer.setSelection((ITimeGraphEntry)treeItems.get(index).getData());
                event.doit = false;
            } else if (event.keyCode == 0x1000006) {
                int height = tree.getSize().y - tree.getHeaderHeight() - tree.getHorizontalBar().getSize().y;
                int countPerPage = height / this.getItemHeight(tree, false);
                int index = Math.min(this.fTimeGraphViewer.getSelectionIndex() + countPerPage - 1, treeItems.size() - 1);
                this.fTimeGraphViewer.setSelection((ITimeGraphEntry)treeItems.get(index).getData());
                event.doit = false;
            } else if (event.keyCode == 0x1000008) {
                this.fTimeGraphViewer.setSelection((ITimeGraphEntry)treeItems.get(treeItems.size() - 1).getData());
                event.doit = false;
            } else {
                if ((event.character == '+' || event.character == '=') && (event.stateMask & 0x40000) != 0) {
                    this.fTimeGraphViewer.getTimeGraphControl().keyPressed(new KeyEvent(event));
                    return;
                }
                if (event.character == '-' && (event.stateMask & 0x40000) != 0) {
                    this.fTimeGraphViewer.getTimeGraphControl().keyPressed(new KeyEvent(event));
                    return;
                }
                if (event.character == '0' && (event.stateMask & 0x40000) != 0) {
                    this.fTimeGraphViewer.getTimeGraphControl().keyPressed(new KeyEvent(event));
                    return;
                }
                return;
            }
            if (this.fTimeGraphViewer.getSelectionIndex() >= 0) {
                this.fTreeViewer.setSelection((ISelection)new StructuredSelection((Object)this.fTimeGraphViewer.getSelection()));
            } else {
                this.fTreeViewer.setSelection((ISelection)new StructuredSelection());
            }
            this.alignTreeItems(false);
        });
        this.fTimeGraphViewer.getTimeGraphControl().addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                TimeGraphCombo.this.alignTreeItems(false);
            }
        });
        this.fTreeViewer.addSelectionChangedListener(event -> {
            if (this.fInhibitTreeSelection) {
                return;
            }
            if (event.getSelection() instanceof IStructuredSelection) {
                Object selection = ((IStructuredSelection)event.getSelection()).getFirstElement();
                if (selection instanceof ITimeGraphEntry) {
                    this.fTimeGraphViewer.setSelection((ITimeGraphEntry)selection);
                }
                this.alignTreeItems(false);
            }
        });
        this.fTimeGraphViewer.addSelectionListener(event -> {
            ITimeGraphEntry entry = this.fTimeGraphViewer.getSelection();
            this.setSelectionInTree(entry);
        });
        this.fTimeGraphViewer.getVerticalBar().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TimeGraphCombo.this.alignTreeItems(false);
            }
        });
        this.fTimeGraphViewer.getTimeGraphControl().addMouseWheelListener(e -> {
            if (e.count == 0) {
                return;
            }
            this.alignTreeItems(false);
        });
        this.fTreeViewer.getControl().addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseEnter(MouseEvent e) {
                if (TimeGraphCombo.this.fTimeGraphViewer.getTimeGraphControl().isFocusControl()) {
                    TimeGraphCombo.this.fTreeViewer.getControl().setFocus();
                }
            }
        });
        this.fTimeGraphViewer.getTimeGraphControl().addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseEnter(MouseEvent e) {
                if (TimeGraphCombo.this.fTreeViewer.getControl().isFocusControl()) {
                    TimeGraphCombo.this.fTimeGraphViewer.getTimeGraphControl().setFocus();
                }
            }
        });
        this.fTimeGraphViewer.getTimeGraphScale().addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseEnter(MouseEvent e) {
                if (TimeGraphCombo.this.fTreeViewer.getControl().isFocusControl()) {
                    TimeGraphCombo.this.fTimeGraphViewer.getTimeGraphControl().setFocus();
                }
            }
        });
        this.fNumFillerRows = Display.getDefault().getBounds().height / this.getItemHeight(tree, false);
        this.fSashForm.setWeights(weights);
        this.fTimeGraphViewer.getTimeGraphControl().addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (TimeGraphCombo.this.fSashDragListener == null) {
                    Control[] controlArray = TimeGraphCombo.this.fSashForm.getChildren();
                    int n = controlArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Control control = controlArray[n2];
                        if (control instanceof Sash) {
                            TimeGraphCombo.this.fSashDragListener = new Listener(){

                                public void handleEvent(Event event) {
                                    TimeGraphCombo.this.sendTimeViewAlignmentChanged();
                                }
                            };
                            control.removePaintListener((PaintListener)this);
                            control.addListener(13, TimeGraphCombo.this.fSashDragListener);
                            break;
                        }
                        ++n2;
                    }
                }
            }
        });
    }

    private void verticalZoom(boolean zoomIn) {
        Tree tree = this.fTreeViewer.getTree();
        FontData fontData = tree.getFont().getFontData()[0];
        int height = fontData.getHeight() + (zoomIn ? 1 : -1);
        if (height <= 0) {
            return;
        }
        fontData.setHeight(height);
        if (this.fTreeFont != null) {
            this.fTreeFont.dispose();
        }
        this.fTreeFont = new Font((Device)tree.getDisplay(), fontData);
        tree.setFont(this.fTreeFont);
        this.redraw();
        this.update();
        this.fTimeGraphViewer.setHeaderHeight(tree.getHeaderHeight());
        this.fTimeGraphViewer.setItemHeight(this.getItemHeight(tree, true));
        this.alignTreeItems(false);
    }

    private void resetVerticalZoom() {
        Tree tree = this.fTreeViewer.getTree();
        if (this.fTreeFont != null) {
            this.fTreeFont.dispose();
            this.fTreeFont = null;
        }
        tree.setFont(null);
        this.redraw();
        this.update();
        this.fTimeGraphViewer.setHeaderHeight(tree.getHeaderHeight());
        this.fTimeGraphViewer.setItemHeight(this.getItemHeight(tree, true));
        this.alignTreeItems(false);
    }

    private void sendTimeViewAlignmentChanged() {
        TmfSignalManager.dispatchSignal((TmfSignal)new TmfTimeViewAlignmentSignal(this.fSashForm, this.getTimeViewAlignmentInfo()));
    }

    public TreeViewer getTreeViewer() {
        return this.fTreeViewer;
    }

    public @NonNull TimeGraphViewer getTimeGraphViewer() {
        return this.fTimeGraphViewer;
    }

    public ShowFilterDialogAction getShowFilterDialogAction() {
        if (this.fShowFilterDialogAction == null) {
            this.fShowFilterDialogAction = new ShowFilterDialogAction(this.fTimeGraphViewer){

                @Override
                protected void addFilter(ViewerFilter filter) {
                    TimeGraphCombo.this.addFilter(filter);
                }

                @Override
                protected void removeFilter(ViewerFilter filter) {
                    TimeGraphCombo.this.removeFilter(filter);
                }

                @Override
                protected void refresh() {
                    TimeGraphCombo.this.refresh();
                }
            };
        }
        return this.fShowFilterDialogAction;
    }

    public void redraw() {
        this.fTimeGraphViewer.getControl().redraw();
        super.redraw();
    }

    public void update() {
        this.fTimeGraphViewer.getControl().update();
        super.update();
    }

    public void setTreeContentProvider(ITreeContentProvider contentProvider) {
        this.fTreeViewer.setContentProvider((IContentProvider)new TreeContentProviderWrapper(contentProvider));
    }

    public void setTreeLabelProvider(ITableLabelProvider labelProvider) {
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)new TreeLabelProviderWrapper(labelProvider));
    }

    public void setFilterContentProvider(ITreeContentProvider contentProvider) {
        this.getShowFilterDialogAction().getFilterDialog().setContentProvider(contentProvider);
    }

    public void setFilterLabelProvider(ITableLabelProvider labelProvider) {
        this.getShowFilterDialogAction().getFilterDialog().setLabelProvider((IBaseLabelProvider)labelProvider);
    }

    public void addTimeGraphFilterCheckActiveButton(ITimeGraphEntryActiveProvider activeProvider) {
        this.getShowFilterDialogAction().getFilterDialog().addTimeGraphFilterCheckActiveButton(activeProvider);
    }

    public void addTimeGraphFilterUncheckInactiveButton(ITimeGraphEntryActiveProvider inactiveProvider) {
        this.getShowFilterDialogAction().getFilterDialog().addTimeGraphFilterUncheckInactiveButton(inactiveProvider);
    }

    public void setTreeColumns(String[] columnNames) {
        Tree tree = this.fTreeViewer.getTree();
        String[] stringArray = columnNames;
        int n = columnNames.length;
        int n2 = 0;
        while (n2 < n) {
            String columnName = stringArray[n2];
            TreeColumn column = new TreeColumn(tree, 16384);
            column.setMoveable(true);
            column.setText(columnName);
            column.pack();
            ++n2;
        }
    }

    public void setFilterColumns(String[] columnNames) {
        this.getShowFilterDialogAction().getFilterDialog().setColumnNames(columnNames);
    }

    public void setTimeGraphContentProvider(ITimeGraphContentProvider timeGraphContentProvider) {
        this.fTimeGraphViewer.setTimeGraphContentProvider(timeGraphContentProvider);
    }

    public void setTimeGraphProvider(ITimeGraphPresentationProvider timeGraphProvider) {
        this.fTimeGraphViewer.setTimeGraphProvider(timeGraphProvider);
    }

    public void setInput(Object input) {
        this.fInhibitTreeSelection = true;
        this.fTreeViewer.setInput(input);
        for (SelectionListenerWrapper listenerWrapper : this.fSelectionListenerMap.values()) {
            listenerWrapper.selection = null;
        }
        this.fInhibitTreeSelection = false;
        if (this.fScrollBarsInTreeWorkaround) {
            this.fTreeViewer.getTree().getVerticalBar().setEnabled(false);
            this.fTreeViewer.getTree().getVerticalBar().setVisible(false);
        }
        this.fTimeGraphViewer.setInput(input);
        this.fTimeGraphViewer.setItemHeight(this.getItemHeight(this.fTreeViewer.getTree(), false));
        this.fVisibleExpandedItems = null;
        this.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (TimeGraphCombo.this.isDisposed()) {
                    return;
                }
                TimeGraphCombo.this.alignTreeItems(true);
            }
        });
    }

    public Object getInput() {
        return this.fTreeViewer.getInput();
    }

    public void setLinks(List<ILinkEvent> links) {
        this.fTimeGraphViewer.setLinks(links);
    }

    public void addFilter(@NonNull ViewerFilter filter) {
        this.fInhibitTreeSelection = true;
        ViewerFilterWrapper wrapper = new ViewerFilterWrapper(filter);
        this.fTreeViewer.addFilter((ViewerFilter)wrapper);
        this.fTimeGraphViewer.addFilter(filter);
        this.fViewerFilterMap.put(filter, wrapper);
        this.alignTreeItems(true);
        this.fInhibitTreeSelection = false;
    }

    public void removeFilter(@NonNull ViewerFilter filter) {
        this.fInhibitTreeSelection = true;
        ViewerFilter wrapper = this.fViewerFilterMap.get(filter);
        this.fTreeViewer.removeFilter(wrapper);
        this.fTimeGraphViewer.removeFilter(filter);
        this.fViewerFilterMap.remove(filter);
        this.alignTreeItems(true);
        this.fInhibitTreeSelection = false;
    }

    public @NonNull ViewerFilter[] getFilters() {
        return this.fTimeGraphViewer.getFilters();
    }

    public void setFilters(@NonNull ViewerFilter[] filters) {
        this.fInhibitTreeSelection = true;
        this.fViewerFilterMap.clear();
        if (filters == null) {
            this.fTreeViewer.resetFilters();
        } else {
            ViewerFilter[] viewerFilterArray = filters;
            int n = filters.length;
            int n2 = 0;
            while (n2 < n) {
                ViewerFilter filter = viewerFilterArray[n2];
                ViewerFilterWrapper wrapper = new ViewerFilterWrapper(filter);
                this.fViewerFilterMap.put(filter, wrapper);
                ++n2;
            }
            ViewerFilter[] wrappers = (ViewerFilter[])Iterables.toArray(this.fViewerFilterMap.values(), ViewerFilter.class);
            this.fTreeViewer.setFilters(wrappers);
        }
        this.fTimeGraphViewer.setFilters(filters);
        this.alignTreeItems(true);
        this.fInhibitTreeSelection = false;
    }

    public void refresh() {
        this.fInhibitTreeSelection = true;
        Tree tree = this.fTreeViewer.getTree();
        try {
            tree.setRedraw(false);
            this.fTreeViewer.refresh();
        }
        finally {
            tree.setRedraw(true);
        }
        this.fTimeGraphViewer.refresh();
        this.alignTreeItems(true);
        this.fInhibitTreeSelection = false;
    }

    public void addSelectionListener(ITimeGraphSelectionListener listener) {
        SelectionListenerWrapper listenerWrapper = new SelectionListenerWrapper(listener);
        this.fTreeViewer.addSelectionChangedListener((ISelectionChangedListener)listenerWrapper);
        this.fSelectionListenerMap.put(listener, listenerWrapper);
        this.fTimeGraphViewer.addSelectionListener(listenerWrapper);
    }

    public void removeSelectionListener(ITimeGraphSelectionListener listener) {
        SelectionListenerWrapper listenerWrapper = this.fSelectionListenerMap.remove(listener);
        this.fTreeViewer.removeSelectionChangedListener((ISelectionChangedListener)listenerWrapper);
        this.fTimeGraphViewer.removeSelectionListener(listenerWrapper);
    }

    public void setSelection(ITimeGraphEntry selection) {
        this.fTimeGraphViewer.setSelection(selection);
        this.setSelectionInTree(selection);
    }

    public void selectAndReveal(@NonNull ITimeGraphEntry selection) {
        this.fTimeGraphViewer.selectAndReveal(selection);
        this.setSelectionInTree(selection);
    }

    private void setSelectionInTree(ITimeGraphEntry selection) {
        this.fInhibitTreeSelection = true;
        if (selection != null) {
            StructuredSelection structuredSelection = new StructuredSelection((Object)selection);
            this.fTreeViewer.setSelection((ISelection)structuredSelection);
        } else {
            this.fTreeViewer.setSelection((ISelection)new StructuredSelection());
        }
        this.fInhibitTreeSelection = false;
        this.alignTreeItems(false);
    }

    public void setAutoExpandLevel(int level) {
        this.fTimeGraphViewer.setAutoExpandLevel(level);
        if (level <= 0) {
            this.fTreeViewer.setAutoExpandLevel(level);
        } else {
            this.fTreeViewer.setAutoExpandLevel(level + 1);
        }
    }

    public int getAutoExpandLevel() {
        return this.fTimeGraphViewer.getAutoExpandLevel();
    }

    public boolean getExpandedState(ITimeGraphEntry entry) {
        return this.fTimeGraphViewer.getExpandedState(entry);
    }

    public void setExpandedState(ITimeGraphEntry entry, boolean expanded) {
        this.fTimeGraphViewer.setExpandedState(entry, expanded);
        this.fTreeViewer.setExpandedState((Object)entry, expanded);
        this.alignTreeItems(true);
    }

    public void collapseAll() {
        this.fTimeGraphViewer.collapseAll();
        this.fTreeViewer.collapseAll();
        this.alignTreeItems(true);
    }

    public void expandAll() {
        this.fTimeGraphViewer.expandAll();
        this.fTreeViewer.expandAll();
        this.alignTreeItems(true);
    }

    private List<TreeItem> getVisibleExpandedItems(Tree tree, boolean refresh) {
        if (this.fVisibleExpandedItems == null || refresh) {
            ArrayList<TreeItem> visibleExpandedItems = new ArrayList<TreeItem>();
            this.addVisibleExpandedItems(visibleExpandedItems, tree.getItems());
            this.fVisibleExpandedItems = visibleExpandedItems;
        }
        return this.fVisibleExpandedItems;
    }

    private void addVisibleExpandedItems(List<TreeItem> visibleExpandedItems, TreeItem[] items) {
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            Object data = item.getData();
            if (data == FILLER) break;
            visibleExpandedItems.add(item);
            boolean expandedState = this.fTimeGraphViewer.getExpandedState((ITimeGraphEntry)data);
            if (item.getExpanded() != expandedState) {
                this.fTreeViewer.setExpandedState(data, expandedState);
            }
            if (expandedState) {
                this.addVisibleExpandedItems(visibleExpandedItems, item.getItems());
            }
            ++n2;
        }
    }

    private int getItemHeight(final Tree tree, boolean force) {
        if (this.fLinuxItemHeight >= 0 && System.getProperty("os.name").contains("Linux")) {
            if (this.fLinuxItemHeight != 0 && !force) {
                return this.fLinuxItemHeight;
            }
            if (this.getVisibleExpandedItems(tree, true).size() > 1) {
                PaintListener paintListener = new PaintListener(){

                    public void paintControl(PaintEvent e) {
                        List treeItems = TimeGraphCombo.this.getVisibleExpandedItems(tree, true);
                        if (treeItems.size() < 2) {
                            return;
                        }
                        TreeItem treeItem0 = (TreeItem)treeItems.get(0);
                        TreeItem treeItem1 = (TreeItem)treeItems.get(1);
                        tree.removePaintListener((PaintListener)this);
                        int y0 = treeItem0.getBounds().y;
                        int y1 = treeItem1.getBounds().y;
                        int itemHeight = y1 - y0;
                        if (itemHeight > 0) {
                            TimeGraphCombo.this.fLinuxItemHeight = itemHeight;
                            TimeGraphCombo.this.fTimeGraphViewer.setItemHeight(itemHeight);
                        }
                    }
                };
                tree.addPaintListener(paintListener);
            }
        } else {
            this.fLinuxItemHeight = -1;
        }
        return tree.getItemHeight();
    }

    private void alignTreeItems(boolean refreshExpandedItems) {
        final Tree tree = this.fTreeViewer.getTree();
        List<TreeItem> treeItems = this.getVisibleExpandedItems(tree, refreshExpandedItems);
        int topIndex = this.fTimeGraphViewer.getTopIndex();
        if (topIndex >= treeItems.size()) {
            return;
        }
        TreeItem item = treeItems.get(topIndex);
        tree.setTopItem(item);
        tree.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                tree.removePaintListener((PaintListener)this);
                TimeGraphCombo.this.doAlignTreeItems();
                TimeGraphCombo.this.redraw();
                if (SWT.getPlatform().equals("gtk")) {
                    tree.getDisplay().asyncExec(() -> {
                        TreeItem topItem = tree.getTopItem();
                        if (!tree.isDisposed() && topItem != null && !topItem.isDisposed()) {
                            tree.setTopItem(topItem);
                        }
                    });
                }
            }
        });
        tree.redraw();
    }

    private void doAlignTreeItems() {
        Tree tree = this.fTreeViewer.getTree();
        List<TreeItem> treeItems = this.getVisibleExpandedItems(tree, false);
        int topIndex = this.fTimeGraphViewer.getTopIndex();
        if (topIndex >= treeItems.size()) {
            return;
        }
        TreeItem item = treeItems.get(topIndex);
        TreeItem fillerItem = null;
        TreeItem[] treeItemArray = this.fTreeViewer.getTree().getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem treeItem = treeItemArray[n2];
            if (treeItem.getData() == FILLER) {
                fillerItem = treeItem;
                break;
            }
            ++n2;
        }
        int treeHeight = this.fTreeViewer.getTree().getBounds().height;
        int index = topIndex;
        Rectangle bounds = item.getBounds();
        while (index < treeItems.size()) {
            if (bounds.y > treeHeight) break;
            TreeItem nextItem = index + 1 == treeItems.size() ? fillerItem : treeItems.get(index + 1);
            Rectangle nextBounds = this.alignTreeItem(item, bounds, nextItem);
            ++index;
            item = nextItem;
            bounds = nextBounds;
        }
        this.fTimeGraphViewer.setTopIndex(topIndex);
        if (this.fTimeGraphViewer.getTopIndex() != topIndex) {
            this.alignTreeItems(false);
        }
    }

    private Rectangle alignTreeItem(TreeItem item, Rectangle bounds, TreeItem nextItem) {
        Rectangle nextBounds = nextItem.getBounds();
        Integer itemHeight = nextBounds.y - bounds.y;
        if (itemHeight > 0) {
            ITimeGraphEntry entry = (ITimeGraphEntry)item.getData();
            this.fTimeGraphViewer.getTimeGraphControl().setItemHeight(entry, itemHeight);
        }
        return nextBounds;
    }

    public TmfTimeViewAlignmentInfo getTimeViewAlignmentInfo() {
        Point location = this.fSashForm.toDisplay(0, 0);
        int timeAxisOffset = this.fTreeViewer.getControl().getSize().x + this.fSashForm.getSashWidth();
        return new TmfTimeViewAlignmentInfo(this.fSashForm.getShell(), location, timeAxisOffset);
    }

    public int getAvailableWidth(int requestedOffset) {
        int vBarWidth = this.fTimeGraphViewer.getVerticalBar() != null && this.fTimeGraphViewer.getVerticalBar().isVisible() ? this.fTimeGraphViewer.getVerticalBar().getSize().x : 0;
        int totalWidth = this.fSashForm.getBounds().width;
        return Math.min(totalWidth, Math.max(0, totalWidth - requestedOffset - vBarWidth));
    }

    public void performAlign(int offset, int width) {
        int total = this.fSashForm.getBounds().width;
        int timeAxisOffset = Math.min(offset, total);
        int width1 = Math.max(0, timeAxisOffset - this.fSashForm.getSashWidth());
        int width2 = total - timeAxisOffset;
        if (width1 >= 0 && width2 > 0 || width1 > 0 && width2 >= 0) {
            this.fSashForm.setWeights(new int[]{width1, width2});
            this.fSashForm.layout();
        }
        Composite composite = this.fTimeGraphViewer.getTimeAlignedComposite();
        GridLayout layout = (GridLayout)composite.getLayout();
        int timeBasedControlsWidth = composite.getSize().x;
        int marginSize = timeBasedControlsWidth - width;
        layout.marginRight = Math.max(0, marginSize);
        composite.layout();
    }

    private class SelectionListenerWrapper
    implements ISelectionChangedListener,
    ITimeGraphSelectionListener {
        private final ITimeGraphSelectionListener listener;
        private ITimeGraphEntry selection = null;

        public SelectionListenerWrapper(ITimeGraphSelectionListener listener) {
            this.listener = listener;
        }

        public void selectionChanged(SelectionChangedEvent event) {
            ITimeGraphEntry entry;
            if (TimeGraphCombo.this.fInhibitTreeSelection) {
                return;
            }
            Object element = ((IStructuredSelection)event.getSelection()).getFirstElement();
            if (element instanceof ITimeGraphEntry && (entry = (ITimeGraphEntry)element) != this.selection) {
                this.selection = entry;
                this.listener.selectionChanged(new TimeGraphSelectionEvent(event.getSource(), this.selection));
            }
        }

        @Override
        public void selectionChanged(TimeGraphSelectionEvent event) {
            ITimeGraphEntry entry = event.getSelection();
            if (entry != this.selection) {
                this.selection = entry;
                this.listener.selectionChanged(new TimeGraphSelectionEvent(event.getSource(), this.selection));
            }
        }
    }

    private class TimeGraphViewerExtension
    extends TimeGraphViewer {
        private TimeGraphViewerExtension(Composite parent, int style, Tree tree) {
            super(parent, style);
            this.setItemHeight(TimeGraphCombo.this.getItemHeight(tree, true));
            this.setHeaderHeight(tree.getHeaderHeight());
            this.setBorderWidth(tree.getBorderWidth());
            this.setNameWidthPref(0);
        }

        @Override
        public ShowFilterDialogAction getShowFilterDialogAction() {
            return TimeGraphCombo.this.getShowFilterDialogAction();
        }

        @Override
        protected TimeGraphControl createTimeGraphControl(Composite composite, TimeGraphColorScheme colors) {
            return new TimeGraphControl(composite, colors){

                @Override
                public void verticalZoom(boolean zoomIn) {
                    TimeGraphCombo.this.verticalZoom(zoomIn);
                }

                @Override
                public void resetVerticalZoom() {
                    TimeGraphCombo.this.resetVerticalZoom();
                }

                @Override
                public void setElementPosition(ITimeGraphEntry entry, int y) {
                    this.getDisplay().asyncExec(() -> {
                        if (this.isDisposed()) {
                            return;
                        }
                        super.setElementPosition(entry, y);
                        TimeGraphCombo.this.alignTreeItems(false);
                    });
                }
            };
        }

        @Override
        protected TimeGraphMarkerAxis createTimeGraphMarkerAxis(Composite parent, @NonNull TimeGraphColorScheme colorScheme, @NonNull ITimeDataProvider timeProvider) {
            final TimeGraphMarkerAxisExtension timeGraphMarkerAxis = new TimeGraphMarkerAxisExtension(parent, colorScheme, timeProvider);
            final Tree tree = TimeGraphCombo.this.fTreeViewer.getTree();
            tree.addPaintListener(e -> {
                Rectangle bounds = timeGraphMarkerAxis.getAxisBounds();
                e.gc.setBackground(timeGraphMarkerAxis.getBackground());
                timeGraphMarkerAxis.drawMarkerAxis(bounds, bounds.width, e.gc);
            });
            tree.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    Rectangle bounds = timeGraphMarkerAxis.getAxisBounds();
                    if (bounds.contains(e.x, e.y)) {
                        timeGraphMarkerAxis.mouseDown(e, bounds, bounds.width);
                    }
                }
            });
            tree.getHorizontalBar().addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    tree.redraw();
                }
            });
            return timeGraphMarkerAxis;
        }

        private class TimeGraphMarkerAxisExtension
        extends TimeGraphMarkerAxis {
            private int fMargin;

            public TimeGraphMarkerAxisExtension(@NonNull Composite parent, @NonNull TimeGraphColorScheme colorScheme, ITimeDataProvider timeProvider) {
                super(parent, colorScheme, timeProvider);
                this.fMargin = 0;
            }

            @Override
            public Point computeSize(int wHint, int hHint, boolean changed) {
                Point size = super.computeSize(wHint, hHint, changed);
                if (size.y > 0) {
                    size.y += this.fMargin;
                }
                return size;
            }

            public void redraw() {
                super.redraw();
                TimeGraphCombo.this.fTreeViewer.getControl().redraw();
            }

            @Override
            protected void drawMarkerAxis(Rectangle bounds, int nameSpace, GC gc) {
                super.drawMarkerAxis(bounds, nameSpace, gc);
            }

            private Rectangle getAxisBounds() {
                Tree tree = TimeGraphCombo.this.fTreeViewer.getTree();
                Rectangle axisBounds = this.getBounds();
                Rectangle treeClientArea = tree.getClientArea();
                if (axisBounds.isEmpty()) {
                    treeClientArea.y += treeClientArea.height;
                    treeClientArea.height = 0;
                    return treeClientArea;
                }
                Composite axisParent = this.getParent();
                Point axisDisplayCoordinates = axisParent.toDisplay(axisBounds.x, axisBounds.y);
                Point axisTreeCoordinates = tree.toControl(axisDisplayCoordinates);
                int height = treeClientArea.y + treeClientArea.height - axisTreeCoordinates.y;
                int margin = Math.max(0, axisBounds.height - height);
                if (this.fMargin != margin) {
                    this.fMargin = margin;
                    this.getParent().layout();
                    this.redraw();
                    axisTreeCoordinates.y -= margin;
                    height += margin;
                }
                return new Rectangle(treeClientArea.x, axisTreeCoordinates.y, treeClientArea.width, height);
            }
        }
    }

    private class TreeContentProviderWrapper
    implements ITreeContentProvider {
        private final ITreeContentProvider contentProvider;

        public TreeContentProviderWrapper(ITreeContentProvider contentProvider) {
            this.contentProvider = contentProvider;
        }

        public void dispose() {
            this.contentProvider.dispose();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.contentProvider.inputChanged(viewer, oldInput, newInput);
        }

        public Object[] getElements(Object inputElement) {
            Object[] elements = this.contentProvider.getElements(inputElement);
            Object[] oElements = Arrays.copyOf(elements, elements.length + TimeGraphCombo.this.fNumFillerRows, Object[].class);
            int i = 0;
            while (i < TimeGraphCombo.this.fNumFillerRows) {
                oElements[elements.length + i] = FILLER;
                ++i;
            }
            return oElements;
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof ITimeGraphEntry) {
                return this.contentProvider.getChildren(parentElement);
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof ITimeGraphEntry) {
                return this.contentProvider.getParent(element);
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof ITimeGraphEntry) {
                return this.contentProvider.hasChildren(element);
            }
            return false;
        }
    }

    private static class TreeLabelProviderWrapper
    implements ITableLabelProvider {
        private final ITableLabelProvider labelProvider;

        public TreeLabelProviderWrapper(ITableLabelProvider labelProvider) {
            this.labelProvider = labelProvider;
        }

        public void addListener(ILabelProviderListener listener) {
            this.labelProvider.addListener(listener);
        }

        public void dispose() {
            this.labelProvider.dispose();
        }

        public boolean isLabelProperty(Object element, String property) {
            if (element instanceof ITimeGraphEntry) {
                return this.labelProvider.isLabelProperty(element, property);
            }
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
            this.labelProvider.removeListener(listener);
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (element instanceof ITimeGraphEntry) {
                return this.labelProvider.getColumnImage(element, columnIndex);
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof ITimeGraphEntry) {
                return this.labelProvider.getColumnText(element, columnIndex);
            }
            return null;
        }
    }

    private static class ViewerFilterWrapper
    extends ViewerFilter {
        private ViewerFilter fWrappedFilter;

        ViewerFilterWrapper(ViewerFilter filter) {
            this.fWrappedFilter = filter;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof ITimeGraphEntry) {
                return this.fWrappedFilter.select(viewer, parentElement, element);
            }
            return true;
        }
    }
}

