{-----------------------------------------------------------------------------
  TPianoPlugin
  
  Author: ZiZii
  Email: webmaster@midipiano.net
  Date: 28-Jun-2006

  The definition of messages please read PianoPluginIntf.pas

  v1.02 (2006-12-16)
    - StartupPlugin() Changed, return WinHandle for Form Handle
-----------------------------------------------------------------------------}

unit PianoPlugin;

interface

uses SysUtils, Messages, Controls, Windows, PianoPluginIntf;

function HostHandle: Cardinal;

procedure InitializePlugin(AppHandle: Cardinal); stdcall;
procedure HeaderPlugin(var Header: PPluginHeader); stdcall;
procedure FreeMemInPlugin(var P: PPluginHeader); stdcall;
procedure StartupPlugin(var WinHandle: Cardinal); stdcall;
procedure StopPlugin; stdcall;

implementation

uses fGuitarTuning;

var
  _HostHandle: Cardinal;

function HostHandle: Cardinal;
begin
  Result := _HostHandle;
end;

procedure HeaderPlugin(var Header: PPluginHeader);
begin
  New(Header);
  Header^.Title := 'Midi Guitar Tuning';
  Header^.Author := 'ZiZii';
  Header^.Version := '1.02';
end;

procedure FreeMemInPlugin(var P: PPluginHeader);
begin
  Dispose(P);
end;

procedure InitializePlugin(AppHandle: Cardinal);
begin
  _HostHandle := AppHandle;
end;

procedure StartupPlugin(var WinHandle: Cardinal);
begin
  WinHandle := 0;
  if not Assigned(frmGuitarPlugin) then
  begin
    frmGuitarPlugin := TfrmGuitarPlugin.Create(nil);
  end;
  WinHandle := frmGuitarPlugin.Handle;
  frmGuitarPlugin.Show;
end;

procedure StopPlugin;
begin
  FreeAndNil(frmGuitarPlugin);
end;

end.

