{-----------------------------------------------------------------------------
  TPianoPlugin
  
  Author: ZiZii
  Email: webmaster@midipiano.net
  Date: 28-Jun-2006

  The definition of messages please read PianoPluginIntf.pas

  v1.03 (2006-12-18)
    - Create it.
-----------------------------------------------------------------------------}

unit PianoPlugin;

interface

uses SysUtils, Messages, Controls, Windows, PianoPluginIntf;

function HostHandle: Cardinal;

procedure InitializePlugin(AppHandle: Cardinal); stdcall;
procedure HeaderPlugin(var Header: PPluginHeader); stdcall;
procedure FreeMemInPlugin(var P: PPluginHeader); stdcall;
procedure StartupPlugin(var WinHandle: Cardinal); stdcall;
procedure StopPlugin; stdcall;

implementation

uses fMonitor;

var
  _HostHandle: Cardinal;

function HostHandle: Cardinal;
begin
  Result := _HostHandle;
end;

procedure HeaderPlugin(var Header: PPluginHeader);
begin
  New(Header);
  Header^.Title := 'Midi Monitor';
  Header^.Author := 'ZiZii';
  Header^.Version := '1.03';
end;

procedure FreeMemInPlugin(var P: PPluginHeader);
begin
  Dispose(P);
end;

procedure InitializePlugin(AppHandle: Cardinal);
begin
  _HostHandle := AppHandle;
end;

procedure StartupPlugin(var WinHandle: Cardinal);
begin
  WinHandle := 0;
  if not Assigned(frmMonitor) then
  begin
    frmMonitor := TfrmMonitor.Create(nil);
  end;
  WinHandle := frmMonitor.Handle;
  frmMonitor.Show;
end;

procedure StopPlugin;
begin
  FreeAndNil(frmMonitor);
end;

end.
