unit fMonitor;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, StdCtrls, ExtCtrls, Buttons, ActnList, ImgList, Spin,
  PianoPluginIntf;

type
  TfrmMonitor = class(TForm)
    ImageList1: TImageList;
    ActionList1: TActionList;
    actStart: TAction;
    actClear: TAction;
    actClose: TAction;
    actPause: TAction;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    BitBtn3: TBitBtn;
    BitBtn4: TBitBtn;
    Memo1: TMemo;
    CheckBox1: TCheckBox;
    SpinEdit1: TSpinEdit;
    StatusBar1: TStatusBar;
    Timer1: TTimer;
    procedure FormCreate(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure Memo1Change(Sender: TObject);
    procedure actClearExecute(Sender: TObject);
    procedure actPauseExecute(Sender: TObject);
    procedure actStartExecute(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure actCloseExecute(Sender: TObject);
  private
    procedure PluginMessageControl(var Msg: TMessage); message WM_HOST_CONTROL;
    procedure PluginMessageMidi(var Msg: TMessage); message WM_HOST_MIDI;
    procedure PluginMessageText(var Msg: TWMCopyData); message WM_HOST_DATA;
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmMonitor: TfrmMonitor;

implementation

{$R *.dfm}

uses PianoPlugin;

procedure TfrmMonitor.actCloseExecute(Sender: TObject);
begin
  Close;
end;

procedure TfrmMonitor.actPauseExecute(Sender: TObject);
begin
  Tag := 0;
  StatusBar1.Panels[0].Text := 'Paused...';
end;

procedure TfrmMonitor.actStartExecute(Sender: TObject);
begin
  Tag := 1;
  StatusBar1.Panels[0].Text := 'Started...';
end;

procedure TfrmMonitor.actClearExecute(Sender: TObject);
begin
  Memo1.Clear;
  StatusBar1.Panels[0].Text := 'Cleared...';
end;

procedure TfrmMonitor.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  actClear.Execute;
end;

procedure TfrmMonitor.FormCreate(Sender: TObject);
begin
  Application.Handle := HostHandle;
end;

procedure TfrmMonitor.Memo1Change(Sender: TObject);
begin
  StatusBar1.Panels[1].Text := Format('Line: %d', [Memo1.Lines.Count]);

  if CheckBox1.Checked then
  begin
    if Memo1.Lines.Count > SpinEdit1.Value then
    begin
      actClear.Execute;
    end;
  end;
end;

procedure TfrmMonitor.PluginMessageControl(var Msg: TMessage);
begin
{
WParam: Longint;
LParam: Longint;
}
  if Tag = 1 then
    Memo1.Lines.Add(Format('[%s] CONTROL: %.4x, %.4x',
      [FormatDateTime('hh:nn:ss.zzz', Now), Msg.WParam, Msg.LParam]));
end;

procedure TfrmMonitor.PluginMessageMidi(var Msg: TMessage);
begin
{
WParamLo: Word;  MidiEvent
WParamHi: Word;  MakeWord(Data1, Data2)
LParamLo: Word;  0
LParamHi: Word;  Keycolor Index
}
  if Tag = 1 then
    Memo1.Lines.Add(Format('[%s] MIDI: %.2x, %.2x, %.2x',
      [FormatDateTime('hh:nn:ss.zzz', Now), Msg.WParamLo, HiByte(Msg.WParamHi), Byte(Msg.WParamHi)]));
end;

procedure TfrmMonitor.PluginMessageText(var Msg: TWMCopyData);
var
  i: integer;
  s: string;
begin
{
Msg: Cardinal;
From: HWND;
CopyDataStruct: PCopyDataStruct;
  dwDate: 0 = String
  dwData: 1 = Binary
Result: Longint;
}
  if Tag = 1 then
  begin
    case Msg.CopyDataStruct.dwData of
      0: begin
          s := StrPas(Pointer(Msg.CopyDataStruct.lpData));
          Memo1.Lines.Add(Format('%s TEXT: %s', [#9, s]));
        end;
      1: begin
          for i := 0 to Msg.CopyDataStruct.cbData - 1 do
            s := s + Format('%.2x ', [Byte(PChar(Msg.CopyDataStruct.lpData)[i])]);
          Memo1.Lines.Add(Format('%s DATA: %s', [#9, s]));
        end;
    end;
  end;
end;

procedure TfrmMonitor.Timer1Timer(Sender: TObject);
begin
  StatusBar1.Panels[2].Text := TimeToStr(Now);
end;

end.

