{-----------------------------------------------------------------------------
  TPianoPlugin messages definition Unit v1.3

  Author: ZiZii
  Email: webmaster@midipiano.net
  Date: 8-Dec-2006

  v1.3 (2006-12-16)
    - TStartupPluginProc Changed, add WinHandle for win form handle
    - Changed WM_HOST_TEXT to WM_HOST_DATA
-----------------------------------------------------------------------------}

unit PianoPluginIntf;

interface

type
  TPluginHeader = record
    Title: PChar;
    Author: PChar;
    Version: PChar;
  end;
  PPluginHeader = ^TPluginHeader;

  TInitializePluginProc = procedure(AppHandle: Cardinal); stdcall;
  THeaderPluginProc = procedure(var Header: PPluginHeader); stdcall;
  TFreeMemInPluginProc = procedure(var P: PPluginHeader); stdcall;
  TStartupPluginProc = procedure(var WinHandle: Cardinal); stdcall;
  TStopPluginProc = procedure; stdcall;

const
  WM_PLUGIN_BASE = $500;

  WM_HOST_CONTROL = WM_PLUGIN_BASE + $01; // Send control message to plugins
{
WParam: Longint; LParam: Longint;

$101: Volume changed, LParam stored the value
$103: Octave changed, ..
$105: Group changed, ..
$107: Color changed, ..
$109: Repeat changed, ..
$111: Patches changed, ..
$113: AutoSpeed changed, ..

$201: PlayingStatus changed
$203: PlayingTime changed, this is only for progress changed
$205: PlayingSpeed changed
}

  WM_HOST_MIDI = WM_PLUGIN_BASE + $02; // Send midi event to plugins
{
WParamLo: Word;  MidiEvent
WParamHi: Word;  MakeWord(Data1, Data2)
LParamLo: Word;  0 = Short, 1 = SysEx
LParamHi: Word;  Keycolor Index
}

  WM_HOST_DATA = WM_PLUGIN_BASE + $03; // Send data to plugins
{
Msg: Cardinal;
From: HWND;
CopyDataStruct: PCopyDataStruct;
  dwDate: 0 = String
  dwData: 1 = Binary
Result: Longint;
}

  WM_PLUGIN_CONTROL = WM_PLUGIN_BASE + $11; // Get and Set Control status
{
WParam: Longint; LParam: Longint;

$0: GetVersion

$101: GetVolume
$102: SetVolume, 0..65535
$103: GetOctave
$104: SetOctave, 0..6
$105: GetGroup
$106: SetGroup, 0..3 -> 5-8 * 12 PianoKeys
$107: GetColor
$108: SetColor, 0..3, pcBlack=0, pcBlue=1, pcRed=2, pcGreen=3
$109: GetRepeat
$110: SetRepeat, 0..1
$111: GetPatches
$112: SetPatches, 0..127
$113: GetAutoSpeed
$114: SetAutoSpeed, 0..1

$201: GetPlayingStatus
$202: SetPlayingStatus, stPlaying=0, stRecording=1, stPaused=2, stStop=3
$203: GetPlayingTime
$204: SetPlayingTime, Integer
$205: GetPlayingSpeed
$206: SetPlayingSpeed,  30..240
}

  WM_PLUGIN_MIDI = WM_PLUGIN_BASE + $12; // Send MidiEvent, Only for Short
{
WParamLo: Word;  MidiEvent
WParamHi: Word;  LoByte -> Data1, HiByte -> Data2
LParamLo: Word;  Keyboard Display: Boolean
LParamHi: Word;  Keycolor Index: $FFFF = not assigned
}
  WM_PLUGIN_HIGH = $600;

implementation

end.

