VERSION 2.00
Begin Form VBSYXSEN 
   BackColor       =   &H00C0C0C0&
   Caption         =   "VB SYSEX Send SYSEX"
   ClientHeight    =   750
   ClientLeft      =   1815
   ClientTop       =   3000
   ClientWidth     =   5160
   Height          =   1155
   Icon            =   VBSYXSEN.FRX:0000
   Left            =   1755
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   ScaleHeight     =   750
   ScaleWidth      =   5160
   Top             =   2655
   Width           =   5280
   Begin MIDI Midi1 
      BuildNum        =   7
      Height          =   420
      InDevCount      =   2
      InDevice        =   0
      InDevNames      =   "Voyetra Super Sapi FM Driver|MPU-401 In"
      Left            =   0
      OutDevCount     =   2
      OutDevice       =   0
      OutDevNames     =   "Voyetra Super Sapi FM Driver|MPU-401 Out"
      Output          =   ""
      Top             =   0
      Width           =   420
   End
   Begin CommandButton Command3 
      Caption         =   "Test Tone"
      Height          =   495
      Left            =   3960
      TabIndex        =   3
      Top             =   120
      Width           =   1095
   End
   Begin CommandButton Command2 
      Caption         =   "Send Sysex"
      Default         =   -1  'True
      Height          =   495
      Left            =   1440
      TabIndex        =   1
      Top             =   120
      Width           =   1215
   End
   Begin CommandButton Exit 
      Caption         =   "Exit"
      Height          =   495
      Left            =   2760
      TabIndex        =   2
      Top             =   120
      Width           =   1095
   End
   Begin CommandButton Command1 
      Caption         =   "Output Port"
      Height          =   495
      Left            =   120
      TabIndex        =   0
      Top             =   120
      Width           =   1215
   End
End
' Old style calls from Grossman
' Declare Function midiOutGetNumDevs% Lib "MMSYSTEM.DLL" ()
' Declare Function midiOutGetDevCaps% Lib "MMSYSTEM.DLL" (ByVal uDeviceID%, lpCaps As MIDIOUTCAPS, ByVal uSize%)
Declare Function midiOutGetNumDevs Lib "MMSYSTEM" () As Integer
Declare Function midiOutGetDevCaps Lib "MMSYSTEM" (ByVal wDeviceID As Integer, lpCaps As MIDIOUTCAPS, ByVal uSize As Integer) As Integer
Declare Function midiOutOpen Lib "MMSYSTEM" (hMidiOut As Integer, ByVal DeviceID As Integer, ByVal dwCallback As Long, ByVal dwInstance As Long, ByVal dwFlags As Long) As Integer
Declare Function midiOutShortMsg Lib "MMSYSTEM" (ByVal hMidiOut As Integer, ByVal MidiMessage As Long) As Integer
Declare Function midiOutClose Lib "MMSYSTEM" (ByVal hMidiOut As Integer) As Integer
Declare Function midiOutPrepareHeader Lib "MMSYSTEM" (ByVal hMidiOut As Integer, lphMidiOut As MIDIHDR, ByVal uSize As Integer) As Integer
Declare Function midiOutUnprepareHeader Lib "MMSYSTEM" (ByVal hMidiOut As Integer, lphMidiOut As MIDIHDR, ByVal uSize As Integer) As Integer
Declare Function midiOutLongMsg Lib "MMSYSTEM" (ByVal hMidiOut As Integer, lphMidiOut As MIDIHDR, ByVal uSize As Integer) As Integer
Declare Function midiOutGetErrorText Lib "MMSYSTEM" (ByVal uError As Integer, ByVal lpText As String, ByVal uSize As Integer) As Integer

Sub Command1_Click ()
    VBSYXMID.Show 1
End Sub

Sub Command2_Click ()
    SYXSend
End Sub

Sub Command3_Click ()
    Dim rc As Integer, tm
    If VBSYXMID.Text.Text <> "N" Then
        mDev = (Val(VBSYXMID.Text.Text)) - 1
        rc = midiOutOpen(hMidi, mDev, 0&, 0&, 0&)
        If rc <> 0 Then
            Call MidiErr("Open", rc)
            Exit Sub
        End If
        rc = midiOutShortMsg(hMidi, &H7F3C90) ' middle c note on velocity 127
        tm = Timer
        For zz = 1 To 32760
            If tm + 1 < Timer Then Exit For
        Next
        rc = midiOutShortMsg(hMidi, &H7F3C80) ' middle c note off velocity 127
        LongMidiMessage (outSYX) ' this doesn't work!
        rc = midiOutClose(hMidi)
        If rc <> 0 Then
            Call MidiErr("Close", rc)
        End If
    End If
End Sub

Sub Exit_Click ()
    End
End Sub

Sub Form_Load ()
    Dim zz As Integer
    Dim OutCaps As MIDIOUTCAPS
    Midi1.OutDevCount = midiOutGetNumDevs()
    VBSYXMID.List1.List(0) = "Device not enabled"
    For zz = 0 To Midi1.OutDevCount - 1            ' Midi Mapper = -1
        vntRet = midiOutGetDevCaps(zz, OutCaps, Len(OutCaps))
        If vntRet <> 0 Then
            MsgBox "midiOutGetDevCaps Error: " & vntRet
            Exit For
        End If
        VBSYXMID.List1.List(zz + 1) = OutCaps.szPname
    Next zz
    VBSYXMID.Show 1
    OpenSYX
End Sub

Sub LongMidiMessage (InString As String)
    Dim mHdr As MIDIHDR
    Dim rc As Integer
    Dim Length As Integer
    Dim Checks As Integer
    Length = Len(InString)
    mHdr.lpData = InString
    mHdr.dwBufferLength = Length
    mHdr.dwBytesRecorded = Length
    mHdr.dwUser = 0
    mHdr.dwFlags = 0
    rc = midiOutPrepareHeader(hMidi, mHdr, Len(mHdr))
    If rc <> 0 Then
        MsgBox "Prepare rc = " & rc
        Exit Sub
    End If
    ' send long message - this doesn't work - AAARGH ...
    rc = midiOutLongMsg(hMidi, mHdr, Len(mHdr))
    If rc <> 0 Then
        MsgBox "Send Long Message rc= " & rc
        Exit Sub
    End If
    rc = midiOutUnprepareHeader(hMidi, mHdr, Len(mHdr))
    If rc <> 0 Then
        MsgBox "Unprepare rc= " & rc
        Exit Sub
    End If
End Sub

Sub MidiErr (mOpt As String, rc As Integer)
    Dim msgText As String * 132
    vntRet = midiOutGetErrorText(rc, msgText, 128)
    MsgBox "Operation: " & mOpt & Chr(13) & Chr(10) & msgText
End Sub

Sub OpenSYX ()
    Dim syx As String * 210
    Fname = "E:\vb\midi\midi1\ok.syx"
    ' Fname = "E:\vb\midi\midi1\gsreset.syx"
    Fnum = FreeFile ' Determine file number.
    Open Fname For Binary Access Read As Fnum   ' Open file.
    syxlen = LOF(Fnum) ' Get number of bytes in file
    If syxlen > 200 Then
        Response = MsgBox("Sorry, I don't handle SYSEX files greater than 200 bytes in length. You wouldn't want to decode them anyway!", 16, "File too large!")
        Exit Sub
    End If
    Get Fnum, 1, syx ' read as many bytes as we can into syx string
    Close   ' Close all Files
    outSYX = Left$(syx, syxlen)
End Sub

Sub SYXSend ()
    Midi1.OutDevice = Val(VBSYXMID.Text.Text) ' MIDI Open
    If Midi1.OutDevice = 0 Then Exit Sub
    ' This works OK
    Midi1.Output = outSYX ' output SYSEX
    Midi1.OutDevice = 0   ' MIDI Close
End Sub

