' MIDI output device capabilities structure
Type MIDIOUTCAPS
    wMid As Integer                ' Manufacturer ID
    wPid As Integer                ' Product ID
    vDriverVersion As Integer      ' Driver version
    szPname As String * 32         ' Product name (NULL terminated string)
    wTechnology As Integer         ' Device type
    wVoices As Integer             ' n. of voices (internal synth only)
    wNotes As Integer              ' max n. of notes (internal synth only)
    wChannelMask As Integer        ' n. of Midi channels (internal synth only)
    dwSupport As Long              ' Supported extra controllers (volume, etc)
End Type
'return value from API Functions, handles etc
Declare Function mciSendString Lib "mmsystem" (ByVal lpstrCommand As String, ByVal lpstrReturnString As String, ByVal uReturnLength As Integer, ByVal hWndCallback As Integer) As Long
Declare Function mciGetErrorString Lib "mmsystem" (ByVal wError As Long, ByVal lpstrBuffer As String, ByVal uLength As Integer) As Integer
Declare Function midiOutGetNumDevs Lib "MMSYSTEM" () As Integer
Declare Function midiOutGetDevCaps Lib "MMSYSTEM" (ByVal wDeviceID As Integer, lpCaps As MIDIOUTCAPS, ByVal uSize As Integer) As Integer
Declare Function GetPrivateProfileString Lib "Kernel" (ByVal lpApplicationName As String, ByVal lpKeyName As Any, ByVal lpDefault As String, ByVal lpReturnedString As String, ByVal nSize As Integer, ByVal lpFilename As String) As Integer
Declare Function WritePrivateProfileString Lib "Kernel" (ByVal lpApplicationName As String, ByVal lpKeyName As Any, ByVal lpString As Any, ByVal lplFileName As String) As Integer
' Variables
Global vntRet As Variant, fileidx As Integer, midistr As String, waitamt As Long
Global outport As String, portout As String, outmidi As String
Global portflag As Integer, midiname As String, midilen As Long
Global sysexport As Integer, midiport As Integer, midititle As String
Global retstr As String * 200, savestr As String

Global Const INI_FILENAME = "VBSYX.INI"
Global Const APP_NAME = "Visual Basic SYSEX Decode Program"

Sub FFRew (ffopt As Integer)
    Dim midilen As Long, rc As Integer, seekamt As String, lrc As Long
    
    rc = mciSendString("status mcidev length", retstr, 200, 0)
    If rc = 263 Then Exit Sub ' mcidev is not open yet
    midilen = Val(retstr)
    rc = mciSendString("status mcidev position", retstr, 200, 0)
    lrc = Val(retstr) / 1000
    If ffopt = 0 Then lrc = 1000 * (lrc + 30) Else lrc = 1000 * (lrc - 30)
    If lrc > midilen Then lrc = midilen - 5000
    If lrc < 0 Then lrc = 0
    seekamt = Str$(lrc)
    rc = mciSendString("seek mcidev to " + seekamt, retstr, 200, 0)
    If rc <> 0 Then
        Call mciMsg("Fast Forward/Rewind", rc)
        Exit Sub
    End If
End Sub

Function hexListToString (ByVal sHexList As String) As String
    Dim sRetString As String, sThisByte As Integer
    Dim nStartPos As Integer, nSpacePos As Integer

    nStartPos = 1
    sRetString = ""
    Do While nStartPos < Len(sHexList)
        nSpacePos = InStr(nStartPos, sHexList, " ")
        sThisByte = Val("&H" + Mid$(sHexList, nStartPos, 2))
        sRetString = sRetString + Chr$(sThisByte)
        Do While Mid$(sHexList, nSpacePos + 1, 1) = " "
            nSpacePos = nSpacePos + 1
        Loop
        If nSpacePos = 0 Then
            Exit Do
        Else
            nStartPos = nSpacePos + 1
        End If
    Loop
    hexListToString = sRetString
End Function

Sub mciMsg (mOpt As String, rc As Integer)
    Dim msgText As String * 132
    Dim lrc As Long

    lrc = rc
    lrc = mciGetErrorString(lrc, msgText, 128)
    MsgBox "Operation:" & mOpt & Chr(13) & Chr(10) & msgText
End Sub

Function PlayMidiFile (MidiFileName As String) As Integer
    Dim rc As Integer, x1 As Long, x2 As Long
    Dim Path As String
    Dim ComString As String

    Path = MidiFileName
    If Path = "" Then Path = "C:\windows\canyon.mid"
ReOpenMci:
    ComString = "open " & Path & " type sequencer alias mcidev"
    rc = mciSendString(ComString, "", 0, 0)
    If rc <> 0 Then
        If rc = 289 Then  ' if device in use close and start over
            rc = mciSendString("close mcidev", "", 0, 0)
            GoTo ReOpenMci
        End If
        If rc = 296 Then  ' bad MID file - cannot open it
            rc = mciSendString("close mcidev", "", 0, 0)
            VBMMSYS.Caption = "Error in " + midiname + "!"
            x1 = Timer
            Do ' wait 2 seconds
                Beep
                x2 = Timer
                DoEvents
            Loop Until x2 > x1 + 2
            PlayMidiFile = 1
            Exit Function
        End If
        Call mciMsg("Open", rc)
        PlayMidiFile = 1
        Exit Function
    End If
    rc = mciSendString("set mcidev time format ms", retstr, 200, 0)
    rc = mciSendString("status mcidev length", retstr, 200, 0)
    midilen = Val(retstr) / 1000
    midistr = Str$(midilen \ 60) + ":" + Right$("0" + Trim$(Str$(midilen Mod 60)), 2)
    rc = mciSendString("set mcidev port " + Str$(midiport - 1), retstr, 200, 0)
    If rc <> 0 Then
        Call mciMsg("Set Port", rc)
        PlayMidiFile = 1
        Exit Function
    End If
    rc = mciSendString("play mcidev", "", 0, 0)
    ' rc = mciSendString("play mcidev from 10000 to 20000", "", 0, 0)
    If rc <> 0 Then
        Call mciMsg("Open/Play", rc)
        PlayMidiFile = 1
        Exit Function
    End If
    PlayMidiFile = 0
End Function

Sub PortChange (portopt As Integer)
    Dim nRetcode As Integer, ztr As String

    If portopt = 0 Then
        ztr = "Device not enabled"
        VBSYXMID.Caption = "VB SYSEX Output Devices"
        VBSYXMID.List1.ListIndex = sysexport
    Else
        ztr = "Midi Mapper"
        VBSYXMID.Caption = "VB SYSEX MIDI Devices"
        VBSYXMID.List1.ListIndex = midiport
    End If
    VBSYXMID.List1.List(0) = ztr
    VBSYXMID.Show 1
    If portflag = 0 Then Exit Sub
    If portopt = 0 Then
        sysexport = Val(VBSYXMID.Text.Text)
        outport = VBSYXMID.List1.List(sysexport)
        nRetcode = WritePrivateProfileString(APP_NAME, "Output", outport, INI_FILENAME)
    Else
        midiport = Val(VBSYXMID.Text.Text)
        outmidi = VBSYXMID.List1.List(midiport)
        nRetcode = WritePrivateProfileString(APP_NAME, "OutMIDI", outmidi, INI_FILENAME)
    End If
End Sub

Sub PortSet (portopt As Integer)
    Dim zz As Integer, flag As Integer, ztr As String
    Dim OutCaps As MIDIOUTCAPS
    Dim sDevName As String, nRetcode As Integer
    sDevName = Space(32)
    
    If portopt = 0 Then
        ztr = "Device not enabled"
        nRetcode = GetPrivateProfileString(APP_NAME, "Output", "UserChoice", sDevName, 32, INI_FILENAME)
    Else
        ztr = "Midi Mapper"
        midiport = 0
        nRetcode = GetPrivateProfileString(APP_NAME, "OutMIDI", "UserChoice", sDevName, 32, INI_FILENAME)
    End If
    outport = szTrim(sDevName)
    VBMMSYS.Midi1.OutDevCount = midiOutGetNumDevs()
    VBSYXMID.List1.List(0) = ztr
    For zz = 0 To VBMMSYS.Midi1.OutDevCount - 1 ' Midi Mapper = -1
        vntRet = midiOutGetDevCaps(zz, OutCaps, Len(OutCaps))
        If vntRet <> 0 Then
            MsgBox "midiOutGetDevCaps Error: " & vntRet
            Exit For
        End If
        VBSYXMID.List1.List(zz + 1) = OutCaps.szPname
        If outport = Mid$(OutCaps.szPname, 1, Len(outport)) Then flag = zz + 1
    Next zz
    If flag > 0 Or portopt = 1 Then
        VBSYXMID.Text.Text = Str$(flag)
        VBSYXMID.List1.ListIndex = flag
        If portopt = 0 Then sysexport = flag Else midiport = flag
        VBSYXMID.Cancel.Enabled = True
    Else
        PortChange (portopt)
    End If
End Sub

Sub StopMidiFile ()
    Dim rc As Integer

    rc = mciSendString("stop mcidev", "", 0, 0)
    If rc = 263 Then Exit Sub ' mcidev is not open yet
    If rc <> 0 Then
        Call mciMsg("Stop", rc)
    End If
    rc = mciSendString("seek mcidev to 0", "", 0, 0)
End Sub

Function szTrim (szString As String) As String
    Dim pos As Integer, ln As Integer

    pos = InStr(szString, Chr$(0))
    ln = Len(szString)
    Select Case pos
        Case Is > 1
            szTrim = Trim(Left(szString, pos - 1))
        Case 1
            szTrim = ""
        Case Else
            szTrim = Trim(szString)
    End Select
End Function

