VERSION 2.00
Begin Form VBMMSYS 
   AutoRedraw      =   -1  'True
   BackColor       =   &H00C0C0C0&
   BorderStyle     =   1  'Fixed Single
   Caption         =   "Mike Le Voi's VB MIDI Jukebox"
   ClientHeight    =   1335
   ClientLeft      =   1575
   ClientTop       =   2805
   ClientWidth     =   6150
   ControlBox      =   0   'False
   FontBold        =   0   'False
   FontItalic      =   0   'False
   FontName        =   "MS Sans Serif"
   FontSize        =   8.25
   FontStrikethru  =   0   'False
   FontUnderline   =   0   'False
   Height          =   1740
   Icon            =   VBMMSYS.FRX:0000
   Left            =   1515
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   ScaleHeight     =   1335
   ScaleWidth      =   6150
   Top             =   2460
   Width           =   6270
   Begin CommandButton SYSEX 
      Caption         =   "GS Reset"
      Height          =   255
      Left            =   3720
      TabIndex        =   10
      Top             =   960
      Width           =   1095
   End
   Begin Timer Timer1 
      Interval        =   1000
      Left            =   2280
      Top             =   720
   End
   Begin FileListBox File1 
      Height          =   420
      Left            =   360
      Pattern         =   "*.mid"
      TabIndex        =   9
      Top             =   120
      Visible         =   0   'False
      Width           =   2655
   End
   Begin CommandButton Last 
      Caption         =   "|<<"
      Height          =   495
      Left            =   2520
      TabIndex        =   2
      Top             =   120
      Width           =   1095
   End
   Begin CommandButton Next 
      Caption         =   ">>|"
      Height          =   495
      Left            =   3720
      TabIndex        =   3
      Top             =   120
      Width           =   1095
   End
   Begin MIDI Midi1 
      BuildNum        =   7
      Height          =   420
      InDevCount      =   2
      InDevice        =   0
      InDevNames      =   "Roland MPU-401|Sound Blaster MIDI input (220)"
      Left            =   4680
      OutDevCount     =   2
      OutDevice       =   0
      OutDevNames     =   "Roland MPU-401|Yamaha OPL2/OPL3 Synthesis"
      Output          =   ""
      Top             =   120
      Width           =   420
   End
   Begin CommonDialog CM1 
      CancelError     =   -1  'True
      Left            =   960
      Top             =   720
   End
   Begin CommandButton Port 
      Caption         =   "MIDI"
      Height          =   255
      Left            =   3720
      TabIndex        =   8
      Top             =   720
      Width           =   1095
   End
   Begin CommandButton Exit 
      Caption         =   "Exit"
      Height          =   495
      Left            =   4920
      TabIndex        =   11
      Top             =   720
      Width           =   1095
   End
   Begin CommandButton Seek 
      Caption         =   ">>"
      Height          =   495
      Left            =   1320
      TabIndex        =   1
      Top             =   120
      Width           =   1095
   End
   Begin CommandButton Rewind 
      Caption         =   "<<"
      Height          =   495
      Left            =   120
      TabIndex        =   0
      Top             =   120
      Width           =   1095
   End
   Begin CommandButton Pause 
      Caption         =   "Pause"
      Height          =   495
      Left            =   2520
      TabIndex        =   7
      Top             =   720
      Width           =   1095
   End
   Begin CommandButton Info 
      Caption         =   "Open"
      Height          =   495
      Left            =   4920
      TabIndex        =   4
      Top             =   120
      Width           =   1095
   End
   Begin CommandButton Stop 
      Caption         =   "Stop"
      Height          =   495
      Left            =   120
      TabIndex        =   5
      Top             =   720
      Width           =   1095
   End
   Begin CommandButton Play 
      Caption         =   "Play"
      Height          =   495
      Left            =   1320
      TabIndex        =   6
      Top             =   720
      Width           =   1095
   End
End
Option Explicit

Sub Exit_Click ()
    Dim rc As Integer

    rc = mciSendString("close mcidev", "", 0, 0)
    End
End Sub

Sub Form_Load ()
    PortSet (0)
    PortSet (1)
End Sub

Sub Form_Unload (Cancel As Integer)
    Dim rc As Integer

    rc = mciSendString("close mcidev", "", 0, 0)
End Sub

Function GetPath (filenam As String) As String
    Dim xx As Integer

    For xx = Len(filenam) To 1 Step -1
	If Mid$(filenam, xx, 1) = "\" Then
	    ' MsgBox Str$(xx)
	    Exit For
	End If
    Next xx
    If xx <> 1 Then
	file1.Path = Mid$(filenam, 1, xx)
    Else
	GetPath = file1.Path
    End If
End Function

Sub Info_Click ()
    OpenMid
End Sub

Sub Last_Click ()
    Dim xx As Integer, rst As String
    
    xx = mciSendString("close mcidev", "", 0, 0)
    xx = file1.ListCount
    If xx = 0 Then Exit Sub
    fileidx = fileidx - 1
    If fileidx < 0 Then
	fileidx = 0
	Exit Sub
    End If
    midiname = UCase$(file1.Path + "\" + file1.List(fileidx))
    midititle = midiname
    If Len(midiname) > 26 Then midititle = Mid$(midiname, 1, 3) + "..." + Mid$(midiname, Len(midiname) - 20, 22)
    VBMMSYS.Caption = midititle
    rst = hexListToString("F0 41 10 42 12 40 00 7F 00 41 F7")
    xx = SYXSend(rst)
    Play_Click
End Sub

Sub Next_Click ()
    Dim xx As Integer, rst As String
    
    xx = mciSendString("close mcidev", "", 0, 0)
    xx = file1.ListCount
    If xx = 0 Then Exit Sub
    fileidx = fileidx + 1
    If xx = fileidx Then
	fileidx = xx - 1
	Exit Sub
    End If
    midiname = UCase$(file1.Path + "\" + file1.List(fileidx))
    midititle = midiname
    If Len(midiname) > 26 Then midititle = Mid$(midiname, 1, 3) + "..." + Mid$(midiname, Len(midiname) - 20, 22)
    VBMMSYS.Caption = midititle
    rst = hexListToString("F0 41 10 42 12 40 00 7F 00 41 F7")
    xx = SYXSend(rst)
    Play_Click
End Sub

Sub OpenMid ()
    Dim rc As Integer, rst As String
    On Error GoTo errhandler ' CancelError is True
    
    cm1.Filter = "All Files (*.*)|*.*|MIDI Files (*.mid;*.midi)|*.mid;*.midi"
    cm1.FilterIndex = 2
    cm1.DialogTitle = "Open MIDI File"
    cm1.Action = 1 ' 1 is Open - 2 is Save As
    midiname = cm1.Filename
    file1.Path = GetPath(midiname)
    For rc = 0 To file1.ListCount
	If midiname = UCase$((file1.Path) + "\" + file1.List(rc)) Then
	    fileidx = rc
	    Exit For
	End If
    Next rc
    midititle = midiname
    If Len(midiname) > 26 Then midititle = Mid$(midiname, 1, 3) + "..." + Mid$(midiname, Len(midiname) - 20, 22)
    VBMMSYS.Caption = midititle
    rc = mciSendString("close mcidev", "", 0, 0)
    rst = hexListToString("F0 41 10 42 12 40 00 7F 00 41 F7")
    rc = SYXSend(rst)
    Play_Click
errhandler:
    ' user pressed cancel button
    ' If Err <> 0 Then RunError ("OpenSYX")
    Exit Sub
End Sub

Sub Pause_Click ()
    Dim rc As Integer

    rc = mciSendString("status mcidev mode", retstr, 200, 0)
    If rc = 263 Then Exit Sub ' mcidev is not open yet
    If rc <> 0 Then
	Call mciMsg("Pause", rc)
	Exit Sub
    End If
    If Mid$(retstr, 1, 6) = "paused" Then
	rc = mciSendString("play mcidev", retstr, 200, 0)
	Exit Sub
    End If
    rc = mciSendString("pause mcidev", retstr, 200, 0)
End Sub

Sub Play_Click ()
    Dim rc As Integer
    Dim x1 As Long, x2 As Long

    If midiname = "" Then midiname = App.Path + "\diana.mid"
    rc = mciSendString("status mcidev length", retstr, 200, 0)
    If rc = 263 Then ' mcidev is not open yet
	rc = PlayMidiFile(midiname)
	If rc = 1 Then Next_Click
	Exit Sub
    End If
    rc = mciSendString("play mcidev", retstr, 200, 0)
    If rc <> 0 Then
	Call mciMsg("Play", rc)
    End If
End Sub

Sub Port_Click ()
    Dim rc As Integer
    
    PortChange (1)
    If portflag = 0 Then Exit Sub
    rc = mciSendString("close mcidev", "", 0, 0)
    Play_Click
End Sub

Sub Rewind_Click ()
    FFRew (1)
    Play_Click
End Sub

Sub Seek_Click ()
    FFRew (0)
    Play_Click
End Sub

Sub Stop_Click ()
    StopMidiFile
End Sub

Sub SYSEX_Click ()
    PortChange (0)
End Sub

Function SYXSend (syxstring As String) As Integer
    Midi1.OutDevice = sysexport ' MIDI Open
    If Midi1.OutDevice = 0 Then
	SYXSend = 0
	Exit Function
    End If
    Midi1.Output = syxstring ' output SYSEX
    Midi1.OutDevice = 0   ' MIDI Close
    SYXSend = 1
End Function

Sub Timer1_Timer ()
    Dim rc As Integer, midipos As Long, timestr As String
    
    rc = mciSendString("status mcidev position", retstr, 200, 0)
    If rc = 263 Then Exit Sub ' mcidev is not open yet
    midipos = Val(retstr) / 1000
    timestr = Str$(midipos \ 60) + ":" + Right$("0" + Trim$(Str$(midipos Mod 60)), 2)
    If midipos > 0 Then VBMMSYS.Caption = midititle + " - " + timestr + " of " + midistr
    If midilen = midipos Then ' end of mid file
	midipos = Timer
	If midipos > waitamt + 3 Then
	    Next_Click
	End If
    Else
	waitamt = Timer
    End If
End Sub

