/*

	Various routines to work with Novell delivering mail to novell mail
	DIR and setting extensions.

	John Bradley GST 

 */

/****************************************************************************
*	$Id: novelcli.c 1.2 93/07/16 11:47:16 ROOT_DOS Exp $
*	08 May 93	1.2		GT	Fix warnings.									*
****************************************************************************/

#include <stdio.h>
#include <sys/types.h>
#include <time.h>
#include <sys/timeb.h>
#include <ctype.h>
#include <string.h>  /* for strchr() */
#ifdef	__TURBOC__
#include <dir.h>
#endif
#include "global.h"
#include "cmdparse.h"
#include "commands.h"

#ifdef NOVELL

static int dosernam	__ARGS((int argc,char *argv[],void *p));
static int doext	__ARGS((int argc,char *argv[],void *p));
static int dostart	__ARGS((int argc,char *argv[],void *p));


static struct cmds novellcmds[] = 
{
	"server",		dosernam,	0,	2,	"novell server <server name>",
	"ext",			doext,		0,  2,	"novell ext <mail ext>",
    "start",		dostart,	0,	2,	"novell start <0|1>",
	NULLCHAR,
}
;

#endif

int donovell(int argc,char *argv[],void *p)
{
#ifdef NOVELL
	return subcmd(novellcmds,argc,argv,p);
#else
	printf("Not built for NOVELL ops\n");
	return (-1);
#endif
}

char	novell_server_name[128];
char	novell_mail_ext[4];
unsigned short	novell_start=0;

#ifdef NOVELL

static int dosernam(int argc,char *argv[],void *p)
{
	strcpy(novell_server_name,argv[1]);
	return 0;
}

static int doext(int argc,char *argv[],void *p)
{
	strcpy(novell_mail_ext,argv[1]);
	return 0;
}

static int dostart(int argc,char *argv[],void *p)
{
	return setshort(&novell_start,"Novell start ",argc,argv);
}

#endif
