/****************************************************************************
*	Language 	:	Turbo C 2.0												*
*	Logfile		:	rbsb.h													*
*	Project		:	Comms library.											*
*	Date 		:	25 Jan 90												*
*	Revision 	:	1.1		GT	Originate.									*
*	25 Oct 92	:	1.2		GT	KA9Q mods.									*
*	24 Jan 94	:	1.3		GT	_flush -> _rbsb_flush.						*
*****************************************************************************
*	Purpose		:	Prototypes and externs for rbsb.c.						*
*	$Id: rbsb.h 1.2 94/01/26 13:55:09 ROOT_DOS Exp $
****************************************************************************/

#ifndef	RBSB_H
#define	RBSB_H

/****************************************************************************
*	sndbrk																	*
*	Send break to the modem.												*
****************************************************************************/

void _sendbrk (void);

/****************************************************************************
*	_rdchk																	*
*	Returns nz if something to read from remote.							*
****************************************************************************/

int _rdchk (void);

/****************************************************************************
*	_send																	*
*	Send some data to the remote.											*
****************************************************************************/

int _send (unsigned char *buf, int len);


/****************************************************************************
*	_rbsb_flush																*
*	Flush output.															*
****************************************************************************/

void _rbsb_flush (void);

/****************************************************************************
*	_receive																*
*	Receive some data from the remote.										*
****************************************************************************/

int _receive (unsigned char *buf, int len);

extern unsigned short _crctab[];
extern unsigned long _cr3tab[];
extern int _z_socket;

/*
 * updcrc macro derived from article Copyright (C) 1986 Stephen Satchell. 
 *  NOTE: First srgument must be in range 0 to 255.
 *        Second argument is referenced twice.
 * 
 * Programmers may incorporate any or all code into their programs, 
 * giving proper credit within the source. Publication of the 
 * source routines is permitted so long as proper credit is given 
 * to Stephen Satchell, Satchell Evaluations and Chuck Forsberg, 
 * Omen Technology.
 */

#if	0
#define updcrc(cp, crc) (_crctab[((crc >> 8) & 255)] ^ (crc << 8) ^ cp)
#endif

#define updcrc(cp, crc) (_crctab[(((crc) >> 8) & 255)] ^ ((crc) << 8) ^ (cp))

#if 0
#define UPDC32(b, c) (_cr3tab[((int) c ^ b) & 0xff] ^ ((c >> 8) & 0x00FFFFFFL))
#endif

#define UPDC32(b, c) (_cr3tab[((unsigned) (c) ^ (b)) & 0xff] ^ (((c) >> 8) & 0x00FFFFFFL))

#endif

