/* Socket status display code
 * Copyright 1991 Phil Karn, KA9Q
 */

/****************************************************************************
*	$Id: sockcmd.c 1.2 93/07/16 11:50:44 ROOT_DOS Exp $
*	13 Jul 93	1.2		GT	LZW conditional.								*
****************************************************************************/

#include <stdio.h>
#include "global.h"
#include "mbuf.h"
#include "proc.h"
#include "lzw.h"
#include "usock.h"
#include "socket.h"
#include "ax25.h"
#include "netrom.h"
#include "tcp.h"
#include "udp.h"
#include "commands.h"
#include "config.h"

/* Socket status display command */
int
dosock(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	register struct usock *up;
	int s,i;
	struct sockaddr fsock;
	char *cp;

	if(argc < 2){
		tprintf("S#  Type    PCB      Remote socket         Owner\n");
		for(s=SOCKBASE;s<Nusock+SOCKBASE;s++){
			up = itop(s);
			if(up == NULLUSOCK)
				continue;

			i = sizeof(fsock);
			if(getpeername(s,(char *)&fsock,&i) == 0 && i != 0)
				cp = psocket(&fsock);
			else
				cp = "";

			tprintf("%3d %-8s%-8lx %-22s%-8lx %-10s\n",
			 s,Socktypes[up->type],ptol(up->cb.p),cp,
			 ptol(up->owner),up->owner->name);
		}
		return 0;
	}
	s = atoi(argv[1]);
	if(s < SOCKBASE || s >= Nusock+SOCKBASE){
		tprintf("Number out of range\n");
		return 1;
	}
	up = itop(s);
	if(up == NULLUSOCK){
		tprintf("Socket not in use\n");
		return 0;
	}
	tprintf("%s %lx %s",Socktypes[up->type],ptol(up->cb.p),
	 up->flag == SOCK_ASCII ? "ascii" : "binary");
	if(up->eol[0] != '\0'){
		tprintf(" eol seq:");
		for(i=0;up->eol[i] != '\0' && i<sizeof(up->eol);i++)
			tprintf(" %02x",up->eol[i]);
	}
	tprintf("\n");
	if(up->cb.p == NULL)
		return 0;
	switch(up->type){
	case TYPE_RAW:
	case TYPE_LOCAL_DGRAM:
		tprintf("Inqlen: %d packets\n",socklen(s,0));
		tprintf("Outqlen: %d packets\n",socklen(s,1));
		break;
	case TYPE_LOCAL_STREAM:
		tprintf("Inqlen: %d bytes\n",socklen(s,0));
		tprintf("Outqlen: %d bytes\n",socklen(s,1));
		break;
	case TYPE_TCP:
		st_tcp(up->cb.tcb);
		break;
	case TYPE_UDP:
		st_udp(up->cb.udp,0);
		break;
#ifdef	AX25
	case TYPE_AX25I:
		st_ax25(up->cb.ax25);
		break;
#endif
#ifdef	NETROM
	case TYPE_NETROML4:
		donrdump(up->cb.nr4);
		break;
#endif
	}
#if	LZW
	if(up->zout != NULLLZW)
		tprintf("Compressed %ld bytes.\n",up->zout->cnt);
	if(up->zin != NULLLZW)
		tprintf("Decompressed %ld bytes.\n",up->zin->cnt);
#endif
	return 0;	
}

