/****************************************************************************
*	Language 	:	Turbo C 2.0												*
*	Logfile		:	sz.h													*
*	Project		:	Comms library.											*
*	Date 		:	24 Jan 90												*
*	Revision 	:	1.1		GT	Originate.									*
*	25 Oct 92	:	1.2		GT	KA9Q mods.									*
*****************************************************************************
*	Purpose		:	Prototypes for sz.c.									*
*	$Id: sz.h 1.2 93/02/07 05:14:51 ROOT_DOS Exp $
****************************************************************************/

#ifndef	SZ_H
#define	SZ_H

/****************************************************************************
*	Definitions.															*
****************************************************************************/

#define	LOGFILE		"zmodem.log"

#define PATHLEN		64					/* MesS-DOS maximum					*/
#define OK			0
#define FALSE		0
#define TRUE		1
#define ERROR		(-1)

/* Ward Christensen / CP/M parameters - Don't change these! */

#define ENQ			005
#define CAN			('X' & 037)
#define XOFF		('s' & 037)
#define XON			('q' & 037)
#define SOH			1
#define STX			2
#define EOT			4
#define ACK			6
#define NAK			025
#define CPMEOF		032
#define WANTCRC		0103		/* send C not NAK to get crc not checksum */
#define WANTG		0107		/* Send G not NAK to get nonstop batch xmsn */
#define ZTIMEOUT		(-2)
#define RCDO		(-3)
#define ERRORMAX	5
#define RETRYMAX	10
#define WCEOT		(-10)
#define SECSIZ		128			/* cp/m's Magic Number record size */
#define KSIZE		1024


/****************************************************************************
*	Function prototypes.													*
****************************************************************************/

/****************************************************************************
*	_sendfile																*
*	Send file(s).  Returns 0 if successful.									*
****************************************************************************/

int _sendfile (int s, char protocol, char *options, char *filenames[],
			   void (*reporter) (int type, void *data));

/****************************************************************************
*	_getfile (in rz.c)														*
*	Receives file(s).  Returns 0 if successful.								*
****************************************************************************/

int _getfile (int s, char protocol, char *options, char *filename,
			  void (*reporter) (int type, void *data));

/****************************************************************************
*	_no_carrier																*
*	Tests to see if CD still present, exits if not.							*
****************************************************************************/

void _no_carrier (void);

/****************************************************************************
*	_sendline and _xsendline												*
*	Send a character to remote.												*
****************************************************************************/

void _sendline (int c);

void _xsendline (int c);

/****************************************************************************
*	_flushmo																*
*	Flush the output channel.												*
****************************************************************************/

void _flushmo (void);

/****************************************************************************
*	_stbnb																	*
*	Skip to blank then skip to nonblank.									*
****************************************************************************/

char *_stbnb (char *cp);

/****************************************************************************
*	_vfile																	*
*	Print debugging message.												*
****************************************************************************/

void _vfile (char *f, ...);

/****************************************************************************
*	_say																	*
*	Report something unconditionally.										*
****************************************************************************/

void _say (char *f, ...);

/****************************************************************************
*	_canit																	*
*	Send cancel string to get the other end to shut up.						*
****************************************************************************/

void _canit (void);

/****************************************************************************
*	_zperr_																	*
*	Log an error.															*
****************************************************************************/

void _zperr_ (char *s, ...);

/****************************************************************************
*	_zperr																	*
*	Default progress report function.										*
****************************************************************************/

void _zperr (int type, void *data);

/****************************************************************************
*	_substr																	*
*	Searches for <token> in string <s>.  Returns pointer to token within 	*
*	string if found, NULL otherwise.										*
****************************************************************************/

char *_substr (char *s, char *t);

/****************************************************************************
*	_bttyout																*
*	Local screen character display function.								*
****************************************************************************/
	
void _bttyout (int c);

/****************************************************************************
*	_readline (in rz.c)														*
*	This version of _readline is reasonably well suited for reading many 	*
*	characters (except, currently, for the Regulus version!).  Timeout is	*
*	in tenths of seconds.													*
****************************************************************************/

int _readline (int timeout);

/****************************************************************************
*	Global data.															*
****************************************************************************/

extern int _firstsec;
extern int _sending;
extern jmp_buf _tohere;
extern jmp_buf _nocarrier;
extern unsigned _Baud_z;
extern int _Crcflg;
extern int _errors;
extern int _Lastrx;
extern char _Lzmanag;
extern int _Nozmodem;
extern int _Quiet;
extern int _Verbose;
extern int _Wcsmask;
extern char _zconv;
extern int _Zctlesc;
extern char _zmanag;
extern int _Zmodem;
extern int _Zrwindow;
extern char _ztrans;
extern void (*_do_report) (int type, void *data);
extern int _zperr_handle;

#endif
/* ~. */
