/****************************************************************************
*	tzset.c																	*
*	tzset () and __isDST () replacements for Borland C++ 3.1.				*
*																			*
*	$Id: tzset.c 1.1 93/03/07 17:07:35 ROOT_DOS Exp $
*																			*
*	27 Feb 93	1.1		GT	From BSD ctime.c.								*
*	02 Mar 93	1.2		GT	Fix getenv () problem.							*
*****************************************************************************
*	This file has been modified by Giles Todd.  These modifications are		*
*	Copyright 1993 Giles Todd, 5 Brentnall Close, Warrington, WA5 1XN, UK	*
*	(gt@rundart.demon.co.uk).												*
*																			*
*	Giles Todd's moral rights under the Copyrights, Designs and Patents Act	*
*	are asserted.															*
*																			*
*	See the University of California's copyright notice below for			*
*	conditions of use and limitation of warranty.							*
*****************************************************************************
*	This file may have been modified by DJ Delorie (Jan 1991).  If so,		*
*	these modifications are Copyright (C) 1991 DJ Delorie, 24 Kirsten Ave,	*
*	Rochester NH, 03867-2954, USA.											*
*****************************************************************************
*	Copyright (c) 1987, 1989 Regents of the University of California.		*
*	All rights reserved.													*
*																			*
*	This code is derived from software contributed to Berkeley by			*
*	Arthur David Olson of the National Cancer Institute.					*
*																			*
*	Redistribution and use in source and binary forms are permitted provided*
*	that: (1) source distributions retain this entire copyright notice and	*
*	comment, and (2) distributions including binaries display the following	*
*	acknowledgement:  ``This product includes software developed by the		*
*	University of California, Berkeley and its contributors'' in the		*
*	documentation or other materials provided with the distribution and in	*
*	all advertising materials mentioning features or use of this software.	*
*	Neither the name of the University nor the names of its contributors may*
*	be used to endorse or promote products derived from this software without*
*	specific prior written permission.										*
*	THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED	*
*	WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF	*
*	MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.					*
*****************************************************************************
*																			*
*	The TZ variable has the following syntax:								*
*																			*
*	STD offset [DST [offset] [, rule]]										*
*																			*
*	(Spaces added for clarity.)												*
*																			*
*																			*
*	Only the STD part is required.  If DST is not specified, summer time	*
*	does not apply.  Uppercase and lowercase letters are allowed in the		*
*	designation.  Any characters except a : (colon), digits, , (comma), -	*
*	(minus), + (plus) and ASCII NULL are allowed.  STD denotes the standard	*
*	time zone and DST denotes the summer time zone.							*
*																			*
*	<offset> indicates the value to be added to local time to equal			*
*	Coordinated Universal Time (equivalent to GMT).  The <offset> part		*
*	has the following format:												*
*																			*
*	hh[:mm[:ss]]															*
*																			*
*	The <offset> part following the STD part is required.  If an <offset>	*
*	part does not follow the DST part then summer time is assumed to be one	*
*	hour ahead of standard time.  One or more digits may be used and are	*
*	interpreted as a decimal integer.  The hour must be specified between 0	*
*	and 24 (sic).  The mm (minutes) and ss (seconds) parts are optional.  If*
*	these parts are present, they must be specified between 0 and 59.  If	*
*	the <offset> part is preceded by a - (minus), the time zone is east of	*
*	the Prime Meridian (Greenwich again).  If the <offset> part is not		*
*	preceded by a - (minus) or is preceded by a + (plus), the time zone is	*
*	assumed to be West of the Prime Meridian.								*
*																			*
*	The <rule> part has the following format:								*
*																			*
*	date/time,date/time														*
*																			*
*	The first date part describes the date when the change from standard to	*
*	summer time occurs.  The second date part describes when the change from*
*	summer to standard time occurs.  Each time part describes, in current	*
*	local time, when the change is made.									*
*																			*
*	The date part has the following format:									*
*																			*
*	J<n>																	*
*																			*
*	or																		*
*																			*
*	M<m>.<n>.<d>															*
*																			*
*	J<n> indicates a Julian date.  <n> is the day of the year and has a		*
*	value from 1 to 365.  Leap days are not counted.						*
*																			*
*	M<m>.<n>.<d> describes a month, a week and a day.  <m> is the month		*
*	(1..12), <n> is the week (1..5) and <d> is the day (0..6).  Week one is	*
*	the first week in the month when day <d> occurs.  Day zero is Sunday.	*
*																			*
*	The time part has the same format as the <offset> part described above	*
*	except that it can have no leading sign (- or +).  The default value of	*
*	the time part is 02:00.													*
*																			*
*	For example, in the UK in 1993 the correct setting would be:			*
*																			*
*	TZ=GMT0BST1,M3.4.0/02:00,M10.4.0/02:00									*
*																			*
*	This extended syntax for TZ may cause some MS-DOS applications to work	*
*	incorrectly.  If this occurs, the extended syntax may be used with the	*
*	GTZ environment variable.  If the GTZ variable is present, it will take	*
*	precedence over the TZ variable for the purposes of these routines.		*
*																			*
****************************************************************************/


#if defined(LIBC_SCCS) && !defined(lint)
static char sccsid[] = "@(#)ctime.c	5.23 (Berkeley) 6/22/90";
#endif						 /* LIBC_SCCS and not lint */

/*
** Leap second handling from Bradley White (bww@k.gp.cs.cmu.edu).
** POSIX-style TZ environment variable handling from Guy Harr
** (guy@auspex.com).
*/

/*LINTLIBRARY*/

#include <fcntl.h>
#include <time.h>
#include <string.h>
#include <ctype.h>
#include <stdio.h>
#include "tzfile.h"

#if defined (__STDC__) || defined (__BORLANDC__)
#include <stdlib.h>

#define P(s)		s
#define alloc_size_t	size_t
#define qsort_size_t	size_t
#define fread_size_t	size_t
#define fwrite_size_t	size_t

#else						 /* !defined __STDC__ */

#define P(s)		()
#define const
#define volatile

typedef char *genericptr_t;
typedef unsigned alloc_size_t;
typedef int qsort_size_t;
typedef int fread_size_t;
typedef int fwrite_size_t;

extern char *calloc ();
extern char *malloc ();
extern char *realloc ();
extern char *getenv ();

#endif						 /* !defined __STDC__ */


#define	USG_COMPAT
#undef	ALTZONE
#undef	ALL_STATE

#define ACCESS_MODE		O_RDONLY
#define OPEN_MODE		O_RDONLY

#ifndef WILDABBR
/*
** Someone might make incorrect use of a time zone abbreviation:
**	1.	They might reference tzname[0] before calling tzset (explicitly
**	 	or implicitly).
**	2.	They might reference tzname[1] before calling tzset (explicitly
**	 	or implicitly).
**	3.	They might reference tzname[1] after setting to a time zone
**		in which Daylight Saving Time is never observed.
**	4.	They might reference tzname[0] after setting to a time zone
**		in which Standard Time is never observed.
**	5.	They might reference tm.TM_ZONE after calling offtime.
** What's best to do in the above cases is open to debate;
** for now, we just set things up so that in any of the five cases
** WILDABBR is used.  Another possibility:  initialize tzname[0] to the
** string "tzname[0] used before set", and similarly for the other cases.
** And another:  initialize tzname[0] to "ERA", with an explanation in the
** manual page of what this "time zone abbreviation" means (doing this so
** that tzname[0] has the "normal" length of three characters).
*/
#define WILDABBR	"   "
#endif						 /* !defined WILDABBR */

#ifndef TRUE
#define TRUE		1
#define FALSE		0
#endif						 /* !defined TRUE */

static const char GMT[] = "GMT";

struct ttinfo
	{						 /* time type information */
	long tt_gmtoff;			 /* GMT offset in seconds */
	int tt_isdst;			 /* used to set tm_isdst */
	int tt_abbrind;			 /* abbreviation list index */
	int tt_ttisstd;			 /* TRUE if transition is std time */
	};

struct lsinfo
	{						 /* leap second information */
	time_t ls_trans;		 /* transition time */
	long ls_corr;			 /* correction to apply */
	};

struct state
	{
	int leapcnt;
	int timecnt;
	int typecnt;
	int charcnt;
	time_t ats[TZ_MAX_TIMES];
	unsigned char types[TZ_MAX_TIMES];
	struct ttinfo ttis[TZ_MAX_TYPES];
	char chars[(TZ_MAX_CHARS + 1 > sizeof GMT) ?
			        TZ_MAX_CHARS + 1 : sizeof GMT];
	struct lsinfo lsis[TZ_MAX_LEAPS];
	};

struct rule
	{
	int r_type;				 /* type of rule--see below */
	int r_day;				 /* day number of rule */
	int r_week;				 /* week number of rule */
	int r_mon;				 /* month number of rule */
	long r_time;			 /* transition time of rule */
	};

#define	JULIAN_DAY		0	 /* Jn - Julian day */
#define	DAY_OF_YEAR		1	 /* n - day of year */
#define	MONTH_NTH_DAY_OF_WEEK	2		/* Mm.n.d - month, week, day of week */

static struct rule to_dst_rule =
	{
	MONTH_NTH_DAY_OF_WEEK,
	0, 4, 3, 2 * SECSPERHOUR
	};
	
static struct rule to_std_rule =
	{
	MONTH_NTH_DAY_OF_WEEK,
	0, 4, 10, 2 * SECSPERHOUR
	};

static long std_off;					/* STD offset						*/
static long dst_off;					/* DST offset						*/

/*
** Prototypes for static functions.
*/

static const char *getzname P ((const char *strp));
static const char *getnum P ((const char *strp, int *nump, int min,
							       int max));
static const char *getsecs P ((const char *strp, long *secsp));
static const char *getoffset P ((const char *strp, long *offsetp));
static const char *getrule P ((const char *strp, struct rule * rulep));
static void gmtload P ((struct state * sp));
static void settzname P ((void));
static time_t transtime P ((time_t janfirst, int year,
						           const struct rule * rulep, long offset));
#if	0
static int tzload P ((const char *name, struct state * sp));
#endif
static int tzparse P ((const char *name, struct state * sp,
					           int lastditch));

#ifdef ALL_STATE
static struct state *lclptr;
#endif						 /* defined ALL_STATE */

#ifndef ALL_STATE
static struct state lclmem;
#if	0
static struct state gmtmem;
#endif

#define lclptr		(&lclmem)
#if	0
#define gmtptr		(&gmtmem)
#endif
#endif						 /* State Farm */

static int lcl_is_set;

char _FAR * const _Cdecl tzname[2] = {
				   WILDABBR,
				   WILDABBR
	};

#ifdef USG_COMPAT
time_t timezone = 0;
int daylight = 0;

#endif						 /* defined USG_COMPAT */

#ifdef ALTZONE
time_t altzone = 0;

#endif						 /* defined ALTZONE */

static void
     settzname ()
	{
	register const struct state *const sp = lclptr;
	register int i;

	(void) strcpy (tzname[0], WILDABBR);
	(void) strcpy (tzname[1], WILDABBR);
#ifdef USG_COMPAT
	daylight = 0;
	timezone = 0;
#endif											 /* defined USG_COMPAT */
#ifdef ALTZONE
	altzone = 0;
#endif											 /* defined ALTZONE */
#ifdef ALL_STATE
	if (sp == NULL)
		{
		(void) strcpy (tzname[0], GMT);
		(void) strcpy (tzname[1], GMT);
		return;
		}
#endif											 /* defined ALL_STATE */

	for (i = 0; i < sp->typecnt; ++i)
		{
		register const struct ttinfo *const ttisp = &sp->ttis[i];

		(void) strcpy (tzname[ttisp->tt_isdst],
					   (char *) &sp->chars[ttisp->tt_abbrind]);
#ifdef USG_COMPAT
		if (ttisp->tt_isdst)
			daylight = 1;

		if (i == 0 || !ttisp->tt_isdst)
			timezone = -(ttisp->tt_gmtoff);
#endif											 /* defined USG_COMPAT */
#ifdef ALTZONE

		if (i == 0 || ttisp->tt_isdst)
			altzone = -(ttisp->tt_gmtoff);
#endif											 /* defined ALTZONE */

		}
	/* * And to get the latest zone names into tzname. . . */
	for (i = 0; i < sp->timecnt; ++i)
		{
		register const struct ttinfo *const ttisp =
		&sp->ttis[sp->types[i]];

		(void) strcpy (tzname[ttisp->tt_isdst], 
					   (char *) &sp->chars[ttisp->tt_abbrind]);
		}
	}

#if	0
static int
    tzload (name, sp)
register const char *name;
register struct state *const sp;
	{
	register const char *p;
	register int i;
	register int fid;

	if (name == NULL && (name = TZDEFAULT) == NULL)
		return -1;

		{
		char fullname[FILENAME_MAX + 1];

		if (name[0] == ':')
			++name;

		if (name[0] != '/')
			{
			if ((p = TZDIR) == NULL)
				return -1;

			if ((strlen (p) + strlen (name) + 1) >= sizeof fullname)
				return -1;

			(void) strcpy (fullname, p);
			(void) strcat (fullname, "/");
			(void) strcat (fullname, name);
			name = fullname;
			}

		if ((fid = open (name, OPEN_MODE)) == -1)
			return -1;

		}
		{
		register const struct tzhead *tzhp;
		char buf[sizeof *sp + sizeof *tzhp];
		int ttisstdcnt;

		i = read (fid, buf, sizeof buf);
		if (close (fid) != 0 || i < sizeof *tzhp)
			return -1;

		tzhp = (struct tzhead *) buf;
		ttisstdcnt = (int) detzcode (tzhp->tzh_ttisstdcnt);
		sp->leapcnt = (int) detzcode (tzhp->tzh_leapcnt);
		sp->timecnt = (int) detzcode (tzhp->tzh_timecnt);
		sp->typecnt = (int) detzcode (tzhp->tzh_typecnt);
		sp->charcnt = (int) detzcode (tzhp->tzh_charcnt);
		if (sp->leapcnt < 0 || sp->leapcnt > TZ_MAX_LEAPS ||
			sp->typecnt <= 0 || sp->typecnt > TZ_MAX_TYPES ||
			sp->timecnt < 0 || sp->timecnt > TZ_MAX_TIMES ||
			sp->charcnt < 0 || sp->charcnt > TZ_MAX_CHARS ||
			(ttisstdcnt != sp->typecnt && ttisstdcnt != 0))
			return -1;
		if (i < sizeof *tzhp +
			sp->timecnt * (4 + sizeof (char)) +
			sp->typecnt * (4 + 2 * sizeof (char)) +
			sp->charcnt * sizeof (char) +
			sp->leapcnt * 2 * 4 +

			ttisstdcnt * sizeof (char))
			return -1;

		p = buf + sizeof *tzhp;
		for (i = 0; i < sp->timecnt; ++i)
			{
			sp->ats[i] = detzcode (p);
			p += 4;
			}

		for (i = 0; i < sp->timecnt; ++i)
			{
			sp->types[i] = (unsigned char) *p++;
			if (sp->types[i] >= sp->typecnt)
				return -1;

			}
		for (i = 0; i < sp->typecnt; ++i)
			{
			register struct ttinfo *ttisp;

			ttisp = &sp->ttis[i];
			ttisp->tt_gmtoff = detzcode (p);
			p += 4;
			ttisp->tt_isdst = (unsigned char) *p++;
			if (ttisp->tt_isdst != 0 && ttisp->tt_isdst != 1)
				return -1;

			ttisp->tt_abbrind = (unsigned char) *p++;
			if (ttisp->tt_abbrind < 0 ||
				ttisp->tt_abbrind > sp->charcnt)
				return -1;

			}
		for (i = 0; i < sp->charcnt; ++i)
			sp->chars[i] = *p++;

		sp->chars[i] = '\0';					 /* ensure '\0' at end */
		for (i = 0; i < sp->leapcnt; ++i)
			{
			register struct lsinfo *lsisp;

			lsisp = &sp->lsis[i];
			lsisp->ls_trans = detzcode (p);
			p += 4;
			lsisp->ls_corr = detzcode (p);
			p += 4;
			}

		for (i = 0; i < sp->typecnt; ++i)
			{
			register struct ttinfo *ttisp;

			ttisp = &sp->ttis[i];
			if (ttisstdcnt == 0)
				ttisp->tt_ttisstd = FALSE;
			else
				{
				ttisp->tt_ttisstd = *p++;
				if (ttisp->tt_ttisstd != TRUE &&
					ttisp->tt_ttisstd != FALSE)
					return -1;

				}
			}
		}
	return 0;
	}
#endif

static const int mon_lengths[2][MONSPERYEAR] = {
							{ 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 },
							{ 31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 }
	};

static const int year_lengths[2] = {
									DAYSPERNYEAR, DAYSPERLYEAR
	};

/*
** Given a pointer into a time zone string, scan until a character that is not
** a valid character in a zone name is found.  Return a pointer to that
** character.
*/

static const char *
     getzname (strp)
register const char *strp;
	{
	register char c;

	while ((c = *strp) != '\0' && !isdigit (c) && c != ',' && c != '-' &&
		   c != '+')
		++strp;

	return strp;
	}

/*
** Given a pointer into a time zone string, extract a number from that string.
** Check that the number is within a specified range; if it is not, return
** NULL.
** Otherwise, return a pointer to the first character not part of the number.
*/

static const char *
     getnum (strp, nump, min, max)
register const char *strp;
int *const nump;
const int min;
const int max;
	{
	register char c;
	register int num;

	if (strp == NULL || !isdigit (*strp))
		return NULL;

	num = 0;
	while ((c = *strp) != '\0' && isdigit (c))
		{
		num = num * 10 + (c - '0');
		if (num > max)
			return NULL;						 /* illegal value */

		++strp;
		}

	if (num < min)
		return NULL;							 /* illegal value */

	*nump = num;
	return strp;
	}

/*
** Given a pointer into a time zone string, extract a number of seconds,
** in hh[:mm[:ss]] form, from the string.
** If any error occurs, return NULL.
** Otherwise, return a pointer to the first character not part of the number
** of seconds.
*/

static const char *
     getsecs (strp, secsp)
register const char *strp;
long *const secsp;
	{
	int num;

	strp = getnum (strp, &num, 0, HOURSPERDAY);
	if (strp == NULL)
		return NULL;

	*secsp = num * SECSPERHOUR;
	if (*strp == ':')
		{
		++strp;
		strp = getnum (strp, &num, 0, MINSPERHOUR - 1);
		if (strp == NULL)
			return NULL;

		*secsp += num * SECSPERMIN;
		if (*strp == ':')
			{
			++strp;
			strp = getnum (strp, &num, 0, SECSPERMIN - 1);
			if (strp == NULL)
				return NULL;

			*secsp += num;
			}

		}

	return strp;
	}

/*
** Given a pointer into a time zone string, extract an offset, in
** [+-]hh[:mm[:ss]] form, from the string.
** If any error occurs, return NULL.
** Otherwise, return a pointer to the first character not part of the time.
*/

static const char *
     getoffset (strp, offsetp)
register const char *strp;
long *const offsetp;
	{
	register int neg;

	if (*strp == '-')
		{
		neg = 1;
		++strp;
		}
	else
	if (isdigit (*strp) || *strp++ == '+')
		neg = 0;
	else
		return NULL;							 /* illegal offset */

	strp = getsecs (strp, offsetp);
	if (strp == NULL)
		return NULL;							 /* illegal time */

	if (neg)
		*offsetp = -*offsetp;

	return strp;
	}

/*
** Given a pointer into a time zone string, extract a rule in the form
** date[/time].  See POSIX section 8 for the format of "date" and "time".
** If a valid rule is not found, return NULL.
** Otherwise, return a pointer to the first character not part of the rule.
*/

static const char *
     getrule (strp, rulep)
const char *strp;
register struct rule *const rulep;
	{
	if (*strp == 'J')
		{
		/* * Julian day. */
		rulep->r_type = JULIAN_DAY;
		++strp;
		strp = getnum (strp, &rulep->r_day, 1, DAYSPERNYEAR);
		}
	else
	if (*strp == 'M')
		{
		/* * Month, week, day. */
		rulep->r_type = MONTH_NTH_DAY_OF_WEEK;
		++strp;
		strp = getnum (strp, &rulep->r_mon, 1, MONSPERYEAR);
		if (strp == NULL)
			return NULL;

		if (*strp++ != '.')
			return NULL;

		strp = getnum (strp, &rulep->r_week, 1, 5);
		if (strp == NULL)
			return NULL;

		if (*strp++ != '.')
			return NULL;

		strp = getnum (strp, &rulep->r_day, 0, DAYSPERWEEK - 1);
		}
	else
	if (isdigit (*strp))
		{
		/* * Day of year. */
		rulep->r_type = DAY_OF_YEAR;
		strp = getnum (strp, &rulep->r_day, 0, DAYSPERLYEAR - 1);
		}
	else
		return NULL;							 /* invalid format */

	if (strp == NULL)
		return NULL;

	if (*strp == '/')
		{
		/* * Time specified. */
		++strp;
		strp = getsecs (strp, &rulep->r_time);
		}
	else
		rulep->r_time = 2 * SECSPERHOUR;		 /* default = 2:00:00 */

	return strp;
	}

/*
** Given the Epoch-relative time of January 1, 00:00:00 GMT, in a year, the
** year, a rule, and the offset from GMT at the time that rule takes effect,
** calculate the Epoch-relative time that rule takes effect.
*/

static time_t
       transtime (janfirst, year, rulep, offset)
const time_t janfirst;
const int year;
register const struct rule *const rulep;
const long offset;
	{
	register int leapyear;
	register time_t value;
	register int i;
	int d, m1, yy0, yy1, yy2, dow;

	leapyear = isleap (year);
	switch (rulep->r_type)
		{

		case JULIAN_DAY:
			/* * Jn - Julian day, 1 == January 1, 60 == March 1 even in
			 * leap * years. * In non-leap years, or if the day number is
			 * 59 or less, just * add SECSPERDAY times the day number-1 to
			 * the time of * January 1, midnight, to get the day. */
			value = janfirst + (rulep->r_day - 1) * SECSPERDAY;
			if (leapyear && rulep->r_day >= 60)
				value += SECSPERDAY;

			break;

		case DAY_OF_YEAR:
			/* * n - day of year. * Just add SECSPERDAY times the day
			 * number to the time of * January 1, midnight, to get the day. */
			value = janfirst + rulep->r_day * SECSPERDAY;
			break;

		case MONTH_NTH_DAY_OF_WEEK:
			/* * Mm.n.d - nth "dth day" of month m. */
			value = janfirst;
			for (i = 0; i < rulep->r_mon - 1; ++i)
				value += mon_lengths[leapyear][i] * SECSPERDAY;

			/* * Use Zeller's Congruence to get day-of-week of first day of *
			 * month. */
			m1 = (rulep->r_mon + 9) % 12 + 1;
			yy0 = (rulep->r_mon <= 2) ? (year - 1) : year;
			yy1 = yy0 / 100;
			yy2 = yy0 % 100;
			dow = ((26 * m1 - 2) / 10 +
				   1 + yy2 + yy2 / 4 + yy1 / 4 - 2 * yy1) % 7;
			if (dow < 0)
				dow += DAYSPERWEEK;

			/* * "dow" is the day-of-week of the first day of the month. 
			 * Get * the day-of-month (zero-origin) of the first "dow" day
			 * of the * month. */

			d = rulep->r_day - dow;
			if (d < 0)
				d += DAYSPERWEEK;

			for (i = 1; i < rulep->r_week; ++i)
				{
				if (d + DAYSPERWEEK >=
					mon_lengths[leapyear][rulep->r_mon - 1])
					break;

				d += DAYSPERWEEK;
				}

			/* * "d" is the day-of-month (zero-origin) of the day we want. */
			value += d * SECSPERDAY;
			break;
		}

	/* * "value" is the Epoch-relative time of 00:00:00 GMT on the day in *
	 * question.  To get the Epoch-relative time of the specified local *
	 * time on that day, add the transition time and the current offset *
	 * from GMT. */
	return value + rulep->r_time + offset;
	}

/*
** Given a POSIX section 8-style TZ string, fill in the rule tables as
** appropriate.
*/

static int
    tzparse (name, sp, lastditch)
const char *name;
register struct state *const sp;
const int lastditch;
	{
	const char *stdname;
	const char *dstname;
	int stdlen;
	int dstlen;
	long stdoffset;
	long dstoffset;
	register time_t *atp;
	register unsigned char *typep;
	register char *cp;
	register int load_result;

	stdname = name;
	if (lastditch)
		{
		stdlen = strlen (name);					 /* length of standard zone
												  * name */
		name += stdlen;
		if (stdlen >= sizeof sp->chars)
			stdlen = (sizeof sp->chars) - 1;

		}
	else
		{
		name = getzname (name);
		stdlen = (int) (name - stdname);
		if (stdlen < 3)
			return -1;

		}
	if (*name == '\0')
		return -1;
	else
		{
		name = getoffset (name, &stdoffset);
		if (name == NULL)
			return -1;

		}
#if	0
	load_result = tzload (TZDEFRULES, sp);
	if (load_result != 0)
#else
		load_result = 1;
#endif
		sp->leapcnt = 0;						 /* so, we're off a little */

	if (*name != '\0')
		{
		dstname = name;
		name = getzname (name);
		dstlen = (int) (name - dstname);		 /* length of DST zone name */
		if (dstlen < 3)
			return -1;

		if (*name != '\0' && *name != ',' && *name != ';')
			{
			name = getoffset (name, &dstoffset);
			if (name == NULL)
				return -1;

			}
		else
			dstoffset = stdoffset - SECSPERHOUR;

		std_off = stdoffset;
		dst_off = dstoffset;
		if (*name == ',' || *name == ';')
			{
			struct rule start;
			struct rule end;
			register int year;
			register time_t janfirst;
			time_t starttime;
			time_t endtime;

			++name;
			if ((name = getrule (name, &start)) == NULL)
				return -1;

			to_dst_rule = start;
			if (*name++ != ',')
				return -1;

			if ((name = getrule (name, &end)) == NULL)
				return -1;

			to_std_rule = end;
			if (*name != '\0')
				return -1;

			sp->typecnt = 2;					 /* standard time and DST */
			/* * Two transitions per year, from EPOCH_YEAR to 2037. */
			sp->timecnt = 2 * (2037 - EPOCH_YEAR + 1);
			if (sp->timecnt > TZ_MAX_TIMES)
				return -1;

			sp->ttis[0].tt_gmtoff = -dstoffset;
			sp->ttis[0].tt_isdst = 1;
			sp->ttis[0].tt_abbrind = stdlen + 1;
			sp->ttis[1].tt_gmtoff = -stdoffset;
			sp->ttis[1].tt_isdst = 0;
			sp->ttis[1].tt_abbrind = 0;
			atp = sp->ats;
			typep = sp->types;
			janfirst = 0;
			for (year = EPOCH_YEAR; year <= 2037; ++year)
				{
				starttime = transtime (janfirst, year, &start,
									   stdoffset);
				endtime = transtime (janfirst, year, &end,
									 dstoffset);
				if (starttime > endtime)
					{
					*atp++ = endtime;
					*typep++ = 1;				 /* DST ends */
					*atp++ = starttime;
					*typep++ = 0;				 /* DST begins */
					}
				else
					{
					*atp++ = starttime;
					*typep++ = 0;				 /* DST begins */
					*atp++ = endtime;
					*typep++ = 1;				 /* DST ends */
					}

				janfirst +=
				year_lengths[isleap (year)] * SECSPERDAY;
				}
			}
		else
			{
			int sawstd;
			int sawdst;
			long stdfix;
			long dstfix;
			long oldfix;
			int isdst;
			register int i;

			if (*name != '\0')
				return -1;

			if (load_result != 0)
				return -1;
			/* * Compute the difference between the real and * prototype
			 * standard and summer time offsets * from GMT, and put the
			 * real standard and summer * time offsets into the rules in
			 * place of the * prototype offsets. */

			sawstd = FALSE;
			sawdst = FALSE;
			stdfix = 0;
			dstfix = 0;
			for (i = 0; i < sp->typecnt; ++i)
				{
				if (sp->ttis[i].tt_isdst)
					{
					oldfix = dstfix;
					dstfix =
					sp->ttis[i].tt_gmtoff + dstoffset;
					if (sawdst && (oldfix != dstfix))
						return -1;

					sp->ttis[i].tt_gmtoff = -dstoffset;
					sp->ttis[i].tt_abbrind = stdlen + 1;
					sawdst = TRUE;
					}
				else
					{
					oldfix = stdfix;
					stdfix =
					sp->ttis[i].tt_gmtoff + stdoffset;
					if (sawstd && (oldfix != stdfix))
						return -1;

					sp->ttis[i].tt_gmtoff = -stdoffset;
					sp->ttis[i].tt_abbrind = 0;
					sawstd = TRUE;
					}
				}

			/* * Make sure we have both standard and summer time. */
			if (!sawdst || !sawstd)
				return -1;
			/* * Now correct the transition times by shifting * them by the
			 * difference between the real and * prototype offsets.  Note
			 * that this difference * can be different in standard and
			 * summer time; * the prototype probably has a 1-hour
			 * difference * between standard and summer time, but a
			 * different * difference can be specified in TZ. */

			isdst = FALSE;						 /* we start in standard time */
			for (i = 0; i < sp->timecnt; ++i)
				{
				register const struct ttinfo *ttisp;

				/* * If summer time is in effect, and the * transition time
				 * was not specified as * standard time, add the summer
				 * time * offset to the transition time; * otherwise, add
				 * the standard time offset * to the transition time. */
				ttisp = &sp->ttis[sp->types[i]];
				sp->ats[i] +=
				(isdst && !ttisp->tt_ttisstd) ?
				dstfix : stdfix;
				isdst = ttisp->tt_isdst;
				}
			}
		}
	else
		{
		dstlen = 0;
		sp->typecnt = 1;						 /* only standard time */
		sp->timecnt = 0;
		sp->ttis[0].tt_gmtoff = -stdoffset;
		sp->ttis[0].tt_isdst = 0;
		sp->ttis[0].tt_abbrind = 0;
		}

	sp->charcnt = stdlen + 1;
	if (dstlen != 0)
		sp->charcnt += dstlen + 1;

	if (sp->charcnt > sizeof sp->chars)
		return -1;

	cp = sp->chars;
	(void) strncpy (cp, stdname, stdlen);
	cp += stdlen;
	*cp++ = '\0';
	if (dstlen != 0)
		{
		(void) strncpy (cp, dstname, dstlen);
		*(cp + dstlen) = '\0';
		}

	return 0;
	}

static void
     gmtload (sp)
struct state *const sp;
	{
#if	0
	if (tzload (GMT, sp) != 0)
#endif
		(void) tzparse (GMT, sp, TRUE);

	}

void _FARFUNC
     tzset ()
	{
	register const char *name;
	void tzsetwall ();

	name = getenv ("GTZ");
	if (name == NULL)
		{
		name = getenv ("TZ");
		if (name == NULL)
			{
#if 0
			tzsetwall ();
			return;
#else
			name = "EST5";
#endif
			}

		}

	lcl_is_set = TRUE;
#ifdef ALL_STATE
	if (lclptr == NULL)
		{
		lclptr = (struct state *) malloc (sizeof *lclptr);
		if (lclptr == NULL)
			{
			settzname ();						 /* all we can do */
			return;
			}

		}
#endif											 /* defined ALL_STATE */

	if (*name == '\0')
		{
		/* * User wants it fast rather than right. */
		lclptr->leapcnt = 0;					 /* so, we're off a little */
		lclptr->timecnt = 0;
		lclptr->ttis[0].tt_gmtoff = 0;
		lclptr->ttis[0].tt_abbrind = 0;
		(void) strcpy (lclptr->chars, GMT);
		}
	else /* if (tzload (name, lclptr) != 0) */
		if (name[0] == ':' || tzparse (name, lclptr, FALSE) != 0)
			(void) gmtload (lclptr);

	settzname ();
	}

void
     tzsetwall ()
	{
	     lcl_is_set = TRUE;
#ifdef ALL_STATE
	if (lclptr == NULL)
		{
		lclptr = (struct state *) malloc (sizeof *lclptr);
		if (lclptr == NULL)
			{
			settzname ();						 /* all we can do */
			return;
			}

		}
#endif											 /* defined ALL_STATE */

#if	0
	if (tzload ((char *) NULL, lclptr) != 0)
#endif
		gmtload (lclptr);

	settzname ();
	}

#pragma startup tzset 30

/****************************************************************************
*	__isDST																	*
*	Determines whether daylight savings time is in effect.					*
*	Returns non-zero if daylight savings time is in effect for the given	*
*	date.  If <month> is zero, <yday> is the day of the year else <yday>	*
*	is the day of the month.  <yday> is zero based.  Assumption: tzset ()	*
*	has previously been called.												*
****************************************************************************/

int pascal near __isDST (unsigned hour, unsigned yday,
						 unsigned month, unsigned year)
	{
	time_t lhour;						/* hour (long)						*/
	time_t lyday;						/* day (long)						*/
	time_t lyear;						/* year (long)						*/
	time_t year_start;					/* epoch relative start of year		*/
	time_t now;							/* epoch relative parameters		*/
	time_t dst_start;					/* start of DST						*/
	time_t std_start;					/* start of STD						*/
	static unsigned long month_day[] =
		{ 0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334, 365 };

	/* Calculate the start of the year. */

	lhour = (time_t) hour;
	lyday = (time_t) yday;
	lyear = (time_t) year;
	year_start = (((lyear + 2L) / 4L) +
				  (lyear * DAYSPERNYEAR)) * 24L * 60L * 60L;

	/* Get the DST and STD start times. */

	dst_start = transtime (year_start, year + 1970, &to_dst_rule, std_off);
	std_start = transtime (year_start, year + 1970, &to_std_rule, dst_off);

	/* Calculate now. */

	if (month == 0)
		now = year_start +
			  (lyday * 24L * 60L * 60L) +
			  (lhour * 60L * 60L);
	else
		now = year_start +
			  (month_day[month - 1] * 24L * 60L * 60L) +
			  (lyday * 24L * 60L * 60L) +
			  (lhour * 60L * 60L);

	/* Are we in DST? */

	if (now < dst_start || now >= std_start)
		return (0);

	return (1);
	}	/* int pascal __isDST (unsigned hour, unsigned yday,
						 	   unsigned month, unsigned year) */
