/****************************************************************************
*	Language 	:	Turbo C 2.0												*
*	Logfile		:	zm.h													*
*	Project		:	Comms Library.											*
*	Date 		:	26 Jan 90												*
*	Revision 	:	1.1		GT	Originate.									*
*	25 Oct 92	:	1.2		GT	KA9Q mods.									*
*****************************************************************************
*	Purpose		:	ZMODEM protocol primitives prototypes.					*
*	$Id: zm.h 1.1 93/01/16 18:37:35 ROOT_DOS Exp $
****************************************************************************/

#ifndef	ZM_H
#define	ZM_H

/****************************************************************************
*	_zsbhdr																	*
*	Send ZMODEM binary header <hdr> of type <type>.							*
****************************************************************************/

void _zsbhdr (int type, char *hdr);

/****************************************************************************
*	_zshhdr																	*
*	Send ZMODEM HEX header <hdr> of type <type>.							*
****************************************************************************/

void _zshhdr (int type, char *hdr);

/****************************************************************************
*	_zsdata																	*
*	Send binary array <buf> of length <length>, with ending ZDLE sequence 	*
*	<frameend>.																*
****************************************************************************/

void _zsdata (char *buf, int length, int frameend);

/****************************************************************************
*	_zrdata																	*
*	Receive array <buf> of max <length> with ending ZDLE sequence and CRC.	*
*	Returns the ending character or error code.  NB: On errors may store 	*
*	<length> + 1 bytes!														*
****************************************************************************/

int _zrdata (char *buf, int length);

/****************************************************************************
*	_zgethdr																	*
*	Read a ZMODEM header to <hdr>, either binary or hex.  <eflag> controls	*
*	local display of non zmodem characters:									*
*	0:  no display															*
*	1:  display printing characters only									*
*	2:  display all non ZMODEM characters									*
* 	On success, set Zmodem to 1, set _Rxpos and return type of header.		*
*	Otherwise return negative on error.										*
*	Return ERROR instantly if ZCRCW sequence, for fast error recovery.		*
****************************************************************************/

int _zgethdr (char *hdr, int eflag);

/****************************************************************************
*	_stohdr																	*
*	Store long integer pos in _Txhdr.										*
****************************************************************************/

void _stohdr (long pos);

/****************************************************************************
*	_rclhdr																	*
*	Recover a long integer from a header.									*
****************************************************************************/

long _rclhdr (char *hdr);


/****************************************************************************
*	Global data.															*
****************************************************************************/

extern int _Znulls;
extern int _Rxtimeout;

#endif
