/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.uninstaller;

import com.izforge.izpack.core.resource.DefaultResources;
import com.izforge.izpack.uninstaller.console.ConsoleUninstaller;
import com.izforge.izpack.uninstaller.console.ConsoleUninstallerContainer;
import com.izforge.izpack.uninstaller.container.UninstallerContainer;
import com.izforge.izpack.uninstaller.gui.GUIUninstallerContainer;
import com.izforge.izpack.uninstaller.gui.UninstallerFrame;
import com.izforge.izpack.uninstaller.resource.InstallLog;
import com.izforge.izpack.util.Housekeeper;
import com.izforge.izpack.util.Platform;
import com.izforge.izpack.util.Platforms;
import com.izforge.izpack.util.PrivilegedRunner;
import com.izforge.izpack.util.SelfModifier;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class Uninstaller {
    private static final String EXEC_ADMIN = "/exec-admin";
    private static final Logger logger = Logger.getLogger(Uninstaller.class.getName());

    public static void main(String[] args) {
        Platform platform = new Platforms().getCurrentPlatform();
        try {
            if (!PrivilegedRunner.isPrivilegedMode() && Uninstaller.isElevationRequired(platform) && Uninstaller.relaunchWithElevatedRights(platform)) {
                System.exit(0);
            }
        }
        catch (IOException exception) {
            logger.log(Level.SEVERE, exception.getMessage(), exception);
            System.exit(1);
        }
        boolean console = false;
        for (String arg : args) {
            if (!arg.equals("-c")) continue;
            console = true;
        }
        if (console) {
            System.out.println("Command line uninstaller.\n");
        }
        try {
            Class<Uninstaller> clazz = Uninstaller.class;
            Method target = console ? clazz.getMethod("consoleUninstall", String[].class) : clazz.getMethod("uninstall", String[].class);
            new SelfModifier(target).invoke(args);
        }
        catch (Exception ioeOrTypo) {
            System.err.println(ioeOrTypo.getMessage());
            ioeOrTypo.printStackTrace();
            System.err.println("Unable to exec java as a subprocess.");
            System.err.println("The uninstall may not fully complete.");
            Uninstaller.uninstall(args);
        }
    }

    public static void consoleUninstall(String[] args) {
        ConsoleUninstallerContainer container = new ConsoleUninstallerContainer();
        try {
            ConsoleUninstaller uninstaller = container.getComponent(ConsoleUninstaller.class);
            boolean force = false;
            for (String arg : args) {
                if (!arg.equals("-f")) continue;
                force = true;
            }
            uninstaller.uninstall(force);
        }
        catch (Exception err) {
            Uninstaller.shutdown(container, err);
        }
    }

    public static void uninstall(final String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GUIUninstallerContainer container = new GUIUninstallerContainer();
                try {
                    boolean displayForceOption = true;
                    boolean forceOptionState = false;
                    for (String arg : args) {
                        if (arg.equals("-f")) {
                            forceOptionState = true;
                            continue;
                        }
                        if (!arg.equals("-x")) continue;
                        displayForceOption = false;
                    }
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                    UninstallerFrame uninstaller = container.getComponent(UninstallerFrame.class);
                    uninstaller.init(displayForceOption, forceOptionState);
                }
                catch (Exception err) {
                    Uninstaller.shutdown(container, err);
                }
            }
        });
    }

    private static void shutdown(UninstallerContainer container, Exception error) {
        logger.log(Level.SEVERE, error.getMessage(), error);
        container.getComponent(Housekeeper.class).shutDown(1);
    }

    private static boolean relaunchWithElevatedRights(Platform platform) {
        boolean result = false;
        PrivilegedRunner runner = new PrivilegedRunner(platform);
        if (runner.isPlatformSupported()) {
            try {
                if (runner.relaunchWithElevatedRights() == 0) {
                    result = true;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (!result) {
                JOptionPane.showMessageDialog(null, "The uninstaller could not launch itself with administrator permissions.\nThe uninstallation will still continue but you may encounter problems due to insufficient permissions.");
            }
        } else {
            JOptionPane.showMessageDialog(null, "This uninstaller should be run by an administrator.\nThe uninstallation will still continue but you may encounter problems due to insufficient permissions.");
        }
        return result;
    }

    private static boolean isElevationRequired(Platform platform) throws IOException {
        boolean result = false;
        if (Uninstaller.class.getResource(EXEC_ADMIN) != null) {
            String path = InstallLog.getInstallPath(new DefaultResources());
            PrivilegedRunner runner = new PrivilegedRunner(platform);
            result = runner.isElevationNeeded(path);
        }
        return result;
    }
}

