/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import com.izforge.izpack.util.CleanupClient;
import com.izforge.izpack.util.Housekeeper;
import com.izforge.izpack.util.IoHelper;
import com.izforge.izpack.util.LibraryRemover;
import com.izforge.izpack.util.NativeLibraryClient;
import com.izforge.izpack.util.TargetFactory;
import com.izforge.izpack.util.file.FileUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Librarian
implements CleanupClient {
    private static final Logger logger = Logger.getLogger(Librarian.class.getName());
    private static final String JAR_PROTOCOL = "jar";
    private static final String FILE_PROTOCOL = "file";
    private static final String NATIVE = "com/izforge/izpack/bin/native/";
    private List<String> trackList = new ArrayList<String>();
    private List<NativeLibraryClient> clients = new ArrayList<NativeLibraryClient>();
    private List<String> temporaryFileNames = new ArrayList<String>();
    private String extension = "";

    public Librarian(TargetFactory factory, Housekeeper housekeeper) {
        housekeeper.registerForCleanup(this);
        this.extension = '.' + factory.getNativeLibraryExtension();
    }

    public synchronized void loadLibrary(String name, NativeLibraryClient client) throws UnsatisfiedLinkError {
        if (!this.trackList.contains(name = this.strip(name))) {
            boolean loaded = this.loadArchSpecificLibrary(name, client);
            if (!loaded) {
                String name64 = name + "_x64";
                loaded = this.loadArchSpecificLibrary(name64, client);
            }
            if (loaded) {
                this.trackList.add(name);
            } else {
                throw new UnsatisfiedLinkError("Failed to load library: " + name);
            }
        }
    }

    @Override
    public void cleanUp() {
        if (!this.temporaryFileNames.isEmpty()) {
            try {
                LibraryRemover.invoke(this.temporaryFileNames);
            }
            catch (IOException exception) {
                logger.log(Level.WARNING, "Cleanup failed for native libraries: " + exception.getMessage(), exception);
            }
        }
        this.clients.clear();
    }

    protected URL getResourcePath(String name) {
        String resource = "/com/izforge/izpack/bin/native/" + name + this.extension;
        return this.getClass().getResource(resource);
    }

    private boolean loadArchSpecificLibrary(String name, NativeLibraryClient client) {
        boolean result = false;
        if (this.loadFromDLLPath(name, client) || this.loadSystemLibrary(name, client) || this.loadFromClassPath(name, client)) {
            result = true;
        }
        return result;
    }

    private boolean loadFromDLLPath(String name, NativeLibraryClient client) {
        String property = System.getProperty("DLL_PATH");
        if (property != null) {
            String path = property + "/" + name + this.extension;
            path = path.replace('/', File.separatorChar);
            return this.load(path, client);
        }
        return false;
    }

    private boolean loadFromClassPath(String name, NativeLibraryClient client) {
        boolean result = false;
        URL url = this.getResourcePath(name);
        if (url != null) {
            String protocol = url.getProtocol();
            if (protocol.equalsIgnoreCase(FILE_PROTOCOL)) {
                try {
                    String path = new File(url.toURI()).getPath();
                    result = this.load(path, client);
                }
                catch (URISyntaxException exception) {
                    logger.log(Level.WARNING, "Failed to load library: " + name + ": " + exception.getMessage(), exception);
                }
            } else if (protocol.equalsIgnoreCase(JAR_PROTOCOL)) {
                result = this.loadJarLibrary(name, url, client);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadJarLibrary(String name, URL url, NativeLibraryClient client) {
        boolean result = false;
        File file = null;
        InputStream in = null;
        FileOutputStream out = null;
        String path = null;
        try {
            file = FileUtils.createTempFile(name, this.extension);
            in = url.openStream();
            out = new FileOutputStream(file);
            IoHelper.copyStream(in, out);
            path = file.getAbsolutePath();
        }
        catch (IOException exception) {
            try {
                logger.log(Level.WARNING, "Failed to load library: " + name + ": " + exception.getMessage(), exception);
            }
            catch (Throwable throwable) {
                FileUtils.close(in);
                FileUtils.close(out);
                throw throwable;
            }
            FileUtils.close(in);
            FileUtils.close(out);
        }
        FileUtils.close(in);
        FileUtils.close(out);
        if (path != null) {
            result = this.load(path, client);
        }
        if (!result) {
            FileUtils.delete(file);
        } else {
            this.temporaryFileNames.add(path);
            file.deleteOnExit();
        }
        return result;
    }

    private boolean loadSystemLibrary(String name, NativeLibraryClient client) {
        try {
            System.loadLibrary(name);
            this.clients.add(client);
            return true;
        }
        catch (Throwable exception) {
            logger.log(Level.FINE, "Failed to load library: " + name + ": " + exception.getMessage(), exception);
            return false;
        }
    }

    private boolean load(String path, NativeLibraryClient client) {
        boolean result = false;
        try {
            System.load(path);
            this.clients.add(client);
            result = true;
        }
        catch (Throwable exception) {
            logger.log(Level.FINE, "Failed to load library: " + path + ": " + exception.getMessage(), exception);
        }
        return result;
    }

    private String strip(String name) {
        int extensionStart = name.lastIndexOf(46);
        int nameStart = name.lastIndexOf(47);
        if (nameStart < 0) {
            nameStart = name.lastIndexOf(92);
        }
        String shortName = extensionStart > 0 ? name.substring(nameStart, extensionStart) : name.substring(++nameStart, name.length());
        return shortName;
    }
}

