/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.autotools.ui.actions;

import org.eclipse.cdt.internal.autotools.core.AutotoolsPropertyConstants;
import org.eclipse.cdt.internal.autotools.ui.actions.InvokeAction;
import org.eclipse.cdt.internal.autotools.ui.actions.InvokeMessages;
import org.eclipse.cdt.internal.autotools.ui.actions.SingleInputDialog;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.widgets.Shell;

public class InvokeAutoheaderAction
extends InvokeAction {
    private static final String DEFAULT_OPTION = "";
    private static final String DEFAULT_COMMAND = "autoheader";

    public void run(IAction action) {
        IContainer container = this.getSelectedContainer();
        if (container == null) {
            return;
        }
        IPath execDir = this.getExecDir(container);
        String cwd = String.valueOf(InvokeMessages.getString("CWD")) + this.getCWD(container);
        SingleInputDialog optionDialog = new SingleInputDialog(new Shell(), cwd, InvokeMessages.getString("InvokeAutoheaderAction.windowTitle.options"), InvokeMessages.getString("InvokeAutoheaderAction.message.options.otherOptions"), DEFAULT_OPTION, null);
        optionDialog.open();
        String rawArgList = optionDialog.getValue();
        String[] optionsList = this.simpleParseOptions(rawArgList);
        String[] argumentList = new String[optionsList.length];
        System.arraycopy(optionsList, 0, argumentList, 0, optionsList.length);
        if (container != null) {
            String autoheaderCommand = null;
            IProject project = this.getSelectedContainer().getProject();
            try {
                autoheaderCommand = project.getPersistentProperty(AutotoolsPropertyConstants.AUTOHEADER_TOOL);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            if (autoheaderCommand == null) {
                autoheaderCommand = DEFAULT_COMMAND;
            }
            this.executeConsoleCommand(DEFAULT_COMMAND, autoheaderCommand, argumentList, execDir);
        }
    }

    public void dispose() {
    }
}

