/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.internal.checkers;

import java.util.HashMap;
import org.eclipse.cdt.codan.checkers.CodanCheckersActivator;
import org.eclipse.cdt.codan.core.cxx.CxxAstUtils;
import org.eclipse.cdt.codan.core.cxx.model.AbstractIndexAstChecker;
import org.eclipse.cdt.codan.core.model.CheckerLaunchMode;
import org.eclipse.cdt.codan.core.model.IProblem;
import org.eclipse.cdt.codan.core.model.IProblemWorkingCopy;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNamedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNewExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.SemanticQueries;
import org.eclipse.cdt.core.parser.util.StringUtil;

public class AbstractClassInstantiationChecker
extends AbstractIndexAstChecker {
    public static final String ER_ID = "org.eclipse.cdt.codan.internal.checkers.AbstractClassCreation";
    private final HashMap<ICPPClassType, ICPPMethod[]> pureVirtualMethodsCache = new HashMap();

    public void initPreferences(IProblemWorkingCopy problem) {
        super.initPreferences(problem);
        this.getLaunchModePreference((IProblem)problem).enableInLaunchModes(new CheckerLaunchMode[]{CheckerLaunchMode.RUN_AS_YOU_TYPE, CheckerLaunchMode.RUN_ON_DEMAND});
    }

    public void processAst(IASTTranslationUnit ast) {
        try {
            ast.accept((ASTVisitor)new OnEachClass());
        }
        finally {
            this.pureVirtualMethodsCache.clear();
        }
    }

    class OnEachClass
    extends ASTVisitor {
        OnEachClass() {
            this.shouldVisitDeclarations = true;
            this.shouldVisitExpressions = true;
            this.shouldVisitParameterDeclarations = true;
        }

        public int visit(IASTDeclaration declaration) {
            IASTSimpleDeclaration simpleDecl;
            IASTDeclSpecifier declSpec;
            if (declaration instanceof IASTSimpleDeclaration && (declSpec = (simpleDecl = (IASTSimpleDeclaration)declaration).getDeclSpecifier()).getStorageClass() != 1) {
                IASTDeclarator[] iASTDeclaratorArray = simpleDecl.getDeclarators();
                int n = iASTDeclaratorArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IASTDeclarator declarator = iASTDeclaratorArray[n2];
                    if (!this.hasPointerOrReference(declarator)) {
                        this.checkClass(declSpec);
                        break;
                    }
                    ++n2;
                }
            }
            return 3;
        }

        public int visit(IASTParameterDeclaration parameterDecl) {
            if (!this.hasPointerOrReference(parameterDecl.getDeclarator())) {
                this.checkClass(parameterDecl.getDeclSpecifier());
            }
            return 3;
        }

        private boolean hasPointerOrReference(IASTDeclarator declarator) {
            return declarator.getPointerOperators().length != 0;
        }

        private void checkClass(IASTDeclSpecifier declSpec) {
            IASTName className;
            IBinding binding;
            if (declSpec instanceof ICPPASTNamedTypeSpecifier && (binding = (className = ((ICPPASTNamedTypeSpecifier)declSpec).getName()).resolveBinding()) instanceof IType) {
                this.reportProblemsIfAbstract((IType)binding, (IASTNode)className);
            }
        }

        public int visit(IASTExpression expression) {
            ICPPASTFunctionCallExpression functionCall;
            IASTExpression functionName;
            if (expression instanceof ICPPASTNewExpression) {
                IASTDeclSpecifier declSpecifier;
                ICPPASTNewExpression newExpression = (ICPPASTNewExpression)expression;
                if (!this.hasPointerOrReference(newExpression.getTypeId().getAbstractDeclarator()) && (declSpecifier = newExpression.getTypeId().getDeclSpecifier()) instanceof ICPPASTNamedTypeSpecifier) {
                    IASTName constructorName = ((ICPPASTNamedTypeSpecifier)declSpecifier).getName();
                    this.checkClassConstructor(constructorName);
                }
            } else if (expression instanceof ICPPASTFunctionCallExpression && (functionName = (functionCall = (ICPPASTFunctionCallExpression)expression).getFunctionNameExpression()) instanceof IASTIdExpression) {
                IASTName constructorName = ((IASTIdExpression)functionName).getName();
                this.checkClassConstructor(constructorName);
            }
            return 3;
        }

        private void checkClassConstructor(IASTName constructorName) {
            IBinding binding = constructorName.resolveBinding();
            if (binding instanceof ICPPConstructor) {
                this.reportProblemsIfAbstract((IType)((ICPPConstructor)binding).getClassOwner(), (IASTNode)constructorName);
            } else if (binding instanceof IType) {
                this.reportProblemsIfAbstract((IType)binding, (IASTNode)constructorName);
            }
        }

        private String resolveName(ICPPBinding binding) {
            try {
                if (binding.isGloballyQualified()) {
                    return StringUtil.join((String[])binding.getQualifiedName(), (String)"::");
                }
            }
            catch (DOMException e) {
                CodanCheckersActivator.log(e);
            }
            return binding.getName();
        }

        private void reportProblemsIfAbstract(IType typeToCheck, IASTNode problemNode) {
            IType unwindedType = CxxAstUtils.unwindTypedef((IType)typeToCheck);
            if (!(unwindedType instanceof ICPPClassType) || unwindedType instanceof IProblemBinding) {
                return;
            }
            ICPPClassType classType = (ICPPClassType)unwindedType;
            ICPPMethod[] pureVirtualMethods = (ICPPMethod[])AbstractClassInstantiationChecker.this.pureVirtualMethodsCache.get(classType);
            if (pureVirtualMethods == null) {
                pureVirtualMethods = SemanticQueries.getPureVirtualMethods((ICPPClassType)classType, (IASTNode)problemNode);
                AbstractClassInstantiationChecker.this.pureVirtualMethodsCache.put(classType, pureVirtualMethods);
            }
            ICPPMethod[] iCPPMethodArray = pureVirtualMethods;
            int n = pureVirtualMethods.length;
            int n2 = 0;
            while (n2 < n) {
                ICPPMethod method = iCPPMethodArray[n2];
                AbstractClassInstantiationChecker.this.reportProblem(AbstractClassInstantiationChecker.ER_ID, problemNode, new Object[]{this.resolveName((ICPPBinding)classType), this.resolveName((ICPPBinding)method)});
                ++n2;
            }
        }
    }
}

