/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.sourcelookup;

import java.io.File;
import java.util.List;
import org.eclipse.cdt.debug.core.sourcelookup.MappingSourceContainer;
import org.eclipse.cdt.debug.internal.core.sourcelookup.MapEntrySourceContainer;
import org.eclipse.cdt.debug.internal.ui.CDebugImages;
import org.eclipse.cdt.debug.internal.ui.ICDebugHelpContextIds;
import org.eclipse.cdt.debug.internal.ui.sourcelookup.SourceLookupUIMessages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class PathMappingDialog
extends TitleAreaDialog {
    private MappingSourceContainer fOriginalMapping;
    protected MappingSourceContainer fMapping;
    private TableViewer fViewer;
    private Text fNameText;
    private Button fAddButton;
    private Button fEditButton;
    private Button fRemoveButton;

    public PathMappingDialog(Shell parentShell, MappingSourceContainer mapping) {
        super(parentShell);
        this.fOriginalMapping = mapping;
        this.fMapping = this.fOriginalMapping.copy();
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.updateButtons();
        return control;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(SourceLookupUIMessages.PathMappingDialog_11);
        this.setTitleImage(CDebugImages.get("org.eclipse.cdt.debug.ui.mapping_wiz.gif"));
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        composite.setLayoutData((Object)data);
        composite.setFont(font);
        Dialog.applyDialogFont((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getShell(), ICDebugHelpContextIds.SOURCE_PATH_MAPPING_DIALOG);
        Composite nameComp = new Composite(composite, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        nameComp.setLayout((Layout)layout);
        data = new GridData(768);
        data.horizontalSpan = 2;
        nameComp.setLayoutData((Object)data);
        nameComp.setFont(font);
        Label label = new Label(nameComp, 16384);
        data = new GridData(32);
        label.setLayoutData((Object)data);
        label.setFont(font);
        label.setText(SourceLookupUIMessages.PathMappingDialog_12);
        this.fNameText = new Text(nameComp, 2052);
        data = new GridData(768);
        this.fNameText.setLayoutData((Object)data);
        this.fNameText.setFont(font);
        this.fNameText.setText(this.getMapping().getName());
        this.fNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
            }
        });
        this.fViewer = this.createViewer(composite);
        data = new GridData(1808);
        this.fViewer.getControl().setLayoutData((Object)data);
        this.fViewer.getControl().setFont(font);
        this.fViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                PathMappingDialog.this.updateButtons();
            }
        });
        Composite buttonComp = new Composite(composite, 0);
        GridLayout buttonLayout = new GridLayout();
        buttonLayout.marginHeight = 0;
        buttonLayout.marginWidth = 0;
        buttonComp.setLayout((Layout)buttonLayout);
        data = new GridData(258);
        buttonComp.setLayoutData((Object)data);
        buttonComp.setFont(font);
        GC gc = new GC((Drawable)parent);
        gc.setFont(parent.getFont());
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        this.fAddButton = this.createPushButton(buttonComp, SourceLookupUIMessages.PathMappingDialog_13, fontMetrics);
        this.fAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                MapEntryDialog dialog = new MapEntryDialog(PathMappingDialog.this.getShell());
                if (dialog.open() == 0) {
                    PathMappingDialog.this.getViewer().refresh();
                }
            }
        });
        this.fEditButton = this.createPushButton(buttonComp, SourceLookupUIMessages.PathMappingDialog_14, fontMetrics);
        this.fEditButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                MapEntryDialog dialog;
                MapEntrySourceContainer[] entries = PathMappingDialog.this.getSelection();
                if (entries.length > 0 && (dialog = new MapEntryDialog(PathMappingDialog.this.getShell(), entries[0])).open() == 0) {
                    PathMappingDialog.this.getViewer().refresh();
                }
            }
        });
        this.fRemoveButton = this.createPushButton(buttonComp, SourceLookupUIMessages.PathMappingDialog_15, fontMetrics);
        this.fRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                MapEntrySourceContainer[] entries = PathMappingDialog.this.getSelection();
                int i = 0;
                while (i < entries.length) {
                    PathMappingDialog.this.fMapping.removeMapEntry(entries[i]);
                    ++i;
                }
                PathMappingDialog.this.getViewer().refresh();
            }
        });
        this.setMessage(null);
        this.fViewer.setInput((Object)this.fMapping);
        return composite;
    }

    private TableViewer createViewer(Composite parent) {
        TableViewer viewer = new TableViewer(parent);
        viewer.setContentProvider((IContentProvider)new ContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new PathMappingLabelProvider());
        return viewer;
    }

    protected MappingSourceContainer getMapping() {
        return this.fOriginalMapping;
    }

    protected Button createPushButton(Composite parent, String label, FontMetrics fontMetrics) {
        Button button = new Button(parent, 8);
        button.setFont(parent.getFont());
        button.setText(label);
        GridData gd = this.getButtonGridData(button, fontMetrics);
        button.setLayoutData((Object)gd);
        return button;
    }

    private GridData getButtonGridData(Button button, FontMetrics fontMetrics) {
        GridData gd = new GridData(770);
        int widthHint = Dialog.convertHorizontalDLUsToPixels((FontMetrics)fontMetrics, (int)61);
        gd.widthHint = Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
        return gd;
    }

    protected void configureShell(Shell newShell) {
        newShell.setText(SourceLookupUIMessages.PathMappingDialog_16);
        super.configureShell(newShell);
    }

    protected Viewer getViewer() {
        return this.fViewer;
    }

    protected void okPressed() {
        this.fOriginalMapping.clear();
        this.fOriginalMapping.setName(this.fNameText.getText().trim());
        try {
            this.fOriginalMapping.addMapEntries((MapEntrySourceContainer[])this.fMapping.getSourceContainers());
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        this.fMapping.dispose();
        super.okPressed();
    }

    protected MapEntrySourceContainer[] getSelection() {
        MapEntrySourceContainer[] result = new MapEntrySourceContainer[]{};
        ISelection s = this.getViewer().getSelection();
        if (s instanceof IStructuredSelection) {
            int size = ((IStructuredSelection)s).size();
            List list = ((IStructuredSelection)s).toList();
            result = list.toArray(new MapEntrySourceContainer[size]);
        }
        return result;
    }

    protected void updateButtons() {
        MapEntrySourceContainer[] entries = this.getSelection();
        if (this.fEditButton != null) {
            this.fEditButton.setEnabled(entries.length == 1);
        }
        if (this.fRemoveButton != null) {
            this.fRemoveButton.setEnabled(entries.length > 0);
        }
    }

    class ContentProvider
    implements IStructuredContentProvider {
        ContentProvider() {
        }

        public Object[] getElements(Object input) {
            if (input instanceof MappingSourceContainer) {
                try {
                    return ((MappingSourceContainer)input).getSourceContainers();
                }
                catch (CoreException e) {
                    PathMappingDialog.this.setErrorMessage(e.getMessage());
                }
            }
            return null;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class MapEntryDialog
    extends TitleAreaDialog {
        private MapEntrySourceContainer fEntry;
        protected Text fBackendPathText;
        protected Text fLocalPathText;

        public MapEntryDialog(Shell parentShell) {
            super(parentShell);
            this.fEntry = null;
        }

        public MapEntryDialog(Shell parentShell, MapEntrySourceContainer entry) {
            super(parentShell);
            this.fEntry = entry;
        }

        protected Control createDialogArea(Composite parent) {
            this.setTitle(SourceLookupUIMessages.PathMappingDialog_0);
            this.setTitleImage(CDebugImages.get("org.eclipse.cdt.debug.ui.mapentry_wiz.gif"));
            Font font = parent.getFont();
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            layout.marginHeight = this.convertVerticalDLUsToPixels(7);
            layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
            layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
            layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
            composite.setLayout((Layout)layout);
            GridData data = new GridData(1808);
            composite.setLayoutData((Object)data);
            composite.setFont(font);
            Dialog.applyDialogFont((Control)composite);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getShell(), ICDebugHelpContextIds.SOURCE_PATH_MAP_ENTRY_DIALOG);
            this.setMessage(null);
            Label label = new Label(composite, 16384);
            label.setText(SourceLookupUIMessages.PathMappingDialog_1);
            data = new GridData(768);
            data.horizontalSpan = 2;
            label.setLayoutData((Object)data);
            label.setFont(font);
            this.fBackendPathText = new Text(composite, 2052);
            data = new GridData(768);
            data.horizontalSpan = 2;
            this.fBackendPathText.setLayoutData((Object)data);
            this.fBackendPathText.setFont(font);
            this.fBackendPathText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    MapEntryDialog.this.update();
                }
            });
            label = new Label(composite, 16384);
            label.setText(SourceLookupUIMessages.PathMappingDialog_2);
            data = new GridData(768);
            data.horizontalSpan = 2;
            label.setLayoutData((Object)data);
            label.setFont(font);
            this.fLocalPathText = new Text(composite, 2052);
            data = new GridData(768);
            this.fLocalPathText.setLayoutData((Object)data);
            this.fLocalPathText.setFont(font);
            this.fLocalPathText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    MapEntryDialog.this.update();
                }
            });
            Button button = new Button(composite, 8);
            button.setFont(font);
            button.setText(SourceLookupUIMessages.PathMappingDialog_3);
            button.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    DirectoryDialog dialog = new DirectoryDialog(MapEntryDialog.this.getShell());
                    String path = dialog.open();
                    if (path != null) {
                        MapEntryDialog.this.fLocalPathText.setText(path);
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            return composite;
        }

        protected Control createContents(Composite parent) {
            Control control = super.createContents(parent);
            this.initialize();
            this.update();
            return control;
        }

        protected void configureShell(Shell newShell) {
            newShell.setText(SourceLookupUIMessages.PathMappingDialog_4);
            super.configureShell(newShell);
        }

        private void initialize() {
            if (this.fEntry != null) {
                this.fBackendPathText.setText(this.fEntry.getBackendPath().toOSString());
                this.fLocalPathText.setText(this.fEntry.getLocalPath().toOSString());
            }
        }

        protected void update() {
            boolean isOk = this.updateErrorMessage();
            Button ok = this.getButton(0);
            if (ok != null) {
                ok.setEnabled(isOk);
            }
        }

        protected boolean updateErrorMessage() {
            this.setErrorMessage(null);
            String backendText = this.fBackendPathText.getText().trim();
            if (backendText.length() == 0) {
                this.setErrorMessage(SourceLookupUIMessages.PathMappingDialog_5);
                return false;
            }
            if (!new Path(backendText).isValidPath(backendText)) {
                this.setErrorMessage(SourceLookupUIMessages.PathMappingDialog_6);
                return false;
            }
            String localText = this.fLocalPathText.getText().trim();
            if (localText.length() == 0) {
                this.setErrorMessage(SourceLookupUIMessages.PathMappingDialog_7);
                return false;
            }
            File localPath = new File(localText);
            if (!localPath.exists()) {
                this.setErrorMessage(SourceLookupUIMessages.PathMappingDialog_8);
                return false;
            }
            if (!localPath.isDirectory()) {
                this.setErrorMessage(SourceLookupUIMessages.PathMappingDialog_9);
                return false;
            }
            if (!localPath.isAbsolute()) {
                this.setErrorMessage(SourceLookupUIMessages.PathMappingDialog_10);
                return false;
            }
            return true;
        }

        protected IPath getBackendPath() {
            return new Path(this.fBackendPathText.getText().trim());
        }

        protected IPath getLocalPath() {
            return new Path(this.fLocalPathText.getText().trim());
        }

        protected void okPressed() {
            if (this.fEntry == null) {
                this.fEntry = new MapEntrySourceContainer();
                PathMappingDialog.this.fMapping.addMapEntry(this.fEntry);
            }
            this.fEntry.setBackendPath(this.getBackendPath());
            this.fEntry.setLocalPath(this.getLocalPath());
            super.okPressed();
        }
    }

    class PathMappingLabelProvider
    extends LabelProvider {
        private ILabelProvider fLabelProvider = null;

        PathMappingLabelProvider() {
        }

        public Image getImage(Object element) {
            Image image = this.getWorkbenchLabelProvider().getImage(element);
            if (image != null) {
                return image;
            }
            return super.getImage(element);
        }

        public String getText(Object element) {
            String label = this.getWorkbenchLabelProvider().getText(element);
            if (label == null || label.length() == 0) {
                if (element instanceof ISourceContainer) {
                    return ((ISourceContainer)element).getName();
                }
            } else {
                return label;
            }
            return super.getText(element);
        }

        private ILabelProvider getWorkbenchLabelProvider() {
            if (this.fLabelProvider == null) {
                this.fLabelProvider = new WorkbenchLabelProvider();
            }
            return this.fLabelProvider;
        }

        public void dispose() {
            super.dispose();
            if (this.fLabelProvider != null) {
                this.fLabelProvider.dispose();
            }
        }
    }
}

