/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.gnu.templates;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.templateengine.TemplateCore;
import org.eclipse.cdt.core.templateengine.TemplateEngineHelper;
import org.eclipse.cdt.core.templateengine.process.ProcessArgument;
import org.eclipse.cdt.core.templateengine.process.ProcessFailureException;
import org.eclipse.cdt.core.templateengine.process.ProcessHelper;
import org.eclipse.cdt.core.templateengine.process.ProcessRunner;
import org.eclipse.cdt.core.templateengine.process.processes.Messages;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;

public class SimpleMakefileGenerator
extends ProcessRunner {
    private static final String MAKEFILE = "Makefile";
    private static final String START = "{{";
    private static final String END = "}}";

    public void process(TemplateCore template, ProcessArgument[] args, String processId, IProgressMonitor monitor) throws ProcessFailureException {
        String fileContents;
        URL path;
        String projectName = args[0].getSimpleValue();
        IProject projectHandle = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        try {
            path = TemplateEngineHelper.getTemplateResourceURLRelativeToTemplate((TemplateCore)template, (String)MAKEFILE);
            if (path == null) {
                throw new ProcessFailureException(this.getProcessMessage(processId, 4, String.valueOf(Messages.getString((String)"AddFile.0")) + MAKEFILE));
            }
        }
        catch (IOException e1) {
            throw new ProcessFailureException(this.getProcessMessage(processId, 4, String.valueOf(Messages.getString((String)"AddFile.1")) + MAKEFILE));
        }
        ByteArrayInputStream contents = null;
        try {
            fileContents = ProcessHelper.readFromFile((URL)path);
        }
        catch (IOException e) {
            throw new ProcessFailureException(this.getProcessMessage(processId, 4, String.valueOf(Messages.getString((String)"AddFile.2")) + MAKEFILE));
        }
        HashMap<String, String> macros = new HashMap<String, String>(template.getValueStore());
        macros.put("exe", Platform.getOS().equals("win32") ? ".exe" : "");
        fileContents = this.replaceMacros(fileContents, macros);
        contents = new ByteArrayInputStream(fileContents.getBytes());
        try {
            IFile iFile = projectHandle.getFile(MAKEFILE);
            if (!iFile.getParent().exists()) {
                ProcessHelper.mkdirs((IProject)projectHandle, (IFolder)projectHandle.getFolder(iFile.getParent().getProjectRelativePath()));
            }
            iFile.create((InputStream)contents, true, null);
            iFile.refreshLocal(1, null);
            projectHandle.refreshLocal(2, null);
        }
        catch (CoreException e) {
            throw new ProcessFailureException(this.getProcessMessage(processId, 4, String.valueOf(Messages.getString((String)"AddFile.4")) + e.getMessage()), (Throwable)e);
        }
    }

    private String replaceMacros(String fileContents, Map<String, String> valueStore) {
        StringBuffer buffer = new StringBuffer(fileContents);
        for (String key : valueStore.keySet()) {
            String pattern = START + key + END;
            if (fileContents.indexOf(pattern) == -1) continue;
            int len = pattern.length();
            int pos = 0;
            while ((pos = buffer.indexOf(pattern, pos)) >= 0) {
                buffer.replace(pos, pos + len, valueStore.get(key));
                pos += len;
            }
        }
        return buffer.toString();
    }
}

