/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.actions;

import java.util.ResourceBundle;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IParent;
import org.eclipse.cdt.core.model.ISourceRange;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;

public class GoToNextPreviousMemberAction
extends TextEditorAction {
    public static final String NEXT_MEMBER = "GotoNextMember";
    public static final String PREVIOUS_MEMBER = "GotoPrevMember";
    private boolean fGotoNext;

    public GoToNextPreviousMemberAction(ResourceBundle bundle, String prefix, ITextEditor editor, boolean gotoNext) {
        super(bundle, prefix, editor);
        this.fGotoNext = gotoNext;
    }

    public GoToNextPreviousMemberAction(ResourceBundle bundle, String prefix, ITextEditor editor, int style, boolean gotoNext) {
        super(bundle, prefix, editor, style);
        this.fGotoNext = gotoNext;
    }

    public void update() {
        ITextEditor editor = this.getTextEditor();
        this.setEnabled(editor instanceof CEditor && ((CEditor)editor).getInputCElement() != null);
    }

    public void run() {
        CEditor editor = (CEditor)this.getTextEditor();
        ITextSelection selection = (ITextSelection)editor.getSelectionProvider().getSelection();
        IEditorInput editorInput = editor.getEditorInput();
        IWorkingCopy workingCopy = CUIPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(editorInput);
        if (workingCopy == null) {
            return;
        }
        try {
            ISourceReference next;
            ISourceReference iSourceReference = next = this.fGotoNext ? this.getNextElement((IParent)workingCopy, selection.getOffset()) : this.getPrevElement((IParent)workingCopy, selection.getOffset());
            if (next != null) {
                editor.selectAndReveal(next.getSourceRange().getIdStartPos(), 0);
            }
        }
        catch (CModelException e) {
            CUIPlugin.log(e);
        }
    }

    private ISourceReference getNextElement(IParent parent, int offset) throws CModelException {
        ICElement[] children = parent.getChildren();
        int i = 0;
        while (i < children.length) {
            ICElement element = children[i];
            if (element instanceof ISourceReference) {
                ISourceReference candidate2;
                ISourceReference candidate1 = (ISourceReference)element;
                ISourceRange range = candidate1.getSourceRange();
                int idpos1 = range.getIdStartPos();
                if (element instanceof IParent && range.getStartPos() + range.getLength() > offset && (candidate2 = this.getNextElement((IParent)element, offset)) != null) {
                    int idpos2 = candidate2.getSourceRange().getIdStartPos();
                    if (idpos1 <= offset || idpos1 > idpos2) {
                        return candidate2;
                    }
                }
                if (idpos1 > offset) {
                    return candidate1;
                }
            }
            ++i;
        }
        return null;
    }

    private ISourceReference getPrevElement(IParent parent, int offset) throws CModelException {
        ICElement[] children = parent.getChildren();
        int i = children.length - 1;
        while (i >= 0) {
            ICElement element = children[i];
            if (element instanceof ISourceReference) {
                ISourceReference candidate2;
                ISourceReference candidate1 = (ISourceReference)element;
                ISourceRange range = candidate1.getSourceRange();
                int idpos1 = range.getIdStartPos();
                if (element instanceof IParent && range.getStartPos() < offset && (candidate2 = this.getPrevElement((IParent)element, offset)) != null) {
                    int idpos2 = candidate2.getSourceRange().getIdStartPos();
                    if (idpos1 >= offset || idpos1 < idpos2) {
                        return candidate2;
                    }
                }
                if (idpos1 < offset) {
                    return candidate1;
                }
            }
            --i;
        }
        return null;
    }
}

