/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui.operations;

import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.epp.internal.mpc.ui.MarketplaceClientUi;
import org.eclipse.epp.internal.mpc.ui.operations.AbstractProvisioningOperation;
import org.eclipse.epp.internal.mpc.ui.operations.CompositeProfileChangeOperation;
import org.eclipse.epp.internal.mpc.ui.operations.Messages;
import org.eclipse.epp.internal.mpc.ui.wizards.SelectionModel;
import org.eclipse.epp.mpc.ui.Operation;
import org.eclipse.equinox.internal.p2.discovery.model.CatalogItem;
import org.eclipse.equinox.internal.p2.ui.discovery.util.WorkbenchUtil;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.operations.InstallOperation;
import org.eclipse.equinox.p2.operations.ProfileChangeOperation;
import org.eclipse.equinox.p2.operations.ProvisioningSession;
import org.eclipse.equinox.p2.operations.RemediationOperation;
import org.eclipse.equinox.p2.operations.RepositoryTracker;
import org.eclipse.equinox.p2.operations.UninstallOperation;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.ui.ProvisioningUI;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfileChangeOperationComputer
extends AbstractProvisioningOperation {
    private final OperationType operationType;
    private final List<SelectionModel.FeatureEntry> featureEntries;
    private ProfileChangeOperation operation;
    private IInstallableUnit[] ius;
    private final ResolutionStrategy resolutionStrategy;
    private final URI dependenciesRepository;
    private final boolean withRemediation;
    private String errorMessage;

    public ProfileChangeOperationComputer(OperationType operationType, Collection<CatalogItem> items, Collection<SelectionModel.FeatureEntry> featureEntries, URI dependenciesRepository, ResolutionStrategy resolutionStrategy, boolean withRemediation) {
        super(items);
        if (featureEntries == null || featureEntries.isEmpty()) {
            throw new IllegalArgumentException();
        }
        if (operationType == null) {
            throw new IllegalArgumentException();
        }
        if (resolutionStrategy == null) {
            throw new IllegalArgumentException();
        }
        this.featureEntries = new ArrayList<SelectionModel.FeatureEntry>(featureEntries);
        this.operationType = operationType;
        this.resolutionStrategy = resolutionStrategy;
        this.dependenciesRepository = dependenciesRepository;
        this.withRemediation = withRemediation;
    }

    public void run(IProgressMonitor progressMonitor) throws InvocationTargetException, InterruptedException {
        try {
            boolean hasInstall = this.hasInstall();
            boolean hasUninstall = this.hasUninstall();
            SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progressMonitor, (String)Messages.ProvisioningOperation_configuringProvisioningOperation, (int)(1000 + (hasInstall ? 500 : 0) + (hasUninstall ? 100 : 0)));
            try {
                IInstallableUnit[] uninstallIUs = null;
                this.ius = hasInstall ? this.computeInstallableUnits((IProgressMonitor)monitor.newChild(500)) : new IInstallableUnit[0];
                if (hasUninstall) {
                    uninstallIUs = this.computeUninstallUnits((IProgressMonitor)monitor.newChild(100));
                }
                this.checkCancelled((IProgressMonitor)monitor);
                URI[] repositories = this.repositoryLocations == null ? new URI[]{} : this.repositoryLocations.toArray(new URI[0]);
                switch (this.operationType) {
                    case INSTALL: {
                        this.operation = this.resolveInstall((IProgressMonitor)monitor.newChild(500), this.ius, repositories);
                        break;
                    }
                    case UPDATE: {
                        this.operation = this.resolveUpdate((IProgressMonitor)monitor.newChild(500), this.computeInstalledIus(this.ius), repositories);
                        break;
                    }
                    case UNINSTALL: {
                        this.operation = this.resolveUninstall((IProgressMonitor)monitor.newChild(500), uninstallIUs, repositories);
                        break;
                    }
                    case CHANGE: {
                        this.operation = this.resolveChange((IProgressMonitor)monitor.newChild(500), this.ius, uninstallIUs, repositories);
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException(this.operationType.name());
                    }
                }
                if (this.withRemediation && this.operation != null && this.operation.getResolutionResult().getSeverity() == 4) {
                    RemediationOperation remediationOperation = new RemediationOperation(ProvisioningUI.getDefaultUI().getSession(), this.operation.getProfileChangeRequest());
                    remediationOperation.resolveModal((IProgressMonitor)monitor.newChild(500));
                    if (remediationOperation.getResolutionResult() == Status.OK_STATUS) {
                        this.errorMessage = this.operation.getResolutionDetails();
                        this.operation = remediationOperation;
                    }
                }
                this.checkCancelled((IProgressMonitor)monitor);
            }
            finally {
                monitor.done();
            }
        }
        catch (OperationCanceledException operationCanceledException) {
            throw new InterruptedException();
        }
        catch (Exception e) {
            throw new InvocationTargetException(e);
        }
    }

    private boolean hasInstall() {
        switch (this.operationType) {
            case INSTALL: 
            case UPDATE: {
                return true;
            }
            case UNINSTALL: {
                return false;
            }
            case CHANGE: {
                for (SelectionModel.FeatureEntry entry : this.featureEntries) {
                    Operation operation = entry.computeChangeOperation();
                    if (operation != Operation.INSTALL && operation != Operation.UPDATE) continue;
                    return true;
                }
                break;
            }
        }
        return false;
    }

    private boolean hasUninstall() {
        switch (this.operationType) {
            case INSTALL: 
            case UPDATE: {
                return false;
            }
            case UNINSTALL: {
                return true;
            }
            case CHANGE: {
                for (SelectionModel.FeatureEntry entry : this.featureEntries) {
                    if (entry.computeChangeOperation() != Operation.UNINSTALL) continue;
                    return true;
                }
                break;
            }
        }
        return false;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    private IInstallableUnit[] computeInstalledIus(IInstallableUnit[] ius) {
        ArrayList<IInstallableUnit> installedIus = new ArrayList<IInstallableUnit>(ius.length);
        Map<String, IInstallableUnit> iUsById = MarketplaceClientUi.computeInstalledIUsById((IProgressMonitor)new NullProgressMonitor());
        IInstallableUnit[] iInstallableUnitArray = ius;
        int n = ius.length;
        int n2 = 0;
        while (n2 < n) {
            IInstallableUnit iu = iInstallableUnitArray[n2];
            IInstallableUnit installedIu = iUsById.get(iu.getId());
            installedIus.add(installedIu);
            ++n2;
        }
        return installedIus.toArray(new IInstallableUnit[installedIus.size()]);
    }

    public ProfileChangeOperation getOperation() {
        return this.operation;
    }

    public IInstallableUnit[] getIus() {
        return this.ius;
    }

    private ProfileChangeOperation resolveInstall(IProgressMonitor monitor, IInstallableUnit[] ius, URI[] repositories) throws CoreException {
        return this.resolve(monitor, new ProfileChangeOperationFactory(){

            @Override
            public ProfileChangeOperation create(List<IInstallableUnit> ius) throws CoreException {
                return ProfileChangeOperationComputer.this.provisioningUI.getInstallOperation(ius, null);
            }
        }, ius, repositories);
    }

    private ProfileChangeOperation resolveUninstall(IProgressMonitor monitor, IInstallableUnit[] ius, URI[] repositories) throws CoreException {
        return this.resolve(monitor, new ProfileChangeOperationFactory(){

            @Override
            public ProfileChangeOperation create(List<IInstallableUnit> ius) throws CoreException {
                return ProfileChangeOperationComputer.this.provisioningUI.getUninstallOperation(ius, null);
            }
        }, ius, repositories);
    }

    private ProfileChangeOperation resolveUpdate(IProgressMonitor monitor, IInstallableUnit[] ius, URI[] repositories) throws CoreException {
        return this.resolve(monitor, new ProfileChangeOperationFactory(){

            @Override
            public ProfileChangeOperation create(List<IInstallableUnit> ius) throws CoreException {
                return ProfileChangeOperationComputer.this.provisioningUI.getUpdateOperation(ius, null);
            }
        }, ius, repositories);
    }

    private ProfileChangeOperation resolveChange(IProgressMonitor monitor, IInstallableUnit[] ius, final IInstallableUnit[] uninstallIUs, URI[] repositories) throws CoreException {
        return this.resolve(monitor, new ProfileChangeOperationFactory(){

            @Override
            public ProfileChangeOperation create(List<IInstallableUnit> ius) throws CoreException {
                InstallOperation installOperation = ProfileChangeOperationComputer.this.provisioningUI.getInstallOperation(ius, null);
                UninstallOperation uninstallOperation = ProfileChangeOperationComputer.this.provisioningUI.getUninstallOperation(Arrays.asList(uninstallIUs), null);
                CompositeProfileChangeOperation operation = new CompositeProfileChangeOperation(ProfileChangeOperationComputer.this.provisioningUI.getSession());
                operation.setProfileId(ProfileChangeOperationComputer.this.provisioningUI.getProfileId());
                ProvisioningContext provisioningContext = installOperation.getProvisioningContext();
                operation.setProvisioningContext(provisioningContext);
                uninstallOperation.setProvisioningContext(provisioningContext);
                operation.add((ProfileChangeOperation)uninstallOperation).add((ProfileChangeOperation)installOperation);
                return operation;
            }
        }, ius, repositories);
    }

    private ProfileChangeOperation resolve(IProgressMonitor monitor, ProfileChangeOperationFactory operationFactory, IInstallableUnit[] ius, URI[] repositories) throws CoreException {
        List<IInstallableUnit> installableUnits = Arrays.asList(ius);
        ArrayList<ResolutionStrategy> strategies = new ArrayList<ResolutionStrategy>(2);
        switch (this.resolutionStrategy) {
            case FALLBACK_STRATEGY: {
                strategies.add(ResolutionStrategy.SELECTED_REPOSITORIES);
                strategies.add(ResolutionStrategy.ALL_REPOSITORIES);
                break;
            }
            default: {
                strategies.add(this.resolutionStrategy);
            }
        }
        ProvisioningSession session = ProvisioningUI.getDefaultUI().getSession();
        RepositoryTracker repositoryTracker = ProvisioningUI.getDefaultUI().getRepositoryTracker();
        URI[] knownRepositories = repositoryTracker.getKnownRepositories(session);
        ProfileChangeOperation operation = null;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(strategies.size() * 1000 + 1000));
        HashSet<URI> previousRepositoryLocations = null;
        for (ResolutionStrategy strategy : strategies) {
            HashSet<URI> repositoryLocations = new HashSet<URI>(Arrays.asList(repositories));
            if (strategy == ResolutionStrategy.SELECTED_REPOSITORIES) {
                repositoryLocations.addAll(Arrays.asList(repositories));
            }
            if (this.dependenciesRepository != null) {
                repositoryLocations.add(this.dependenciesRepository);
            }
            if (strategy == ResolutionStrategy.ALL_REPOSITORIES && !repositoryLocations.isEmpty()) {
                repositoryLocations.addAll(Arrays.asList(knownRepositories));
            }
            if (repositoryLocations.equals(previousRepositoryLocations)) continue;
            operation = operationFactory.create(installableUnits);
            if (!repositoryLocations.isEmpty()) {
                URI[] locations = repositoryLocations.toArray(new URI[repositoryLocations.size()]);
                operation.getProvisioningContext().setMetadataRepositories(locations);
                operation.getProvisioningContext().setArtifactRepositories(locations);
            }
            this.resolveModal((IProgressMonitor)subMonitor.newChild(1000), operation);
            if (operation.getResolutionResult() != null && operation.getResolutionResult().getSeverity() != 4) break;
            previousRepositoryLocations = repositoryLocations;
        }
        return operation;
    }

    public void resolveModal(IProgressMonitor monitor, ProfileChangeOperation operation) throws CoreException {
        operation.resolveModal((IProgressMonitor)new SubProgressMonitor(monitor, this.items.size()));
    }

    public IInstallableUnit[] computeInstallableUnits(IProgressMonitor monitor) throws CoreException {
        try {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            List<IMetadataRepository> repositories = this.addRepositories(progress.newChild(50));
            List<IInstallableUnit> installableUnits = this.queryInstallableUnits(progress.newChild(50), repositories);
            this.checkForUnavailable(installableUnits);
            this.pruneNonInstall(installableUnits);
            this.pruneOlderVersions(installableUnits);
            IInstallableUnit[] iInstallableUnitArray = installableUnits.toArray(new IInstallableUnit[installableUnits.size()]);
            return iInstallableUnitArray;
        }
        catch (URISyntaxException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.epp.mpc.ui", Messages.ProvisioningOperation_unexpectedErrorUrl, (Throwable)e));
        }
        finally {
            monitor.done();
        }
    }

    public IInstallableUnit[] computeUninstallUnits(IProgressMonitor monitor) throws CoreException {
        try {
            Map<String, IInstallableUnit> installedIUs = MarketplaceClientUi.computeInstalledIUsById(monitor);
            ArrayList<IInstallableUnit> installableUnits = new ArrayList<IInstallableUnit>(installedIUs.values());
            this.pruneNonUninstall(installableUnits);
            IInstallableUnit[] iInstallableUnitArray = installableUnits.toArray(new IInstallableUnit[installableUnits.size()]);
            return iInstallableUnitArray;
        }
        finally {
            monitor.done();
        }
    }

    private void pruneOlderVersions(List<IInstallableUnit> installableUnits) throws CoreException {
        if (!installableUnits.isEmpty()) {
            Map<String, IInstallableUnit> iUsById = MarketplaceClientUi.computeInstalledIUsById((IProgressMonitor)new NullProgressMonitor());
            Iterator<IInstallableUnit> it = installableUnits.iterator();
            while (it.hasNext()) {
                Version installableVersion;
                Version installedVersion;
                IInstallableUnit iu = it.next();
                IInstallableUnit installedIu = iUsById.get(iu.getId());
                if (installedIu == null || (installedVersion = installedIu.getVersion()).compareTo((Object)(installableVersion = iu.getVersion())) < 0) continue;
                it.remove();
            }
            if (installableUnits.isEmpty()) {
                throw new CoreException((IStatus)new Status(1, "org.eclipse.epp.mpc.ui", Messages.ProvisioningOperation_nothingToUpdate));
            }
        }
    }

    private void pruneNonInstall(List<IInstallableUnit> installableUnits) {
        HashSet<String> installableFeatureIds = new HashSet<String>();
        for (SelectionModel.FeatureEntry featureEntry : this.featureEntries) {
            Operation operation = featureEntry.computeChangeOperation();
            if (operation != Operation.INSTALL && operation != Operation.UPDATE) continue;
            installableFeatureIds.add(featureEntry.getFeatureDescriptor().getId());
        }
        Iterator<IInstallableUnit> it = installableUnits.iterator();
        while (it.hasNext()) {
            IInstallableUnit iu = it.next();
            if (installableFeatureIds.contains(iu.getId())) continue;
            it.remove();
        }
    }

    private void pruneNonUninstall(List<IInstallableUnit> installableUnits) {
        HashSet<String> installableFeatureIds = new HashSet<String>();
        for (SelectionModel.FeatureEntry featureEntry : this.featureEntries) {
            if (featureEntry.computeChangeOperation() != Operation.UNINSTALL) continue;
            installableFeatureIds.add(featureEntry.getFeatureDescriptor().getId());
        }
        Iterator<IInstallableUnit> it = installableUnits.iterator();
        while (it.hasNext()) {
            IInstallableUnit iu = it.next();
            if (installableFeatureIds.contains(iu.getId())) continue;
            it.remove();
        }
    }

    private void checkForUnavailable(List<IInstallableUnit> installableUnits) throws CoreException {
        HashSet<String> foundIds = new HashSet<String>();
        for (IInstallableUnit unit : installableUnits) {
            foundIds.add(unit.getId());
        }
        HashSet<String> installFeatureIds = new HashSet<String>();
        for (SelectionModel.FeatureEntry entry : this.featureEntries) {
            Operation operation = entry.computeChangeOperation();
            if (operation != Operation.INSTALL && operation != Operation.UPDATE) continue;
            installFeatureIds.add(entry.getFeatureDescriptor().getId());
        }
        String message = "";
        String detailedMessage = "";
        for (CatalogItem descriptor : this.items) {
            StringBuilder unavailableIds = null;
            for (String id : this.getFeatureIds(descriptor)) {
                if (foundIds.contains(id) || !installFeatureIds.contains(id)) continue;
                if (unavailableIds == null) {
                    unavailableIds = new StringBuilder();
                } else {
                    unavailableIds.append(Messages.ProvisioningOperation_commaSeparator);
                }
                unavailableIds.append(id);
            }
            if (unavailableIds == null) continue;
            if (message.length() > 0) {
                message = String.valueOf(message) + Messages.ProvisioningOperation_commaSeparator;
            }
            message = String.valueOf(message) + descriptor.getName();
            if (detailedMessage.length() > 0) {
                detailedMessage = String.valueOf(detailedMessage) + Messages.ProvisioningOperation_commaSeparator;
            }
            detailedMessage = String.valueOf(detailedMessage) + NLS.bind((String)Messages.ProvisioningOperation_unavailableFeatures, (Object[])new Object[]{descriptor.getName(), unavailableIds.toString(), descriptor.getSiteUrl()});
        }
        if (message.length() > 0) {
            final boolean[] okayToProceed = new boolean[1];
            final String finalMessage = message;
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    okayToProceed[0] = MessageDialog.openQuestion((Shell)WorkbenchUtil.getShell(), (String)Messages.ProvisioningOperation_proceedQuestion, (String)NLS.bind((String)Messages.ProvisioningOperation_unavailableSolutions_proceedQuestion, (Object[])new Object[]{finalMessage}));
                }
            });
            if (!okayToProceed[0]) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.epp.mpc.ui", NLS.bind((String)Messages.ProvisioningOperation_unavailableSolutions, (Object)detailedMessage), null));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OperationType {
        INSTALL,
        UPDATE,
        UNINSTALL,
        CHANGE;


        public static OperationType map(Operation operation) {
            if (operation == null) {
                return null;
            }
            switch (operation) {
                case INSTALL: {
                    return INSTALL;
                }
                case UNINSTALL: {
                    return UNINSTALL;
                }
                case UPDATE: {
                    return UPDATE;
                }
                case CHANGE: {
                    return CHANGE;
                }
                case NONE: {
                    return null;
                }
            }
            throw new IllegalArgumentException(NLS.bind((String)Messages.ProfileChangeOperationComputer_unknownOperation, (Object)((Object)operation)));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface ProfileChangeOperationFactory {
        public ProfileChangeOperation create(List<IInstallableUnit> var1) throws CoreException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ResolutionStrategy {
        ALL_REPOSITORIES,
        SELECTED_REPOSITORIES,
        FALLBACK_STRATEGY;

    }
}

