/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.action.local;

import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.team.svn.core.IStateFilter;
import org.eclipse.team.svn.core.operation.CompositeOperation;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.local.JavaHLMergeOperation;
import org.eclipse.team.svn.core.operation.local.RefreshResourcesOperation;
import org.eclipse.team.svn.core.operation.local.RestoreProjectMetaOperation;
import org.eclipse.team.svn.core.operation.local.SaveProjectMetaOperation;
import org.eclipse.team.svn.core.operation.remote.LocateResourceURLInHistoryOperation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.resource.IRepositoryResourceProvider;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.ui.SVNTeamUIPlugin;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.action.AbstractNonRecursiveTeamAction;
import org.eclipse.team.svn.ui.dialog.AdvancedDialog;
import org.eclipse.team.svn.ui.dialog.OperationErrorDialog;
import org.eclipse.team.svn.ui.operation.ShowMergeViewOperation;
import org.eclipse.team.svn.ui.panel.local.MergePanel;
import org.eclipse.team.svn.ui.preferences.SVNTeamPreferences;

public class MergeAction
extends AbstractNonRecursiveTeamAction {
    public void runImpl(IAction action) {
        IResource[] resources = this.getSelectedResources(IStateFilter.SF_EXCLUDE_DELETED);
        if (!OperationErrorDialog.isAcceptableAtOnce(resources, SVNUIMessages.MergeAction_MergeError, this.getShell())) {
            return;
        }
        IRepositoryResource remote = SVNRemoteStorage.instance().asRepositoryResource(resources[0]);
        long revision = SVNRemoteStorage.instance().asLocalResourceAccessible(resources[0]).getRevision();
        if (resources.length > 1) {
            revision = -1L;
            remote = remote.getRoot();
        }
        MergePanel panel = new MergePanel(resources, remote, revision);
        AdvancedDialog dialog = new AdvancedDialog(this.getShell(), panel);
        if (dialog.open() == 0) {
            LocateResourceURLInHistoryOperation locateFirst = new LocateResourceURLInHistoryOperation(panel.getFirstSelection());
            LocateResourceURLInHistoryOperation locateSecond = null;
            LocateResourceURLInHistoryOperation firstSet = locateFirst;
            LocateResourceURLInHistoryOperation secondSet = null;
            if (panel.getMode() == 0) {
                firstSet = new IRepositoryResourceProvider.DefaultRepositoryResourceProvider(panel.getFirstSelection());
            } else if (panel.getMode() == 1) {
                secondSet = locateSecond = new LocateResourceURLInHistoryOperation(panel.getSecondSelection());
            }
            ShowMergeViewOperation mergeOp = null;
            if (SVNTeamPreferences.getMergeBoolean(SVNTeamUIPlugin.instance().getPreferenceStore(), "useJavaHL")) {
                JavaHLMergeOperation mainOp = null;
                mainOp = panel.getMode() == 1 ? new JavaHLMergeOperation(resources, (IRepositoryResourceProvider)firstSet, (IRepositoryResourceProvider)secondSet, false, panel.getIgnoreAncestry(), panel.getDepth()) : (panel.getMode() == 0 ? new JavaHLMergeOperation(resources, (IRepositoryResourceProvider)firstSet, panel.getSelectedRevisions(), false, panel.getIgnoreAncestry(), panel.getDepth()) : new JavaHLMergeOperation(resources, (IRepositoryResourceProvider)firstSet, false));
                mainOp.setRecordOnly(panel.getRecordOnly());
                CompositeOperation op = new CompositeOperation(mainOp.getId(), mainOp.getMessagesClass());
                SaveProjectMetaOperation saveOp = new SaveProjectMetaOperation(resources);
                op.add((IActionOperation)saveOp);
                op.add((IActionOperation)mainOp);
                op.add((IActionOperation)new RestoreProjectMetaOperation(saveOp));
                op.add((IActionOperation)new RefreshResourcesOperation(resources));
                mergeOp = op;
            } else if (panel.getMode() == 1) {
                mergeOp = new ShowMergeViewOperation(resources, (IRepositoryResourceProvider)firstSet, (IRepositoryResourceProvider)secondSet, panel.getIgnoreAncestry(), panel.getDepth(), this.getTargetPart());
                mergeOp.setRecordOnly(panel.getRecordOnly());
            } else if (panel.getMode() == 0) {
                mergeOp = new ShowMergeViewOperation(resources, (IRepositoryResourceProvider)firstSet, panel.getSelectedRevisions(), panel.getIgnoreAncestry(), panel.getDepth(), this.getTargetPart());
                mergeOp.setRecordOnly(panel.getRecordOnly());
            } else {
                mergeOp = new ShowMergeViewOperation(resources, (IRepositoryResourceProvider)firstSet, this.getTargetPart());
            }
            if (panel.getMode() != 0) {
                CompositeOperation op = new CompositeOperation(mergeOp.getId(), mergeOp.getMessagesClass());
                op.add((IActionOperation)locateFirst);
                if (panel.getMode() == 1) {
                    op.add((IActionOperation)locateSecond);
                }
                op.add((IActionOperation)mergeOp);
                this.runScheduled((IActionOperation)op);
            } else {
                this.runScheduled((IActionOperation)mergeOp);
            }
        }
    }

    public boolean isEnabled() {
        return this.checkForResourcesPresence(IStateFilter.SF_EXCLUDE_DELETED);
    }

    protected boolean needsToSaveDirtyEditors() {
        return true;
    }
}

