/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.os.linux.ui.views.controlflow;

import org.eclipse.tracecompass.analysis.os.linux.ui.views.controlflow.ControlFlowEntry;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.tmf.core.statesystem.TmfStateSystemAnalysisModule;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceContext;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.dialogs.ITimeGraphEntryActiveProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;

public class ControlFlowCheckActiveProvider
implements ITimeGraphEntryActiveProvider {
    String fLabel;
    String fTooltip;

    public ControlFlowCheckActiveProvider(String label, String tooltip) {
        this.fLabel = label;
        this.fTooltip = tooltip;
    }

    public String getLabel() {
        return this.fLabel;
    }

    public String getTooltip() {
        return this.fTooltip;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isActive(ITimeGraphEntry element) {
        ITmfTrace trace;
        ITmfStateSystem ssq;
        long endTS;
        if (!(element instanceof ControlFlowEntry)) return false;
        ControlFlowEntry cfe = (ControlFlowEntry)element;
        TmfTraceManager traceManager = TmfTraceManager.getInstance();
        TmfTraceContext traceContext = traceManager.getCurrentTraceContext();
        TmfTimeRange winRange = traceContext.getWindowRange();
        TmfTimeRange selRange = traceContext.getSelectionRange();
        long beginTS = selRange.getStartTime().getValue();
        if (beginTS == (endTS = selRange.getEndTime().getValue())) {
            beginTS = winRange.getStartTime().getValue();
            endTS = winRange.getEndTime().getValue();
        }
        if ((ssq = TmfStateSystemAnalysisModule.getStateSystem((ITmfTrace)(trace = cfe.getTrace()), (String)"org.eclipse.tracecompass.analysis.os.linux.kernel")) == null) return false;
        if ((beginTS = Math.max(beginTS, ssq.getStartTime())) > (endTS = Math.min(endTS, ssq.getCurrentEndTime()))) {
            return false;
        }
        try {
            int statusQuark = ssq.getQuarkRelative(cfe.getThreadQuark(), new String[]{"Status"});
            ITmfStateInterval currentInterval = ssq.querySingleState(beginTS, statusQuark);
            if (ControlFlowCheckActiveProvider.isIntervalInStateActive(currentInterval)) {
                return true;
            }
            long ts = currentInterval.getEndTime();
            while (ts != -1L) {
                if (ts >= endTS) {
                    return false;
                }
                if (ControlFlowCheckActiveProvider.isIntervalInStateActive(currentInterval = ssq.querySingleState(++ts, statusQuark))) {
                    return true;
                }
                ts = currentInterval.getEndTime();
            }
            return false;
        }
        catch (AttributeNotFoundException | StateSystemDisposedException throwable) {
            // empty catch block
        }
        return false;
    }

    private static boolean isIntervalInStateActive(ITmfStateInterval ival) {
        int value = ival.getStateValue().unboxInt();
        return value == 2 || value == 3 || value == 4;
    }
}

