/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.os.linux.ui.views.cpuusage;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.tracecompass.analysis.os.linux.ui.views.cpuusage.CpuUsageComposite;
import org.eclipse.tracecompass.analysis.os.linux.ui.views.cpuusage.CpuUsageEntry;
import org.eclipse.tracecompass.analysis.os.linux.ui.views.cpuusage.CpuUsageXYViewer;
import org.eclipse.tracecompass.analysis.os.linux.ui.views.cpuusage.Messages;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceSelectedSignal;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.ui.signal.TmfTimeViewAlignmentInfo;
import org.eclipse.tracecompass.tmf.ui.signal.TmfTimeViewAlignmentSignal;
import org.eclipse.tracecompass.tmf.ui.views.ITmfTimeAligned;
import org.eclipse.tracecompass.tmf.ui.views.TmfView;

public class CpuUsageView
extends TmfView
implements ITmfTimeAligned {
    public static final String ID = "org.eclipse.tracecompass.analysis.os.linux.views.cpuusage";
    private static final int[] DEFAULT_WEIGHTS = new int[]{1, 3};
    private CpuUsageComposite fTreeViewer = null;
    private CpuUsageXYViewer fXYViewer = null;
    private SashForm fSashForm;
    private Listener fSashDragListener;
    private Composite fXYViewerContainer;

    public CpuUsageView() {
        super(Messages.CpuUsageView_Title);
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.fSashForm = new SashForm(parent, 0);
        this.fTreeViewer = new CpuUsageComposite((Composite)this.fSashForm);
        this.fXYViewerContainer = new Composite((Composite)this.fSashForm, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.fXYViewerContainer.setLayout((Layout)layout);
        this.fXYViewer = new CpuUsageXYViewer(this.fXYViewerContainer);
        this.fXYViewer.setSendTimeAlignSignals(true);
        this.fXYViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.fTreeViewer.addSelectionChangeListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object structSelection;
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection && (structSelection = ((IStructuredSelection)selection).getFirstElement()) instanceof CpuUsageEntry) {
                    CpuUsageEntry entry = (CpuUsageEntry)((Object)structSelection);
                    CpuUsageView.this.fTreeViewer.setSelectedThread(entry.getTid());
                    CpuUsageView.this.fXYViewer.setSelectedThread(Long.valueOf(entry.getTid()));
                }
            }
        });
        ITmfTrace trace = TmfTraceManager.getInstance().getActiveTrace();
        if (trace != null) {
            TmfTraceSelectedSignal signal = new TmfTraceSelectedSignal((Object)this, trace);
            this.fTreeViewer.traceSelected(signal);
            this.fXYViewer.traceSelected(signal);
        }
        this.fTreeViewer.getControl().addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                super.controlResized(e);
            }
        });
        this.fXYViewer.getControl().addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (CpuUsageView.this.fSashDragListener == null) {
                    Control[] controlArray = CpuUsageView.this.fSashForm.getChildren();
                    int n = controlArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Control control = controlArray[n2];
                        if (control instanceof Sash) {
                            CpuUsageView.this.fSashDragListener = new Listener(){

                                public void handleEvent(Event event) {
                                    TmfSignalManager.dispatchSignal((TmfSignal)new TmfTimeViewAlignmentSignal((Object)CpuUsageView.this.fSashForm, CpuUsageView.this.getTimeViewAlignmentInfo()));
                                }
                            };
                            control.removePaintListener((PaintListener)this);
                            control.addListener(13, CpuUsageView.this.fSashDragListener);
                            break;
                        }
                        ++n2;
                    }
                }
            }
        });
        this.fSashForm.setWeights(DEFAULT_WEIGHTS);
    }

    public void setFocus() {
        this.fXYViewer.getControl().setFocus();
    }

    public void dispose() {
        super.dispose();
        if (this.fTreeViewer != null) {
            this.fTreeViewer.dispose();
        }
        if (this.fXYViewer != null) {
            this.fXYViewer.dispose();
        }
    }

    public TmfTimeViewAlignmentInfo getTimeViewAlignmentInfo() {
        if (this.fSashForm == null) {
            return null;
        }
        return new TmfTimeViewAlignmentInfo(this.fSashForm.getShell(), this.fSashForm.toDisplay(0, 0), this.getTimeAxisOffset());
    }

    private int getTimeAxisOffset() {
        return this.fTreeViewer.getControl().getSize().x + this.fSashForm.getSashWidth() + this.fXYViewer.getPointAreaOffset();
    }

    public int getAvailableWidth(int requestedOffset) {
        int pointAreaWidth = this.fXYViewer.getPointAreaWidth();
        int curTimeAxisOffset = this.getTimeAxisOffset();
        if (pointAreaWidth <= 0) {
            pointAreaWidth = this.fSashForm.getBounds().width - curTimeAxisOffset;
        }
        int endOffset = curTimeAxisOffset + pointAreaWidth;
        GridLayout layout = (GridLayout)this.fXYViewerContainer.getLayout();
        int endOffsetWithoutMargin = endOffset + layout.marginRight;
        int availableWidth = endOffsetWithoutMargin - requestedOffset;
        availableWidth = Math.min(this.fSashForm.getBounds().width, Math.max(0, availableWidth));
        return availableWidth;
    }

    public void performAlign(int offset, int width) {
        int total = this.fSashForm.getBounds().width;
        int plotAreaOffset = this.fXYViewer.getPointAreaOffset();
        int width1 = Math.max(0, offset - plotAreaOffset - this.fSashForm.getSashWidth());
        int width2 = Math.max(0, total - width1 - this.fSashForm.getSashWidth());
        this.fSashForm.setWeights(new int[]{width1, width2});
        this.fSashForm.layout();
        Composite composite = this.fXYViewerContainer;
        GridLayout layout = (GridLayout)composite.getLayout();
        int timeAxisWidth = this.getAvailableWidth(offset);
        int marginSize = timeAxisWidth - width;
        layout.marginRight = Math.max(0, marginSize);
        composite.layout();
    }
}

