/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.jfr.settings;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.text.ParseException;
import java.util.Collection;
import oracle.jrockit.jfr.settings.JSONArray;
import oracle.jrockit.jfr.settings.JSONMember;
import oracle.jrockit.jfr.settings.JSONObject;
import oracle.jrockit.jfr.settings.JSONTokener;

@Deprecated
public abstract class JSONElement
implements Iterable<JSONMember> {
    public abstract boolean isArray();

    public abstract boolean isObject();

    public abstract boolean isValue();

    public abstract int size();

    public abstract JSONElement value(int var1);

    public abstract JSONMember member(int var1);

    public abstract JSONMember member(String var1);

    public abstract Object value();

    private void checkValue() {
        if (!this.isValue()) {
            throw new RuntimeException("not value");
        }
    }

    public boolean booleanValue() {
        this.checkValue();
        String string = String.valueOf(this.value());
        if ("true".equalsIgnoreCase(string) || "1".equals(string)) {
            return true;
        }
        if ("false".equalsIgnoreCase(string) || "0".equals(string)) {
            return false;
        }
        throw new IllegalArgumentException(string);
    }

    public long longValue() {
        this.checkValue();
        String string = String.valueOf(this.value());
        return Long.parseLong(string);
    }

    public double doubleValue() {
        this.checkValue();
        String string = String.valueOf(this.value());
        return Double.parseDouble(string);
    }

    public String stringValue() {
        this.checkValue();
        return String.valueOf(this.value());
    }

    public abstract Collection<JSONElement> values();

    public static JSONElement parse(String string) throws ParseException, IOException {
        return JSONElement.parse(new StringReader(string));
    }

    public static JSONElement parse(InputStream inputStream) throws ParseException, IOException {
        return JSONElement.parse(new InputStreamReader(inputStream));
    }

    public static JSONElement parse(Reader reader) throws ParseException, IOException {
        JSONTokener jSONTokener = new JSONTokener(reader);
        char c = jSONTokener.nextClean();
        jSONTokener.back();
        if (c == '[') {
            return new JSONArray(jSONTokener);
        }
        return new JSONObject(jSONTokener);
    }

    static void indent(StringBuilder stringBuilder, int n) {
        while (n-- > 0) {
            stringBuilder.append('\t');
        }
    }

    abstract String toString(int var1);

    public String toString() {
        return this.toString(0);
    }

    public boolean equals(JSONElement jSONElement) {
        int n = this.size();
        if (n != jSONElement.size()) {
            return false;
        }
        if (this.isArray() && jSONElement.isArray()) {
            for (int i = 0; i < n; ++i) {
                JSONElement jSONElement2;
                JSONElement jSONElement3 = this.value(i);
                if (jSONElement3.equals(jSONElement2 = jSONElement.value(i))) continue;
                return false;
            }
            return true;
        }
        if (this.isObject() && jSONElement.isObject()) {
            for (int i = 0; i < n; ++i) {
                JSONMember jSONMember;
                JSONMember jSONMember2 = this.member(i);
                if (jSONMember2.equals(jSONMember = jSONElement.member(jSONMember2.getName()))) continue;
                return false;
            }
            return true;
        }
        if (this.isValue() && jSONElement.isValue()) {
            Object object = this.value();
            Object object2 = jSONElement.value();
            if (object == null) {
                return object == object2;
            }
            return object.equals(object2);
        }
        return false;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof JSONElement) {
            return this.equals((JSONElement)object);
        }
        return false;
    }
}

