/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.css.converters;

import com.sun.javafx.Logging;
import com.sun.javafx.css.ParsedValue;
import com.sun.javafx.css.StringStore;
import com.sun.javafx.css.StyleConverter;
import com.sun.javafx.cursor.CursorType;
import com.sun.javafx.logging.PlatformLogger;
import com.sun.javafx.scene.layout.region.Repeat;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javafx.geometry.HPos;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.geometry.Side;
import javafx.geometry.VPos;
import javafx.scene.effect.BlendMode;
import javafx.scene.effect.BlurType;
import javafx.scene.paint.CycleMethod;
import javafx.scene.shape.ArcType;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeLineJoin;
import javafx.scene.shape.StrokeType;
import javafx.scene.text.Font;
import javafx.scene.text.FontPosture;
import javafx.scene.text.FontSmoothingType;
import javafx.scene.text.FontWeight;
import javafx.scene.text.TextAlignment;

public final class EnumConverter<T extends Enum<T>>
extends StyleConverter<String, T> {
    final Class enumClass;
    private static Map<String, StyleConverter> converters;

    public EnumConverter(Class clazz) {
        this.enumClass = clazz;
    }

    @Override
    public T convert(ParsedValue<String, T> parsedValue, Font font) {
        if (this.enumClass == null) {
            return null;
        }
        String string = parsedValue.getValue();
        int n = string.lastIndexOf(46);
        if (n > -1) {
            string = string.substring(n + 1);
        }
        try {
            string = string.replace('-', '_');
            return Enum.valueOf(this.enumClass, string.toUpperCase());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return Enum.valueOf(this.enumClass, string);
        }
    }

    @Override
    public void writeBinary(DataOutputStream dataOutputStream, StringStore stringStore) throws IOException {
        super.writeBinary(dataOutputStream, stringStore);
        String string = this.enumClass.getName();
        int n = stringStore.addString(string);
        dataOutputStream.writeShort(n);
    }

    public static StyleConverter readBinary(DataInputStream dataInputStream, String[] stringArray) throws IOException {
        String string;
        short s = dataInputStream.readShort();
        String string2 = string = 0 <= s && s <= stringArray.length ? stringArray[s] : null;
        if (string == null || string.isEmpty()) {
            return null;
        }
        if (converters == null || !converters.containsKey(string)) {
            PlatformLogger platformLogger;
            StyleConverter styleConverter = EnumConverter.getInstance(string);
            if (styleConverter == null && (platformLogger = Logging.getCSSLogger()).isLoggable(1000)) {
                platformLogger.severe("could not deserialize EnumConverter for " + string);
            }
            if (converters == null) {
                converters = new HashMap<String, StyleConverter>();
            }
            converters.put(string, styleConverter);
            return styleConverter;
        }
        return converters.get(string);
    }

    static StyleConverter getInstance(String string) {
        EnumConverter enumConverter = null;
        if ("com.sun.javafx.cursor.CursorType".equals(string)) {
            enumConverter = new EnumConverter(CursorType.class);
        } else if ("com.sun.javafx.scene.layout.region.Repeat".equals(string)) {
            enumConverter = new EnumConverter(Repeat.class);
        } else if ("javafx.geometry.HPos".equals(string)) {
            enumConverter = new EnumConverter(HPos.class);
        } else if ("javafx.geometry.Orientation".equals(string)) {
            enumConverter = new EnumConverter(Orientation.class);
        } else if ("javafx.geometry.Pos".equals(string)) {
            enumConverter = new EnumConverter(Pos.class);
        } else if ("javafx.geometry.Side".equals(string)) {
            enumConverter = new EnumConverter(Side.class);
        } else if ("javafx.geometry.VPos".equals(string)) {
            enumConverter = new EnumConverter(VPos.class);
        } else if ("javafx.scene.effect.BlendMode".equals(string)) {
            enumConverter = new EnumConverter(BlendMode.class);
        } else if ("javafx.scene.effect.BlurType".equals(string)) {
            enumConverter = new EnumConverter(BlurType.class);
        } else if ("javafx.scene.paint.CycleMethod".equals(string)) {
            enumConverter = new EnumConverter(CycleMethod.class);
        } else if ("javafx.scene.shape.ArcType".equals(string)) {
            enumConverter = new EnumConverter(ArcType.class);
        } else if ("javafx.scene.shape.StrokeLineCap".equals(string)) {
            enumConverter = new EnumConverter(StrokeLineCap.class);
        } else if ("javafx.scene.shape.StrokeLineJoin".equals(string)) {
            enumConverter = new EnumConverter(StrokeLineJoin.class);
        } else if ("javafx.scene.shape.StrokeType".equals(string)) {
            enumConverter = new EnumConverter(StrokeType.class);
        } else if ("javafx.scene.text.FontPosture".equals(string)) {
            enumConverter = new EnumConverter(FontPosture.class);
        } else if ("javafx.scene.text.FontSmoothingType".equals(string)) {
            enumConverter = new EnumConverter(FontSmoothingType.class);
        } else if ("javafx.scene.text.FontWeight".equals(string)) {
            enumConverter = new EnumConverter(FontWeight.class);
        } else if ("javafx.scene.text.TextAlignment".equals(string)) {
            enumConverter = new EnumConverter(TextAlignment.class);
        } else assert (false) : "EnumConverter<" + string + "> not expected";
        return enumConverter;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof EnumConverter)) {
            return false;
        }
        return this.enumClass.equals(((EnumConverter)object).enumClass);
    }

    public int hashCode() {
        return this.enumClass.hashCode();
    }

    public String toString() {
        return "EnumConveter[" + this.enumClass.getName() + "]";
    }
}

