/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.Constants;
import com.sun.org.apache.bcel.internal.classfile.AttributeReader;
import com.sun.org.apache.bcel.internal.classfile.ClassFormatException;
import com.sun.org.apache.bcel.internal.classfile.Code;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.ConstantUtf8;
import com.sun.org.apache.bcel.internal.classfile.ConstantValue;
import com.sun.org.apache.bcel.internal.classfile.Deprecated;
import com.sun.org.apache.bcel.internal.classfile.ExceptionTable;
import com.sun.org.apache.bcel.internal.classfile.InnerClasses;
import com.sun.org.apache.bcel.internal.classfile.LineNumberTable;
import com.sun.org.apache.bcel.internal.classfile.LocalVariableTable;
import com.sun.org.apache.bcel.internal.classfile.Node;
import com.sun.org.apache.bcel.internal.classfile.PMGClass;
import com.sun.org.apache.bcel.internal.classfile.Signature;
import com.sun.org.apache.bcel.internal.classfile.SourceFile;
import com.sun.org.apache.bcel.internal.classfile.StackMap;
import com.sun.org.apache.bcel.internal.classfile.Synthetic;
import com.sun.org.apache.bcel.internal.classfile.Unknown;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;

public abstract class Attribute
implements Cloneable,
Node,
Serializable {
    protected int name_index;
    protected int length;
    protected byte tag;
    protected ConstantPool constant_pool;
    private static HashMap readers = new HashMap();

    protected Attribute(byte by, int n, int n2, ConstantPool constantPool) {
        this.tag = by;
        this.name_index = n;
        this.length = n2;
        this.constant_pool = constantPool;
    }

    @Override
    public abstract void accept(Visitor var1);

    public void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.name_index);
        dataOutputStream.writeInt(this.length);
    }

    public static void addAttributeReader(String string, AttributeReader attributeReader) {
        readers.put(string, attributeReader);
    }

    public static void removeAttributeReader(String string) {
        readers.remove(string);
    }

    public static final Attribute readAttribute(DataInputStream dataInputStream, ConstantPool constantPool) throws IOException, ClassFormatException {
        int n = -1;
        int n2 = dataInputStream.readUnsignedShort();
        ConstantUtf8 constantUtf8 = (ConstantUtf8)constantPool.getConstant(n2, (byte)1);
        String string = constantUtf8.getBytes();
        int n3 = dataInputStream.readInt();
        for (int n4 = 0; n4 < 12; n4 = (int)((byte)(n4 + 1))) {
            if (!string.equals(Constants.ATTRIBUTE_NAMES[n4])) continue;
            n = n4;
            break;
        }
        switch (n) {
            case -1: {
                AttributeReader attributeReader = (AttributeReader)readers.get(string);
                if (attributeReader != null) {
                    return attributeReader.createAttribute(n2, n3, dataInputStream, constantPool);
                }
                return new Unknown(n2, n3, dataInputStream, constantPool);
            }
            case 1: {
                return new ConstantValue(n2, n3, dataInputStream, constantPool);
            }
            case 0: {
                return new SourceFile(n2, n3, dataInputStream, constantPool);
            }
            case 2: {
                return new Code(n2, n3, dataInputStream, constantPool);
            }
            case 3: {
                return new ExceptionTable(n2, n3, dataInputStream, constantPool);
            }
            case 4: {
                return new LineNumberTable(n2, n3, dataInputStream, constantPool);
            }
            case 5: {
                return new LocalVariableTable(n2, n3, dataInputStream, constantPool);
            }
            case 6: {
                return new InnerClasses(n2, n3, dataInputStream, constantPool);
            }
            case 7: {
                return new Synthetic(n2, n3, dataInputStream, constantPool);
            }
            case 8: {
                return new Deprecated(n2, n3, dataInputStream, constantPool);
            }
            case 9: {
                return new PMGClass(n2, n3, dataInputStream, constantPool);
            }
            case 10: {
                return new Signature(n2, n3, dataInputStream, constantPool);
            }
            case 11: {
                return new StackMap(n2, n3, dataInputStream, constantPool);
            }
        }
        throw new IllegalStateException("Ooops! default case reached.");
    }

    public final int getLength() {
        return this.length;
    }

    public final void setLength(int n) {
        this.length = n;
    }

    public final void setNameIndex(int n) {
        this.name_index = n;
    }

    public final int getNameIndex() {
        return this.name_index;
    }

    public final byte getTag() {
        return this.tag;
    }

    public final ConstantPool getConstantPool() {
        return this.constant_pool;
    }

    public final void setConstantPool(ConstantPool constantPool) {
        this.constant_pool = constantPool;
    }

    public Object clone() {
        Object object = null;
        try {
            object = super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
        }
        return object;
    }

    public abstract Attribute copy(ConstantPool var1);

    public String toString() {
        return Constants.ATTRIBUTE_NAMES[this.tag];
    }
}

