/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.image;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.RasterFormatException;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import sun.awt.image.NativeLibLoader;
import sun.awt.image.SunWritableRaster;

public class ByteComponentRaster
extends SunWritableRaster {
    protected int bandOffset;
    protected int[] dataOffsets;
    protected int scanlineStride;
    protected int pixelStride;
    protected byte[] data;
    int type;
    private int maxX;
    private int maxY;

    private static native void initIDs();

    public ByteComponentRaster(SampleModel sampleModel, Point point) {
        this(sampleModel, sampleModel.createDataBuffer(), new Rectangle(point.x, point.y, sampleModel.getWidth(), sampleModel.getHeight()), point, null);
    }

    public ByteComponentRaster(SampleModel sampleModel, DataBuffer dataBuffer, Point point) {
        this(sampleModel, dataBuffer, new Rectangle(point.x, point.y, sampleModel.getWidth(), sampleModel.getHeight()), point, null);
    }

    public ByteComponentRaster(SampleModel sampleModel, DataBuffer dataBuffer, Rectangle rectangle, Point point, ByteComponentRaster byteComponentRaster) {
        super(sampleModel, dataBuffer, rectangle, point, byteComponentRaster);
        this.maxX = this.minX + this.width;
        this.maxY = this.minY + this.height;
        if (!(dataBuffer instanceof DataBufferByte)) {
            throw new RasterFormatException("ByteComponentRasters must have byte DataBuffers");
        }
        DataBufferByte dataBufferByte = (DataBufferByte)dataBuffer;
        this.data = ByteComponentRaster.stealData(dataBufferByte, 0);
        if (dataBufferByte.getNumBanks() != 1) {
            throw new RasterFormatException("DataBuffer for ByteComponentRasters must only have 1 bank.");
        }
        int n = dataBufferByte.getOffset();
        if (sampleModel instanceof ComponentSampleModel) {
            ComponentSampleModel componentSampleModel = (ComponentSampleModel)sampleModel;
            this.type = 1;
            this.scanlineStride = componentSampleModel.getScanlineStride();
            this.pixelStride = componentSampleModel.getPixelStride();
            this.dataOffsets = componentSampleModel.getBandOffsets();
            int n2 = rectangle.x - point.x;
            int n3 = rectangle.y - point.y;
            int n4 = 0;
            while (n4 < this.getNumDataElements()) {
                int n5 = n4++;
                this.dataOffsets[n5] = this.dataOffsets[n5] + (n + n2 * this.pixelStride + n3 * this.scanlineStride);
            }
        } else if (sampleModel instanceof SinglePixelPackedSampleModel) {
            SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)sampleModel;
            this.type = 7;
            this.scanlineStride = singlePixelPackedSampleModel.getScanlineStride();
            this.pixelStride = 1;
            this.dataOffsets = new int[1];
            this.dataOffsets[0] = n;
            int n6 = rectangle.x - point.x;
            int n7 = rectangle.y - point.y;
            this.dataOffsets[0] = this.dataOffsets[0] + (n6 * this.pixelStride + n7 * this.scanlineStride);
        } else {
            throw new RasterFormatException("IntegerComponentRasters must have ComponentSampleModel or SinglePixelPackedSampleModel");
        }
        this.bandOffset = this.dataOffsets[0];
        this.verify();
    }

    public int[] getDataOffsets() {
        return (int[])this.dataOffsets.clone();
    }

    public int getDataOffset(int n) {
        return this.dataOffsets[n];
    }

    public int getScanlineStride() {
        return this.scanlineStride;
    }

    public int getPixelStride() {
        return this.pixelStride;
    }

    public byte[] getDataStorage() {
        return this.data;
    }

    @Override
    public Object getDataElements(int n, int n2, Object object) {
        if (n < this.minX || n2 < this.minY || n >= this.maxX || n2 >= this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        byte[] byArray = object == null ? new byte[this.numDataElements] : (byte[])object;
        int n3 = (n2 - this.minY) * this.scanlineStride + (n - this.minX) * this.pixelStride;
        for (int i = 0; i < this.numDataElements; ++i) {
            byArray[i] = this.data[this.dataOffsets[i] + n3];
        }
        return byArray;
    }

    @Override
    public Object getDataElements(int n, int n2, int n3, int n4, Object object) {
        if (n < this.minX || n2 < this.minY || n + n3 > this.maxX || n2 + n4 > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        byte[] byArray = object == null ? new byte[n3 * n4 * this.numDataElements] : (byte[])object;
        int n5 = (n2 - this.minY) * this.scanlineStride + (n - this.minX) * this.pixelStride;
        int n6 = 0;
        int n7 = 0;
        while (n7 < n4) {
            int n8 = n5;
            int n9 = 0;
            while (n9 < n3) {
                for (int i = 0; i < this.numDataElements; ++i) {
                    byArray[n6++] = this.data[this.dataOffsets[i] + n8];
                }
                ++n9;
                n8 += this.pixelStride;
            }
            ++n7;
            n5 += this.scanlineStride;
        }
        return byArray;
    }

    public byte[] getByteData(int n, int n2, int n3, int n4, int n5, byte[] byArray) {
        if (n < this.minX || n2 < this.minY || n + n3 > this.maxX || n2 + n4 > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        if (byArray == null) {
            byArray = new byte[this.scanlineStride * n4];
        }
        int n6 = (n2 - this.minY) * this.scanlineStride + (n - this.minX) * this.pixelStride + this.dataOffsets[n5];
        int n7 = 0;
        if (this.pixelStride == 1) {
            if (this.scanlineStride == n3) {
                System.arraycopy(this.data, n6, byArray, 0, n3 * n4);
            } else {
                int n8 = 0;
                while (n8 < n4) {
                    System.arraycopy(this.data, n6, byArray, n7, n3);
                    n7 += n3;
                    ++n8;
                    n6 += this.scanlineStride;
                }
            }
        } else {
            int n9 = 0;
            while (n9 < n4) {
                int n10 = n6;
                int n11 = 0;
                while (n11 < n3) {
                    byArray[n7++] = this.data[n10];
                    ++n11;
                    n10 += this.pixelStride;
                }
                ++n9;
                n6 += this.scanlineStride;
            }
        }
        return byArray;
    }

    public byte[] getByteData(int n, int n2, int n3, int n4, byte[] byArray) {
        if (n < this.minX || n2 < this.minY || n + n3 > this.maxX || n2 + n4 > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        if (byArray == null) {
            byArray = new byte[this.numDataElements * this.scanlineStride * n4];
        }
        int n5 = (n2 - this.minY) * this.scanlineStride + (n - this.minX) * this.pixelStride;
        int n6 = 0;
        int n7 = 0;
        while (n7 < n4) {
            int n8 = n5;
            int n9 = 0;
            while (n9 < n3) {
                for (int i = 0; i < this.numDataElements; ++i) {
                    byArray[n6++] = this.data[this.dataOffsets[i] + n8];
                }
                ++n9;
                n8 += this.pixelStride;
            }
            ++n7;
            n5 += this.scanlineStride;
        }
        return byArray;
    }

    @Override
    public void setDataElements(int n, int n2, Object object) {
        if (n < this.minX || n2 < this.minY || n >= this.maxX || n2 >= this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        byte[] byArray = (byte[])object;
        int n3 = (n2 - this.minY) * this.scanlineStride + (n - this.minX) * this.pixelStride;
        for (int i = 0; i < this.numDataElements; ++i) {
            this.data[this.dataOffsets[i] + n3] = byArray[i];
        }
        this.markDirty();
    }

    @Override
    public void setDataElements(int n, int n2, Raster raster) {
        int n3 = raster.getMinX() + n;
        int n4 = raster.getMinY() + n2;
        int n5 = raster.getWidth();
        int n6 = raster.getHeight();
        if (n3 < this.minX || n4 < this.minY || n3 + n5 > this.maxX || n4 + n6 > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        this.setDataElements(n3, n4, n5, n6, raster);
    }

    private void setDataElements(int n, int n2, int n3, int n4, Raster raster) {
        if (n3 <= 0 || n4 <= 0) {
            return;
        }
        int n5 = raster.getMinX();
        int n6 = raster.getMinY();
        Object object = null;
        if (raster instanceof ByteComponentRaster) {
            ByteComponentRaster byteComponentRaster = (ByteComponentRaster)raster;
            byte[] byArray = byteComponentRaster.getDataStorage();
            if (this.numDataElements == 1) {
                int n7 = byteComponentRaster.getDataOffset(0);
                int n8 = byteComponentRaster.getScanlineStride();
                int n9 = n7;
                int n10 = this.dataOffsets[0] + (n2 - this.minY) * this.scanlineStride + (n - this.minX);
                if (this.pixelStride == byteComponentRaster.getPixelStride()) {
                    n3 *= this.pixelStride;
                    for (int i = 0; i < n4; ++i) {
                        System.arraycopy(byArray, n9, this.data, n10, n3);
                        n9 += n8;
                        n10 += this.scanlineStride;
                    }
                    this.markDirty();
                    return;
                }
            }
        }
        for (int i = 0; i < n4; ++i) {
            object = raster.getDataElements(n5, n6 + i, n3, 1, object);
            this.setDataElements(n, n2 + i, n3, 1, object);
        }
    }

    @Override
    public void setDataElements(int n, int n2, int n3, int n4, Object object) {
        if (n < this.minX || n2 < this.minY || n + n3 > this.maxX || n2 + n4 > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        byte[] byArray = (byte[])object;
        int n5 = (n2 - this.minY) * this.scanlineStride + (n - this.minX) * this.pixelStride;
        int n6 = 0;
        if (this.numDataElements == 1) {
            int n7 = 0;
            int n8 = n5 + this.dataOffsets[0];
            for (int i = 0; i < n4; ++i) {
                int n9 = n5;
                System.arraycopy(byArray, n7, this.data, n8, n3);
                n7 += n3;
                n8 += this.scanlineStride;
            }
            this.markDirty();
            return;
        }
        int n10 = 0;
        while (n10 < n4) {
            int n11 = n5;
            int n12 = 0;
            while (n12 < n3) {
                for (int i = 0; i < this.numDataElements; ++i) {
                    this.data[this.dataOffsets[i] + n11] = byArray[n6++];
                }
                ++n12;
                n11 += this.pixelStride;
            }
            ++n10;
            n5 += this.scanlineStride;
        }
        this.markDirty();
    }

    public void putByteData(int n, int n2, int n3, int n4, int n5, byte[] byArray) {
        if (n < this.minX || n2 < this.minY || n + n3 > this.maxX || n2 + n4 > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int n6 = (n2 - this.minY) * this.scanlineStride + (n - this.minX) * this.pixelStride + this.dataOffsets[n5];
        int n7 = 0;
        if (this.pixelStride == 1) {
            if (this.scanlineStride == n3) {
                System.arraycopy(byArray, 0, this.data, n6, n3 * n4);
            } else {
                int n8 = 0;
                while (n8 < n4) {
                    System.arraycopy(byArray, n7, this.data, n6, n3);
                    n7 += n3;
                    ++n8;
                    n6 += this.scanlineStride;
                }
            }
        } else {
            int n9 = 0;
            while (n9 < n4) {
                int n10 = n6;
                int n11 = 0;
                while (n11 < n3) {
                    this.data[n10] = byArray[n7++];
                    ++n11;
                    n10 += this.pixelStride;
                }
                ++n9;
                n6 += this.scanlineStride;
            }
        }
        this.markDirty();
    }

    public void putByteData(int n, int n2, int n3, int n4, byte[] byArray) {
        if (n < this.minX || n2 < this.minY || n + n3 > this.maxX || n2 + n4 > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int n5 = (n2 - this.minY) * this.scanlineStride + (n - this.minX) * this.pixelStride;
        int n6 = 0;
        if (this.numDataElements == 1) {
            n5 += this.dataOffsets[0];
            if (this.pixelStride == 1) {
                if (this.scanlineStride == n3) {
                    System.arraycopy(byArray, 0, this.data, n5, n3 * n4);
                } else {
                    for (int i = 0; i < n4; ++i) {
                        System.arraycopy(byArray, n6, this.data, n5, n3);
                        n6 += n3;
                        n5 += this.scanlineStride;
                    }
                }
            } else {
                int n7 = 0;
                while (n7 < n4) {
                    int n8 = n5;
                    int n9 = 0;
                    while (n9 < n3) {
                        this.data[n8] = byArray[n6++];
                        ++n9;
                        n8 += this.pixelStride;
                    }
                    ++n7;
                    n5 += this.scanlineStride;
                }
            }
        } else {
            int n10 = 0;
            while (n10 < n4) {
                int n11 = n5;
                int n12 = 0;
                while (n12 < n3) {
                    for (int i = 0; i < this.numDataElements; ++i) {
                        this.data[this.dataOffsets[i] + n11] = byArray[n6++];
                    }
                    ++n12;
                    n11 += this.pixelStride;
                }
                ++n10;
                n5 += this.scanlineStride;
            }
        }
        this.markDirty();
    }

    @Override
    public Raster createChild(int n, int n2, int n3, int n4, int n5, int n6, int[] nArray) {
        WritableRaster writableRaster = this.createWritableChild(n, n2, n3, n4, n5, n6, nArray);
        return writableRaster;
    }

    @Override
    public WritableRaster createWritableChild(int n, int n2, int n3, int n4, int n5, int n6, int[] nArray) {
        if (n < this.minX) {
            throw new RasterFormatException("x lies outside the raster");
        }
        if (n2 < this.minY) {
            throw new RasterFormatException("y lies outside the raster");
        }
        if (n + n3 < n || n + n3 > this.minX + this.width) {
            throw new RasterFormatException("(x + width) is outside of Raster");
        }
        if (n2 + n4 < n2 || n2 + n4 > this.minY + this.height) {
            throw new RasterFormatException("(y + height) is outside of Raster");
        }
        SampleModel sampleModel = nArray != null ? this.sampleModel.createSubsetSampleModel(nArray) : this.sampleModel;
        int n7 = n5 - n;
        int n8 = n6 - n2;
        return new ByteComponentRaster(sampleModel, this.dataBuffer, new Rectangle(n5, n6, n3, n4), new Point(this.sampleModelTranslateX + n7, this.sampleModelTranslateY + n8), this);
    }

    @Override
    public WritableRaster createCompatibleWritableRaster(int n, int n2) {
        if (n <= 0 || n2 <= 0) {
            throw new RasterFormatException("negative " + (n <= 0 ? "width" : "height"));
        }
        SampleModel sampleModel = this.sampleModel.createCompatibleSampleModel(n, n2);
        return new ByteComponentRaster(sampleModel, new Point(0, 0));
    }

    @Override
    public WritableRaster createCompatibleWritableRaster() {
        return this.createCompatibleWritableRaster(this.width, this.height);
    }

    protected final void verify() {
        int n;
        if (this.width <= 0 || this.height <= 0 || this.height > Integer.MAX_VALUE / this.width) {
            throw new RasterFormatException("Invalid raster dimension");
        }
        for (n = 0; n < this.dataOffsets.length; ++n) {
            if (this.dataOffsets[n] >= 0) continue;
            throw new RasterFormatException("Data offsets for band " + n + "(" + this.dataOffsets[n] + ") must be >= 0");
        }
        if (this.scanlineStride < 0 || this.scanlineStride > Integer.MAX_VALUE / this.height || this.scanlineStride > this.data.length) {
            throw new RasterFormatException("Incorrect scanline stride: " + this.scanlineStride);
        }
        n = (this.height - 1) * this.scanlineStride;
        if (this.pixelStride < 0 || this.pixelStride > Integer.MAX_VALUE / this.width || this.pixelStride > this.data.length) {
            throw new RasterFormatException("Incorrect pixel stride: " + this.pixelStride);
        }
        int n2 = (this.width - 1) * this.pixelStride;
        if (n2 > Integer.MAX_VALUE - n) {
            throw new RasterFormatException("Incorrect raster attributes");
        }
        n2 += n;
        int n3 = 0;
        for (int i = 0; i < this.numDataElements; ++i) {
            if (this.dataOffsets[i] > Integer.MAX_VALUE - n2) {
                throw new RasterFormatException("Incorrect band offset: " + this.dataOffsets[i]);
            }
            int n4 = n2 + this.dataOffsets[i];
            if (n4 <= n3) continue;
            n3 = n4;
        }
        if (this.data.length <= n3) {
            throw new RasterFormatException("Data array too small (should be > " + n3 + " )");
        }
    }

    public String toString() {
        return new String("ByteComponentRaster: width = " + this.width + " height = " + this.height + " #numDataElements " + this.numDataElements + " dataOff[0] = " + this.dataOffsets[0]);
    }

    static {
        NativeLibLoader.loadLibraries();
        ByteComponentRaster.initIDs();
    }
}

