/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.model;

import com.ibm.icu.text.DateFormat;
import java.util.Date;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.ui.ProvUI;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.p2.ui.model.RemoteQueriedElement;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.query.IQueryable;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RollbackProfileElement
extends RemoteQueriedElement {
    private String profileId;
    private long timestamp;
    private IProfile snapshot;
    private boolean isCurrent = false;
    private String profileTag;
    static /* synthetic */ Class class$0;

    public RollbackProfileElement(Object parent, String profileId, long timestamp) {
        this(parent, profileId, timestamp, null);
    }

    public RollbackProfileElement(Object parent, String profileId, long timestamp, String profileTag) {
        super(parent);
        this.timestamp = timestamp;
        this.profileId = profileId;
        this.profileTag = profileTag;
    }

    @Override
    protected String getImageId(Object obj) {
        return "obj/profile_obj.gif";
    }

    @Override
    public String getLabel(Object o) {
        if (this.isCurrent) {
            return ProvUIMessages.RollbackProfileElement_CurrentInstallation;
        }
        return DateFormat.getDateTimeInstance((int)3, (int)1).format(new Date(this.timestamp));
    }

    @Override
    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.p2.engine.IProfile");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz) {
            return this.getProfileSnapshot((IProgressMonitor)new NullProgressMonitor());
        }
        return super.getAdapter(adapter);
    }

    public IProfile getProfileSnapshot(IProgressMonitor monitor) {
        if (this.snapshot == null) {
            this.snapshot = ProvUI.getProfileRegistry(this.getProvisioningUI().getSession()).getProfile(this.profileId, this.timestamp);
            this.setQueryable((IQueryable<?>)this.snapshot);
        }
        return this.snapshot;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setIsCurrentProfile(boolean current) {
        this.isCurrent = current;
    }

    public boolean isCurrentProfile() {
        return this.isCurrent;
    }

    public String getProfileId() {
        return this.profileId;
    }

    public String getProfileTag() {
        return this.profileTag;
    }

    public void setProfileTag(String profileTag) {
        this.profileTag = profileTag;
    }

    @Override
    protected int getDefaultQueryType() {
        return 6;
    }

    @Override
    public IQueryable<?> getQueryable() {
        return this.getProfileSnapshot((IProgressMonitor)new NullProgressMonitor());
    }
}

