/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core;

import java.util.Hashtable;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jpt.common.core.JptResourceType;
import org.eclipse.jpt.common.core.internal.JptPlugin;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.jpa.core.JpaFacet;
import org.eclipse.jpt.jpa.core.JpaNode;
import org.eclipse.jpt.jpa.core.JpaPlatform;
import org.eclipse.jpt.jpa.core.JpaProjectManager;
import org.eclipse.jpt.jpa.core.context.XmlContextNode;
import org.eclipse.jpt.jpa.core.internal.InternalJpaProjectManager;
import org.eclipse.jpt.jpa.core.internal.platform.JpaPlatformManagerImpl;
import org.eclipse.jpt.jpa.core.internal.prefs.JpaPreferencesManager;
import org.eclipse.jpt.jpa.core.platform.GenericPlatform;
import org.eclipse.jpt.jpa.core.platform.JpaPlatformDescription;
import org.eclipse.jpt.jpa.core.platform.JpaPlatformManager;
import org.eclipse.wst.common.project.facet.core.FacetedProjectFramework;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.osgi.framework.BundleContext;
import org.osgi.service.prefs.Preferences;

public class JptJpaCorePlugin
extends JptPlugin {
    private final Hashtable<IWorkspace, InternalJpaProjectManager> jpaProjectManagers = new Hashtable();
    public static final String PLUGIN_ID = "org.eclipse.jpt.jpa.core";
    public static final String PLUGIN_ID_ = "org.eclipse.jpt.jpa.core.";
    public static final String LEGACY_PLUGIN_ID = "org.eclipse.jpt.core";
    public static final String LEGACY_PLUGIN_ID_ = "org.eclipse.jpt.core.";
    public static final QualifiedName DATA_SOURCE_CONNECTION_PROFILE_NAME = new QualifiedName("org.eclipse.jpt.jpa.core", "dataSource.connectionProfileName");
    public static final QualifiedName USER_OVERRIDE_DEFAULT_CATALOG = new QualifiedName("org.eclipse.jpt.jpa.core", "userOverrideDefaultCatalogName");
    public static final QualifiedName USER_OVERRIDE_DEFAULT_SCHEMA = new QualifiedName("org.eclipse.jpt.jpa.core", "userOverrideDefaultSchemaName");
    public static final String VALIDATION_MARKER_ID = "org.eclipse.jpt.jpa.core.jpaProblemMarker";
    public static final String VALIDATOR_ID = "org.eclipse.jpt.jpa.core.jpaValidator";
    public static final IContentType PERSISTENCE_XML_CONTENT_TYPE = JptJpaCorePlugin.getJpaContentType("persistence");
    public static final JptResourceType PERSISTENCE_XML_1_0_RESOURCE_TYPE = new JptResourceType(PERSISTENCE_XML_CONTENT_TYPE, "1.0");
    public static final JptResourceType PERSISTENCE_XML_2_0_RESOURCE_TYPE = new JptResourceType(PERSISTENCE_XML_CONTENT_TYPE, "2.0");
    public static final IContentType MAPPING_FILE_CONTENT_TYPE = JptJpaCorePlugin.getJpaContentType("mappingFile");
    public static final IContentType ORM_XML_CONTENT_TYPE = JptJpaCorePlugin.getJpaContentType("orm");
    public static final JptResourceType ORM_XML_1_0_RESOURCE_TYPE = new JptResourceType(ORM_XML_CONTENT_TYPE, "1.0");
    public static final JptResourceType ORM_XML_2_0_RESOURCE_TYPE = new JptResourceType(ORM_XML_CONTENT_TYPE, "2.0");
    public static final IProjectFacet WEB_FACET = ProjectFacetsManager.getProjectFacet((String)"jst.web");
    public static final IPath DEFAULT_PERSISTENCE_XML_RUNTIME_PATH = new Path("META-INF/persistence.xml");
    public static final IPath DEFAULT_ORM_XML_RUNTIME_PATH = new Path("META-INF/orm.xml");
    public static final String CONTENT_PREFIX = "org.eclipse.jpt.jpa.core.content";
    public static final String CONTENT_PREFIX_ = "org.eclipse.jpt.jpa.core.content.";
    static JptJpaCorePlugin INSTANCE;

    private static IContentType getJpaContentType(String jpaContentType) {
        return JptJpaCorePlugin.getContentType(CONTENT_PREFIX_ + jpaContentType);
    }

    private static IContentType getContentType(String contentType) {
        return Platform.getContentTypeManager().getContentType(contentType);
    }

    public static JptJpaCorePlugin instance() {
        return INSTANCE;
    }

    @Deprecated
    public static JpaProjectManager getJpaProjectManager(IWorkspace workspace) {
        return INSTANCE.getJpaProjectManager_(workspace);
    }

    public static boolean projectHasWebFacet(IProject project) {
        return JptJpaCorePlugin.projectHasFacet(project, WEB_FACET);
    }

    private static boolean projectHasFacet(IProject project, IProjectFacet facet) {
        try {
            return FacetedProjectFramework.hasProjectFacet((IProject)project, (String)facet.getId());
        }
        catch (CoreException ex) {
            JptJpaCorePlugin.log(ex);
            return false;
        }
    }

    public static IPath getJarRuntimeRootPath(IProject project) {
        return JptJpaCorePlugin.projectHasWebFacet(project) ? new Path("/WEB-INF") : new Path("/");
    }

    public static JpaPlatformDescription getDefaultJpaPlatform(IProjectFacetVersion jpaFacetVersion) {
        JpaPlatformDescription defaultPlatform = JptJpaCorePlugin.getDefaultJpaPlatform(jpaFacetVersion, new Preferences[]{JpaPreferencesManager.getLegacyWorkspacePreferences(), JpaPreferencesManager.getLegacyDefaultPreferences(), JpaPreferencesManager.getDefaultPreferences()});
        if (defaultPlatform == null) {
            defaultPlatform = JptJpaCorePlugin.getDefaultJpaPlatform(jpaFacetVersion, new Preferences[]{JpaPreferencesManager.getLegacyDefaultPreferences()});
        }
        return defaultPlatform;
    }

    private static JpaPlatformDescription getDefaultJpaPlatform(IProjectFacetVersion jpaFacetVersion, Preferences ... nodes) {
        JpaPlatformDescription defaultDefaultPlatform = JptJpaCorePlugin.getDefaultJpaPlatform(jpaFacetVersion, "defaultJpaPlatform", null, nodes);
        String preferenceKey = null;
        if (jpaFacetVersion.equals(JpaFacet.VERSION_1_0)) {
            if (defaultDefaultPlatform == null) {
                defaultDefaultPlatform = GenericPlatform.VERSION_1_0;
            }
            preferenceKey = JpaPreferencesManager.DEFAULT_JPA_PLATFORM_1_0_PREF_KEY;
        } else if (jpaFacetVersion.equals(JpaFacet.VERSION_2_0)) {
            if (defaultDefaultPlatform == null) {
                defaultDefaultPlatform = GenericPlatform.VERSION_2_0;
            }
            preferenceKey = JpaPreferencesManager.DEFAULT_JPA_PLATFORM_2_0_PREF_KEY;
        } else {
            throw new IllegalArgumentException("Illegal JPA facet version: " + jpaFacetVersion);
        }
        return JptJpaCorePlugin.getDefaultJpaPlatform(jpaFacetVersion, preferenceKey, defaultDefaultPlatform, nodes);
    }

    private static JpaPlatformDescription getDefaultJpaPlatform(IProjectFacetVersion jpaFacetVersion, String preferenceKey, JpaPlatformDescription defaultDefault, Preferences ... nodes) {
        String defaultDefaultId = defaultDefault == null ? null : defaultDefault.getId();
        String defaultPlatformId = Platform.getPreferencesService().get(preferenceKey, defaultDefaultId, nodes);
        JpaPlatformDescription defaultPlatform = JptJpaCorePlugin.getJpaPlatformManager().getJpaPlatform(defaultPlatformId);
        if (defaultPlatform != null && defaultPlatform.supportsJpaFacetVersion(jpaFacetVersion)) {
            return defaultPlatform;
        }
        if (defaultDefault != null && defaultDefault.supportsJpaFacetVersion(jpaFacetVersion)) {
            return defaultDefault;
        }
        return null;
    }

    public static JpaPlatformManager getJpaPlatformManager() {
        return JpaPlatformManagerImpl.instance();
    }

    public static void setDefaultJpaPlatformId(String jpaFacetVersion, String platformId) {
        String preferenceKey = null;
        if (JpaFacet.VERSION_1_0.getVersionString().equals(jpaFacetVersion)) {
            preferenceKey = JpaPreferencesManager.DEFAULT_JPA_PLATFORM_1_0_PREF_KEY;
        } else if (JpaFacet.VERSION_2_0.getVersionString().equals(jpaFacetVersion)) {
            preferenceKey = JpaPreferencesManager.DEFAULT_JPA_PLATFORM_2_0_PREF_KEY;
        } else {
            throw new IllegalArgumentException("Illegal JPA facet version: " + jpaFacetVersion);
        }
        JpaPreferencesManager.setLegacyWorkspacePreference(preferenceKey, platformId);
    }

    public static String getJpaPlatformId(IProject project) {
        return new JpaPreferencesManager(project).getJpaPlatformId();
    }

    public static JpaPlatformDescription getJpaPlatformDescription(IProject project) {
        String jpaPlatformId = JptJpaCorePlugin.getJpaPlatformId(project);
        return JptJpaCorePlugin.getJpaPlatformManager().getJpaPlatform(jpaPlatformId);
    }

    public static void setJpaPlatformId(IProject project, String jpaPlatformId) {
        new JpaPreferencesManager(project).setJpaPlatformId(jpaPlatformId);
    }

    public static boolean getDiscoverAnnotatedClasses(IProject project) {
        return new JpaPreferencesManager(project).getDiscoverAnnotatedClasses();
    }

    public static void setDiscoverAnnotatedClasses(IProject project, boolean discoverAnnotatedClasses) {
        new JpaPreferencesManager(project).setDiscoverAnnotatedClasses(discoverAnnotatedClasses);
    }

    public static String getMetamodelSourceFolderName(IProject project) {
        return new JpaPreferencesManager(project).getMetamodelSourceFolderName();
    }

    public static void setMetamodelSourceFolderName(IProject project, String metamodelSourceFolderName) {
        new JpaPreferencesManager(project).setMetamodelSourceFolderName(metamodelSourceFolderName);
    }

    public static String getConnectionProfileName(IProject project) {
        try {
            String connectionProfileName = project.getPersistentProperty(DATA_SOURCE_CONNECTION_PROFILE_NAME);
            return StringTools.stringIsEmpty((String)connectionProfileName) ? null : connectionProfileName;
        }
        catch (CoreException ex) {
            JptJpaCorePlugin.log(ex);
            return null;
        }
    }

    public static void setConnectionProfileName(IProject project, String connectionProfileName) {
        try {
            project.setPersistentProperty(DATA_SOURCE_CONNECTION_PROFILE_NAME, connectionProfileName);
        }
        catch (CoreException ex) {
            JptJpaCorePlugin.log(ex);
        }
    }

    public static String getUserOverrideDefaultCatalog(IProject project) {
        try {
            return project.getPersistentProperty(USER_OVERRIDE_DEFAULT_CATALOG);
        }
        catch (CoreException ex) {
            JptJpaCorePlugin.log(ex);
            return null;
        }
    }

    public static void setUserOverrideDefaultCatalog(IProject project, String defaultCatalog) {
        try {
            project.setPersistentProperty(USER_OVERRIDE_DEFAULT_CATALOG, defaultCatalog);
        }
        catch (CoreException ex) {
            JptJpaCorePlugin.log(ex);
        }
    }

    public static String getUserOverrideDefaultSchema(IProject project) {
        try {
            return project.getPersistentProperty(USER_OVERRIDE_DEFAULT_SCHEMA);
        }
        catch (CoreException ex) {
            JptJpaCorePlugin.log(ex);
            return null;
        }
    }

    public static void setUserOverrideDefaultSchema(IProject project, String defaultSchema) {
        try {
            project.setPersistentProperty(USER_OVERRIDE_DEFAULT_SCHEMA, defaultSchema);
        }
        catch (CoreException ex) {
            JptJpaCorePlugin.log(ex);
        }
    }

    public static void clearProjectPersistentProperties(IProject project) {
        try {
            project.setPersistentProperty(DATA_SOURCE_CONNECTION_PROFILE_NAME, null);
            project.setPersistentProperty(USER_OVERRIDE_DEFAULT_CATALOG, null);
            project.setPersistentProperty(USER_OVERRIDE_DEFAULT_SCHEMA, null);
        }
        catch (CoreException ce) {
            JptJpaCorePlugin.log(ce);
        }
    }

    public static boolean nodeIsJpa2_0Compatible(JpaNode jpaNode) {
        return jpaNode.getJpaProject().getJpaPlatform().getJpaVersion().isCompatibleWithJpaVersion(JpaFacet.VERSION_2_0.getVersionString());
    }

    public static boolean nodeIsXml2_0Compatible(XmlContextNode xmlContextNode) {
        return JptJpaCorePlugin.resourceTypeIsCompatible(xmlContextNode.getResourceType(), "2.0");
    }

    public static boolean resourceTypeIsCompatible(JptResourceType resourceType, String version) {
        return JpaPlatform.Version.VERSION_COMPARATOR.compare(resourceType.getVersion(), version) >= 0;
    }

    public static void log(String msg) {
        INSTANCE.logError(msg);
    }

    public static void log(Throwable throwable) {
        INSTANCE.logError(throwable);
    }

    public static void log(String msg, Throwable throwable) {
        INSTANCE.logError(msg, throwable);
    }

    public JptJpaCorePlugin() {
        if (INSTANCE != null) {
            throw new IllegalStateException();
        }
        INSTANCE = this;
    }

    public synchronized void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public synchronized void stop(BundleContext context) throws Exception {
        try {
            for (InternalJpaProjectManager jpaProjectManager : this.jpaProjectManagers.values()) {
                jpaProjectManager.stop();
            }
            this.jpaProjectManagers.clear();
        }
        finally {
            super.stop(context);
        }
    }

    private synchronized InternalJpaProjectManager getJpaProjectManager_(IWorkspace workspace) {
        InternalJpaProjectManager jpaProjectManager = this.jpaProjectManagers.get(workspace);
        if (this.isActive() && jpaProjectManager == null) {
            jpaProjectManager = this.buildJpaProjectManager(workspace);
            jpaProjectManager.start();
            this.jpaProjectManagers.put(workspace, jpaProjectManager);
        }
        return jpaProjectManager;
    }

    private InternalJpaProjectManager buildJpaProjectManager(IWorkspace workspace) {
        return new InternalJpaProjectManager(workspace);
    }
}

