/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.context.orm;

import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.jpa.core.context.BaseTemporalConverter;
import org.eclipse.jpt.jpa.core.context.Converter;
import org.eclipse.jpt.jpa.core.context.orm.OrmAttributeMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmBaseTemporalConverter;
import org.eclipse.jpt.jpa.core.context.orm.OrmConverter;
import org.eclipse.jpt.jpa.core.context.orm.OrmXmlContextNodeFactory;
import org.eclipse.jpt.jpa.core.internal.context.JptValidator;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.ConverterTextRangeResolver;
import org.eclipse.jpt.jpa.core.internal.jpa2.context.orm.OrmElementCollectionTemporalConverterValidator;
import org.eclipse.jpt.jpa.core.internal.jpa2.context.orm.OrmTemporalConverterValidator;
import org.eclipse.jpt.jpa.core.resource.orm.TemporalType;
import org.eclipse.jpt.jpa.core.resource.orm.XmlAttributeMapping;
import org.eclipse.jpt.jpa.core.resource.orm.XmlConvertibleMapping;

public interface OrmTemporalConverter
extends OrmBaseTemporalConverter {

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class AbstractAdapter
    implements OrmConverter.Adapter {
        AbstractAdapter() {
        }

        @Override
        public Class<? extends Converter> getConverterType() {
            return BaseTemporalConverter.class;
        }

        @Override
        public OrmConverter buildConverter(OrmAttributeMapping parent, OrmXmlContextNodeFactory factory) {
            XmlConvertibleMapping xmlMapping = (XmlConvertibleMapping)((Object)parent.getXmlAttributeMapping());
            return xmlMapping.getTemporal() == null ? null : factory.buildOrmBaseTemporalConverter(parent, this.buildOwner(xmlMapping));
        }

        protected abstract OrmBaseTemporalConverter.Owner buildOwner(XmlConvertibleMapping var1);

        @Override
        public boolean isActive(XmlAttributeMapping xmlMapping) {
            return ((XmlConvertibleMapping)((Object)xmlMapping)).getTemporal() != null;
        }

        @Override
        public OrmConverter buildNewConverter(OrmAttributeMapping parent, OrmXmlContextNodeFactory factory) {
            return factory.buildOrmBaseTemporalConverter(parent, this.buildOwner((XmlConvertibleMapping)((Object)parent.getXmlAttributeMapping())));
        }

        @Override
        public void clearXmlValue(XmlAttributeMapping xmlMapping) {
            ((XmlConvertibleMapping)((Object)xmlMapping)).setTemporal(null);
        }
    }

    public static class BasicAdapter
    extends AbstractAdapter {
        private static final OrmConverter.Adapter INSTANCE = new BasicAdapter();

        public static OrmConverter.Adapter instance() {
            return INSTANCE;
        }

        private BasicAdapter() {
        }

        protected OrmBaseTemporalConverter.Owner buildOwner(final XmlConvertibleMapping mapping) {
            return new OrmBaseTemporalConverter.Owner(){

                public void setXmlTemporalType(TemporalType temporalType) {
                    mapping.setTemporal(temporalType);
                }

                public TemporalType getXmlTemporalType() {
                    return mapping.getTemporal();
                }

                public TextRange getTemporalTextRange() {
                    return mapping.getTemporalTextRange();
                }

                public JptValidator buildValidator(Converter converter, ConverterTextRangeResolver textRangeResolver) {
                    return new OrmTemporalConverterValidator((BaseTemporalConverter)converter, textRangeResolver);
                }
            };
        }
    }

    public static class ElementCollectionAdapter
    extends AbstractAdapter {
        private static final OrmConverter.Adapter INSTANCE = new ElementCollectionAdapter();

        public static OrmConverter.Adapter instance() {
            return INSTANCE;
        }

        private ElementCollectionAdapter() {
        }

        protected OrmBaseTemporalConverter.Owner buildOwner(final XmlConvertibleMapping mapping) {
            return new OrmBaseTemporalConverter.Owner(){

                public void setXmlTemporalType(TemporalType temporalType) {
                    mapping.setTemporal(temporalType);
                }

                public TemporalType getXmlTemporalType() {
                    return mapping.getTemporal();
                }

                public TextRange getTemporalTextRange() {
                    return mapping.getTemporalTextRange();
                }

                public JptValidator buildValidator(Converter converter, ConverterTextRangeResolver textRangeResolver) {
                    return new OrmElementCollectionTemporalConverterValidator((BaseTemporalConverter)converter, textRangeResolver);
                }
            };
        }
    }
}

