/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context;

import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.Transformer;
import org.eclipse.jpt.common.utility.internal.iterables.CompositeIterable;
import org.eclipse.jpt.common.utility.internal.iterables.FilteringIterable;
import org.eclipse.jpt.common.utility.internal.iterables.SubIterableWrapper;
import org.eclipse.jpt.common.utility.internal.iterables.TransformationIterable;
import org.eclipse.jpt.jpa.core.context.AttributeMapping;
import org.eclipse.jpt.jpa.core.context.ReadOnlyTable;
import org.eclipse.jpt.jpa.core.context.TypeMapping;
import org.eclipse.jpt.jpa.core.jpa2.context.DerivedIdentity2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.MapsIdDerivedIdentityStrategy2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.SingleRelationshipMapping2_0;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeMappingTools {
    public static final Transformer<TypeMapping, Iterable<AttributeMapping>> ATTRIBUTE_MAPPINGS_TRANSFORMER = new AttributeMappingsTransformer();
    public static final Transformer<TypeMapping, Iterable<ReadOnlyTable>> ASSOCIATED_TABLES_TRANSFORMER = new AssociatedTablesTransformer();
    public static final Transformer<TypeMapping, Iterable<String>> OVERRIDABLE_ATTRIBUTE_NAMES_TRANSFORMER = new OverridableAttributeNamesTransformer();
    public static final Transformer<TypeMapping, Iterable<String>> OVERRIDABLE_ASSOCIATION_NAMES_TRANSFORMER = new OverridableAssociationNamesTransformer();

    public static boolean attributeIsDerivedId(TypeMapping typeMapping, String attributeName) {
        if (attributeName == null) {
            return false;
        }
        int dotIndex = attributeName.indexOf(46);
        attributeName = dotIndex == -1 ? attributeName : attributeName.substring(0, dotIndex);
        return CollectionTools.contains(TypeMappingTools.getMapsIdDerivedIdAttributeNames(typeMapping), (Object)attributeName);
    }

    protected static Iterable<String> getMapsIdDerivedIdAttributeNames(TypeMapping typeMapping) {
        return new TransformationIterable<MapsIdDerivedIdentityStrategy2_0, String>(TypeMappingTools.getMapsIdDerivedIdentityStrategies(typeMapping)){

            protected String transform(MapsIdDerivedIdentityStrategy2_0 strategy) {
                return strategy.getIdAttributeName();
            }
        };
    }

    protected static Iterable<MapsIdDerivedIdentityStrategy2_0> getMapsIdDerivedIdentityStrategies(TypeMapping typeMapping) {
        return new TransformationIterable<DerivedIdentity2_0, MapsIdDerivedIdentityStrategy2_0>(TypeMappingTools.getMapsIdDerivedIdentities(typeMapping)){

            protected MapsIdDerivedIdentityStrategy2_0 transform(DerivedIdentity2_0 derivedIdentity) {
                return derivedIdentity.getMapsIdDerivedIdentityStrategy();
            }
        };
    }

    protected static Iterable<DerivedIdentity2_0> getMapsIdDerivedIdentities(TypeMapping typeMapping) {
        return new FilteringIterable<DerivedIdentity2_0>(TypeMappingTools.getDerivedIdentities(typeMapping)){

            protected boolean accept(DerivedIdentity2_0 derivedIdentity) {
                return derivedIdentity.usesMapsIdDerivedIdentityStrategy();
            }
        };
    }

    protected static Iterable<DerivedIdentity2_0> getDerivedIdentities(TypeMapping typeMapping) {
        return new TransformationIterable<SingleRelationshipMapping2_0, DerivedIdentity2_0>(TypeMappingTools.getSingleRelationshipMappings(typeMapping)){

            protected DerivedIdentity2_0 transform(SingleRelationshipMapping2_0 mapping) {
                return mapping.getDerivedIdentity();
            }
        };
    }

    protected static Iterable<SingleRelationshipMapping2_0> getSingleRelationshipMappings(TypeMapping typeMapping) {
        return new SubIterableWrapper(TypeMappingTools.getSingleRelationshipMappings_(typeMapping));
    }

    protected static Iterable<AttributeMapping> getSingleRelationshipMappings_(TypeMapping typeMapping) {
        return new CompositeIterable(new Iterable[]{typeMapping.getAllAttributeMappings("oneToOne"), typeMapping.getAllAttributeMappings("manyToOne")});
    }

    private TypeMappingTools() {
        throw new UnsupportedOperationException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class AssociatedTablesTransformer
    implements Transformer<TypeMapping, Iterable<ReadOnlyTable>> {
        AssociatedTablesTransformer() {
        }

        public Iterable<ReadOnlyTable> transform(TypeMapping mapping) {
            return mapping.getAssociatedTables();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class AttributeMappingsTransformer
    implements Transformer<TypeMapping, Iterable<AttributeMapping>> {
        AttributeMappingsTransformer() {
        }

        public Iterable<AttributeMapping> transform(TypeMapping mapping) {
            return mapping.getAttributeMappings();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class OverridableAssociationNamesTransformer
    implements Transformer<TypeMapping, Iterable<String>> {
        OverridableAssociationNamesTransformer() {
        }

        public Iterable<String> transform(TypeMapping mapping) {
            return mapping.getOverridableAssociationNames();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class OverridableAttributeNamesTransformer
    implements Transformer<TypeMapping, Iterable<String>> {
        OverridableAttributeNamesTransformer() {
        }

        public Iterable<String> transform(TypeMapping mapping) {
            return mapping.getOverridableAttributeNames();
        }
    }
}

