/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.java;

import java.util.List;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.resource.java.Annotation;
import org.eclipse.jpt.common.core.resource.java.JavaResourceMember;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.Filter;
import org.eclipse.jpt.common.utility.internal.Transformer;
import org.eclipse.jpt.common.utility.internal.iterables.CompositeIterable;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterables.TransformationIterable;
import org.eclipse.jpt.jpa.core.context.AttributeMapping;
import org.eclipse.jpt.jpa.core.context.AttributeOverrideContainer;
import org.eclipse.jpt.jpa.core.context.Column;
import org.eclipse.jpt.jpa.core.context.Embeddable;
import org.eclipse.jpt.jpa.core.context.OverrideContainer;
import org.eclipse.jpt.jpa.core.context.ReadOnlyAttributeOverride;
import org.eclipse.jpt.jpa.core.context.ReadOnlyBaseColumn;
import org.eclipse.jpt.jpa.core.context.ReadOnlyOverride;
import org.eclipse.jpt.jpa.core.context.ReadOnlyPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.ReadOnlyTableColumn;
import org.eclipse.jpt.jpa.core.context.TypeMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaAttributeOverride;
import org.eclipse.jpt.jpa.core.context.java.JavaAttributeOverrideContainer;
import org.eclipse.jpt.jpa.core.context.java.JavaBaseEmbeddedMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.jpa.core.internal.context.AttributeMappingTools;
import org.eclipse.jpt.jpa.core.internal.context.JptValidator;
import org.eclipse.jpt.jpa.core.internal.context.MappingTools;
import org.eclipse.jpt.jpa.core.internal.context.OverrideTextRangeResolver;
import org.eclipse.jpt.jpa.core.internal.context.TableColumnTextRangeResolver;
import org.eclipse.jpt.jpa.core.internal.context.java.AbstractJavaAttributeMapping;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.AttributeOverrideColumnValidator;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.AttributeOverrideValidator;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.EmbeddableOverrideDescriptionProvider;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.EntityTableDescriptionProvider;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.OverrideValidator;
import org.eclipse.jpt.jpa.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.jpa.core.jpa2.context.java.JavaAttributeOverrideContainer2_0;
import org.eclipse.jpt.jpa.db.Table;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJavaBaseEmbeddedMapping<A extends Annotation>
extends AbstractJavaAttributeMapping<A>
implements JavaBaseEmbeddedMapping {
    protected final JavaAttributeOverrideContainer attributeOverrideContainer = this.buildAttributeOverrideContainer();
    protected Embeddable targetEmbeddable;

    protected AbstractJavaBaseEmbeddedMapping(JavaPersistentAttribute parent) {
        super(parent);
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.attributeOverrideContainer.synchronizeWithResourceModel();
    }

    @Override
    public void update() {
        super.update();
        this.attributeOverrideContainer.update();
        this.setTargetEmbeddable(this.buildTargetEmbeddable());
    }

    @Override
    public JavaAttributeOverrideContainer getAttributeOverrideContainer() {
        return this.attributeOverrideContainer;
    }

    protected JavaAttributeOverrideContainer buildAttributeOverrideContainer() {
        return this.getJpaFactory().buildJavaAttributeOverrideContainer(this, this.buildAttributeOverrideContainerOwner());
    }

    protected abstract JavaAttributeOverrideContainer.Owner buildAttributeOverrideContainerOwner();

    @Override
    public Embeddable getTargetEmbeddable() {
        return this.targetEmbeddable;
    }

    protected void setTargetEmbeddable(Embeddable embeddable) {
        Embeddable old = this.targetEmbeddable;
        this.targetEmbeddable = embeddable;
        this.firePropertyChanged("targetEmbeddable", old, embeddable);
    }

    protected Embeddable buildTargetEmbeddable() {
        String typeName = this.getPersistentAttribute().getSingleReferenceTargetTypeName();
        return typeName == null ? null : this.getPersistenceUnit().getEmbeddable(typeName);
    }

    @Override
    public Iterable<String> getAllOverridableAttributeMappingNames() {
        return this.isJpa2_0Compatible() ? this.getEmbeddableOverridableAttributeMappingNames() : super.getAllOverridableAttributeMappingNames();
    }

    protected Iterable<String> getEmbeddableOverridableAttributeMappingNames() {
        return this.getQualifiedEmbeddableOverridableMappingNames(AttributeMappingTools.ALL_OVERRIDABLE_ATTRIBUTE_MAPPING_NAMES_TRANSFORMER);
    }

    @Override
    public Iterable<String> getAllOverridableAssociationMappingNames() {
        return this.isJpa2_0Compatible() ? this.getEmbeddableOverridableAssociationMappingNames() : super.getAllOverridableAssociationMappingNames();
    }

    protected Iterable<String> getEmbeddableOverridableAssociationMappingNames() {
        return this.getQualifiedEmbeddableOverridableMappingNames(AttributeMappingTools.ALL_OVERRIDABLE_ASSOCIATION_MAPPING_NAMES_TRANSFORMER);
    }

    protected Iterable<String> getQualifiedEmbeddableOverridableMappingNames(Transformer<AttributeMapping, Iterable<String>> transformer) {
        return new TransformationIterable(this.getEmbeddableAttributeMappingNames(transformer), this.buildQualifierTransformer());
    }

    protected Iterable<String> getEmbeddableAttributeMappingNames(Transformer<AttributeMapping, Iterable<String>> transformer) {
        return new CompositeIterable(this.getEmbeddableAttributeMappingNamesLists(transformer));
    }

    protected Iterable<Iterable<String>> getEmbeddableAttributeMappingNamesLists(Transformer<AttributeMapping, Iterable<String>> transformer) {
        return new TransformationIterable(this.getEmbeddableAttributeMappings(), transformer);
    }

    protected Iterable<AttributeMapping> getEmbeddableAttributeMappings() {
        return this.targetEmbeddable != null && this.targetEmbeddable != this.getTypeMapping() ? this.targetEmbeddable.getAttributeMappings() : EmptyIterable.instance();
    }

    @Override
    public Column resolveOverriddenColumn(String attributeName) {
        return this.isJpa2_0Compatible() ? this.resolveOverriddenColumn_(attributeName) : null;
    }

    protected Column resolveOverriddenColumn_(String attributeName) {
        if ((attributeName = this.unqualify(attributeName)) == null) {
            return null;
        }
        JavaAttributeOverride override = this.attributeOverrideContainer.getSpecifiedOverrideNamed(attributeName);
        return override != null ? override.getColumn() : this.resolveOverriddenColumnInTargetEmbeddable(attributeName);
    }

    protected Column resolveOverriddenColumnInTargetEmbeddable(String attributeName) {
        return this.targetEmbeddable == null ? null : this.targetEmbeddable.resolveOverriddenColumn(attributeName);
    }

    @Override
    public Iterable<String> getJavaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterable result = super.getJavaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        result = this.attributeOverrideContainer.getJavaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        return null;
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
        if (this.validateTargetEmbeddable(messages, astRoot)) {
            this.validateOverrides(messages, reporter, astRoot);
        }
    }

    protected boolean validateTargetEmbeddable(List<IMessage> messages, CompilationUnit astRoot) {
        if (this.targetEmbeddable != null) {
            return true;
        }
        String targetEmbeddableTypeName = this.getPersistentAttribute().getTypeName();
        if (this.getPersistentAttribute().isVirtual()) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "VIRTUAL_ATTRIBUTE_TARGET_NOT_AN_EMBEDDABLE", new String[]{this.getName(), targetEmbeddableTypeName}, this, this.getValidationTextRange(astRoot)));
        } else {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "TARGET_NOT_AN_EMBEDDABLE", new String[]{targetEmbeddableTypeName}, this, this.getValidationTextRange(astRoot)));
        }
        return false;
    }

    protected void validateOverrides(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        this.attributeOverrideContainer.validate(messages, reporter, astRoot);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class AttributeOverrideContainerOwner
    implements JavaAttributeOverrideContainer2_0.Owner {
        protected AttributeOverrideContainerOwner() {
        }

        @Override
        public JavaResourceMember getResourceMember() {
            return AbstractJavaBaseEmbeddedMapping.this.getResourceAttribute();
        }

        @Override
        public TypeMapping getTypeMapping() {
            return AbstractJavaBaseEmbeddedMapping.this.getTypeMapping();
        }

        @Override
        public TypeMapping getOverridableTypeMapping() {
            return AbstractJavaBaseEmbeddedMapping.this.getTargetEmbeddable();
        }

        @Override
        public Iterable<String> getAllOverridableNames() {
            TypeMapping overriddenTypeMapping = this.getOverridableTypeMapping();
            return overriddenTypeMapping != null ? this.getAllOverridableAttributeNames_(overriddenTypeMapping) : EmptyIterable.instance();
        }

        protected Iterable<String> getAllOverridableAttributeNames_(TypeMapping overriddenTypeMapping) {
            return overriddenTypeMapping.getAllOverridableAttributeNames();
        }

        @Override
        public Column resolveOverriddenColumn(String attributeName) {
            return MappingTools.resolveOverriddenColumn(this.getOverridableTypeMapping(), attributeName);
        }

        @Override
        public boolean tableNameIsInvalid(String tableName) {
            return this.getTypeMapping().tableNameIsInvalid(tableName);
        }

        @Override
        public Iterable<String> getCandidateTableNames() {
            return this.getTypeMapping().getAllAssociatedTableNames();
        }

        @Override
        public Table resolveDbTable(String tableName) {
            return this.getTypeMapping().resolveDbTable(tableName);
        }

        @Override
        public String getDefaultTableName() {
            return this.getTypeMapping().getPrimaryTableName();
        }

        @Override
        public String getPossiblePrefix() {
            return null;
        }

        @Override
        public String getWritePrefix() {
            return null;
        }

        @Override
        public boolean isRelevant(String overrideName) {
            return true;
        }

        @Override
        public TextRange getValidationTextRange(CompilationUnit astRoot) {
            return AbstractJavaBaseEmbeddedMapping.this.getValidationTextRange(astRoot);
        }

        @Override
        public JptValidator buildOverrideValidator(ReadOnlyOverride override, OverrideContainer container, OverrideTextRangeResolver textRangeResolver) {
            return new AttributeOverrideValidator((ReadOnlyPersistentAttribute)this.getPersistentAttribute(), (ReadOnlyAttributeOverride)override, (AttributeOverrideContainer)container, textRangeResolver, (OverrideValidator.OverrideDescriptionProvider)new EmbeddableOverrideDescriptionProvider());
        }

        @Override
        public JptValidator buildColumnValidator(ReadOnlyOverride override, ReadOnlyBaseColumn column, ReadOnlyTableColumn.Owner owner, TableColumnTextRangeResolver textRangeResolver) {
            return new AttributeOverrideColumnValidator(this.getPersistentAttribute(), (ReadOnlyAttributeOverride)override, column, textRangeResolver, new EntityTableDescriptionProvider());
        }

        protected JavaPersistentAttribute getPersistentAttribute() {
            return AbstractJavaBaseEmbeddedMapping.this.getPersistentAttribute();
        }
    }
}

