/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.java;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceMember;
import org.eclipse.jpt.common.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.resource.java.NestableAnnotation;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.Filter;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.NotNullFilter;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.Tools;
import org.eclipse.jpt.common.utility.internal.iterables.CompositeIterable;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.FilteringIterable;
import org.eclipse.jpt.common.utility.internal.iterables.ListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.LiveCloneListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.SingleElementListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.SubListIterableWrapper;
import org.eclipse.jpt.common.utility.internal.iterables.TransformationIterable;
import org.eclipse.jpt.jpa.core.JpaPlatformVariation;
import org.eclipse.jpt.jpa.core.context.AssociationOverrideContainer;
import org.eclipse.jpt.jpa.core.context.AttributeMapping;
import org.eclipse.jpt.jpa.core.context.AttributeOverrideContainer;
import org.eclipse.jpt.jpa.core.context.Column;
import org.eclipse.jpt.jpa.core.context.DiscriminatorColumn;
import org.eclipse.jpt.jpa.core.context.DiscriminatorType;
import org.eclipse.jpt.jpa.core.context.Entity;
import org.eclipse.jpt.jpa.core.context.Generator;
import org.eclipse.jpt.jpa.core.context.InheritanceType;
import org.eclipse.jpt.jpa.core.context.JpaContextNode;
import org.eclipse.jpt.jpa.core.context.OverrideContainer;
import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpa.core.context.PrimaryKeyJoinColumn;
import org.eclipse.jpt.jpa.core.context.Query;
import org.eclipse.jpt.jpa.core.context.ReadOnlyAssociationOverride;
import org.eclipse.jpt.jpa.core.context.ReadOnlyAttributeOverride;
import org.eclipse.jpt.jpa.core.context.ReadOnlyBaseColumn;
import org.eclipse.jpt.jpa.core.context.ReadOnlyBaseJoinColumn;
import org.eclipse.jpt.jpa.core.context.ReadOnlyJoinColumn;
import org.eclipse.jpt.jpa.core.context.ReadOnlyJoinTable;
import org.eclipse.jpt.jpa.core.context.ReadOnlyNamedColumn;
import org.eclipse.jpt.jpa.core.context.ReadOnlyNamedDiscriminatorColumn;
import org.eclipse.jpt.jpa.core.context.ReadOnlyOverride;
import org.eclipse.jpt.jpa.core.context.ReadOnlySecondaryTable;
import org.eclipse.jpt.jpa.core.context.ReadOnlyTable;
import org.eclipse.jpt.jpa.core.context.ReadOnlyTableColumn;
import org.eclipse.jpt.jpa.core.context.Relationship;
import org.eclipse.jpt.jpa.core.context.SecondaryTable;
import org.eclipse.jpt.jpa.core.context.TypeMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaAssociationOverride;
import org.eclipse.jpt.jpa.core.context.java.JavaAssociationOverrideContainer;
import org.eclipse.jpt.jpa.core.context.java.JavaAttributeOverride;
import org.eclipse.jpt.jpa.core.context.java.JavaAttributeOverrideContainer;
import org.eclipse.jpt.jpa.core.context.java.JavaDiscriminatorColumn;
import org.eclipse.jpt.jpa.core.context.java.JavaEntity;
import org.eclipse.jpt.jpa.core.context.java.JavaGeneratorContainer;
import org.eclipse.jpt.jpa.core.context.java.JavaIdClassReference;
import org.eclipse.jpt.jpa.core.context.java.JavaJpaContextNode;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpa.core.context.java.JavaPrimaryKeyJoinColumn;
import org.eclipse.jpt.jpa.core.context.java.JavaQueryContainer;
import org.eclipse.jpt.jpa.core.context.java.JavaReadOnlyBaseJoinColumn;
import org.eclipse.jpt.jpa.core.context.java.JavaReadOnlyNamedColumn;
import org.eclipse.jpt.jpa.core.context.java.JavaSecondaryTable;
import org.eclipse.jpt.jpa.core.context.java.JavaTable;
import org.eclipse.jpt.jpa.core.internal.AbstractJpaNode;
import org.eclipse.jpt.jpa.core.internal.context.BaseJoinColumnTextRangeResolver;
import org.eclipse.jpt.jpa.core.internal.context.EntityTextRangeResolver;
import org.eclipse.jpt.jpa.core.internal.context.JoinColumnTextRangeResolver;
import org.eclipse.jpt.jpa.core.internal.context.JptValidator;
import org.eclipse.jpt.jpa.core.internal.context.MappingTools;
import org.eclipse.jpt.jpa.core.internal.context.NamedColumnTextRangeResolver;
import org.eclipse.jpt.jpa.core.internal.context.OverrideTextRangeResolver;
import org.eclipse.jpt.jpa.core.internal.context.PrimaryKeyTextRangeResolver;
import org.eclipse.jpt.jpa.core.internal.context.TableColumnTextRangeResolver;
import org.eclipse.jpt.jpa.core.internal.context.TableTextRangeResolver;
import org.eclipse.jpt.jpa.core.internal.context.TypeMappingTools;
import org.eclipse.jpt.jpa.core.internal.context.java.AbstractJavaTypeMapping;
import org.eclipse.jpt.jpa.core.internal.context.java.GenericJavaIdClassReference;
import org.eclipse.jpt.jpa.core.internal.context.java.JavaEntityTextRangeResolver;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.AbstractNamedColumnValidator;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.AssociationOverrideInverseJoinColumnValidator;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.AssociationOverrideJoinColumnValidator;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.AssociationOverrideJoinTableValidator;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.AssociationOverrideValidator;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.AttributeOverrideColumnValidator;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.AttributeOverrideValidator;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.DiscriminatorColumnValidator;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.EntityPrimaryKeyJoinColumnValidator;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.EntityTableDescriptionProvider;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.GenericEntityPrimaryKeyValidator;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.JoinTableTableDescriptionProvider;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.MappedSuperclassOverrideDescriptionProvider;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.OverrideValidator;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.SecondaryTableValidator;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.TableValidator;
import org.eclipse.jpt.jpa.core.internal.resource.java.NullPrimaryKeyJoinColumnAnnotation;
import org.eclipse.jpt.jpa.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.jpa.core.jpa2.context.java.JavaAssociationOverrideContainer2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.java.JavaAttributeOverrideContainer2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.java.JavaCacheableHolder2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.java.JavaOverrideContainer2_0;
import org.eclipse.jpt.jpa.core.resource.java.DiscriminatorValueAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.EntityAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.InheritanceAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.PrimaryKeyJoinColumnAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.SecondaryTableAnnotation;
import org.eclipse.jpt.jpa.db.Schema;
import org.eclipse.jpt.jpa.db.Table;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJavaEntity
extends AbstractJavaTypeMapping<EntityAnnotation>
implements JavaEntity,
JavaCacheableHolder2_0,
JavaGeneratorContainer.ParentAdapter,
JavaQueryContainer.Owner {
    protected String specifiedName;
    protected String defaultName;
    protected Entity rootEntity;
    protected final Vector<Entity> descendants = new Vector();
    protected final JavaIdClassReference idClassReference;
    protected final JavaTable table;
    protected boolean specifiedTableIsAllowed;
    protected boolean tableIsUndefined;
    protected final AbstractJpaNode.ContextListContainer<JavaSecondaryTable, SecondaryTableAnnotation> specifiedSecondaryTableContainer;
    protected final ReadOnlyTable.Owner specifiedSecondaryTableOwner;
    protected final PrimaryKeyJoinColumnOwner primaryKeyJoinColumnOwner;
    protected final AbstractJpaNode.ContextListContainer<JavaPrimaryKeyJoinColumn, PrimaryKeyJoinColumnAnnotation> specifiedPrimaryKeyJoinColumnContainer;
    protected JavaPrimaryKeyJoinColumn defaultPrimaryKeyJoinColumn;
    protected InheritanceType specifiedInheritanceStrategy;
    protected InheritanceType defaultInheritanceStrategy;
    protected String specifiedDiscriminatorValue;
    protected String defaultDiscriminatorValue;
    protected boolean specifiedDiscriminatorValueIsAllowed;
    protected boolean discriminatorValueIsUndefined;
    protected final JavaDiscriminatorColumn discriminatorColumn;
    protected boolean specifiedDiscriminatorColumnIsAllowed;
    protected boolean discriminatorColumnIsUndefined;
    protected final JavaAttributeOverrideContainer attributeOverrideContainer;
    protected final JavaAssociationOverrideContainer associationOverrideContainer;
    protected final JavaGeneratorContainer generatorContainer;
    protected final JavaQueryContainer queryContainer;

    protected AbstractJavaEntity(JavaPersistentType parent, EntityAnnotation mappingAnnotation) {
        super(parent, mappingAnnotation);
        this.specifiedName = ((EntityAnnotation)this.mappingAnnotation).getName();
        this.idClassReference = this.buildIdClassReference();
        this.table = this.buildTable();
        this.rootEntity = this;
        this.specifiedSecondaryTableOwner = this.buildSpecifiedSecondaryTableOwner();
        this.specifiedSecondaryTableContainer = this.buildSpecifiedSecondaryTableContainer();
        this.primaryKeyJoinColumnOwner = this.buildPrimaryKeyJoinColumnOwner();
        this.specifiedPrimaryKeyJoinColumnContainer = this.buildSpecifiedPrimaryKeyJoinColumnContainer();
        this.specifiedInheritanceStrategy = this.buildSpecifiedInheritanceStrategy();
        this.specifiedDiscriminatorValue = this.getDiscriminatorValueAnnotation().getValue();
        this.discriminatorColumn = this.buildDiscriminatorColumn();
        this.attributeOverrideContainer = this.buildAttributeOverrideContainer();
        this.associationOverrideContainer = this.buildAssociationOverrideContainer();
        this.generatorContainer = this.buildGeneratorContainer();
        this.queryContainer = this.buildQueryContainer();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setSpecifiedName_(((EntityAnnotation)this.mappingAnnotation).getName());
        this.idClassReference.synchronizeWithResourceModel();
        this.table.synchronizeWithResourceModel();
        this.syncSpecifiedSecondaryTables();
        this.syncSpecifiedPrimaryKeyJoinColumns();
        this.setSpecifiedInheritanceStrategy_(this.buildSpecifiedInheritanceStrategy());
        this.setSpecifiedDiscriminatorValue_(this.getDiscriminatorValueAnnotation().getValue());
        this.discriminatorColumn.synchronizeWithResourceModel();
        this.attributeOverrideContainer.synchronizeWithResourceModel();
        this.associationOverrideContainer.synchronizeWithResourceModel();
        this.generatorContainer.synchronizeWithResourceModel();
        this.queryContainer.synchronizeWithResourceModel();
    }

    @Override
    public void update() {
        super.update();
        this.setDefaultName(this.buildDefaultName());
        this.setRootEntity(this.buildRootEntity());
        this.updateDescendants();
        this.idClassReference.update();
        this.setDefaultInheritanceStrategy(this.buildDefaultInheritanceStrategy());
        this.table.update();
        this.setSpecifiedTableIsAllowed(this.buildSpecifiedTableIsAllowed());
        this.setTableIsUndefined(this.buildTableIsUndefined());
        this.updateNodes((Iterable<? extends JpaContextNode>)this.getSecondaryTables());
        this.updateDefaultPrimaryKeyJoinColumn();
        this.updateNodes((Iterable<? extends JpaContextNode>)this.getPrimaryKeyJoinColumns());
        this.discriminatorColumn.update();
        this.setSpecifiedDiscriminatorColumnIsAllowed(this.buildSpecifiedDiscriminatorColumnIsAllowed());
        this.setDiscriminatorColumnIsUndefined(this.buildDiscriminatorColumnIsUndefined());
        this.setDefaultDiscriminatorValue(this.buildDefaultDiscriminatorValue());
        this.setSpecifiedDiscriminatorValueIsAllowed(this.buildSpecifiedDiscriminatorValueIsAllowed());
        this.setDiscriminatorValueIsUndefined(this.buildDiscriminatorValueIsUndefined());
        this.attributeOverrideContainer.update();
        this.associationOverrideContainer.update();
        this.generatorContainer.update();
        this.queryContainer.update();
    }

    @Override
    public String getName() {
        return this.specifiedName != null ? this.specifiedName : this.defaultName;
    }

    @Override
    public String getSpecifiedName() {
        return this.specifiedName;
    }

    @Override
    public void setSpecifiedName(String name) {
        ((EntityAnnotation)this.mappingAnnotation).setName(name);
        this.setSpecifiedName_(name);
    }

    protected void setSpecifiedName_(String name) {
        String old = this.specifiedName;
        this.specifiedName = name;
        this.firePropertyChanged("specifiedName", old, name);
    }

    @Override
    public String getDefaultName() {
        return this.defaultName;
    }

    protected void setDefaultName(String name) {
        String old = this.defaultName;
        this.defaultName = name;
        this.firePropertyChanged("defaultName", old, name);
    }

    protected String buildDefaultName() {
        return this.getJavaResourceType().getName();
    }

    @Override
    public Entity getRootEntity() {
        return this.rootEntity;
    }

    protected void setRootEntity(Entity entity) {
        Entity old = this.rootEntity;
        this.rootEntity = entity;
        this.firePropertyChanged("rootEntity", old, entity);
    }

    protected Entity buildRootEntity() {
        Entity root = this;
        for (TypeMapping typeMapping : this.getAncestors()) {
            if (!(typeMapping instanceof Entity)) continue;
            root = (Entity)typeMapping;
        }
        return root;
    }

    @Override
    public Iterable<Entity> getDescendants() {
        return new LiveCloneListIterable(this.descendants);
    }

    protected void updateDescendants() {
        this.synchronizeCollection(this.buildDescendants(), this.descendants, "descendants");
    }

    protected Iterable<Entity> buildDescendants() {
        if (!this.isRootEntity()) {
            return EmptyIterable.instance();
        }
        return new FilteringIterable<Entity>(this.getPersistenceUnit().getEntities()){

            protected boolean accept(Entity entity) {
                return AbstractJavaEntity.this.entityIsDescendant(entity);
            }
        };
    }

    protected boolean entityIsDescendant(Entity entity) {
        String typeName = this.getPersistentType().getName();
        String entityTypeName = entity.getPersistentType().getName();
        String rootEntityTypeName = entity.getRootEntity().getPersistentType().getName();
        return Tools.valuesAreDifferent((Object)typeName, (Object)entityTypeName) && Tools.valuesAreEqual((Object)typeName, (Object)rootEntityTypeName);
    }

    @Override
    public JavaIdClassReference getIdClassReference() {
        return this.idClassReference;
    }

    protected JavaIdClassReference buildIdClassReference() {
        return new GenericJavaIdClassReference(this);
    }

    @Override
    public JavaPersistentType getIdClass() {
        return this.idClassReference.getIdClass();
    }

    @Override
    public JavaTable getTable() {
        return this.table;
    }

    protected JavaTable buildTable() {
        return this.getJpaFactory().buildJavaTable(this, this.buildTableOwner());
    }

    protected ReadOnlyTable.Owner buildTableOwner() {
        return new TableOwner();
    }

    @Override
    public boolean specifiedTableIsAllowed() {
        return this.specifiedTableIsAllowed;
    }

    protected void setSpecifiedTableIsAllowed(boolean specifiedTableIsAllowed) {
        boolean old = this.specifiedTableIsAllowed;
        this.specifiedTableIsAllowed = specifiedTableIsAllowed;
        this.firePropertyChanged("specifiedTableIsAllowed", old, specifiedTableIsAllowed);
    }

    protected boolean buildSpecifiedTableIsAllowed() {
        return !this.isAbstractTablePerClass() && !this.isSingleTableDescendant();
    }

    @Override
    public boolean tableIsUndefined() {
        return this.tableIsUndefined;
    }

    protected void setTableIsUndefined(boolean tableIsUndefined) {
        boolean old = this.tableIsUndefined;
        this.tableIsUndefined = tableIsUndefined;
        this.firePropertyChanged("tableIsUndefined", old, tableIsUndefined);
    }

    protected boolean buildTableIsUndefined() {
        return this.isAbstractTablePerClass();
    }

    @Override
    public String getDefaultTableName() {
        return this.isSingleTableDescendant() ? this.rootEntity.getTable().getName() : (this.isAbstractTablePerClass() ? null : this.getName());
    }

    @Override
    public String getDefaultSchema() {
        return this.isSingleTableDescendant() ? this.rootEntity.getTable().getSchema() : (this.isAbstractTablePerClass() ? null : this.getContextDefaultSchema());
    }

    @Override
    public String getDefaultCatalog() {
        return this.isSingleTableDescendant() ? this.rootEntity.getTable().getCatalog() : (this.isAbstractTablePerClass() ? null : this.getContextDefaultCatalog());
    }

    @Override
    public ListIterable<JavaSecondaryTable> getSecondaryTables() {
        return this.getSpecifiedSecondaryTables();
    }

    @Override
    public int getSecondaryTablesSize() {
        return this.getSpecifiedSecondaryTablesSize();
    }

    @Override
    public ListIterable<JavaSecondaryTable> getSpecifiedSecondaryTables() {
        return this.specifiedSecondaryTableContainer.getContextElements();
    }

    @Override
    public int getSpecifiedSecondaryTablesSize() {
        return this.specifiedSecondaryTableContainer.getContextElementsSize();
    }

    @Override
    public JavaSecondaryTable addSpecifiedSecondaryTable() {
        return this.addSpecifiedSecondaryTable(this.getSpecifiedSecondaryTablesSize());
    }

    @Override
    public JavaSecondaryTable addSpecifiedSecondaryTable(int index) {
        SecondaryTableAnnotation annotation = this.addSecondaryTableAnnotation(index);
        return (JavaSecondaryTable)this.specifiedSecondaryTableContainer.addContextElement(index, annotation);
    }

    protected SecondaryTableAnnotation addSecondaryTableAnnotation(int index) {
        return (SecondaryTableAnnotation)this.getJavaResourceType().addAnnotation(index, "javax.persistence.SecondaryTable");
    }

    @Override
    public void removeSpecifiedSecondaryTable(SecondaryTable secondaryTable) {
        this.removeSpecifiedSecondaryTable(this.specifiedSecondaryTableContainer.indexOfContextElement((JavaSecondaryTable)secondaryTable));
    }

    @Override
    public void removeSpecifiedSecondaryTable(int index) {
        this.getJavaResourceType().removeAnnotation(index, "javax.persistence.SecondaryTable");
        this.specifiedSecondaryTableContainer.removeContextElement(index);
    }

    @Override
    public void moveSpecifiedSecondaryTable(int targetIndex, int sourceIndex) {
        this.getResourceAnnotatedElement().moveAnnotation(targetIndex, sourceIndex, "javax.persistence.SecondaryTable");
        this.specifiedSecondaryTableContainer.moveContextElement(targetIndex, sourceIndex);
    }

    protected JavaSecondaryTable buildSecondaryTable(SecondaryTableAnnotation secondaryTableAnnotation) {
        return this.getJpaFactory().buildJavaSecondaryTable(this, this.specifiedSecondaryTableOwner, secondaryTableAnnotation);
    }

    protected void syncSpecifiedSecondaryTables() {
        this.specifiedSecondaryTableContainer.synchronizeWithResourceModel();
    }

    protected ListIterable<SecondaryTableAnnotation> getSecondaryTableAnnotations() {
        return this.getSecondaryTableAnnotations_();
    }

    protected ListIterable<SecondaryTableAnnotation> getSecondaryTableAnnotations_() {
        return new SubListIterableWrapper(this.getNestableSecondaryTableAnnotations_());
    }

    protected ListIterable<NestableAnnotation> getNestableSecondaryTableAnnotations_() {
        return this.getResourceAnnotatedElement().getAnnotations("javax.persistence.SecondaryTable");
    }

    protected AbstractJpaNode.ContextListContainer<JavaSecondaryTable, SecondaryTableAnnotation> buildSpecifiedSecondaryTableContainer() {
        SpecifiedSecondaryTableContainer container = new SpecifiedSecondaryTableContainer();
        container.initialize();
        return container;
    }

    protected ReadOnlyTable.Owner buildSpecifiedSecondaryTableOwner() {
        return new SecondaryTableOwner();
    }

    @Override
    public ListIterable<JavaPrimaryKeyJoinColumn> getPrimaryKeyJoinColumns() {
        return this.hasSpecifiedPrimaryKeyJoinColumns() ? this.getSpecifiedPrimaryKeyJoinColumns() : this.getDefaultPrimaryKeyJoinColumns();
    }

    @Override
    public int getPrimaryKeyJoinColumnsSize() {
        return this.hasSpecifiedPrimaryKeyJoinColumns() ? this.getSpecifiedPrimaryKeyJoinColumnsSize() : this.getDefaultPrimaryKeyJoinColumnsSize();
    }

    @Override
    public ListIterable<JavaPrimaryKeyJoinColumn> getSpecifiedPrimaryKeyJoinColumns() {
        return this.specifiedPrimaryKeyJoinColumnContainer.getContextElements();
    }

    @Override
    public PrimaryKeyJoinColumn getSpecifiedPrimaryKeyJoinColumn(int index) {
        return (PrimaryKeyJoinColumn)this.specifiedPrimaryKeyJoinColumnContainer.get(index);
    }

    @Override
    public int getSpecifiedPrimaryKeyJoinColumnsSize() {
        return this.specifiedPrimaryKeyJoinColumnContainer.getContextElementsSize();
    }

    protected boolean hasSpecifiedPrimaryKeyJoinColumns() {
        return this.getSpecifiedPrimaryKeyJoinColumnsSize() != 0;
    }

    @Override
    public JavaPrimaryKeyJoinColumn addSpecifiedPrimaryKeyJoinColumn() {
        return this.addSpecifiedPrimaryKeyJoinColumn(this.getSpecifiedPrimaryKeyJoinColumnsSize());
    }

    @Override
    public JavaPrimaryKeyJoinColumn addSpecifiedPrimaryKeyJoinColumn(int index) {
        PrimaryKeyJoinColumnAnnotation annotation = this.addPrimaryKeyJoinColumnAnnotation(index);
        return (JavaPrimaryKeyJoinColumn)this.specifiedPrimaryKeyJoinColumnContainer.addContextElement(index, annotation);
    }

    protected PrimaryKeyJoinColumnAnnotation addPrimaryKeyJoinColumnAnnotation(int index) {
        return (PrimaryKeyJoinColumnAnnotation)this.getJavaResourceType().addAnnotation(index, "javax.persistence.PrimaryKeyJoinColumn");
    }

    @Override
    public void removeSpecifiedPrimaryKeyJoinColumn(PrimaryKeyJoinColumn joinColumn) {
        this.removeSpecifiedPrimaryKeyJoinColumn(this.specifiedPrimaryKeyJoinColumnContainer.indexOfContextElement((JavaPrimaryKeyJoinColumn)joinColumn));
    }

    @Override
    public void convertDefaultPrimaryKeyJoinColumnsToSpecified() {
        if (this.defaultPrimaryKeyJoinColumn == null) {
            throw new IllegalStateException("default PK join column is null");
        }
        String columnName = this.defaultPrimaryKeyJoinColumn.getDefaultName();
        String referencedColumnName = this.defaultPrimaryKeyJoinColumn.getDefaultReferencedColumnName();
        JavaPrimaryKeyJoinColumn pkJoinColumn = this.addSpecifiedPrimaryKeyJoinColumn(0);
        pkJoinColumn.setSpecifiedName(columnName);
        pkJoinColumn.setSpecifiedReferencedColumnName(referencedColumnName);
    }

    @Override
    public void clearSpecifiedPrimaryKeyJoinColumns() {
        int index = this.getSpecifiedPrimaryKeyJoinColumnsSize();
        while (--index >= 0) {
            this.getJavaResourceType().removeAnnotation(index, "javax.persistence.PrimaryKeyJoinColumn");
        }
        this.specifiedPrimaryKeyJoinColumnContainer.clearContextList();
    }

    @Override
    public void removeSpecifiedPrimaryKeyJoinColumn(int index) {
        this.getJavaResourceType().removeAnnotation(index, "javax.persistence.PrimaryKeyJoinColumn");
        this.specifiedPrimaryKeyJoinColumnContainer.removeContextElement(index);
    }

    @Override
    public void moveSpecifiedPrimaryKeyJoinColumn(int targetIndex, int sourceIndex) {
        this.getJavaResourceType().moveAnnotation(targetIndex, sourceIndex, "javax.persistence.PrimaryKeyJoinColumn");
        this.specifiedPrimaryKeyJoinColumnContainer.moveContextElement(targetIndex, sourceIndex);
    }

    protected void syncSpecifiedPrimaryKeyJoinColumns() {
        this.specifiedPrimaryKeyJoinColumnContainer.synchronizeWithResourceModel();
    }

    protected ListIterable<PrimaryKeyJoinColumnAnnotation> getPrimaryKeyJoinColumnAnnotations() {
        return this.getPrimaryKeyJoinColumnAnnotations_();
    }

    protected ListIterable<PrimaryKeyJoinColumnAnnotation> getPrimaryKeyJoinColumnAnnotations_() {
        return new SubListIterableWrapper(this.getNestablePrimaryKeyJoinColumnAnnotations_());
    }

    protected ListIterable<NestableAnnotation> getNestablePrimaryKeyJoinColumnAnnotations_() {
        return this.getResourceAnnotatedElement().getAnnotations("javax.persistence.PrimaryKeyJoinColumn");
    }

    protected PrimaryKeyJoinColumnOwner buildPrimaryKeyJoinColumnOwner() {
        return new PrimaryKeyJoinColumnOwner();
    }

    protected JavaPrimaryKeyJoinColumn buildSpecifiedPrimaryKeyJoinColumn(PrimaryKeyJoinColumnAnnotation primaryKeyJoinColumnAnnotation) {
        return this.getJpaFactory().buildJavaPrimaryKeyJoinColumn(this, this.primaryKeyJoinColumnOwner, primaryKeyJoinColumnAnnotation);
    }

    protected AbstractJpaNode.ContextListContainer<JavaPrimaryKeyJoinColumn, PrimaryKeyJoinColumnAnnotation> buildSpecifiedPrimaryKeyJoinColumnContainer() {
        SpecifiedPrimaryKeyJoinColumnContainer container = new SpecifiedPrimaryKeyJoinColumnContainer();
        container.initialize();
        return container;
    }

    @Override
    public JavaPrimaryKeyJoinColumn getDefaultPrimaryKeyJoinColumn() {
        return this.defaultPrimaryKeyJoinColumn;
    }

    protected void setDefaultPrimaryKeyJoinColumn(JavaPrimaryKeyJoinColumn pkJoinColumn) {
        JavaPrimaryKeyJoinColumn old = this.defaultPrimaryKeyJoinColumn;
        this.defaultPrimaryKeyJoinColumn = pkJoinColumn;
        this.firePropertyChanged("defaultPrimaryKeyJoinColumn", old, pkJoinColumn);
    }

    protected ListIterable<JavaPrimaryKeyJoinColumn> getDefaultPrimaryKeyJoinColumns() {
        return this.defaultPrimaryKeyJoinColumn != null ? new SingleElementListIterable((Object)this.defaultPrimaryKeyJoinColumn) : EmptyListIterable.instance();
    }

    protected int getDefaultPrimaryKeyJoinColumnsSize() {
        return this.defaultPrimaryKeyJoinColumn == null ? 0 : 1;
    }

    protected void updateDefaultPrimaryKeyJoinColumn() {
        if (this.buildsDefaultPrimaryKeyJoinColumn()) {
            if (this.defaultPrimaryKeyJoinColumn == null) {
                this.setDefaultPrimaryKeyJoinColumn(this.buildDefaultPrimaryKeyJoinColumn());
            } else {
                this.defaultPrimaryKeyJoinColumn.update();
            }
        } else {
            this.setDefaultPrimaryKeyJoinColumn(null);
        }
    }

    protected boolean buildsDefaultPrimaryKeyJoinColumn() {
        return !this.hasSpecifiedPrimaryKeyJoinColumns();
    }

    protected JavaPrimaryKeyJoinColumn buildDefaultPrimaryKeyJoinColumn() {
        return this.buildSpecifiedPrimaryKeyJoinColumn(new NullPrimaryKeyJoinColumnAnnotation((JavaResourceNode)this.getJavaResourceType()));
    }

    @Override
    public InheritanceType getInheritanceStrategy() {
        return this.specifiedInheritanceStrategy != null ? this.specifiedInheritanceStrategy : this.defaultInheritanceStrategy;
    }

    @Override
    public InheritanceType getSpecifiedInheritanceStrategy() {
        return this.specifiedInheritanceStrategy;
    }

    @Override
    public void setSpecifiedInheritanceStrategy(InheritanceType inheritanceType) {
        if (this.valuesAreDifferent((Object)this.specifiedInheritanceStrategy, (Object)inheritanceType)) {
            this.getInheritanceAnnotation().setStrategy(InheritanceType.toJavaResourceModel(inheritanceType));
            this.removeInheritanceAnnotationIfUnset();
            this.setSpecifiedInheritanceStrategy_(inheritanceType);
        }
    }

    protected void setSpecifiedInheritanceStrategy_(InheritanceType inheritanceType) {
        InheritanceType old = this.specifiedInheritanceStrategy;
        this.specifiedInheritanceStrategy = inheritanceType;
        this.firePropertyChanged("specifiedInheritanceStrategy", (Object)old, (Object)inheritanceType);
    }

    protected InheritanceType buildSpecifiedInheritanceStrategy() {
        return InheritanceType.fromJavaResourceModel(this.getInheritanceAnnotation().getStrategy());
    }

    @Override
    public InheritanceType getDefaultInheritanceStrategy() {
        return this.defaultInheritanceStrategy;
    }

    protected void setDefaultInheritanceStrategy(InheritanceType inheritanceType) {
        InheritanceType old = this.defaultInheritanceStrategy;
        this.defaultInheritanceStrategy = inheritanceType;
        this.firePropertyChanged("defaultInheritanceStrategy", (Object)old, (Object)inheritanceType);
    }

    protected InheritanceType buildDefaultInheritanceStrategy() {
        return this.isRootEntity() ? InheritanceType.SINGLE_TABLE : this.rootEntity.getInheritanceStrategy();
    }

    protected InheritanceAnnotation getInheritanceAnnotation() {
        return (InheritanceAnnotation)this.getJavaResourceType().getNonNullAnnotation("javax.persistence.Inheritance");
    }

    protected void removeInheritanceAnnotationIfUnset() {
        if (this.getInheritanceAnnotation().isUnset()) {
            this.removeInheritanceAnnotation();
        }
    }

    protected void removeInheritanceAnnotation() {
        this.getJavaResourceType().removeAnnotation("javax.persistence.Inheritance");
    }

    @Override
    public String getDiscriminatorValue() {
        return this.specifiedDiscriminatorValue != null ? this.specifiedDiscriminatorValue : this.defaultDiscriminatorValue;
    }

    @Override
    public String getSpecifiedDiscriminatorValue() {
        return this.specifiedDiscriminatorValue;
    }

    @Override
    public void setSpecifiedDiscriminatorValue(String discriminatorValue) {
        if (this.valuesAreDifferent(this.specifiedDiscriminatorValue, discriminatorValue)) {
            this.getDiscriminatorValueAnnotation().setValue(discriminatorValue);
            this.removeDiscriminatorValueAnnotationIfUnset();
            this.setSpecifiedDiscriminatorValue_(discriminatorValue);
        }
    }

    protected void setSpecifiedDiscriminatorValue_(String discriminatorValue) {
        String old = this.specifiedDiscriminatorValue;
        this.specifiedDiscriminatorValue = discriminatorValue;
        this.firePropertyChanged("specifiedDiscriminatorValue", old, discriminatorValue);
    }

    @Override
    public String getDefaultDiscriminatorValue() {
        return this.defaultDiscriminatorValue;
    }

    protected void setDefaultDiscriminatorValue(String discriminatorValue) {
        String old = this.defaultDiscriminatorValue;
        this.defaultDiscriminatorValue = discriminatorValue;
        this.firePropertyChanged("defaultDiscriminatorValue", old, discriminatorValue);
    }

    protected String buildDefaultDiscriminatorValue() {
        if (this.discriminatorValueIsUndefined) {
            return null;
        }
        return this.getDiscriminatorType() == DiscriminatorType.STRING ? this.getName() : null;
    }

    protected DiscriminatorType getDiscriminatorType() {
        return this.discriminatorColumn.getDiscriminatorType();
    }

    @Override
    public boolean specifiedDiscriminatorValueIsAllowed() {
        return this.specifiedDiscriminatorValueIsAllowed;
    }

    protected void setSpecifiedDiscriminatorValueIsAllowed(boolean allowed) {
        boolean old = this.specifiedDiscriminatorValueIsAllowed;
        this.specifiedDiscriminatorValueIsAllowed = allowed;
        this.firePropertyChanged("discriminatorValueIsAllowed", old, allowed);
    }

    protected boolean buildSpecifiedDiscriminatorValueIsAllowed() {
        return !this.isTablePerClass() && !this.isAbstract();
    }

    @Override
    public boolean discriminatorValueIsUndefined() {
        return this.discriminatorValueIsUndefined;
    }

    protected void setDiscriminatorValueIsUndefined(boolean undefined) {
        boolean old = this.discriminatorValueIsUndefined;
        this.discriminatorValueIsUndefined = undefined;
        this.firePropertyChanged("discriminatorValueIsUndefined", old, undefined);
    }

    protected boolean buildDiscriminatorValueIsUndefined() {
        return this.isTablePerClass() || this.isAbstract() || this.isRootNoDescendantsNoStrategyDefined();
    }

    protected DiscriminatorValueAnnotation getDiscriminatorValueAnnotation() {
        return (DiscriminatorValueAnnotation)this.getJavaResourceType().getNonNullAnnotation("javax.persistence.DiscriminatorValue");
    }

    protected void removeDiscriminatorValueAnnotationIfUnset() {
        if (this.getDiscriminatorValueAnnotation().isUnset()) {
            this.removeDiscriminatorValueAnnotation();
        }
    }

    protected void removeDiscriminatorValueAnnotation() {
        this.getJavaResourceType().removeAnnotation("javax.persistence.DiscriminatorValue");
    }

    @Override
    public JavaDiscriminatorColumn getDiscriminatorColumn() {
        return this.discriminatorColumn;
    }

    protected JavaDiscriminatorColumn buildDiscriminatorColumn() {
        return this.getJpaFactory().buildJavaDiscriminatorColumn(this, this.buildDiscriminatorColumnOwner());
    }

    protected JavaDiscriminatorColumn.Owner buildDiscriminatorColumnOwner() {
        return new DiscriminatorColumnOwner();
    }

    @Override
    public boolean specifiedDiscriminatorColumnIsAllowed() {
        return this.specifiedDiscriminatorColumnIsAllowed;
    }

    protected void setSpecifiedDiscriminatorColumnIsAllowed(boolean allowed) {
        boolean old = this.specifiedDiscriminatorColumnIsAllowed;
        this.specifiedDiscriminatorColumnIsAllowed = allowed;
        this.firePropertyChanged("specifiedDiscriminatorColumnIsAllowed", old, allowed);
    }

    protected boolean buildSpecifiedDiscriminatorColumnIsAllowed() {
        return !this.isTablePerClass() && this.isRootEntity();
    }

    @Override
    public boolean discriminatorColumnIsUndefined() {
        return this.discriminatorColumnIsUndefined;
    }

    protected void setDiscriminatorColumnIsUndefined(boolean undefined) {
        boolean old = this.discriminatorColumnIsUndefined;
        this.discriminatorColumnIsUndefined = undefined;
        this.firePropertyChanged("discriminatorColumnIsUndefined", old, undefined);
    }

    protected boolean buildDiscriminatorColumnIsUndefined() {
        return this.isTablePerClass() || this.isRootNoDescendantsNoStrategyDefined();
    }

    @Override
    public JavaAttributeOverrideContainer getAttributeOverrideContainer() {
        return this.attributeOverrideContainer;
    }

    protected JavaAttributeOverrideContainer buildAttributeOverrideContainer() {
        return this.getJpaFactory().buildJavaAttributeOverrideContainer(this, new AttributeOverrideContainerOwner());
    }

    public TypeMapping getOverridableTypeMapping() {
        PersistentType superPersistentType = this.getPersistentType().getSuperPersistentType();
        return superPersistentType == null ? null : superPersistentType.getMapping();
    }

    @Override
    public JavaAssociationOverrideContainer getAssociationOverrideContainer() {
        return this.associationOverrideContainer;
    }

    protected JavaAssociationOverrideContainer buildAssociationOverrideContainer() {
        return this.getJpaFactory().buildJavaAssociationOverrideContainer(this, new AssociationOverrideContainerOwner());
    }

    @Override
    public Relationship resolveOverriddenRelationship(String attributeName) {
        JavaAssociationOverride override = this.associationOverrideContainer.getSpecifiedOverrideNamed(attributeName);
        return override != null ? override.getRelationship() : super.resolveOverriddenRelationship(attributeName);
    }

    @Override
    public JavaGeneratorContainer getGeneratorContainer() {
        return this.generatorContainer;
    }

    protected JavaGeneratorContainer buildGeneratorContainer() {
        return this.getJpaFactory().buildJavaGeneratorContainer(this);
    }

    @Override
    public Iterable<Generator> getGenerators() {
        return new CompositeIterable(new Iterable[]{super.getGenerators(), this.generatorContainer.getGenerators()});
    }

    @Override
    public JavaJpaContextNode getGeneratorContainerParent() {
        return this;
    }

    public JavaResourceType getResourceAnnotatedElement() {
        return this.getJavaResourceType();
    }

    @Override
    public boolean parentSupportsGenerators() {
        return true;
    }

    @Override
    public JavaQueryContainer getQueryContainer() {
        return this.queryContainer;
    }

    protected JavaQueryContainer buildQueryContainer() {
        return this.getJpaFactory().buildJavaQueryContainer(this, this);
    }

    @Override
    public Iterable<Query> getQueries() {
        return this.queryContainer.getQueries();
    }

    @Override
    public Iterable<ReadOnlyTable> getAssociatedTables() {
        return new CompositeIterable((Object)this.table, this.getSecondaryTables());
    }

    @Override
    public Iterable<ReadOnlyTable> getAllAssociatedTables() {
        return new CompositeIterable(this.allAssociatedTablesLists());
    }

    protected Iterable<Iterable<ReadOnlyTable>> allAssociatedTablesLists() {
        return new TransformationIterable(this.getInheritanceHierarchy(), TypeMappingTools.ASSOCIATED_TABLES_TRANSFORMER);
    }

    @Override
    public Iterable<String> getAllAssociatedTableNames() {
        return this.convertToNames(this.getAllAssociatedTables());
    }

    protected Iterable<String> convertToNames(Iterable<ReadOnlyTable> tables) {
        return new FilteringIterable(this.convertToNames_(tables), NotNullFilter.instance());
    }

    protected Iterable<String> convertToNames_(Iterable<ReadOnlyTable> tables) {
        return new TransformationIterable<ReadOnlyTable, String>(tables){

            protected String transform(ReadOnlyTable t) {
                return t.getName();
            }
        };
    }

    @Override
    public boolean tableNameIsInvalid(String tableName) {
        return !this.tableNameIsValid(tableName);
    }

    protected boolean tableNameIsValid(String tableName) {
        return this.tableIsUndefined || this.tableNameIsValid_(tableName);
    }

    protected boolean tableNameIsValid_(String tableName) {
        return this.connectionProfileIsActive() ? this.resolveDbTable(tableName) != null : this.tableNameIsAssociatedTable(tableName);
    }

    protected boolean tableNameIsAssociatedTable(String tableName) {
        if (tableName != null && tableName.equals(this.getPrimaryTableName())) {
            return true;
        }
        return CollectionTools.contains(this.getAllAssociatedTableNames(), (Object)tableName);
    }

    @Override
    public String getPrimaryTableName() {
        return this.table.getName();
    }

    @Override
    public Table getPrimaryDbTable() {
        return this.table.getDbTable();
    }

    @Override
    public Table resolveDbTable(String tableName) {
        if (this.getDataSource().connectionProfileIsActive()) {
            return this.getDataSource().selectTableForIdentifier(this.getAllAssociatedDbTables(), tableName);
        }
        return null;
    }

    protected Iterable<Table> getAllAssociatedDbTables() {
        return new FilteringIterable(this.getAllAssociatedDbTables_(), NotNullFilter.instance());
    }

    protected Iterable<Table> getAllAssociatedDbTables_() {
        return new TransformationIterable<ReadOnlyTable, Table>(this.getAllAssociatedTables()){

            protected Table transform(ReadOnlyTable entityTable) {
                return entityTable.getDbTable();
            }
        };
    }

    @Override
    public Schema getDbSchema() {
        return this.table.getDbSchema();
    }

    @Override
    public String getPrimaryKeyColumnName() {
        return MappingTools.getPrimaryKeyColumnName(this);
    }

    @Override
    public PersistentAttribute getIdAttribute() {
        Iterator<AttributeMapping> idAttributeMappings = this.getAllAttributeMappings("id").iterator();
        if (idAttributeMappings.hasNext()) {
            PersistentAttribute attribute = idAttributeMappings.next().getPersistentAttribute();
            return idAttributeMappings.hasNext() ? null : attribute;
        }
        return null;
    }

    @Override
    public String getKey() {
        return "entity";
    }

    @Override
    public boolean isMapped() {
        return true;
    }

    @Override
    public JavaResourceType getJavaResourceType() {
        return super.getJavaResourceType();
    }

    @Override
    public Column resolveOverriddenColumn(String attributeName) {
        JavaAttributeOverride override = this.attributeOverrideContainer.getSpecifiedOverrideNamed(attributeName);
        return override != null ? override.getColumn() : super.resolveOverriddenColumn(attributeName);
    }

    @Override
    public Iterable<String> getOverridableAttributeNames() {
        return this.isTablePerClass() ? super.getOverridableAttributeNames() : EmptyIterable.instance();
    }

    @Override
    public Iterable<String> getOverridableAssociationNames() {
        return this.isTablePerClass() ? super.getOverridableAssociationNames() : EmptyIterable.instance();
    }

    @Override
    public AttributeMapping resolveAttributeMapping(String name) {
        for (AttributeMapping attributeMapping : this.getAllAttributeMappings()) {
            AttributeMapping resolvedMapping = attributeMapping.resolveAttributeMapping(name);
            if (resolvedMapping == null) continue;
            return resolvedMapping;
        }
        return null;
    }

    @Override
    public Entity getParentEntity() {
        for (TypeMapping typeMapping : this.getAncestors()) {
            if (!(typeMapping instanceof Entity)) continue;
            return (Entity)typeMapping;
        }
        return null;
    }

    @Override
    public boolean isRootEntity() {
        return this == this.rootEntity;
    }

    protected boolean isDescendant() {
        return !this.isRootEntity();
    }

    protected boolean isSingleTableDescendant() {
        return this.isDescendant() && this.getInheritanceStrategy() == InheritanceType.SINGLE_TABLE;
    }

    protected boolean isRootNoDescendantsNoStrategyDefined() {
        return this.isRootEntity() && this.descendants.isEmpty() && this.specifiedInheritanceStrategy == null;
    }

    protected boolean isAbstractTablePerClass() {
        return this.isAbstract() && this.isTablePerClass();
    }

    protected boolean isTablePerClass() {
        return this.getInheritanceStrategy() == InheritanceType.TABLE_PER_CLASS;
    }

    protected boolean isTablePerClassDescendant() {
        return this.isTablePerClass() && this.isDescendant();
    }

    protected boolean isAbstract() {
        return this.getJavaResourceType().isAbstract();
    }

    protected boolean isFinal() {
        return this.getJavaResourceType().isFinal();
    }

    protected boolean isMember() {
        return this.getJavaResourceType().isMemberType();
    }

    protected boolean isStatic() {
        return this.getJavaResourceType().isStatic();
    }

    @Override
    public Iterable<String> getJavaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterable result = super.getJavaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        result = this.table.getJavaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        for (JavaSecondaryTable secondaryTable : this.getSecondaryTables()) {
            result = secondaryTable.getJavaCompletionProposals(pos, filter, astRoot);
            if (result == null) continue;
            return result;
        }
        for (JavaPrimaryKeyJoinColumn pkJoinColumn : this.getPrimaryKeyJoinColumns()) {
            result = pkJoinColumn.getJavaCompletionProposals(pos, filter, astRoot);
            if (result == null) continue;
            return result;
        }
        result = this.attributeOverrideContainer.getJavaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        result = this.associationOverrideContainer.getJavaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        result = this.discriminatorColumn.getJavaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        result = this.generatorContainer.getJavaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        return null;
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
        this.validatePrimaryKey(messages, reporter, astRoot);
        this.validateTable(messages, reporter, astRoot);
        for (JavaSecondaryTable secondaryTable : this.getSecondaryTables()) {
            secondaryTable.validate(messages, reporter, astRoot);
        }
        this.validateInheritance(messages, reporter, astRoot);
        for (JavaPrimaryKeyJoinColumn pkJoinColumn : this.getPrimaryKeyJoinColumns()) {
            pkJoinColumn.validate(messages, reporter, astRoot);
        }
        this.generatorContainer.validate(messages, reporter, astRoot);
        this.queryContainer.validate(messages, reporter, astRoot);
        this.attributeOverrideContainer.validate(messages, reporter, astRoot);
        this.associationOverrideContainer.validate(messages, reporter, astRoot);
        this.validateEntityName(messages);
        this.idClassReference.validate(messages, reporter, astRoot);
    }

    @Override
    public boolean validatesAgainstDatabase() {
        return super.validatesAgainstDatabase() && !this.isAbstractTablePerClass();
    }

    protected void validateEntityName(List<IMessage> messages) {
        if (StringTools.stringIsEmpty((String)this.getName())) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "ENTITY_NAME_MISSING", new String[]{this.getPersistentType().getName()}, this, ((EntityAnnotation)this.getMappingAnnotation()).getNameTextRange()));
        }
    }

    protected void validatePrimaryKey(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        this.buildPrimaryKeyValidator(astRoot).validate(messages, reporter);
    }

    protected JptValidator buildPrimaryKeyValidator(CompilationUnit astRoot) {
        return new GenericEntityPrimaryKeyValidator(this, (PrimaryKeyTextRangeResolver)this.buildTextRangeResolver(astRoot));
    }

    @Override
    protected EntityTextRangeResolver buildTextRangeResolver(CompilationUnit astRoot) {
        return new JavaEntityTextRangeResolver(this, astRoot);
    }

    protected void validateTable(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        if (this.isAbstractTablePerClass()) {
            if (this.table.isSpecifiedInResource()) {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "ENTITY_ABSTRACT_TABLE_PER_CLASS_DEFINES_TABLE", new String[]{this.getName()}, this, this.table.getValidationTextRange(astRoot)));
            }
            return;
        }
        if (this.isSingleTableDescendant() && this.getDataSource().connectionProfileIsActive()) {
            if (this.specifiedTableDoesNotMatchRootTable()) {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "ENTITY_SINGLE_TABLE_DESCENDANT_DEFINES_TABLE", new String[]{this.getName()}, this, this.table.getValidationTextRange(astRoot)));
            }
            return;
        }
        this.table.validate(messages, reporter, astRoot);
    }

    protected boolean specifiedTableDoesNotMatchRootTable() {
        return this.table.isSpecifiedInResource() && this.table.getDbTable() != this.getRootEntity().getTable().getDbTable();
    }

    protected void validateInheritance(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        this.validateInheritanceStrategy(messages, astRoot);
        this.validateDiscriminatorColumn(messages, reporter, astRoot);
        this.validateDiscriminatorValue(messages, astRoot);
    }

    protected void validateDiscriminatorColumn(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        if (this.specifiedDiscriminatorColumnIsAllowed && !this.discriminatorColumnIsUndefined) {
            this.discriminatorColumn.validate(messages, reporter, astRoot);
        } else if (!this.discriminatorColumn.isVirtual()) {
            if (this.isDescendant()) {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "ENTITY_NON_ROOT_DISCRIMINATOR_COLUMN_DEFINED", new String[]{this.getName()}, this, this.getDiscriminatorColumnTextRange(astRoot)));
            } else if (this.isTablePerClass()) {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "ENTITY_TABLE_PER_CLASS_DISCRIMINATOR_COLUMN_DEFINED", new String[]{this.getName()}, this, this.getDiscriminatorColumnTextRange(astRoot)));
            }
        }
    }

    protected void validateDiscriminatorValue(List<IMessage> messages, CompilationUnit astRoot) {
        if (this.discriminatorValueIsUndefined && this.specifiedDiscriminatorValue != null) {
            if (this.isAbstract()) {
                messages.add(DefaultJpaValidationMessages.buildMessage(2, "ENTITY_ABSTRACT_DISCRIMINATOR_VALUE_DEFINED", new String[]{this.getName()}, this, this.getDiscriminatorValueTextRange(astRoot)));
            } else if (this.isTablePerClass()) {
                messages.add(DefaultJpaValidationMessages.buildMessage(2, "ENTITY_TABLE_PER_CLASS_DISCRIMINATOR_VALUE_DEFINED", new String[]{this.getName()}, this, this.getDiscriminatorValueTextRange(astRoot)));
            }
        }
    }

    protected void validateInheritanceStrategy(List<IMessage> messages, CompilationUnit astRoot) {
        JpaPlatformVariation.Supported tablePerConcreteClassInheritanceIsSupported = this.getJpaPlatformVariation().getTablePerConcreteClassInheritanceIsSupported();
        if (tablePerConcreteClassInheritanceIsSupported == JpaPlatformVariation.Supported.YES) {
            return;
        }
        if (this.getInheritanceStrategy() == InheritanceType.TABLE_PER_CLASS && this.isRootEntity()) {
            if (tablePerConcreteClassInheritanceIsSupported == JpaPlatformVariation.Supported.NO) {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "ENTITY_TABLE_PER_CLASS_NOT_SUPPORTED_ON_PLATFORM", new String[]{this.getName()}, this, this.getInheritanceStrategyTextRange(astRoot)));
            } else {
                messages.add(DefaultJpaValidationMessages.buildMessage(2, "ENTITY_TABLE_PER_CLASS_NOT_PORTABLE_ON_PLATFORM", new String[]{this.getName()}, this, this.getInheritanceStrategyTextRange(astRoot)));
            }
        }
    }

    protected TextRange getDiscriminatorValueTextRange(CompilationUnit astRoot) {
        return this.getValidationTextRange(this.getDiscriminatorValueAnnotation().getTextRange(astRoot), astRoot);
    }

    protected TextRange getDiscriminatorColumnTextRange(CompilationUnit astRoot) {
        return this.getValidationTextRange(this.discriminatorColumn.getValidationTextRange(astRoot), astRoot);
    }

    protected TextRange getInheritanceStrategyTextRange(CompilationUnit astRoot) {
        return this.getValidationTextRange(this.getInheritanceAnnotation().getStrategyTextRange(), astRoot);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class AssociationOverrideContainerOwner
    extends OverrideContainerOwner
    implements JavaAssociationOverrideContainer2_0.Owner {
        protected AssociationOverrideContainerOwner() {
        }

        @Override
        protected Iterable<String> getAllOverridableNames_(TypeMapping overriddenTypeMapping) {
            return overriddenTypeMapping.getAllOverridableAssociationNames();
        }

        @Override
        public Relationship resolveOverriddenRelationship(String attributeName) {
            return MappingTools.resolveOverriddenRelationship(this.getOverridableTypeMapping(), attributeName);
        }

        @Override
        public JptValidator buildOverrideValidator(ReadOnlyOverride override, OverrideContainer container, OverrideTextRangeResolver textRangeResolver) {
            return new AssociationOverrideValidator((ReadOnlyAssociationOverride)override, (AssociationOverrideContainer)container, textRangeResolver, (OverrideValidator.OverrideDescriptionProvider)new MappedSuperclassOverrideDescriptionProvider());
        }

        @Override
        public JptValidator buildColumnValidator(ReadOnlyOverride override, ReadOnlyBaseColumn column, ReadOnlyTableColumn.Owner owner, TableColumnTextRangeResolver textRangeResolver) {
            return new AssociationOverrideJoinColumnValidator((ReadOnlyAssociationOverride)override, (ReadOnlyJoinColumn)column, (ReadOnlyJoinColumn.Owner)owner, (JoinColumnTextRangeResolver)textRangeResolver, (AbstractNamedColumnValidator.TableDescriptionProvider)new EntityTableDescriptionProvider());
        }

        @Override
        public JptValidator buildJoinTableJoinColumnValidator(ReadOnlyAssociationOverride override, ReadOnlyJoinColumn column, ReadOnlyJoinColumn.Owner owner, JoinColumnTextRangeResolver textRangeResolver) {
            return new AssociationOverrideJoinColumnValidator(override, column, owner, textRangeResolver, (AbstractNamedColumnValidator.TableDescriptionProvider)new JoinTableTableDescriptionProvider());
        }

        @Override
        public JptValidator buildJoinTableInverseJoinColumnValidator(ReadOnlyAssociationOverride override, ReadOnlyJoinColumn column, ReadOnlyJoinColumn.Owner owner, JoinColumnTextRangeResolver textRangeResolver) {
            return new AssociationOverrideInverseJoinColumnValidator(override, column, owner, textRangeResolver, (AbstractNamedColumnValidator.TableDescriptionProvider)new JoinTableTableDescriptionProvider());
        }

        @Override
        public JptValidator buildJoinTableValidator(ReadOnlyAssociationOverride override, ReadOnlyTable t, TableTextRangeResolver textRangeResolver) {
            return new AssociationOverrideJoinTableValidator(override, (ReadOnlyJoinTable)t, textRangeResolver);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class AttributeOverrideContainerOwner
    extends OverrideContainerOwner
    implements JavaAttributeOverrideContainer2_0.Owner {
        protected AttributeOverrideContainerOwner() {
        }

        @Override
        protected Iterable<String> getAllOverridableNames_(TypeMapping overriddenTypeMapping) {
            return new FilteringIterable<String>(overriddenTypeMapping.getAllOverridableAttributeNames()){

                protected boolean accept(String attributeName) {
                    return !AttributeOverrideContainerOwner.this.getTypeMapping().attributeIsDerivedId(attributeName);
                }
            };
        }

        @Override
        public Column resolveOverriddenColumn(String attributeName) {
            return MappingTools.resolveOverriddenColumn(this.getOverridableTypeMapping(), attributeName);
        }

        @Override
        public JptValidator buildOverrideValidator(ReadOnlyOverride override, OverrideContainer container, OverrideTextRangeResolver textRangeResolver) {
            return new AttributeOverrideValidator((ReadOnlyAttributeOverride)override, (AttributeOverrideContainer)container, textRangeResolver, (OverrideValidator.OverrideDescriptionProvider)new MappedSuperclassOverrideDescriptionProvider());
        }

        @Override
        public JptValidator buildColumnValidator(ReadOnlyOverride override, ReadOnlyBaseColumn column, ReadOnlyTableColumn.Owner owner, TableColumnTextRangeResolver textRangeResolver) {
            return new AttributeOverrideColumnValidator((ReadOnlyAttributeOverride)override, column, textRangeResolver, (AbstractNamedColumnValidator.TableDescriptionProvider)new EntityTableDescriptionProvider());
        }
    }

    protected class DiscriminatorColumnOwner
    extends NamedColumnOwner
    implements JavaDiscriminatorColumn.Owner {
        protected DiscriminatorColumnOwner() {
        }

        public String getDefaultColumnName(ReadOnlyNamedColumn column) {
            return this.isDescendant() ? this.getRootDiscriminatorColumn().getName() : (this.discriminatorColumnIsUndefined() ? null : "DTYPE");
        }

        public int getDefaultLength() {
            return this.isDescendant() ? this.getRootDiscriminatorColumn().getLength() : (this.discriminatorColumnIsUndefined() ? 0 : 31);
        }

        public DiscriminatorType getDefaultDiscriminatorType() {
            return this.isDescendant() ? this.getRootDiscriminatorColumn().getDiscriminatorType() : (this.discriminatorColumnIsUndefined() ? null : ReadOnlyNamedDiscriminatorColumn.DEFAULT_DISCRIMINATOR_TYPE);
        }

        protected boolean isDescendant() {
            return AbstractJavaEntity.this.isDescendant();
        }

        protected DiscriminatorColumn getRootDiscriminatorColumn() {
            return AbstractJavaEntity.this.rootEntity.getDiscriminatorColumn();
        }

        protected boolean discriminatorColumnIsUndefined() {
            return AbstractJavaEntity.this.discriminatorColumnIsUndefined;
        }

        public JptValidator buildColumnValidator(ReadOnlyNamedColumn column, NamedColumnTextRangeResolver textRangeResolver) {
            return new DiscriminatorColumnValidator(column, textRangeResolver);
        }
    }

    protected abstract class NamedColumnOwner
    implements JavaReadOnlyNamedColumn.Owner {
        protected NamedColumnOwner() {
        }

        public String getDefaultTableName() {
            return AbstractJavaEntity.this.getPrimaryTableName();
        }

        public Table resolveDbTable(String tableName) {
            return AbstractJavaEntity.this.resolveDbTable(tableName);
        }

        public TextRange getValidationTextRange(CompilationUnit astRoot) {
            return AbstractJavaEntity.this.getValidationTextRange(astRoot);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class OverrideContainerOwner
    implements JavaOverrideContainer2_0.Owner {
        protected OverrideContainerOwner() {
        }

        @Override
        public JavaResourceMember getResourceMember() {
            return AbstractJavaEntity.this.getJavaResourceType();
        }

        @Override
        public AbstractJavaEntity getTypeMapping() {
            return AbstractJavaEntity.this;
        }

        @Override
        public TextRange getValidationTextRange(CompilationUnit astRoot) {
            return AbstractJavaEntity.this.getValidationTextRange(astRoot);
        }

        @Override
        public TypeMapping getOverridableTypeMapping() {
            return AbstractJavaEntity.this.getOverridableTypeMapping();
        }

        @Override
        public Iterable<String> getAllOverridableNames() {
            TypeMapping overriddenTypeMapping = this.getOverridableTypeMapping();
            return overriddenTypeMapping != null ? this.getAllOverridableNames_(overriddenTypeMapping) : EmptyIterable.instance();
        }

        protected abstract Iterable<String> getAllOverridableNames_(TypeMapping var1);

        @Override
        public String getDefaultTableName() {
            return AbstractJavaEntity.this.getPrimaryTableName();
        }

        @Override
        public boolean tableNameIsInvalid(String tableName) {
            return AbstractJavaEntity.this.tableNameIsInvalid(tableName);
        }

        @Override
        public Table resolveDbTable(String tableName) {
            return AbstractJavaEntity.this.resolveDbTable(tableName);
        }

        @Override
        public Iterable<String> getCandidateTableNames() {
            return AbstractJavaEntity.this.getAllAssociatedTableNames();
        }

        @Override
        public String getPossiblePrefix() {
            return null;
        }

        @Override
        public String getWritePrefix() {
            return null;
        }

        @Override
        public boolean isRelevant(String overrideName) {
            return true;
        }
    }

    protected class PrimaryKeyJoinColumnOwner
    extends NamedColumnOwner
    implements JavaReadOnlyBaseJoinColumn.Owner {
        protected PrimaryKeyJoinColumnOwner() {
        }

        public Table getReferencedColumnDbTable() {
            Entity parentEntity = AbstractJavaEntity.this.getParentEntity();
            return parentEntity == null ? null : parentEntity.getPrimaryDbTable();
        }

        public int getJoinColumnsSize() {
            return AbstractJavaEntity.this.getPrimaryKeyJoinColumnsSize();
        }

        public String getDefaultColumnName(ReadOnlyNamedColumn column) {
            if (this.getJoinColumnsSize() != 1) {
                return null;
            }
            Entity parentEntity = AbstractJavaEntity.this.getParentEntity();
            return parentEntity == null ? AbstractJavaEntity.this.getPrimaryKeyColumnName() : parentEntity.getPrimaryKeyColumnName();
        }

        public JptValidator buildColumnValidator(ReadOnlyNamedColumn column, NamedColumnTextRangeResolver textRangeResolver) {
            return new EntityPrimaryKeyJoinColumnValidator((ReadOnlyBaseJoinColumn)column, this, (BaseJoinColumnTextRangeResolver)textRangeResolver);
        }
    }

    protected class SecondaryTableOwner
    implements ReadOnlyTable.Owner {
        protected SecondaryTableOwner() {
        }

        public JptValidator buildTableValidator(ReadOnlyTable t, TableTextRangeResolver textRangeResolver) {
            return new SecondaryTableValidator((ReadOnlySecondaryTable)t, textRangeResolver);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class SpecifiedPrimaryKeyJoinColumnContainer
    extends AbstractJpaNode.ContextListContainer<JavaPrimaryKeyJoinColumn, PrimaryKeyJoinColumnAnnotation> {
        protected SpecifiedPrimaryKeyJoinColumnContainer() {
        }

        @Override
        protected String getContextElementsPropertyName() {
            return "specifiedPrimaryKeyJoinColumns";
        }

        @Override
        protected JavaPrimaryKeyJoinColumn buildContextElement(PrimaryKeyJoinColumnAnnotation resourceElement) {
            return AbstractJavaEntity.this.buildSpecifiedPrimaryKeyJoinColumn(resourceElement);
        }

        @Override
        protected ListIterable<PrimaryKeyJoinColumnAnnotation> getResourceElements() {
            return AbstractJavaEntity.this.getPrimaryKeyJoinColumnAnnotations();
        }

        @Override
        protected PrimaryKeyJoinColumnAnnotation getResourceElement(JavaPrimaryKeyJoinColumn contextElement) {
            return contextElement.getColumnAnnotation();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class SpecifiedSecondaryTableContainer
    extends AbstractJpaNode.ContextListContainer<JavaSecondaryTable, SecondaryTableAnnotation> {
        protected SpecifiedSecondaryTableContainer() {
        }

        @Override
        protected String getContextElementsPropertyName() {
            return "specifiedSecondaryTables";
        }

        @Override
        protected JavaSecondaryTable buildContextElement(SecondaryTableAnnotation resourceElement) {
            return AbstractJavaEntity.this.buildSecondaryTable(resourceElement);
        }

        @Override
        protected ListIterable<SecondaryTableAnnotation> getResourceElements() {
            return AbstractJavaEntity.this.getSecondaryTableAnnotations();
        }

        @Override
        protected SecondaryTableAnnotation getResourceElement(JavaSecondaryTable contextElement) {
            return contextElement.getTableAnnotation();
        }
    }

    protected class TableOwner
    implements ReadOnlyTable.Owner {
        protected TableOwner() {
        }

        public JptValidator buildTableValidator(ReadOnlyTable t, TableTextRangeResolver textRangeResolver) {
            return new TableValidator(t, textRangeResolver);
        }
    }
}

